/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.autoimport;

import com.intellij.ProjectTopics;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.ExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskState;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.autoimport.ConfigurationFileCrcFactory;
import com.intellij.openapi.externalSystem.service.project.autoimport.ExternalSystemProjectsWatcher;
import com.intellij.openapi.externalSystem.service.project.autoimport.FileChangeListenerBase;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemProjectsWatcherImpl
extends ExternalSystemTaskNotificationListenerAdapter
implements ExternalSystemProjectsWatcher {
    private static final Logger LOG = Logger.getInstance(ExternalSystemProjectsWatcherImpl.class);
    private static final ExtensionPointName<Contributor> EP_NAME = ExtensionPointName.create((String)"com.intellij.externalProjectWatcherContributor");
    private static final Key<Long> CRC_WITHOUT_SPACES_CURRENT = Key.create((String)"ExternalSystemProjectsWatcher.CRC_WITHOUT_SPACES_CURRENT");
    private static final Key<Long> CRC_WITHOUT_SPACES_BEFORE_LAST_IMPORT = Key.create((String)"ExternalSystemProjectsWatcher.CRC_WITHOUT_SPACES_BEFORE_LAST_IMPORT");
    private static final int DOCUMENT_SAVE_DELAY = 1000;
    private static final int REFRESH_MERGING_TIME_SPAN = 2000;
    private final Project myProject;
    private final MergingUpdateQueue myChangedDocumentsQueue;
    private final List<ExternalSystemAutoImportAware> myImportAwareManagers;
    private final MergingUpdateQueue myUpdatesQueue;
    private final Map<ProjectSystemId, MyNotification> myNotificationMap;
    private final MultiMap<String, String> myKnownAffectedFiles = MultiMap.createConcurrentSet();
    private final MultiMap<VirtualFilePointer, String> myFilesPointers = MultiMap.createConcurrentSet();
    private final List<LocalFileSystem.WatchRequest> myWatchedRoots = new ArrayList<LocalFileSystem.WatchRequest>();
    private final MergingUpdateQueue myRefreshRequestsQueue;

    public ExternalSystemProjectsWatcherImpl(Project project2) {
        this.myProject = project2;
        this.myChangedDocumentsQueue = new MergingUpdateQueue("ExternalSystemProjectsWatcher: Document changes queue", 1000, false, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this.myProject);
        this.myRefreshRequestsQueue = new MergingUpdateQueue("ExternalSystemProjectsWatcher: Refresh requests queue", 2000, false, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this.myProject, null, false);
        this.myImportAwareManagers = ContainerUtil.newArrayList();
        for (ExternalSystemManager manager : ExternalSystemApiUtil.getAllManagers()) {
            if (!(manager instanceof ExternalSystemAutoImportAware)) continue;
            this.myImportAwareManagers.add((ExternalSystemAutoImportAware)manager);
            NotificationsConfiguration.getNotificationsConfiguration().register(manager.getSystemId().getReadableName() + " Import", NotificationDisplayType.STICKY_BALLOON, false);
        }
        this.myUpdatesQueue = new MergingUpdateQueue("ExternalSystemProjectsWatcher: Notifier queue", 500, false, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this.myProject);
        this.myNotificationMap = ContainerUtil.newConcurrentMap();
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myProject).subscribe(BatchFileChangeListener.TOPIC, (Object)new BatchFileChangeListener(){

            public void batchChangeStarted(@NotNull Project project2, @Nullable String activityName) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                ExternalSystemProjectsWatcherImpl.this.myRefreshRequestsQueue.suspend();
            }

            public void batchChangeCompleted(@NotNull Project project2) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                ExternalSystemProjectsWatcherImpl.this.myRefreshRequestsQueue.resume();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "batchChangeStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "batchChangeCompleted";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void markDirtyAllExternalProjects() {
        this.findLinkedProjectsSettings().forEach(this::scheduleUpdate);
        for (Contributor contributor : (Contributor[])EP_NAME.getExtensions()) {
            contributor.markDirtyAllExternalProjects(this.myProject);
        }
    }

    public void markDirty(Module module2) {
        this.scheduleUpdate(ExternalSystemApiUtil.getExternalProjectPath((Module)module2));
        for (Contributor contributor : (Contributor[])EP_NAME.getExtensions()) {
            contributor.markDirty(module2);
        }
    }

    public void markDirty(String projectPath) {
        this.scheduleUpdate(projectPath);
        for (Contributor contributor : (Contributor[])EP_NAME.getExtensions()) {
            contributor.markDirty(projectPath);
        }
    }

    public synchronized void start() {
        if (ExternalSystemUtil.isNoBackgroundMode()) {
            return;
        }
        this.myUpdatesQueue.activate();
        MessageBusConnection myBusConnection = this.myProject.getMessageBus().connect((Disposable)this.myChangedDocumentsQueue);
        myBusConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new MyFileChangeListener(this));
        ExternalSystemProjectsWatcherImpl.makeUserAware(this.myChangedDocumentsQueue, this.myProject);
        this.myChangedDocumentsQueue.activate();
        this.myRefreshRequestsQueue.activate();
        DocumentListener myDocumentListener = new DocumentListener(){
            private final Map<Document, Pair<String, VirtualFile>> myChangedDocuments = new THashMap();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                Document doc = event.getDocument();
                VirtualFile file = FileDocumentManager.getInstance().getFile(doc);
                if (file == null) {
                    return;
                }
                String externalProjectPath = ExternalSystemProjectsWatcherImpl.this.getRelatedExternalProjectPath(file);
                if (externalProjectPath == null) {
                    return;
                }
                Map<Document, Pair<String, VirtualFile>> map = this.myChangedDocuments;
                synchronized (map) {
                    this.myChangedDocuments.put(doc, (Pair<String, VirtualFile>)Pair.create((Object)externalProjectPath, (Object)file));
                }
                ExternalSystemProjectsWatcherImpl.this.myChangedDocumentsQueue.queue(new Update((Object)ExternalSystemProjectsWatcherImpl.this){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        THashMap copy;
                        Map map = myChangedDocuments;
                        synchronized (map) {
                            copy = new THashMap(myChangedDocuments);
                            myChangedDocuments.clear();
                        }
                        ExternalSystemUtil.invokeLater(ExternalSystemProjectsWatcherImpl.this.myProject, () -> this.lambda$run$2((Map)copy));
                    }

                    private /* synthetic */ void lambda$run$2(Map copy) {
                        WriteAction.run(() -> copy.forEach((document, pair2) -> {
                            if (!((VirtualFile)pair2.second).isValid()) {
                                return;
                            }
                            PsiDocumentManager.getInstance((Project)ExternalSystemProjectsWatcherImpl.this.myProject).commitDocument(document);
                            FileDocumentManagerImpl fileDocumentManager = (FileDocumentManagerImpl)FileDocumentManager.getInstance();
                            fileDocumentManager.saveDocumentAsIs(document);
                            Long beforeImport = (Long)((VirtualFile)pair2.second).getUserData(CRC_WITHOUT_SPACES_BEFORE_LAST_IMPORT);
                            Long current = (Long)((VirtualFile)pair2.second).getUserData(CRC_WITHOUT_SPACES_CURRENT);
                            if (current != null && current.equals(beforeImport)) {
                                Long newCrc = ExternalSystemProjectsWatcherImpl.this.calculateCrc((VirtualFile)pair2.second);
                                ((VirtualFile)pair2.second).putUserData(CRC_WITHOUT_SPACES_CURRENT, (Object)newCrc);
                                if (!current.equals(newCrc)) {
                                    ExternalSystemProjectsWatcherImpl.this.scheduleUpdate((String)pair2.first, false);
                                }
                            }
                        }));
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$2", "documentChanged"));
            }
        };
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(myDocumentListener, (Disposable)myBusConnection);
        ((ExternalSystemProgressNotificationManager)ServiceManager.getService(ExternalSystemProgressNotificationManager.class)).addNotificationListener((ExternalSystemTaskNotificationListener)this);
        this.updateWatchedRoots(true);
        Disposer.register((Disposable)this.myChangedDocumentsQueue, () -> this.myFilesPointers.clear());
    }

    public synchronized void stop() {
        Disposer.dispose((Disposable)this.myChangedDocumentsQueue);
        Disposer.dispose((Disposable)this.myUpdatesQueue);
        Disposer.dispose((Disposable)this.myRefreshRequestsQueue);
        this.myNotificationMap.clear();
        ((ExternalSystemProgressNotificationManager)ServiceManager.getService(ExternalSystemProgressNotificationManager.class)).removeNotificationListener((ExternalSystemTaskNotificationListener)this);
    }

    public void onStart(@NotNull ExternalSystemTaskId id, final String workingDir) {
        if (id == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(0);
        }
        if (id.getType() == ExternalSystemTaskType.RESOLVE_PROJECT) {
            final ProjectSystemId systemId = id.getProjectSystemId();
            for (String filePath2 : ContainerUtil.newArrayList((Iterable)this.myKnownAffectedFiles.get((Object)workingDir))) {
                VirtualFile file = VfsUtil.findFileByIoFile((File)new File(filePath2), (boolean)false);
                if (file == null || file.isDirectory()) continue;
                file.putUserData(CRC_WITHOUT_SPACES_BEFORE_LAST_IMPORT, file.getUserData(CRC_WITHOUT_SPACES_CURRENT));
            }
            this.myUpdatesQueue.queue(new Update(Pair.create((Object)systemId, (Object)workingDir)){

                public void run() {
                    ExternalSystemProjectsWatcherImpl.this.doUpdateNotifications(true, systemId, workingDir);
                }
            });
        }
    }

    public void onSuccess(@NotNull ExternalSystemTaskId id) {
        if (id == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(1);
        }
        if (id.getType() == ExternalSystemTaskType.RESOLVE_PROJECT) {
            this.updateWatchedRoots(false);
        }
    }

    private void scheduleUpdate(@Nullable String projectPath) {
        this.scheduleUpdate(projectPath, true);
    }

    private void scheduleUpdate(@Nullable String projectPath, boolean reportRefreshError) {
        if (projectPath == null || ExternalSystemUtil.isNoBackgroundMode()) {
            return;
        }
        Pair<ExternalSystemManager, ExternalProjectSettings> linkedProject = this.findLinkedProjectSettings(projectPath);
        if (linkedProject == null) {
            return;
        }
        this.scheduleUpdate(linkedProject, reportRefreshError);
    }

    private void scheduleUpdate(@NotNull Pair<ExternalSystemManager, ExternalProjectSettings> linkedProject) {
        if (linkedProject == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(2);
        }
        this.scheduleUpdate(linkedProject, true);
    }

    private void scheduleUpdate(@NotNull Pair<ExternalSystemManager, ExternalProjectSettings> linkedProject, final boolean reportRefreshError) {
        if (linkedProject == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(3);
        }
        if (ExternalSystemUtil.isNoBackgroundMode()) {
            return;
        }
        ExternalSystemManager manager = (ExternalSystemManager)linkedProject.first;
        final String projectPath = ((ExternalProjectSettings)linkedProject.second).getExternalProjectPath();
        final ProjectSystemId systemId = manager.getSystemId();
        boolean useAutoImport = ((ExternalProjectSettings)linkedProject.second).isUseAutoImport();
        if (useAutoImport) {
            ExternalSystemTaskState taskState;
            ExternalSystemTask resolveTask = ((ExternalSystemProcessingManager)ServiceManager.getService(ExternalSystemProcessingManager.class)).findTask(ExternalSystemTaskType.RESOLVE_PROJECT, systemId, projectPath);
            ExternalSystemTaskState externalSystemTaskState = taskState = resolveTask == null ? null : resolveTask.getState();
            if (taskState == null || taskState.isStopped()) {
                this.addToRefreshQueue(projectPath, systemId, reportRefreshError);
            } else if (taskState != ExternalSystemTaskState.NOT_STARTED) {
                Long lastTimestamp;
                if (manager instanceof ExternalSystemAutoImportAware && (lastTimestamp = (Long)((AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)this.myProject)).getExternalConfigModificationStamps().get(projectPath)) != null) {
                    List affectedFiles = ((ExternalSystemAutoImportAware)manager).getAffectedExternalProjectFiles(projectPath, this.myProject);
                    long currentTimeStamp = affectedFiles.stream().mapToLong(File::lastModified).sum();
                    if (lastTimestamp != currentTimeStamp) {
                        return;
                    }
                }
                final ExternalSystemProgressNotificationManager progressManager = (ExternalSystemProgressNotificationManager)ServiceManager.getService(ExternalSystemProgressNotificationManager.class);
                ExternalSystemTaskNotificationListenerAdapter taskListener = new ExternalSystemTaskNotificationListenerAdapter(){

                    public void onEnd(@NotNull ExternalSystemTaskId id) {
                        if (id == null) {
                            4.$$$reportNull$$$0(0);
                        }
                        progressManager.removeNotificationListener((ExternalSystemTaskNotificationListener)this);
                        ExternalSystemProjectsWatcherImpl.this.addToRefreshQueue(projectPath, systemId, reportRefreshError);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$4", "onEnd"));
                    }
                };
                progressManager.addNotificationListener(resolveTask.getId(), (ExternalSystemTaskNotificationListener)taskListener);
            }
        } else {
            LOG.debug("Scheduling new external project update notification", new Throwable("Schedule update call trace"));
            this.myUpdatesQueue.queue(new Update(Pair.create((Object)systemId, (Object)projectPath)){

                public void run() {
                    ExternalSystemProjectsWatcherImpl.this.doUpdateNotifications(false, systemId, projectPath);
                }
            });
        }
    }

    private void addToRefreshQueue(final String projectPath, final ProjectSystemId systemId, final boolean reportRefreshError) {
        this.myRefreshRequestsQueue.queue(new Update(Pair.create((Object)systemId, (Object)projectPath)){

            public void run() {
                ExternalSystemProjectsWatcherImpl.scheduleRefresh(ExternalSystemProjectsWatcherImpl.this.myProject, projectPath, systemId, reportRefreshError);
            }
        });
    }

    private void updateWatchedRoots(boolean isProjectOpen) {
        SmartList pathsToWatch = new SmartList();
        this.myFilesPointers.clear();
        LocalFileSystem.getInstance().removeWatchedRoots(this.myWatchedRoots);
        HashMap pointerMap = ContainerUtil.newHashMap();
        for (ExternalSystemManager manager : ExternalSystemApiUtil.getAllManagers()) {
            if (!(manager instanceof ExternalSystemAutoImportAware)) continue;
            ExternalSystemAutoImportAware importAware = (ExternalSystemAutoImportAware)manager;
            for (ExternalProjectSettings settings : ((AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)this.myProject)).getLinkedProjectsSettings()) {
                Long affectedFilesTimestamp;
                List files = importAware.getAffectedExternalProjectFiles(settings.getExternalProjectPath(), this.myProject);
                long timeStamp = 0L;
                for (File file : files) {
                    timeStamp += file.lastModified();
                }
                Map modificationStamps = ((AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)this.myProject)).getExternalConfigModificationStamps();
                if (isProjectOpen && this.myProject.getUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT) != Boolean.TRUE && this.myProject.getUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT) != Boolean.TRUE && timeStamp != (affectedFilesTimestamp = Long.valueOf((affectedFilesTimestamp = (Long)modificationStamps.get(settings.getExternalProjectPath())) == null ? -1L : affectedFilesTimestamp))) {
                    this.scheduleUpdate(settings.getExternalProjectPath());
                }
                modificationStamps.put(settings.getExternalProjectPath(), timeStamp);
                for (File file : files) {
                    String path;
                    if (file == null || (path = ExternalSystemProjectsWatcherImpl.getNormalizedPath(file)) == null) continue;
                    pathsToWatch.add(path);
                    String url = VfsUtilCore.pathToUrl((String)path);
                    VirtualFilePointer pointer = (VirtualFilePointer)pointerMap.get(url);
                    if (pointer == null) {
                        pointer = VirtualFilePointerManager.getInstance().create(url, (Disposable)this.myChangedDocumentsQueue, null);
                        pointerMap.put(url, pointer);
                        VirtualFile virtualFile = pointer.getFile();
                        if (virtualFile != null) {
                            Long crc = (Long)virtualFile.getUserData(CRC_WITHOUT_SPACES_BEFORE_LAST_IMPORT);
                            if (crc != null) {
                                modificationStamps.put(path, crc);
                            } else {
                                UIUtil.invokeLaterIfNeeded(() -> {
                                    Long newCrc = this.calculateCrc(virtualFile);
                                    virtualFile.putUserData(CRC_WITHOUT_SPACES_CURRENT, (Object)newCrc);
                                    virtualFile.putUserData(CRC_WITHOUT_SPACES_BEFORE_LAST_IMPORT, (Object)newCrc);
                                    modificationStamps.put(path, newCrc);
                                });
                            }
                        }
                    }
                    this.myFilesPointers.putValue((Object)pointer, (Object)settings.getExternalProjectPath());
                }
            }
        }
        this.myWatchedRoots.addAll(LocalFileSystem.getInstance().addRootsToWatch((Collection)pathsToWatch, false));
    }

    @Nullable
    private String getRelatedExternalProjectPath(VirtualFile file) {
        String path = file.getPath();
        return this.getRelatedExternalProjectPath(path);
    }

    @Nullable
    private String getRelatedExternalProjectPath(String path) {
        ExternalSystemAutoImportAware importAware;
        String externalProjectPath = null;
        Iterator<ExternalSystemAutoImportAware> iterator = this.myImportAwareManagers.iterator();
        while (iterator.hasNext() && (externalProjectPath = (importAware = iterator.next()).getAffectedExternalProjectPath(path, this.myProject)) == null) {
        }
        if (externalProjectPath != null) {
            this.myKnownAffectedFiles.putValue(externalProjectPath, (Object)path);
        }
        return externalProjectPath;
    }

    private void doUpdateNotifications(boolean close, @NotNull ProjectSystemId systemId, @NotNull String projectPath) {
        if (systemId == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(4);
        }
        if (projectPath == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(5);
        }
        MyNotification notification = this.myNotificationMap.get(systemId);
        if (close) {
            if (notification == null) {
                return;
            }
            notification.projectPaths.remove(projectPath);
            if (notification.projectPaths.isEmpty()) {
                notification.expire();
            }
        } else {
            if (notification != null && !notification.isExpired()) {
                notification.projectPaths.add(projectPath);
                return;
            }
            notification = new MyNotification(this.myProject, this.myNotificationMap, systemId, projectPath);
            this.myNotificationMap.put(systemId, notification);
            Notifications.Bus.notify((Notification)notification, (Project)this.myProject);
        }
    }

    private static void scheduleRefresh(final @NotNull Project project2, String projectPath, ProjectSystemId systemId, boolean reportRefreshError) {
        if (project2 == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(6);
        }
        ExternalSystemUtil.refreshProject(project2, systemId, projectPath, new ExternalProjectRefreshCallback(){

            public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
                if (externalProject != null) {
                    ((ProjectDataManager)ServiceManager.getService(ProjectDataManager.class)).importData(externalProject, project2, true);
                }
            }
        }, false, ProgressExecutionMode.IN_BACKGROUND_ASYNC, reportRefreshError);
    }

    private static void makeUserAware(final MergingUpdateQueue mergingUpdateQueue, Project project2) {
        ApplicationManager.getApplication().runReadAction(() -> {
            EditorEventMulticaster multicaster = EditorFactory.getInstance().getEventMulticaster();
            multicaster.addCaretListener(new CaretListener(){

                public void caretPositionChanged(@NotNull CaretEvent e) {
                    if (e == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    mergingUpdateQueue.restartTimer();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$8", "caretPositionChanged"));
                }
            }, (Disposable)mergingUpdateQueue);
            multicaster.addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent event) {
                    if (event == null) {
                        9.$$$reportNull$$$0(0);
                    }
                    mergingUpdateQueue.restartTimer();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$9", "documentChanged"));
                }
            }, (Disposable)mergingUpdateQueue);
            project2.getMessageBus().connect((Disposable)mergingUpdateQueue).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){
                int beforeCalled;

                public void beforeRootsChange(@NotNull ModuleRootEvent event) {
                    if (event == null) {
                        10.$$$reportNull$$$0(0);
                    }
                    if (this.beforeCalled++ == 0) {
                        mergingUpdateQueue.suspend();
                    }
                }

                public void rootsChanged(@NotNull ModuleRootEvent event) {
                    if (event == null) {
                        10.$$$reportNull$$$0(1);
                    }
                    if (this.beforeCalled == 0) {
                        return;
                    }
                    if (--this.beforeCalled == 0) {
                        mergingUpdateQueue.resume();
                        mergingUpdateQueue.restartTimer();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "event";
                    objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$10";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "beforeRootsChange";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "rootsChanged";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        });
    }

    @Nullable
    private Pair<ExternalSystemManager, ExternalProjectSettings> findLinkedProjectSettings(String projectPath) {
        ExternalProjectSettings[] linkedProjectSettings = new ExternalProjectSettings[1];
        Optional<ExternalSystemManager> systemManager = ExternalSystemApiUtil.getAllManagers().stream().filter(m -> {
            linkedProjectSettings[0] = ((AbstractExternalSystemSettings)m.getSettingsProvider().fun((Object)this.myProject)).getLinkedProjectSettings(projectPath);
            return linkedProjectSettings[0] != null;
        }).findAny();
        if (!systemManager.isPresent()) {
            return null;
        }
        ExternalSystemManager manager = systemManager.get();
        return Pair.create((Object)manager, (Object)linkedProjectSettings[0]);
    }

    @NotNull
    private List<Pair<ExternalSystemManager, ExternalProjectSettings>> findLinkedProjectsSettings() {
        List<Pair<ExternalSystemManager, ExternalProjectSettings>> list = ExternalSystemApiUtil.getAllManagers().stream().flatMap(manager -> ((AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)this.myProject)).getLinkedProjectsSettings().stream().map(settings -> Pair.create((Object)manager, (Object)settings))).collect(Collectors.toList());
        if (list == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Nullable
    private static String getNormalizedPath(@NotNull File file) {
        String canonized;
        if (file == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(8);
        }
        return (canonized = PathUtil.getCanonicalPath((String)file.getAbsolutePath())) == null ? null : FileUtil.toSystemIndependentName((String)canonized);
    }

    @NotNull
    private Long calculateCrc(@NotNull VirtualFile file) {
        if (file == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(9);
        }
        Long l = new ConfigurationFileCrcFactory(this.myProject, file).create();
        if (l == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(10);
        }
        return l;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedProject";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findLinkedProjectsSettings";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateCrc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "onStart";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onSuccess";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "scheduleUpdate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateNotifications";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "scheduleRefresh";
                break;
            }
            case 7: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "calculateCrc";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Experimental
    public static interface Contributor {
        public void markDirtyAllExternalProjects(@NotNull Project var1);

        public void markDirty(@NotNull Module var1);

        default public void markDirty(@NotNull String projectPath) {
            if (projectPath == null) {
                Contributor.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$Contributor", "markDirty"));
        }
    }

    private class MyFileChangeListener
    extends FileChangeListenerBase {
        private final ExternalSystemProjectsWatcherImpl myWatcher;
        private final MultiMap<String, String> myKnownFiles = MultiMap.createSet();
        private List<VirtualFile> filesToUpdate;
        private List<VirtualFile> filesToRemove;

        MyFileChangeListener(ExternalSystemProjectsWatcherImpl watcher) {
            this.myWatcher = watcher;
        }

        @Override
        protected boolean isRelevant(String path) {
            if (!this.myKnownFiles.get((Object)path).isEmpty()) {
                return true;
            }
            for (VirtualFilePointer pointer : ExternalSystemProjectsWatcherImpl.this.myFilesPointers.keySet()) {
                String filePath2 = VfsUtilCore.urlToPath((String)pointer.getUrl());
                if (StringUtil.isNotEmpty((String)filePath2) && FileUtil.namesEqual((String)path, (String)filePath2)) {
                    for (String projectPath : ExternalSystemProjectsWatcherImpl.this.myFilesPointers.get((Object)pointer)) {
                        this.myKnownFiles.putValue((Object)path, (Object)projectPath);
                        ExternalSystemProjectsWatcherImpl.this.myKnownAffectedFiles.putValue((Object)projectPath, (Object)path);
                    }
                    return true;
                }
                if (!LOG.isDebugEnabled() || !StringUtil.isNotEmpty((String)filePath2) || !FileUtil.namesEqual((String)FileUtil.toCanonicalPath((String)path), (String)FileUtil.toCanonicalPath((String)filePath2))) continue;
                LOG.debug("Changes were ignored: " + path + ". Related FW: " + filePath2);
            }
            String affectedProjectPath = ExternalSystemProjectsWatcherImpl.this.getRelatedExternalProjectPath(path);
            if (affectedProjectPath != null) {
                this.myKnownFiles.putValue((Object)path, (Object)affectedProjectPath);
            }
            return affectedProjectPath != null;
        }

        @Override
        protected void updateFile(VirtualFile file, VFileEvent event) {
            this.doUpdateFile(file, event, false);
        }

        @Override
        protected void deleteFile(VirtualFile file, VFileEvent event) {
            this.doUpdateFile(file, event, true);
        }

        private void doUpdateFile(VirtualFile file, VFileEvent event, boolean remove) {
            this.init();
            if (remove) {
                this.filesToRemove.add(file);
            } else if (this.fileWasChanged(file, event)) {
                this.filesToUpdate.add(file);
            } else {
                for (String externalProjectPath : this.myKnownFiles.get((Object)file.getPath())) {
                    this.handleRevertedChanges(externalProjectPath);
                }
            }
        }

        private void handleRevertedChanges(final String externalProjectPath) {
            for (Object filePath2 : ContainerUtil.newArrayList((Iterable)ExternalSystemProjectsWatcherImpl.this.myKnownAffectedFiles.get((Object)externalProjectPath))) {
                VirtualFile f = VfsUtil.findFileByIoFile((File)new File((String)filePath2), (boolean)false);
                if (f != null && Objects.equals(f.getUserData(CRC_WITHOUT_SPACES_BEFORE_LAST_IMPORT), f.getUserData(CRC_WITHOUT_SPACES_CURRENT))) continue;
                return;
            }
            ProjectSystemId systemId = null;
            for (ExternalSystemManager manager : ExternalSystemApiUtil.getAllManagers()) {
                if (((AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)ExternalSystemProjectsWatcherImpl.this.myProject)).getLinkedProjectSettings(externalProjectPath) == null) continue;
                systemId = manager.getSystemId();
            }
            if (systemId != null) {
                final ProjectSystemId finalSystemId = systemId;
                ExternalSystemProjectsWatcherImpl.this.myUpdatesQueue.queue(new Update(Pair.create(finalSystemId, (Object)externalProjectPath)){

                    public void run() {
                        ExternalSystemProjectsWatcherImpl.this.doUpdateNotifications(true, finalSystemId, externalProjectPath);
                    }
                });
            }
        }

        private boolean fileWasChanged(VirtualFile file, VFileEvent event) {
            if (!file.isValid()) {
                return true;
            }
            if (!(event instanceof VFileContentChangeEvent)) {
                return false;
            }
            Long newCrc = ExternalSystemProjectsWatcherImpl.this.calculateCrc(file);
            file.putUserData(CRC_WITHOUT_SPACES_CURRENT, (Object)newCrc);
            Long crc = (Long)file.getUserData(CRC_WITHOUT_SPACES_BEFORE_LAST_IMPORT);
            if (crc == null) {
                file.putUserData(CRC_WITHOUT_SPACES_BEFORE_LAST_IMPORT, (Object)newCrc);
                return true;
            }
            return !newCrc.equals(crc);
        }

        @Override
        protected void apply() {
            if (this.areFileSetsInitialised()) {
                this.filesToUpdate.removeAll(this.filesToRemove);
                this.scheduleUpdate(ContainerUtil.concat(this.filesToUpdate, this.filesToRemove));
            }
            this.clear();
        }

        private boolean areFileSetsInitialised() {
            return this.filesToUpdate != null;
        }

        private void scheduleUpdate(List<VirtualFile> filesToUpdate) {
            filesToUpdate.stream().flatMap(f -> this.myKnownFiles.get((Object)f.getPath()).stream()).distinct().forEach(path -> this.myWatcher.scheduleUpdate(path, false));
        }

        private void init() {
            if (this.areFileSetsInitialised()) {
                return;
            }
            this.filesToUpdate = new ArrayList<VirtualFile>();
            this.filesToRemove = new ArrayList<VirtualFile>();
        }

        private void clear() {
            this.filesToUpdate = null;
            this.filesToRemove = null;
            this.myKnownFiles.clear();
        }
    }

    private static class MyNotification
    extends Notification {
        private final ProjectSystemId mySystemId;
        private final Map<ProjectSystemId, MyNotification> myNotificationMap;
        private final Set<String> projectPaths;

        MyNotification(final Project project2, Map<ProjectSystemId, MyNotification> notificationMap, final ProjectSystemId systemId, String projectPath) {
            super(systemId.getReadableName() + " Import", ExternalSystemBundle.message((String)"import.needed", (Object[])new Object[]{systemId.getReadableName()}), "", NotificationType.INFORMATION, null);
            this.mySystemId = systemId;
            this.myNotificationMap = notificationMap;
            this.projectPaths = ContainerUtil.newHashSet((Object[])new String[]{projectPath});
            this.addAction((AnAction)new NotificationAction(ExternalSystemBundle.message((String)"import.importChanged", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (notification == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    this.doAction(notification, project2, systemId, false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$MyNotification$1";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            this.addAction((AnAction)new NotificationAction(ExternalSystemBundle.message((String)"import.enableAutoImport", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (notification == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    this.doAction(notification, project2, systemId, true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$MyNotification$2";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        public void expire() {
            super.expire();
            this.projectPaths.clear();
            this.myNotificationMap.remove(this.mySystemId);
        }

        private void doAction(@NotNull Notification notification, Project project2, ProjectSystemId systemId, boolean isAutoImport) {
            if (notification == null) {
                MyNotification.$$$reportNull$$$0(0);
            }
            this.projectPaths.stream().map(path -> ExternalSystemApiUtil.getSettings((Project)project2, (ProjectSystemId)systemId).getLinkedProjectSettings(path)).distinct().filter(Objects::nonNull).forEach(settings -> {
                if (isAutoImport) {
                    settings.setUseAutoImport(true);
                }
                ExternalSystemProjectsWatcherImpl.scheduleRefresh(project2, settings.getExternalProjectPath(), systemId, !isAutoImport);
            });
            notification.expire();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$MyNotification", "doAction"));
        }
    }
}

