/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.internal;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskState;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.ExternalSystemFacadeManager;
import com.intellij.openapi.externalSystem.service.internal.AbstractExternalSystemTask;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemProcessingManager
implements ExternalSystemTaskNotificationListener,
Disposable {
    private static final long TOO_LONG_EXECUTION_MS = TimeUnit.SECONDS.toMillis(10L);
    @NotNull
    private final ConcurrentMap<ExternalSystemTaskId, Long> myTasksInProgress;
    @NotNull
    private final ConcurrentMap<ExternalSystemTaskId, ExternalSystemTask> myTasksDetails;
    @NotNull
    private final Alarm myAlarm;
    @NotNull
    private final ExternalSystemFacadeManager myFacadeManager;
    @NotNull
    private final ExternalSystemProgressNotificationManager myProgressNotificationManager;

    public ExternalSystemProcessingManager(@NotNull ExternalSystemFacadeManager facadeManager, @NotNull ExternalSystemProgressNotificationManager notificationManager) {
        if (facadeManager == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(0);
        }
        if (notificationManager == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(1);
        }
        this.myTasksInProgress = ContainerUtil.newConcurrentMap();
        this.myTasksDetails = ContainerUtil.newConcurrentMap();
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.myFacadeManager = facadeManager;
        this.myProgressNotificationManager = notificationManager;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        notificationManager.addNotificationListener(this);
    }

    public void dispose() {
        this.myProgressNotificationManager.removeNotificationListener(this);
        this.myAlarm.cancelAllRequests();
    }

    public boolean hasTaskOfTypeInProgress(@NotNull ExternalSystemTaskType type, @NotNull Project project2) {
        if (type == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(3);
        }
        String projectId = ExternalSystemTaskId.getProjectId((Project)project2);
        for (ExternalSystemTaskId id : this.myTasksInProgress.keySet()) {
            if (!type.equals((Object)id.getType()) || !projectId.equals(id.getIdeProjectId())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public ExternalSystemTask findTask(@NotNull ExternalSystemTaskType type, @NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        if (type == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(4);
        }
        if (projectSystemId == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(5);
        }
        if (externalProjectPath == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(6);
        }
        for (ExternalSystemTask task : this.myTasksDetails.values()) {
            AbstractExternalSystemTask externalSystemTask;
            if (!(task instanceof AbstractExternalSystemTask) || (externalSystemTask = (AbstractExternalSystemTask)task).getId().getType() != type || !externalSystemTask.getExternalSystemId().getId().equals(projectSystemId.getId()) || !externalSystemTask.getExternalProjectPath().equals(externalProjectPath)) continue;
            return task;
        }
        return null;
    }

    @NotNull
    public List<ExternalSystemTask> findTasksOfState(@NotNull ProjectSystemId projectSystemId, ExternalSystemTaskState ... taskStates) {
        if (projectSystemId == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(7);
        }
        if (taskStates == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(8);
        }
        SmartList result = new SmartList();
        for (ExternalSystemTask task : this.myTasksDetails.values()) {
            AbstractExternalSystemTask externalSystemTask;
            if (!(task instanceof AbstractExternalSystemTask) || !(externalSystemTask = (AbstractExternalSystemTask)task).getExternalSystemId().getId().equals(projectSystemId.getId()) || !ArrayUtil.contains((Object)externalSystemTask.getState(), (Object[])taskStates)) continue;
            result.add(task);
        }
        SmartList smartList = result;
        if (smartList == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(9);
        }
        return smartList;
    }

    public void add(@NotNull ExternalSystemTask task) {
        if (task == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(10);
        }
        this.myTasksDetails.put(task.getId(), task);
    }

    public void release(@NotNull ExternalSystemTaskId id) {
        if (id == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(11);
        }
        this.myTasksDetails.remove(id);
    }

    public void onQueued(@NotNull ExternalSystemTaskId id, String workingDir) {
        if (id == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(12);
        }
        this.onStart(id, workingDir);
    }

    public void onStart(@NotNull ExternalSystemTaskId id, String workingDir) {
        if (id == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(13);
        }
        this.myTasksInProgress.put(id, System.currentTimeMillis() + TOO_LONG_EXECUTION_MS);
        if (this.myAlarm.getActiveRequestCount() <= 0) {
            this.myAlarm.addRequest(() -> this.update(), TOO_LONG_EXECUTION_MS);
        }
    }

    public void onStart(@NotNull ExternalSystemTaskId id) {
        if (id == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(14);
        }
        this.myTasksInProgress.put(id, System.currentTimeMillis() + TOO_LONG_EXECUTION_MS);
    }

    public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
        if (event == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(15);
        }
        this.myTasksInProgress.put(event.getId(), System.currentTimeMillis() + TOO_LONG_EXECUTION_MS);
    }

    public void onTaskOutput(@NotNull ExternalSystemTaskId id, @NotNull String text, boolean stdOut) {
        if (id == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(16);
        }
        if (text == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(17);
        }
        this.myTasksInProgress.put(id, System.currentTimeMillis() + TOO_LONG_EXECUTION_MS);
    }

    public void onEnd(@NotNull ExternalSystemTaskId id) {
        if (id == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(18);
        }
        this.myTasksInProgress.remove(id);
        if (this.myTasksInProgress.isEmpty()) {
            this.myAlarm.cancelAllRequests();
        }
    }

    public void onSuccess(@NotNull ExternalSystemTaskId id) {
        if (id == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(19);
        }
    }

    public void onFailure(@NotNull ExternalSystemTaskId id, @NotNull Exception e) {
        if (id == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(20);
        }
        if (e == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(21);
        }
    }

    public void beforeCancel(@NotNull ExternalSystemTaskId id) {
        if (id == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(22);
        }
    }

    public void onCancel(@NotNull ExternalSystemTaskId id) {
        if (id == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(23);
        }
    }

    public void update() {
        long delay = TOO_LONG_EXECUTION_MS;
        HashMap newState = ContainerUtilRt.newHashMap();
        HashMap currentState = ContainerUtilRt.newHashMap(this.myTasksInProgress);
        if (currentState.isEmpty()) {
            return;
        }
        for (Map.Entry entry : currentState.entrySet()) {
            long diff = System.currentTimeMillis() - (Long)entry.getValue();
            if (diff > 0L) {
                delay = Math.min(delay, diff);
                newState.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!this.myFacadeManager.isTaskActive((ExternalSystemTaskId)entry.getKey())) continue;
            newState.put(entry.getKey(), System.currentTimeMillis() + TOO_LONG_EXECUTION_MS);
        }
        this.myTasksInProgress.clear();
        this.myTasksInProgress.putAll(newState);
        if (!newState.isEmpty()) {
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(() -> this.update(), delay);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facadeManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationManager";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskStates";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/internal/ExternalSystemProcessingManager";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/internal/ExternalSystemProcessingManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findTasksOfState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasTaskOfTypeInProgress";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findTask";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findTasksOfState";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "release";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "onQueued";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "onStart";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "onStatusChange";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "onTaskOutput";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "onEnd";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "onSuccess";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "onFailure";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "beforeCancel";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "onCancel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

