/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ui.configuration.actions.NewModuleAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportProvider;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportModuleAction
extends AnAction {
    private static final String LAST_IMPORTED_LOCATION = "last.imported.location";

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ImportModuleAction.$$$reportNull$$$0(0);
        }
        ImportModuleAction.doImport(ImportModuleAction.getEventProject((AnActionEvent)e));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ImportModuleAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(ImportModuleAction.getEventProject((AnActionEvent)e) != null);
    }

    public boolean isDumbAware() {
        return true;
    }

    public static List<Module> doImport(@Nullable Project project2) {
        AddModuleWizard wizard = ImportModuleAction.selectFileAndCreateWizard(project2, null);
        if (wizard == null || wizard.getStepCount() > 0 && !wizard.showAndGet()) {
            return Collections.emptyList();
        }
        return ImportModuleAction.createFromWizard(project2, wizard);
    }

    public static List<Module> createFromWizard(@Nullable Project project2, AbstractProjectWizard wizard) {
        Ref result = Ref.create();
        TransactionGuard.getInstance().submitTransactionAndWait(() -> result.set(ImportModuleAction.doCreateFromWizard(project2, wizard)));
        return (List)result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Module> doCreateFromWizard(@Nullable Project project2, AbstractProjectWizard wizard) {
        if (project2 == null) {
            Project newProject = NewProjectUtil.createFromWizard(wizard, null);
            return newProject == null ? Collections.emptyList() : Arrays.asList(ModuleManager.getInstance((Project)newProject).getModules());
        }
        ProjectBuilder projectBuilder = wizard.getProjectBuilder();
        try {
            if (wizard.getStepCount() > 0) {
                Module module2 = new NewModuleAction().createModuleFromWizard(project2, null, wizard);
                List<Module> list = Collections.singletonList(module2);
                return list;
            }
            List list = projectBuilder.commit(project2);
            return list;
        }
        finally {
            if (projectBuilder != null) {
                projectBuilder.cleanup();
            }
        }
    }

    @Nullable
    public static AddModuleWizard selectFileAndCreateWizard(@Nullable Project project2, @Nullable Component dialogParent) {
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleLocalFileDescriptor();
        descriptor2.setHideIgnored(false);
        descriptor2.setTitle("Select File or Directory to Import");
        List<ProjectImportProvider> providers = ImportModuleAction.getProviders(project2);
        String description = ImportModuleAction.getFileChooserDescription(providers);
        descriptor2.setDescription(description);
        return ImportModuleAction.selectFileAndCreateWizard(project2, dialogParent, descriptor2, providers.toArray(new ProjectImportProvider[0]));
    }

    @Nullable
    public static AddModuleWizard selectFileAndCreateWizard(@Nullable Project project2, @Nullable Component dialogParent, @NotNull FileChooserDescriptor descriptor2, ProjectImportProvider[] providers) {
        VirtualFile[] files;
        if (descriptor2 == null) {
            ImportModuleAction.$$$reportNull$$$0(2);
        }
        FileChooserDialog chooser = FileChooserFactory.getInstance().createFileChooser(descriptor2, project2, dialogParent);
        VirtualFile toSelect = null;
        String lastLocation = PropertiesComponent.getInstance().getValue(LAST_IMPORTED_LOCATION);
        if (lastLocation != null) {
            toSelect = LocalFileSystem.getInstance().refreshAndFindFileByPath(lastLocation);
        }
        if ((files = chooser.choose(project2, new VirtualFile[]{toSelect})).length == 0) {
            return null;
        }
        VirtualFile file = files[0];
        if (project2 == null) {
            for (Project p : ProjectManager.getInstance().getOpenProjects()) {
                if (!ProjectUtil.isSameProject((String)file.getPath(), (Project)p)) continue;
                ProjectUtil.focusProjectWindow((Project)p, (boolean)false);
                return null;
            }
        }
        PropertiesComponent.getInstance().setValue(LAST_IMPORTED_LOCATION, file.getPath());
        return ImportModuleAction.createImportWizard(project2, dialogParent, file, providers);
    }

    private static String getFileChooserDescription(List<ProjectImportProvider> providers) {
        StringBuilder builder = new StringBuilder("<html>Select ");
        boolean first = true;
        if (providers.size() > 0) {
            for (ProjectImportProvider provider : providers) {
                String sample = provider.getFileSample();
                if (sample == null) continue;
                if (!first) {
                    builder.append(", <br>");
                } else {
                    first = false;
                }
                builder.append(sample);
            }
        }
        builder.append(".</html>");
        return builder.toString();
    }

    @NotNull
    public static List<ProjectImportProvider> getProviders(@Nullable Project project2) {
        Object[] providers = (ProjectImportProvider[])ProjectImportProvider.PROJECT_IMPORT_PROVIDER.getExtensions();
        List list = ContainerUtil.filter((Object[])providers, provider -> project2 == null ? provider.canCreateNewProject() : provider.canImportModule());
        if (list == null) {
            ImportModuleAction.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public static AddModuleWizard createImportWizard(@Nullable Project project2, @Nullable Component dialogParent, @NotNull VirtualFile file, ProjectImportProvider ... providers) {
        List available;
        if (file == null) {
            ImportModuleAction.$$$reportNull$$$0(4);
        }
        if ((available = ContainerUtil.filter((Object[])providers, provider -> provider.canImport(file, project2))).isEmpty()) {
            Messages.showInfoMessage((Project)project2, (String)("Cannot import anything from " + file.getPath()), (String)"Cannot Import");
            return null;
        }
        String path = available.size() == 1 ? ((ProjectImportProvider)available.get(0)).getPathToBeImported(file) : ProjectImportProvider.getDefaultPath(file);
        ProjectImportProvider[] availableProviders = available.toArray(new ProjectImportProvider[0]);
        return dialogParent == null ? new AddModuleWizard(project2, path, availableProviders) : new AddModuleWizard(project2, dialogParent, path, availableProviders);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/ImportModuleAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/ImportModuleAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "selectFileAndCreateWizard";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createImportWizard";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

