/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.ConfigurationWithCommandLineShortener;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.JavaTestConfigurationWithDiscoverySupport;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunProfileWithCompileBeforeLaunchOption;
import com.intellij.execution.configurations.WrappingRunConfiguration;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testDiscovery.TestDiscoveryIndex;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestFramework;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TestDiscoveryConfigurationProducer
extends JavaRunConfigurationProducerBase<JavaTestConfigurationWithDiscoverySupport> {
    protected abstract void setPosition(JavaTestConfigurationBase var1, PsiLocation<PsiMethod> var2);

    protected abstract Pair<String, String> getPosition(JavaTestConfigurationBase var1);

    protected void setupDiscoveryConfiguration(JavaTestConfigurationBase configuration, PsiMethod sourceMethod, Module targetModule) {
        this.setPosition(configuration, (PsiLocation<PsiMethod>)new PsiLocation((PsiElement)sourceMethod));
        Pair<String, String> position = this.getPosition(configuration);
        configuration.setName("Tests for " + StringUtil.getShortName((String)((String)position.first)) + "." + (String)position.second);
        configuration.setModule(targetModule);
    }

    protected boolean setupConfigurationFromContext(JavaTestConfigurationWithDiscoverySupport configuration, ConfigurationContext configurationContext, Ref<PsiElement> ref) {
        if (!Registry.is((String)"testDiscovery.enabled")) {
            return false;
        }
        Location contextLocation = configurationContext.getLocation();
        assert (contextLocation != null);
        Location location = JavaExecutionUtil.stepIntoSingleClass((Location)contextLocation);
        if (location == null) {
            return false;
        }
        PsiMethod sourceMethod = TestDiscoveryConfigurationProducer.getSourceMethod(location);
        Pair<String, String> position = TestDiscoveryConfigurationProducer.getPosition(sourceMethod);
        if (sourceMethod != null && position != null) {
            Project project2 = configuration.getProject();
            TestDiscoveryIndex testDiscoveryIndex = TestDiscoveryIndex.getInstance(project2);
            if (testDiscoveryIndex.getTestsByMethodName((String)position.first, (String)position.second, configuration.getTestFrameworkId()).isEmpty()) {
                return false;
            }
            Module targetModule = this.getTargetModule(configuration, configurationContext, position, project2, testDiscoveryIndex);
            this.setupDiscoveryConfiguration(configuration, sourceMethod, targetModule);
            return true;
        }
        return false;
    }

    private Module getTargetModule(JavaTestConfigurationWithDiscoverySupport configuration, ConfigurationContext configurationContext, Pair<String, String> position, Project project2, TestDiscoveryIndex testDiscoveryIndex) {
        RunnerAndConfigurationSettings template = configurationContext.getRunManager().getConfigurationTemplate(this.getConfigurationFactory());
        Module predefinedModule = ((ModuleBasedConfiguration)template.getConfiguration()).getConfigurationModule().getModule();
        if (predefinedModule != null) {
            return predefinedModule;
        }
        Collection<String> modules = testDiscoveryIndex.getTestModulesByMethodName((String)position.first, (String)position.second, configuration.getTestFrameworkId());
        if (modules.isEmpty()) {
            return null;
        }
        ArrayList<Module> survivedModules = new ArrayList<Module>();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project2);
        for (String moduleName : modules) {
            Module moduleByName = moduleManager.findModuleByName(moduleName);
            if (moduleByName == null) continue;
            survivedModules.add(moduleByName);
        }
        if (survivedModules.isEmpty()) {
            return null;
        }
        return TestDiscoveryConfigurationProducer.detectTargetModule(survivedModules, project2);
    }

    public abstract boolean isApplicable(@NotNull Location<PsiMethod> var1);

    @NotNull
    public abstract RunProfileState createProfile(@NotNull Location<PsiMethod>[] var1, Module var2, RunConfiguration var3, ExecutionEnvironment var4);

    public RunProfile createProfile(Location<PsiMethod>[] testMethods, Module module2, ConfigurationContext context, String configurationName) {
        RunnerAndConfigurationSettings settings = this.cloneTemplateConfiguration(context);
        JavaTestConfigurationBase configuration = (JavaTestConfigurationBase)settings.getConfiguration();
        configuration.setModule(module2);
        if (module2 == null) {
            configuration.setSearchScope(TestSearchScope.WHOLE_PROJECT);
        } else {
            configuration.setSearchScope(TestSearchScope.MODULE_WITH_DEPENDENCIES);
        }
        configuration.setShortenCommandLine(ShortenCommandLine.MANIFEST);
        return new MyRunProfile(testMethods, module2, configuration, configurationName);
    }

    public static Module detectTargetModule(Collection<? extends Module> survivedModules, Project project2) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project2);
        HashSet<Module> allModules = new HashSet<Module>(Arrays.asList(moduleManager.getModules()));
        survivedModules.forEach(module2 -> {
            List dependentModules = ModuleUtilCore.getAllDependentModules((Module)module2);
            dependentModules.add(module2);
            allModules.retainAll(dependentModules);
        });
        if (!allModules.isEmpty()) {
            Module aModule = (Module)allModules.iterator().next();
            for (Module module3 : survivedModules) {
                if (!allModules.contains(module3)) continue;
                aModule = module3;
            }
            return aModule;
        }
        return null;
    }

    @Override
    protected Module findModule(JavaTestConfigurationWithDiscoverySupport configuration, Module contextModule) {
        return null;
    }

    private static PsiMethod getSourceMethod(Location location) {
        PsiClass containingClass;
        PsiElement psiElement = location.getPsiElement();
        PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMethod.class);
        if (psiMethod != null && (containingClass = psiMethod.getContainingClass()) != null) {
            TestFramework testFramework = TestFrameworks.detectFramework((PsiClass)containingClass);
            if (testFramework != null) {
                return null;
            }
            return psiMethod;
        }
        return null;
    }

    private static Pair<String, String> getPosition(PsiMethod method) {
        if (method == null) {
            return null;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        String qualifiedName = ClassUtil.getJVMClassName((PsiClass)containingClass);
        if (qualifiedName != null) {
            return Pair.create((Object)qualifiedName, (Object)method.getName());
        }
        return null;
    }

    public boolean isConfigurationFromContext(JavaTestConfigurationWithDiscoverySupport configuration, ConfigurationContext configurationContext) {
        Pair<String, String> position = TestDiscoveryConfigurationProducer.getPosition(TestDiscoveryConfigurationProducer.getSourceMethod(configurationContext.getLocation()));
        return position != null && position.equals(this.getPosition(configuration));
    }

    protected static LinkedHashSet<String> collectMethodPatterns(@NotNull Location<PsiMethod>[] testMethods) {
        if (testMethods == null) {
            TestDiscoveryConfigurationProducer.$$$reportNull$$$0(0);
        }
        return Arrays.stream(testMethods).map(method -> {
            Iterator ancestors = method.getAncestors(PsiClass.class, true);
            return JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)((PsiClass)((Location)ancestors.next()).getPsiElement())) + "," + ((PsiMethod)method.getPsiElement()).getName();
        }).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testMethods", "com/intellij/execution/testDiscovery/TestDiscoveryConfigurationProducer", "collectMethodPatterns"));
    }

    private class MyRunProfile
    implements WrappingRunConfiguration<RunConfiguration>,
    RunConfiguration,
    ConfigurationWithCommandLineShortener,
    RunProfileWithCompileBeforeLaunchOption {
        private final Location<PsiMethod>[] myTestMethods;
        private final Module myModule;
        private final JavaTestConfigurationBase myConfiguration;
        private final String myConfigurationName;

        MyRunProfile(Location<PsiMethod>[] testMethods, Module module2, JavaTestConfigurationBase configuration, String configurationName) {
            this.myTestMethods = testMethods;
            this.myModule = module2;
            this.myConfiguration = configuration;
            this.myConfigurationName = configurationName;
        }

        @Nullable
        public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
            if (executor == null) {
                MyRunProfile.$$$reportNull$$$0(0);
            }
            if (environment == null) {
                MyRunProfile.$$$reportNull$$$0(1);
            }
            return TestDiscoveryConfigurationProducer.this.createProfile(this.myTestMethods, this.myModule, (RunConfiguration)this.myConfiguration, environment);
        }

        @NotNull
        public String getName() {
            String string = this.myConfigurationName;
            if (string == null) {
                MyRunProfile.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nullable
        public Icon getIcon() {
            return this.myConfiguration.getIcon();
        }

        @Nullable
        public ShortenCommandLine getShortenCommandLine() {
            return this.myConfiguration.getShortenCommandLine();
        }

        public void setShortenCommandLine(@Nullable ShortenCommandLine mode) {
            this.myConfiguration.setShortenCommandLine(mode);
        }

        @Nullable
        public ConfigurationFactory getFactory() {
            return this.myConfiguration.getFactory();
        }

        public void setName(@NotNull String name2) {
            if (name2 == null) {
                MyRunProfile.$$$reportNull$$$0(3);
            }
        }

        @NotNull
        public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
            SettingsEditor settingsEditor = this.myConfiguration.getConfigurationEditor();
            if (settingsEditor == null) {
                MyRunProfile.$$$reportNull$$$0(4);
            }
            return settingsEditor;
        }

        public Project getProject() {
            return this.myConfiguration.getProject();
        }

        public RunConfiguration clone() {
            return new MyRunProfile(this.myTestMethods, this.myModule, this.myConfiguration, this.myConfigurationName);
        }

        public RunConfiguration getPeer() {
            return this.myConfiguration;
        }

        @NotNull
        public Module[] getModules() {
            Module[] moduleArray = this.myConfiguration.getModules();
            if (moduleArray == null) {
                MyRunProfile.$$$reportNull$$$0(5);
            }
            return moduleArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/testDiscovery/TestDiscoveryConfigurationProducer$MyRunProfile";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/testDiscovery/TestDiscoveryConfigurationProducer$MyRunProfile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigurationEditor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModules";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getState";
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

