/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer;

import com.intellij.designer.DesignerToolWindowContent;
import com.intellij.designer.componentTree.ComponentTree;
import com.intellij.designer.componentTree.ComponentTreeBuilder;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.propertyTable.PropertyTablePanel;
import com.intellij.designer.propertyTable.RadPropertyTable;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public final class DesignerToolWindow
implements DesignerToolWindowContent {
    private final Splitter myToolWindowPanel;
    private ComponentTree myComponentTree = new ComponentTree();
    private ComponentTreeBuilder myTreeBuilder;
    private PropertyTablePanel myPropertyTablePanel;

    public DesignerToolWindow(Project project2, boolean updateOrientation) {
        JScrollPane treeScrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myComponentTree));
        treeScrollPane.setBorder(IdeBorderFactory.createBorder((int)8));
        treeScrollPane.setPreferredSize(new Dimension(250, -1));
        this.myComponentTree.initQuickFixManager(treeScrollPane.getViewport());
        this.myPropertyTablePanel = new PropertyTablePanel(project2);
        this.myToolWindowPanel = new Splitter(true, 0.42f){

            public void doLayout() {
                super.doLayout();
                JComponent firstComponent = this.getFirstComponent();
                JComponent secondComponent = this.getSecondComponent();
                if (firstComponent == null || secondComponent == null) {
                    return;
                }
                int firstHeight = firstComponent.getHeight();
                int dividerHeight = this.getDivider().getHeight();
                int height = this.getSize().height;
                if (firstHeight + dividerHeight + secondComponent.getHeight() != height) {
                    Rectangle bounds = secondComponent.getBounds();
                    bounds.height = height - firstHeight - dividerHeight;
                    secondComponent.setBounds(bounds);
                }
            }
        };
        this.myToolWindowPanel.setDividerWidth(3);
        this.myToolWindowPanel.setShowDividerControls(false);
        this.myToolWindowPanel.setShowDividerIcon(false);
        this.myToolWindowPanel.setFirstComponent((JComponent)treeScrollPane);
        this.myToolWindowPanel.setSecondComponent((JComponent)this.myPropertyTablePanel);
        if (updateOrientation) {
            this.myToolWindowPanel.addComponentListener((ComponentListener)new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    boolean newVertical;
                    Dimension size = DesignerToolWindow.this.myToolWindowPanel.getSize();
                    boolean bl = newVertical = size.width < size.height;
                    if (DesignerToolWindow.this.myToolWindowPanel.getOrientation() != newVertical) {
                        DesignerToolWindow.this.myToolWindowPanel.setOrientation(newVertical);
                    }
                }
            });
        }
    }

    void update(DesignerEditorPanel designer) {
        this.clearTreeBuilder();
        this.myComponentTree.newModel();
        if (designer == null) {
            this.myComponentTree.setDesignerPanel(null);
            this.myPropertyTablePanel.setArea(null, null);
        } else {
            this.myComponentTree.setDesignerPanel(designer);
            this.myTreeBuilder = new ComponentTreeBuilder(this.myComponentTree, designer);
            this.myPropertyTablePanel.setArea(designer, this.myTreeBuilder.getTreeArea());
        }
    }

    public void dispose() {
        this.clearTreeBuilder();
        this.myToolWindowPanel.dispose();
        this.myComponentTree = null;
        this.myPropertyTablePanel = null;
    }

    private void clearTreeBuilder() {
        if (this.myTreeBuilder != null) {
            Disposer.dispose((Disposable)this.myTreeBuilder);
            this.myTreeBuilder = null;
        }
    }

    Splitter getToolWindowPanel() {
        return this.myToolWindowPanel;
    }

    AnAction[] createActions() {
        AnAction expandAll = new AnAction("Expand All", null, AllIcons.Actions.Expandall){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (DesignerToolWindow.this.myTreeBuilder != null) {
                    TreeUtil.expandAll((JTree)((Object)DesignerToolWindow.this.myComponentTree));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/designer/DesignerToolWindow$3", "actionPerformed"));
            }
        };
        AnAction collapseAll = new AnAction("Collapse All", null, AllIcons.Actions.Collapseall){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (DesignerToolWindow.this.myTreeBuilder != null) {
                    TreeUtil.collapseAll((JTree)((Object)DesignerToolWindow.this.myComponentTree), (int)1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/designer/DesignerToolWindow$4", "actionPerformed"));
            }
        };
        return new AnAction[]{expandAll, collapseAll};
    }

    public ComponentTree getComponentTree() {
        return this.myComponentTree;
    }

    public RadPropertyTable getPropertyTable() {
        return this.myPropertyTablePanel.getPropertyTable();
    }

    @Override
    public void expandFromState() {
        if (this.myTreeBuilder != null) {
            this.myTreeBuilder.expandFromState();
        }
    }

    @Override
    public void refresh(boolean updateProperties) {
        if (this.myTreeBuilder != null) {
            if (updateProperties) {
                this.myTreeBuilder.selectFromSurface();
            } else {
                this.myTreeBuilder.queueUpdate();
            }
        }
    }

    @Override
    public void updateInspections() {
        if (this.myComponentTree != null) {
            this.myComponentTree.updateInspections();
        }
        if (this.myPropertyTablePanel != null) {
            this.myPropertyTablePanel.getPropertyTable().updateInspections();
        }
    }
}

