/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.ui.impl.ValueNodeDnD;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.project.Project;
import com.intellij.ui.PopupHandler;
import java.awt.Component;
import java.awt.event.MouseListener;
import org.jetbrains.annotations.NotNull;

public class InspectDebuggerTree
extends DebuggerTree {
    private NodeDescriptorImpl myInspectDescriptor;

    public InspectDebuggerTree(Project project2) {
        super(project2);
        PopupHandler popupHandler = new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionPopupMenu popupMenu = InspectDebuggerTree.createPopupMenu();
                if (popupMenu != null) {
                    InspectDebuggerTree.this.myTipManager.registerPopup(popupMenu.getComponent()).show(comp, x, y);
                }
            }
        };
        this.addMouseListener((MouseListener)popupHandler);
        new ValueNodeDnD(this, (Disposable)project2);
    }

    public static ActionPopupMenu createPopupMenu() {
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("Debugger.InspectPanelPopup");
        return ActionManager.getInstance().createActionPopupMenu("Debugger.InspectPanelPopup", group);
    }

    @Override
    protected void build(DebuggerContextImpl context) {
        this.updateNode(context);
    }

    public void setInspectDescriptor(NodeDescriptorImpl inspectDescriptor) {
        this.myInspectDescriptor = inspectDescriptor;
    }

    public NodeDescriptorImpl getInspectDescriptor() {
        return this.myInspectDescriptor;
    }

    private void updateNode(final DebuggerContextImpl context) {
        context.getDebugProcess().getManagerThread().schedule(new DebuggerContextCommandImpl(context){

            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    2.$$$reportNull$$$0(0);
                }
                DebuggerTreeNodeImpl node = InspectDebuggerTree.this.getNodeFactory().createNode(InspectDebuggerTree.this.myInspectDescriptor, context.createEvaluationContext());
                DebuggerInvocationUtil.swingInvokeLater(InspectDebuggerTree.this.getProject(), () -> {
                    DebuggerTreeNodeImpl root = (DebuggerTreeNodeImpl)InspectDebuggerTree.this.getModel().getRoot();
                    root.removeAllChildren();
                    root.add(node);
                    InspectDebuggerTree.this.treeChanged();
                    root.getTree().expandRow(0);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/ui/impl/InspectDebuggerTree$2", "threadAction"));
            }
        });
    }
}

