/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.java.debugger.breakpoints.properties.JavaExceptionBreakpointProperties;

public class ExceptionBreakpoint
extends Breakpoint<JavaExceptionBreakpointProperties> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.ExceptionBreakpoint");
    protected static final String READ_NO_CLASS_NAME = DebuggerBundle.message((String)"error.absent.exception.breakpoint.class.name", (Object[])new Object[0]);
    @NonNls
    public static final Key<ExceptionBreakpoint> CATEGORY = BreakpointCategory.lookup("exception_breakpoints");

    public ExceptionBreakpoint(Project project2, XBreakpoint<JavaExceptionBreakpointProperties> xBreakpoint) {
        super(project2, xBreakpoint);
    }

    @Override
    public Key<? extends ExceptionBreakpoint> getCategory() {
        return CATEGORY;
    }

    protected ExceptionBreakpoint(Project project2, String qualifiedName, String packageName, XBreakpoint<JavaExceptionBreakpointProperties> xBreakpoint) {
        super(project2, xBreakpoint);
        this.setQualifiedName(qualifiedName);
        if (packageName == null) {
            this.setPackageName(ExceptionBreakpoint.calcPackageName(qualifiedName));
        } else {
            this.setPackageName(packageName);
        }
    }

    private static String calcPackageName(String qualifiedName) {
        if (qualifiedName == null) {
            return null;
        }
        int dotIndex = qualifiedName.lastIndexOf(46);
        return dotIndex >= 0 ? qualifiedName.substring(0, dotIndex) : "";
    }

    @Override
    public String getClassName() {
        return this.getQualifiedName();
    }

    @Override
    public String getPackageName() {
        return ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).myPackageName;
    }

    @Override
    public PsiClass getPsiClass() {
        return (PsiClass)ReadAction.compute(() -> this.getQualifiedName() != null ? DebuggerUtils.findClass((String)this.getQualifiedName(), (Project)this.myProject, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject)) : null);
    }

    @Override
    public String getDisplayName() {
        return DebuggerBundle.message((String)"breakpoint.exception.breakpoint.display.name", (Object[])new Object[]{this.getQualifiedName()});
    }

    @Override
    public Icon getIcon() {
        return AllIcons.Debugger.Db_exception_breakpoint;
    }

    @Override
    public void reload() {
    }

    @Override
    public void createRequest(DebugProcessImpl debugProcess) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!this.shouldCreateRequest(debugProcess)) {
            return;
        }
        SourcePosition classPosition = (SourcePosition)ReadAction.compute(() -> {
            PsiClass psiClass = DebuggerUtils.findClass((String)this.getQualifiedName(), (Project)this.myProject, (GlobalSearchScope)debugProcess.getSearchScope());
            return psiClass != null ? SourcePosition.createFromElement((PsiElement)psiClass) : null;
        });
        if (classPosition == null) {
            this.createOrWaitPrepare(debugProcess, this.getQualifiedName());
        } else {
            this.createOrWaitPrepare(debugProcess, classPosition);
        }
    }

    @Override
    public void processClassPrepare(DebugProcess process2, ReferenceType refType) {
        DebugProcessImpl debugProcess = (DebugProcessImpl)process2;
        if (this.shouldCreateRequest(debugProcess, true) && !debugProcess.getRequestsManager().checkReadOnly(this)) {
            RequestManagerImpl manager = debugProcess.getRequestsManager();
            manager.enableRequest(manager.createExceptionRequest(this, refType, this.isNotifyCaught(), this.isNotifyUncaught()));
            if (LOG.isDebugEnabled()) {
                if (refType != null) {
                    LOG.debug("Created exception request for reference type " + refType.name());
                } else {
                    LOG.debug("Created exception request for reference type null");
                }
            }
        }
    }

    @Override
    protected String calculateEventClass(EvaluationContextImpl context, LocatableEvent event) throws EvaluateException {
        return event.location().declaringType().name();
    }

    @Override
    protected ObjectReference getThisObject(SuspendContextImpl context, LocatableEvent event) throws EvaluateException {
        if (event instanceof ExceptionEvent) {
            return ((ExceptionEvent)event).exception();
        }
        return super.getThisObject(context, event);
    }

    @Override
    public String getEventMessage(LocatableEvent event) {
        String locationInfo;
        String exceptionName = this.getQualifiedName() != null ? this.getQualifiedName() : "java.lang.Throwable";
        String threadName = null;
        if (event instanceof ExceptionEvent) {
            ExceptionEvent exceptionEvent = (ExceptionEvent)event;
            try {
                exceptionName = exceptionEvent.exception().type().name();
                threadName = exceptionEvent.thread().name();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Location location = event.location();
        String locationQName = DebuggerUtilsEx.getLocationMethodQName(location);
        try {
            String file = location.sourceName();
            int line = DebuggerUtilsEx.getLineNumber(location, false);
            locationInfo = DebuggerBundle.message((String)"exception.breakpoint.console.message.location.info", (Object[])new Object[]{file, line});
        }
        catch (AbsentInformationException e) {
            locationInfo = DebuggerBundle.message((String)"exception.breakpoint.console.message.location.info.absent", (Object[])new Object[0]);
        }
        if (threadName != null) {
            return DebuggerBundle.message((String)"exception.breakpoint.console.message.with.thread.info", (Object[])new Object[]{exceptionName, threadName, locationQName, locationInfo});
        }
        return DebuggerBundle.message((String)"exception.breakpoint.console.message", (Object[])new Object[]{exceptionName, locationQName, locationInfo});
    }

    @Override
    public boolean evaluateCondition(EvaluationContextImpl context, LocatableEvent event) throws EvaluateException {
        Location location;
        if (((JavaExceptionBreakpointProperties)((Object)this.getProperties())).isCatchFiltersEnabled() && event instanceof ExceptionEvent && (location = ((ExceptionEvent)event).catchLocation()) != null && !ExceptionBreakpoint.typeMatchesClassFilters(location.declaringType().name(), ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).getCatchClassFilters(), ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).getCatchClassExclusionFilters())) {
            return false;
        }
        return super.evaluateCondition(context, event);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public PsiElement getEvaluationElement() {
        if (this.getClassName() == null) {
            return null;
        }
        return JavaPsiFacade.getInstance((Project)this.myProject).findClass(this.getClassName(), GlobalSearchScope.allScope((Project)this.myProject));
    }

    @Override
    public void readExternal(Element parentNode) throws InvalidDataException {
        super.readExternal(parentNode);
        String packageName = parentNode.getAttributeValue("package_name");
        this.setPackageName(packageName != null ? packageName : ExceptionBreakpoint.calcPackageName(packageName));
        try {
            ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).NOTIFY_CAUGHT = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)parentNode, (String)"NOTIFY_CAUGHT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).NOTIFY_UNCAUGHT = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)parentNode, (String)"NOTIFY_UNCAUGHT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String className = parentNode.getAttributeValue("class_name");
        this.setQualifiedName(className);
        if (className == null) {
            throw new InvalidDataException(READ_NO_CLASS_NAME);
        }
    }

    private boolean isNotifyCaught() {
        return ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).NOTIFY_CAUGHT;
    }

    private boolean isNotifyUncaught() {
        return ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).NOTIFY_UNCAUGHT;
    }

    private String getQualifiedName() {
        return ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).myQualifiedName;
    }

    void setQualifiedName(String qualifiedName) {
        ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).myQualifiedName = qualifiedName;
    }

    void setPackageName(String packageName) {
        ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).myPackageName = packageName;
    }

    public void setCatchFiltersEnabled(boolean enabled) {
        ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).setCatchFiltersEnabled(enabled);
    }

    public void setCatchClassFilters(ClassFilter[] filters) {
        ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).setCatchClassFilters(filters);
    }

    public void setCatchClassExclusionFilters(ClassFilter[] filters) {
        ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).setCatchClassExclusionFilters(filters);
    }
}

