/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.engine.DebugProcessEvents;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.settings.TraceSettings;
import com.intellij.debugger.ui.overhead.OverheadProducer;
import com.intellij.debugger.ui.overhead.OverheadTimings;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.Consumer;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MethodEntryRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CallTracer
implements OverheadProducer {
    private static final Logger LOG = Logger.getInstance(CallTracer.class);
    public static final Key<CallTracer> CALL_TRACER_KEY = Key.create((String)"CALL_TRACER");
    private final EventRequestManager myRequestManager;
    private final DebugProcessImpl myDebugProcess;
    private final Map<ThreadReference, ThreadRequest> myThreadRequests = new ConcurrentHashMap<ThreadReference, ThreadRequest>();

    public CallTracer(DebugProcessImpl debugProcess) {
        this.myDebugProcess = debugProcess;
        this.myRequestManager = debugProcess.getRequestsManager().getVMRequestManager();
    }

    public void start(@Nullable ThreadReferenceProxyImpl thread) {
        try {
            if (thread != null) {
                this.start(thread.getThreadReference(), thread.frameCount());
            }
        }
        catch (EvaluateException e) {
            LOG.error((Throwable)e);
        }
    }

    private void start(@NotNull ThreadReference thread, int startIndent) {
        if (thread == null) {
            CallTracer.$$$reportNull$$$0(0);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myThreadRequests.computeIfAbsent(thread, t -> new ThreadRequest((ThreadReference)t, startIndent));
    }

    public void stop(@NotNull ThreadReference thread) {
        if (thread == null) {
            CallTracer.$$$reportNull$$$0(1);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ThreadRequest request = this.myThreadRequests.remove(thread);
        if (request != null) {
            request.stop();
        }
    }

    public void stopAll() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ArrayList<ThreadRequest> requests = new ArrayList<ThreadRequest>(this.myThreadRequests.values());
        this.myThreadRequests.clear();
        requests.forEach(ThreadRequest::stop);
    }

    private void accept(Event event) {
        block14: {
            OverheadTimings.add(this.myDebugProcess, this, 1L, null);
            if (event instanceof MethodEntryEvent) {
                MethodEntryEvent methodEntryEvent = (MethodEntryEvent)event;
                try {
                    ThreadReference thread = methodEntryEvent.thread();
                    ThreadRequest request = this.myThreadRequests.get(thread);
                    if (request == null) break block14;
                    for (SuspendContextImpl context : this.myDebugProcess.getSuspendManager().getEventContexts()) {
                        ThreadReferenceProxyImpl contextThread = context.getThread();
                        if (!context.isEvaluating() || contextThread == null || !contextThread.getThreadReference().equals(thread)) continue;
                        return;
                    }
                    int indent = thread.frameCount() - request.myStartIndent;
                    String indentString = indent < 0 ? "-" : StringUtil.repeat((String)" ", (int)indent);
                    Method method = methodEntryEvent.method();
                    StringBuilder res = new StringBuilder("\n");
                    res.append(indentString).append(method.declaringType().name()).append('.').append(method.name()).append('(');
                    if (Registry.is((String)"debugger.call.tracing.arguments")) {
                        StackFrame frame = thread.frame(0);
                        boolean first = true;
                        for (Value value : DebuggerUtilsEx.getArgumentValues(frame)) {
                            if (!first) {
                                res.append(", ");
                            }
                            first = false;
                            if (value == null) {
                                res.append("null");
                                continue;
                            }
                            if (value instanceof StringReference) {
                                res.append(((StringReference)value).value());
                                continue;
                            }
                            if (value instanceof ObjectReference) {
                                ObjectReference objectReference = (ObjectReference)value;
                                res.append(StringUtil.getShortName((String)objectReference.referenceType().name())).append("@").append(objectReference.uniqueID());
                                continue;
                            }
                            res.append(value.toString());
                        }
                    } else {
                        boolean first = true;
                        for (String typeName : method.argumentTypeNames()) {
                            if (!first) {
                                res.append(", ");
                            }
                            first = false;
                            res.append(StringUtil.getShortName((String)typeName));
                        }
                    }
                    res.append(')').append(" thread ").append(thread.uniqueID());
                    this.myDebugProcess.printToConsole(res.toString());
                }
                catch (VMDisconnectedException vmd) {
                    throw vmd;
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return !this.myThreadRequests.isEmpty();
    }

    @Override
    public void setEnabled(boolean state) {
        this.myDebugProcess.getManagerThread().schedule(PrioritizedTask.Priority.HIGH, () -> {
            DebuggerContextImpl debuggerContext = this.myDebugProcess.getDebuggerContext();
            ThreadReferenceProxyImpl threadProxy = debuggerContext.getThreadProxy();
            if (state) {
                StackFrameProxyImpl frame = debuggerContext.getFrameProxy();
                if (frame != null && threadProxy != null) {
                    this.start(threadProxy.getThreadReference(), frame.getIndexFromBottom());
                }
            } else if (threadProxy != null) {
                this.stop(threadProxy.getThreadReference());
            } else {
                this.stopAll();
            }
        });
    }

    @Override
    public void customizeRenderer(SimpleColoredComponent renderer) {
        renderer.append("Call Tracer");
    }

    @NotNull
    public static CallTracer get(DebugProcessImpl debugProcess) {
        CallTracer tracer = (CallTracer)debugProcess.getUserData(CALL_TRACER_KEY);
        if (tracer == null) {
            tracer = new CallTracer(debugProcess);
            debugProcess.putUserData(CALL_TRACER_KEY, tracer);
        }
        CallTracer callTracer = tracer;
        if (callTracer == null) {
            CallTracer.$$$reportNull$$$0(2);
        }
        return callTracer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/CallTracer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/CallTracer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "stop";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CallTracerToggleAction
    extends DumbAwareToggleAction {
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CallTracerToggleAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabledAndVisible(Registry.is((String)"debugger.call.tracing"));
            super.update(e);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            CallTracer tracer;
            DebugProcessImpl process2;
            if (e == null) {
                CallTracerToggleAction.$$$reportNull$$$0(1);
            }
            if ((process2 = JavaDebugProcess.getCurrentDebugProcess(e.getProject())) != null && (tracer = (CallTracer)process2.getUserData(CALL_TRACER_KEY)) != null) {
                return tracer.isEnabled();
            }
            return false;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            DebugProcessImpl process2;
            if (e == null) {
                CallTracerToggleAction.$$$reportNull$$$0(2);
            }
            if ((process2 = JavaDebugProcess.getCurrentDebugProcess(e.getProject())) != null) {
                CallTracer.get(process2).setEnabled(state);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/debugger/ui/breakpoints/CallTracer$CallTracerToggleAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ThreadRequest {
        private final List<MethodEntryRequest> myEntryRequests = new ArrayList<MethodEntryRequest>(1);
        private final int myStartIndent;

        private ThreadRequest(ThreadReference thread, int startIndent) {
            this.myStartIndent = startIndent;
            TraceSettings traceSettings = TraceSettings.getInstance();
            ClassFilter[] classFilters = traceSettings.getClassFilters();
            ClassFilter[] exclusionFilters = traceSettings.getClassExclusionFilters();
            if (DebuggerUtilsEx.getEnabledNumber(classFilters) == 0) {
                this.addEntryRequest(null, exclusionFilters, thread);
            } else {
                for (ClassFilter filter : classFilters) {
                    if (!filter.isEnabled()) continue;
                    this.addEntryRequest(filter, exclusionFilters, thread);
                }
            }
        }

        private void addEntryRequest(ClassFilter filter, ClassFilter[] exclusionFilters, ThreadReference thread) {
            ClassFilter[] classFilterArray;
            MethodEntryRequest request = CallTracer.this.myRequestManager.createMethodEntryRequest();
            request.setSuspendPolicy(1);
            request.addThreadFilter(thread);
            RequestManagerImpl requestManagerImpl = CallTracer.this.myDebugProcess.getRequestsManager();
            if (filter != null) {
                ClassFilter[] classFilterArray2 = new ClassFilter[1];
                classFilterArray = classFilterArray2;
                classFilterArray2[0] = filter;
            } else {
                classFilterArray = ClassFilter.EMPTY_ARRAY;
            }
            requestManagerImpl.addClassFilters(request, classFilterArray, exclusionFilters);
            this.myEntryRequests.add(request);
            DebugProcessEvents.enableRequestWithHandler(request, (Consumer<Event>)((Consumer)x$0 -> CallTracer.this.accept(x$0)));
        }

        void stop() {
            this.myEntryRequests.forEach(CallTracer.this.myRequestManager::deleteEventRequest);
        }
    }
}

