/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.memory.agent.MemoryAgentUtil;
import com.intellij.debugger.memory.filtering.FilteringResult;
import com.intellij.debugger.memory.filtering.FilteringTask;
import com.intellij.debugger.memory.filtering.FilteringTaskCallback;
import com.intellij.debugger.memory.ui.ExpressionEditorWithHistory;
import com.intellij.debugger.memory.ui.FilteringProgressView;
import com.intellij.debugger.memory.ui.InstancesWithStackFrameView;
import com.intellij.debugger.memory.ui.JavaReferenceInfo;
import com.intellij.debugger.memory.ui.StackFrameList;
import com.intellij.debugger.memory.utils.ErrorsValueGroup;
import com.intellij.debugger.memory.utils.InstanceJavaValue;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionEditor;
import com.intellij.xdebugger.memory.ui.InstancesTree;
import com.intellij.xdebugger.memory.ui.InstancesViewBase;
import com.intellij.xdebugger.memory.utils.InstancesProvider;
import com.sun.jdi.VirtualMachine;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

class InstancesView
extends InstancesViewBase {
    private static final Logger LOG = Logger.getInstance(InstancesView.class);
    private static final int MAX_TREE_NODE_COUNT = 2000;
    private static final int FILTERING_CHUNK_SIZE = 50;
    private static final int FILTERING_BUTTON_ADDITIONAL_WIDTH = 30;
    private static final int BORDER_LAYOUT_DEFAULT_GAP = 5;
    private static final int DEFAULT_INSTANCES_LIMIT = 500000;
    private static final int MAX_DURATION_TO_UPDATE_TREE_SECONDS = 3;
    private static final int FILTERING_PROGRESS_UPDATING_MIN_DELAY_MILLIS = 17;
    private final InstancesTree myInstancesTree;
    private final XDebuggerExpressionEditor myFilterConditionEditor;
    private final MyNodeManager myNodeManager;
    private final Consumer<? super String> myWarningMessageConsumer;
    private final JButton myFilterButton;
    private final FilteringProgressView myProgress;
    private final Object myFilteringTaskLock;
    private boolean myIsAndroidVM;
    private final DebugProcessImpl myDebugProcess;
    private final String myClassName;
    private volatile MyFilteringWorker myFilteringTask;

    InstancesView(@NotNull XDebugSession session, InstancesProvider instancesProvider, String className, Consumer<? super String> warningMessageConsumer) {
        if (session == null) {
            InstancesView.$$$reportNull$$$0(0);
        }
        super((LayoutManager)new BorderLayout(0, JBUI.scale((int)5)), session, instancesProvider);
        this.myFilterButton = new JButton("Filter");
        this.myProgress = new FilteringProgressView();
        this.myFilteringTaskLock = new Object();
        this.myIsAndroidVM = false;
        this.myFilteringTask = null;
        this.myClassName = className;
        this.myDebugProcess = (DebugProcessImpl)DebuggerManager.getInstance((Project)session.getProject()).getDebugProcess(session.getDebugProcess().getProcessHandler());
        this.myNodeManager = new MyNodeManager(session.getProject());
        this.myWarningMessageConsumer = warningMessageConsumer;
        XDebuggerEditorsProvider editorsProvider = session.getDebugProcess().getEditorsProvider();
        this.myFilterConditionEditor = new ExpressionEditorWithHistory(session.getProject(), className, editorsProvider, (Disposable)this);
        Dimension filteringButtonSize = this.myFilterConditionEditor.getEditorComponent().getPreferredSize();
        filteringButtonSize.width = JBUI.scale((int)30) + this.getFilterButton().getPreferredSize().width;
        this.getFilterButton().setPreferredSize(filteringButtonSize);
        JBPanel filteringPane = new JBPanel((LayoutManager)new BorderLayout(JBUI.scale((int)5), 0));
        JBLabel sideEffectsWarning = new JBLabel("Warning: filtering may have side effects", 4);
        sideEffectsWarning.setBorder((Border)JBUI.Borders.emptyTop((int)1));
        sideEffectsWarning.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        sideEffectsWarning.setFontColor(UIUtil.FontColor.BRIGHTER);
        filteringPane.add((Component)new JBLabel("Condition:"), (Object)"West");
        filteringPane.add((Component)this.myFilterConditionEditor.getComponent(), (Object)"Center");
        filteringPane.add((Component)this.getFilterButton(), (Object)"East");
        filteringPane.add((Component)sideEffectsWarning, (Object)"South");
        this.getProgress().addStopActionListener(this::cancelFilteringTask);
        this.myInstancesTree = new InstancesTree(session.getProject(), editorsProvider, this.getValueMarkers(session), this::updateInstances);
        this.getFilterButton().addActionListener(e -> {
            String expression = this.myFilterConditionEditor.getExpression().getExpression();
            if (!expression.isEmpty()) {
                this.myFilterConditionEditor.saveTextInHistory();
            }
            this.getFilterButton().setEnabled(false);
            this.myInstancesTree.rebuildTree(InstancesTree.RebuildPolicy.RELOAD_INSTANCES);
        });
        final StackFrameList list = new StackFrameList(this.myDebugProcess);
        list.addListSelectionListener(e -> list.navigateToSelectedValue(false));
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                list.navigateToSelectedValue(true);
                return true;
            }
        }.installOn((Component)((Object)list));
        InstancesWithStackFrameView instancesWithStackFrame = new InstancesWithStackFrameView(session, this.myInstancesTree, list, className);
        this.add((Component)filteringPane, "North");
        this.add(instancesWithStackFrame.getComponent(), "Center");
        JComponent focusedComponent = this.myFilterConditionEditor.getEditorComponent();
        UiNotifyConnector.doWhenFirstShown((JComponent)focusedComponent, () -> IdeFocusManager.findInstanceByComponent((Component)focusedComponent).requestFocus((Component)focusedComponent, true));
        session.addSessionListener(new XDebugSessionListener(){

            public void sessionPaused() {
                ApplicationManager.getApplication().invokeLater(() -> InstancesView.this.cancelFilteringTask());
            }

            public void sessionResumed() {
                ApplicationManager.getApplication().invokeLater(() -> InstancesView.this.getProgress().setVisible(true));
            }
        });
    }

    protected InstancesTree getInstancesTree() {
        return this.myInstancesTree;
    }

    public void dispose() {
        this.cancelFilteringTask();
        Disposer.dispose((Disposable)this.myInstancesTree);
    }

    private void updateInstances() {
        this.cancelFilteringTask();
        this.myDebugProcess.getManagerThread().schedule(new DebuggerContextCommandImpl(this.myDebugProcess.getDebuggerContext()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.LOWEST;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    3.$$$reportNull$$$0(0);
                }
                InstancesView.this.myIsAndroidVM = DebuggerUtils.isAndroidVM((VirtualMachine)InstancesView.this.myDebugProcess.getVirtualMachineProxy().getVirtualMachine());
                int limit = InstancesView.this.myIsAndroidVM ? 30000 : 500000;
                List<JavaReferenceInfo> instances = ContainerUtil.map((Collection)InstancesView.this.getInstancesProvider().getInstances(limit + 1), referenceInfo -> (JavaReferenceInfo)referenceInfo);
                EvaluationContextImpl evaluationContext = InstancesView.this.myDebugProcess.getDebuggerContext().createEvaluationContext();
                if (instances.size() > limit) {
                    InstancesView.this.myWarningMessageConsumer.accept(String.format("Not all instances will be loaded (only %d)", limit));
                    instances = instances.subList(0, limit);
                }
                if (Registry.is((String)"debugger.memory.agent.use.in.memory.view")) {
                    instances = MemoryAgentUtil.tryCalculateSizes(instances, InstancesView.this.myDebugProcess.getMemoryAgent());
                }
                if (evaluationContext != null) {
                    Object object = InstancesView.this.myFilteringTaskLock;
                    synchronized (object) {
                        List<JavaReferenceInfo> finalInstances = instances;
                        ApplicationManager.getApplication().runReadAction(() -> {
                            InstancesView.this.myFilteringTask = new MyFilteringWorker(finalInstances, InstancesView.this.myFilterConditionEditor.getExpression(), evaluationContext);
                            InstancesView.this.myFilteringTask.execute();
                        });
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/memory/ui/InstancesView$3", "threadAction"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelFilteringTask() {
        if (this.myFilteringTask != null) {
            Object object = this.myFilteringTaskLock;
            synchronized (object) {
                if (this.myFilteringTask != null) {
                    this.myFilteringTask.cancel();
                    this.myFilteringTask = null;
                }
            }
        }
    }

    public JButton getFilterButton() {
        return this.myFilterButton;
    }

    public FilteringProgressView getProgress() {
        return this.myProgress;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/debugger/memory/ui/InstancesView", "<init>"));
    }

    private class MyFilteringWorker
    extends SwingWorker<Void, Void> {
        private final FilteringTask myTask;

        MyFilteringWorker(@NotNull List<JavaReferenceInfo> refs, @NotNull XExpression expression, EvaluationContextImpl evaluationContext) {
            if (refs == null) {
                MyFilteringWorker.$$$reportNull$$$0(0);
            }
            if (expression == null) {
                MyFilteringWorker.$$$reportNull$$$0(1);
            }
            if (evaluationContext == null) {
                MyFilteringWorker.$$$reportNull$$$0(2);
            }
            this.myTask = new FilteringTask(InstancesView.this.myClassName, InstancesView.this.myDebugProcess, expression, new MyValuesList(refs), new MyFilteringCallback(evaluationContext));
        }

        @Override
        protected Void doInBackground() {
            try {
                this.myTask.run();
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            return null;
        }

        public void cancel() {
            this.myTask.cancel();
            super.cancel(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "refs";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "expression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "evaluationContext";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/memory/ui/InstancesView$MyFilteringWorker";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyValuesList
    implements FilteringTask.ValuesList {
        private final List<? extends JavaReferenceInfo> myRefs;

        MyValuesList(List<? extends JavaReferenceInfo> refs) {
            this.myRefs = refs;
        }

        @Override
        public int size() {
            return this.myRefs.size();
        }

        @Override
        public JavaReferenceInfo get(int index) {
            return this.myRefs.get(index);
        }
    }

    private class MyFilteringCallback
    implements FilteringTaskCallback {
        private final ErrorsValueGroup myErrorsGroup;
        private final EvaluationContextImpl myEvaluationContext;
        private long myFilteringStartedTime;
        private int myProceedCount;
        private int myMatchedCount;
        private int myErrorsCount;
        private long myLastTreeUpdatingTime;
        private long myLastProgressUpdatingTime;
        private XValueChildrenList myChildren;

        MyFilteringCallback(EvaluationContextImpl evaluationContext) {
            if (evaluationContext == null) {
                MyFilteringCallback.$$$reportNull$$$0(0);
            }
            this.myErrorsGroup = new ErrorsValueGroup();
            this.myProceedCount = 0;
            this.myMatchedCount = 0;
            this.myErrorsCount = 0;
            this.myChildren = new XValueChildrenList();
            this.myEvaluationContext = evaluationContext;
        }

        @Override
        public void started(int total) {
            this.myLastTreeUpdatingTime = this.myFilteringStartedTime = System.nanoTime();
            this.myLastProgressUpdatingTime = System.nanoTime();
            ApplicationManager.getApplication().invokeLater(() -> InstancesView.this.getProgress().start(total));
        }

        @Override
        @NotNull
        public FilteringTaskCallback.Action matched(@NotNull JavaReferenceInfo ref) {
            if (ref == null) {
                MyFilteringCallback.$$$reportNull$$$0(1);
            }
            InstanceJavaValue val = new InstanceJavaValue(ref.createDescriptor(InstancesView.this.myDebugProcess.getProject()), this.myEvaluationContext, InstancesView.this.myNodeManager);
            ++this.myMatchedCount;
            ++this.myProceedCount;
            this.myChildren.add((XNamedValue)val);
            this.updateProgress();
            this.updateTree();
            FilteringTaskCallback.Action action = this.myMatchedCount < 2000 ? FilteringTaskCallback.Action.CONTINUE : FilteringTaskCallback.Action.STOP;
            if (action == null) {
                MyFilteringCallback.$$$reportNull$$$0(2);
            }
            return action;
        }

        @Override
        @NotNull
        public FilteringTaskCallback.Action notMatched(@NotNull JavaReferenceInfo ref) {
            if (ref == null) {
                MyFilteringCallback.$$$reportNull$$$0(3);
            }
            ++this.myProceedCount;
            this.updateProgress();
            FilteringTaskCallback.Action action = FilteringTaskCallback.Action.CONTINUE;
            if (action == null) {
                MyFilteringCallback.$$$reportNull$$$0(4);
            }
            return action;
        }

        @Override
        @NotNull
        public FilteringTaskCallback.Action error(@NotNull JavaReferenceInfo ref, @NotNull String description) {
            if (ref == null) {
                MyFilteringCallback.$$$reportNull$$$0(5);
            }
            if (description == null) {
                MyFilteringCallback.$$$reportNull$$$0(6);
            }
            InstanceJavaValue val = new InstanceJavaValue(ref.createDescriptor(InstancesView.this.myDebugProcess.getProject()), this.myEvaluationContext, InstancesView.this.myNodeManager);
            this.myErrorsGroup.addErrorValue(description, val);
            ++this.myProceedCount;
            ++this.myErrorsCount;
            this.updateProgress();
            FilteringTaskCallback.Action action = FilteringTaskCallback.Action.CONTINUE;
            if (action == null) {
                MyFilteringCallback.$$$reportNull$$$0(7);
            }
            return action;
        }

        @Override
        public void completed(@NotNull FilteringResult reason) {
            if (reason == null) {
                MyFilteringCallback.$$$reportNull$$$0(8);
            }
            if (!this.myErrorsGroup.isEmpty()) {
                this.myChildren.addBottomGroup((XValueGroup)this.myErrorsGroup);
            }
            long duration = System.nanoTime() - this.myFilteringStartedTime;
            LOG.info(String.format("Filtering completed in %d ms for %d instances", TimeUnit.NANOSECONDS.toMillis(duration), this.myProceedCount));
            int proceed = this.myProceedCount;
            int matched = this.myMatchedCount;
            int errors = this.myErrorsCount;
            XValueChildrenList childrenList = this.myChildren;
            ApplicationManager.getApplication().invokeLater(() -> {
                InstancesView.this.getProgress().updateProgress(proceed, matched, errors);
                InstancesView.this.myInstancesTree.addChildren(childrenList, true);
                InstancesView.this.getFilterButton().setEnabled(true);
                InstancesView.this.getProgress().complete(reason);
            });
        }

        private void updateProgress() {
            long now = System.nanoTime();
            if (now - this.myLastProgressUpdatingTime > TimeUnit.MILLISECONDS.toNanos(17L)) {
                int proceed = this.myProceedCount;
                int matched = this.myMatchedCount;
                int errors = this.myErrorsCount;
                ApplicationManager.getApplication().invokeLater(() -> InstancesView.this.getProgress().updateProgress(proceed, matched, errors));
                this.myLastProgressUpdatingTime = now;
            }
        }

        private void updateTree() {
            long now = System.nanoTime();
            int newChildrenCount = this.myChildren.size();
            if (newChildrenCount >= 50 || newChildrenCount > 0 && now - this.myLastTreeUpdatingTime > TimeUnit.SECONDS.toNanos(3L)) {
                XValueChildrenList children = this.myChildren;
                ApplicationManager.getApplication().invokeLater(() -> InstancesView.this.myInstancesTree.addChildren(children, false));
                this.myChildren = new XValueChildrenList();
                this.myLastTreeUpdatingTime = System.nanoTime();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evaluationContext";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 2: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/memory/ui/InstancesView$MyFilteringCallback";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reason";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/memory/ui/InstancesView$MyFilteringCallback";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "matched";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "notMatched";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "error";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "matched";
                    break;
                }
                case 2: 
                case 4: 
                case 7: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "notMatched";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "error";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "completed";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class MyNodeManager
    extends NodeManagerImpl {
        MyNodeManager(Project project2) {
            super(project2, null);
        }

        @Override
        @NotNull
        public DebuggerTreeNodeImpl createNode(NodeDescriptor descriptor2, EvaluationContext evaluationContext) {
            DebuggerTreeNodeImpl debuggerTreeNodeImpl = new DebuggerTreeNodeImpl(null, descriptor2);
            if (debuggerTreeNodeImpl == null) {
                MyNodeManager.$$$reportNull$$$0(0);
            }
            return debuggerTreeNodeImpl;
        }

        @Override
        public DebuggerTreeNodeImpl createMessageNode(MessageDescriptor descriptor2) {
            return new DebuggerTreeNodeImpl(null, descriptor2);
        }

        @Override
        @NotNull
        public DebuggerTreeNodeImpl createMessageNode(String message) {
            DebuggerTreeNodeImpl debuggerTreeNodeImpl = new DebuggerTreeNodeImpl(null, new MessageDescriptor(message));
            if (debuggerTreeNodeImpl == null) {
                MyNodeManager.$$$reportNull$$$0(1);
            }
            return debuggerTreeNodeImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/debugger/memory/ui/InstancesView$MyNodeManager";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createMessageNode";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

