/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionEditor;
import java.awt.Component;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingWorker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExpressionEditorWithHistory
extends XDebuggerExpressionEditor {
    private static final String HISTORY_ID_PREFIX = "filtering";

    ExpressionEditorWithHistory(final @NotNull Project project2, final @NotNull String className, @NotNull XDebuggerEditorsProvider debuggerEditorsProvider, @Nullable Disposable parentDisposable) {
        if (project2 == null) {
            ExpressionEditorWithHistory.$$$reportNull$$$0(0);
        }
        if (className == null) {
            ExpressionEditorWithHistory.$$$reportNull$$$0(1);
        }
        if (debuggerEditorsProvider == null) {
            ExpressionEditorWithHistory.$$$reportNull$$$0(2);
        }
        super(project2, debuggerEditorsProvider, HISTORY_ID_PREFIX + className, null, XExpressionImpl.EMPTY_EXPRESSION, false, true, true);
        new AnAction("InstancesWindow.ShowHistory"){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ExpressionEditorWithHistory.this.showHistory();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(LookupManager.getActiveLookup((Editor)ExpressionEditorWithHistory.this.getEditor()) == null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/debugger/memory/ui/ExpressionEditorWithHistory$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"DOWN"}), this.getComponent(), parentDisposable);
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                ApplicationManager.getApplication().runReadAction(() -> {
                    PsiClass psiClass = DebuggerUtils.findClass((String)className, (Project)project2, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project2));
                    ApplicationManager.getApplication().invokeLater(() -> ExpressionEditorWithHistory.this.setContext((PsiElement)psiClass));
                });
                return null;
            }
        }.execute();
    }

    private void showHistory() {
        List expressions = this.getRecentExpressions();
        if (!expressions.isEmpty()) {
            ListPopupImpl historyPopup = new ListPopupImpl((ListPopupStep)new BaseListPopupStep<XExpression>(null, expressions){

                public PopupStep onChosen(XExpression selectedValue, boolean finalChoice) {
                    ExpressionEditorWithHistory.this.setExpression(selectedValue);
                    ExpressionEditorWithHistory.this.requestFocusInEditor();
                    return FINAL_CHOICE;
                }
            }){

                protected ListCellRenderer getListElementRenderer() {
                    return new ColoredListCellRenderer<XExpression>(){

                        protected void customizeCellRenderer(@NotNull JList list, XExpression value, int index, boolean selected, boolean hasFocus) {
                            if (list == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            this.append(value.getExpression(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/debugger/memory/ui/ExpressionEditorWithHistory$4$1", "customizeCellRenderer"));
                        }
                    };
                }
            };
            historyPopup.getList().setFont(EditorUtil.getEditorFont());
            historyPopup.showUnderneathOf((Component)this.getEditorComponent());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "className";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "debuggerEditorsProvider";
                break;
            }
        }
        objectArray[1] = "com/intellij/debugger/memory/ui/ExpressionEditorWithHistory";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

