/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent.parsers;

import com.intellij.debugger.memory.agent.UnexpectedValueFormatException;
import com.intellij.debugger.memory.agent.parsers.IntArrayParser;
import com.intellij.debugger.memory.agent.parsers.ResultParser;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/debugger/memory/agent/parsers/BackwardReferencesParser;", "Lcom/intellij/debugger/memory/agent/parsers/ResultParser;", "", "", "()V", "parse", "value", "Lcom/sun/jdi/Value;", "intellij.java.debugger.impl"})
public final class BackwardReferencesParser
implements ResultParser<List<? extends List<? extends Integer>>> {
    public static final BackwardReferencesParser INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<List<Integer>> parse(@NotNull Value value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (!(value instanceof ArrayReference)) {
            throw (Throwable)new UnexpectedValueFormatException("Array with nested arrays expected");
        }
        ArrayList<List> result = new ArrayList<List>();
        for (Value linksInfo : ((ArrayReference)value).getValues()) {
            void $receiver$iv$iv;
            void $receiver$iv;
            if (!(linksInfo instanceof ArrayReference)) {
                throw (Throwable)new UnexpectedValueFormatException("Object references information should be represented by array");
            }
            Value value2 = ((ArrayReference)linksInfo).getValue(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)value2, (String)"linksInfo.getValue(0)");
            Iterable iterable = CollectionsKt.distinct((Iterable)((Iterable)IntArrayParser.INSTANCE.parse(value2)));
            void var7_7 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                int it = ((Number)element$iv$iv).intValue();
                boolean bl = false;
                if (!(it != -1)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List indices = (List)destination$iv$iv;
            result.add(indices);
        }
        return result;
    }

    private BackwardReferencesParser() {
    }

    static {
        BackwardReferencesParser backwardReferencesParser;
        INSTANCE = backwardReferencesParser = new BackwardReferencesParser();
    }
}

