/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcessAdapterImpl;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.memory.agent.AgentLoader;
import com.intellij.debugger.memory.agent.MemoryAgent;
import com.intellij.debugger.memory.agent.extractor.AgentExtractor;
import com.intellij.debugger.memory.ui.JavaReferenceInfo;
import com.intellij.debugger.memory.ui.SizedReferenceInfo;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.JavaDebuggerSupport;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Bitness;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.jar.Attributes;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;

public class MemoryAgentUtil {
    private static final Logger LOG = Logger.getInstance(MemoryAgentUtil.class);
    private static final String MEMORY_AGENT_EXTRACT_DIRECTORY = "memory.agent.extract.dir";
    private static final Key<Boolean> LISTEN_MEMORY_AGENT_STARTUP_FAILED = Key.create((String)"LISTEN_MEMORY_AGENT_STARTUP_FAILED");
    private static final int ESTIMATE_OBJECTS_SIZE_LIMIT = 2000;

    public static void addMemoryAgent(@NotNull JavaParameters parameters) {
        if (parameters == null) {
            MemoryAgentUtil.$$$reportNull$$$0(0);
        }
        if (!DebuggerSettings.getInstance().ENABLE_MEMORY_AGENT) {
            return;
        }
        if (MemoryAgentUtil.isIbmJdk(parameters)) {
            LOG.info("Do not attach memory agent for IBM jdk");
            return;
        }
        ParametersList parametersList = parameters.getVMParametersList();
        if (parametersList.getParameters().stream().anyMatch(x -> x.contains("memory_agent"))) {
            return;
        }
        boolean isInDebugMode = Registry.is((String)"debugger.memory.agent.debug");
        File agentFile = null;
        String errorMessage = null;
        long start = System.currentTimeMillis();
        try {
            agentFile = MemoryAgentUtil.getAgentFile(isInDebugMode, parameters.getJdkPath());
        }
        catch (InterruptedException e) {
            errorMessage = "Interrupted";
        }
        catch (ExecutionException e) {
            LOG.warn(e.getCause());
            errorMessage = "Exception thrown (see logs for details)";
        }
        catch (TimeoutException e) {
            errorMessage = "Timeout";
        }
        catch (CantRunException e) {
            errorMessage = e.getMessage();
        }
        if (errorMessage != null || agentFile == null) {
            LOG.warn("Could not extract agent: " + errorMessage);
            return;
        }
        LOG.info("Memory agent extracting took " + (System.currentTimeMillis() - start) + " ms");
        String agentFileName = agentFile.getName();
        String path = JavaExecutionUtil.handleSpacesInAgentPath((String)agentFile.getAbsolutePath(), (String)"debugger-memory-agent", (String)MEMORY_AGENT_EXTRACT_DIRECTORY, f -> agentFileName.equals(f.getName()));
        if (path == null) {
            return;
        }
        String args = "";
        if (isInDebugMode) {
            args = "5";
        }
        path = path + "=" + args;
        parametersList.add("-agentpath:" + path);
        MemoryAgentUtil.listenIfStartupFailed();
    }

    public static List<JavaReferenceInfo> tryCalculateSizes(@NotNull List<JavaReferenceInfo> objects, @Nullable MemoryAgent agent) {
        if (objects == null) {
            MemoryAgentUtil.$$$reportNull$$$0(1);
        }
        if (agent == null || !agent.canEvaluateObjectsSizes()) {
            return objects;
        }
        if (objects.size() > 2000) {
            LOG.info("Too many objects to estimate their sizes");
            return objects;
        }
        try {
            long[] sizes = agent.evaluateObjectsSizes(ContainerUtil.map(objects, x -> x.getObjectReference()));
            return ((StreamEx)IntStreamEx.range((int)0, (int)objects.size()).mapToObj(i -> new SizedReferenceInfo(((JavaReferenceInfo)objects.get(i)).getObjectReference(), sizes[i])).reverseSorted(Comparator.comparing(x -> x.size()))).map(x -> x).toList();
        }
        catch (EvaluateException e) {
            LOG.error("Could not estimate objects sizes", (Throwable)e);
            return objects;
        }
    }

    public static void loadAgentProxy(final @NotNull DebugProcessImpl debugProcess, final @NotNull Consumer<MemoryAgent> agentLoaded) {
        if (debugProcess == null) {
            MemoryAgentUtil.$$$reportNull$$$0(2);
        }
        if (agentLoaded == null) {
            MemoryAgentUtil.$$$reportNull$$$0(3);
        }
        debugProcess.addDebugProcessListener(new DebugProcessAdapterImpl(){
            private final AtomicBoolean isInitializing = new AtomicBoolean(false);

            @Override
            public void paused(SuspendContextImpl suspendContext) {
                if (this.isInitializing.compareAndSet(false, true)) {
                    try {
                        MemoryAgent memoryAgent = this.initMemoryAgent(suspendContext);
                        if (memoryAgent == null) {
                            LOG.warn("Could not initialize memory agent.");
                            return;
                        }
                        agentLoaded.accept(memoryAgent);
                        debugProcess.removeDebugProcessListener(this);
                    }
                    finally {
                        this.isInitializing.set(false);
                    }
                }
            }

            @Nullable
            private MemoryAgent initMemoryAgent(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!DebuggerSettings.getInstance().ENABLE_MEMORY_AGENT) {
                    LOG.info("Memory agent disabled");
                    return AgentLoader.DEFAULT_PROXY;
                }
                StackFrameProxyImpl frameProxy = suspendContext.getFrameProxy();
                if (frameProxy == null) {
                    LOG.warn("frame proxy is not available");
                    return null;
                }
                long start = System.currentTimeMillis();
                EvaluationContextImpl evaluationContext = new EvaluationContextImpl(suspendContext, frameProxy);
                MemoryAgent agent = new AgentLoader().load(evaluationContext, debugProcess.getVirtualMachineProxy());
                LOG.info("Memory agent loading took " + (System.currentTimeMillis() - start) + " ms");
                return agent;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/memory/agent/MemoryAgentUtil$1", "initMemoryAgent"));
            }
        });
    }

    private static boolean isIbmJdk(@NotNull JavaParameters parameters) {
        Sdk jdk;
        if (parameters == null) {
            MemoryAgentUtil.$$$reportNull$$$0(4);
        }
        String vendor = (jdk = parameters.getJdk()) == null ? null : JdkUtil.getJdkMainAttribute((Sdk)jdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VENDOR);
        return vendor != null && StringUtil.containsIgnoreCase((String)vendor, (String)"ibm");
    }

    private static File getAgentFile(boolean isInDebugMode, String jdkPath) throws InterruptedException, ExecutionException, TimeoutException {
        String debugAgentPath;
        if (isInDebugMode && !(debugAgentPath = Registry.get((String)"debugger.memory.agent.debug.path").asString()).isEmpty()) {
            LOG.info("Local memory agent will be used: " + debugAgentPath);
            return new File(debugAgentPath);
        }
        return (File)ApplicationManager.getApplication().executeOnPooledThread(() -> new AgentExtractor().extract(MemoryAgentUtil.detectAgentKind(jdkPath), MemoryAgentUtil.getAgentDirectory())).get(1L, TimeUnit.SECONDS);
    }

    private static AgentExtractor.AgentLibraryType detectAgentKind(String jdkPath) {
        if (SystemInfo.isLinux) {
            return AgentExtractor.AgentLibraryType.LINUX;
        }
        if (SystemInfo.isMac) {
            return AgentExtractor.AgentLibraryType.MACOS;
        }
        JdkVersionDetector.JdkVersionInfo versionInfo = JdkVersionDetector.getInstance().detectJdkVersionInfo(jdkPath);
        if (versionInfo == null) {
            LOG.warn("Could not detect jdk bitness. x64 will be used.");
            return AgentExtractor.AgentLibraryType.WINDOWS64;
        }
        return Bitness.x32.equals((Object)versionInfo.bitness) ? AgentExtractor.AgentLibraryType.WINDOWS32 : AgentExtractor.AgentLibraryType.WINDOWS64;
    }

    @NotNull
    private static File getAgentDirectory() {
        String agentDirectory = System.getProperty(MEMORY_AGENT_EXTRACT_DIRECTORY);
        if (agentDirectory != null) {
            File file = new File(agentDirectory);
            if (file.exists() || file.mkdirs()) {
                File file2 = file;
                if (file2 == null) {
                    MemoryAgentUtil.$$$reportNull$$$0(5);
                }
                return file2;
            }
            LOG.info("Directory specified in property \"memory.agent.extract.dir\" not found. Default tmp directory will be used");
        }
        File file = new File(FileUtil.getTempDirectory());
        if (file == null) {
            MemoryAgentUtil.$$$reportNull$$$0(6);
        }
        return file;
    }

    private static void listenIfStartupFailed() {
        final Project project2 = JavaDebuggerSupport.getContextProjectForEditorFieldsInDebuggerConfigurables();
        if (Boolean.TRUE.equals(project2.getUserData(LISTEN_MEMORY_AGENT_STARTUP_FAILED))) {
            return;
        }
        project2.getMessageBus().connect().subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

            public void processTerminated(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler, int exitCode) {
                if (executorId == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (env == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (handler == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (executorId != DefaultDebugExecutor.EXECUTOR_ID || exitCode == 0) {
                    return;
                }
                RunContentDescriptor content = env.getContentToReuse();
                if (content == null) {
                    return;
                }
                ExecutionConsole console = content.getExecutionConsole();
                if (!(console instanceof ConsoleViewImpl)) {
                    return;
                }
                ConsoleViewImpl consoleView = (ConsoleViewImpl)console;
                ApplicationManager.getApplication().invokeLater(() -> {
                    Editor editor;
                    if (consoleView.hasDeferredOutput()) {
                        consoleView.flushDeferredText();
                    }
                    if ((editor = consoleView.getEditor()) == null) {
                        return;
                    }
                    Object[] outputLines = StringUtil.splitByLines((String)editor.getDocument().getText());
                    List mentions = ((StreamEx)((StreamEx)((StreamEx)StreamEx.of((Object[])outputLines).skip(1L)).filter(x -> x.contains("memory_agent"))).limit(10L)).toList();
                    if (outputLines.length >= 1 && ((String)outputLines[0]).contains("memory_agent") && !mentions.isEmpty()) {
                        Project project22 = env.getProject();
                        String name2 = env.getRunProfile().getName();
                        String windowId = ExecutionManager.getInstance((Project)project22).getContentManager().getToolWindowIdByEnvironment(env);
                        Attachment[] mentionsInOutput = (Attachment[])StreamEx.of((Collection)mentions).map(x -> new Attachment("agent_mention.txt", x)).toArray((Object[])Attachment.EMPTY_ARRAY);
                        RuntimeExceptionWithAttachments exception = new RuntimeExceptionWithAttachments("Could not start debug process with memory agent", mentionsInOutput);
                        String checkboxName = DebuggerBundle.message((String)"label.debugger.general.configurable.enable.memory.agent", (Object[])new Object[0]);
                        String description = "Memory agent could not be loaded. <a href=\"Disable\">Disable</a> the agent. To enable it back use \"" + checkboxName + "\" option in File | Settings | Build, Execution, Deployment | Debugger";
                        ExecutionUtil.handleExecutionError((Project)project22, (String)windowId, (String)name2, (Throwable)exception, (String)description, (HyperlinkListener)new DisablingMemoryAgentListener());
                        LOG.error((Throwable)exception);
                    }
                }, project2.getDisposed());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "executorId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "env";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "handler";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/memory/agent/MemoryAgentUtil$2";
                objectArray[2] = "processTerminated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        project2.putUserData(LISTEN_MEMORY_AGENT_STARTUP_FAILED, (Object)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentLoaded";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/memory/agent/MemoryAgentUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/memory/agent/MemoryAgentUtil";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAgentDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addMemoryAgent";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "tryCalculateSizes";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadAgentProxy";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isIbmJdk";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DisablingMemoryAgentListener
    implements HyperlinkListener {
        private DisablingMemoryAgentListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                DebuggerSettings.getInstance().ENABLE_MEMORY_AGENT = false;
            }
        }
    }
}

