/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.action;

import com.intellij.debugger.memory.action.ShowInstancesAction;
import com.intellij.debugger.memory.ui.InstancesWindow;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.memory.ui.ClassesTable;
import com.intellij.xdebugger.memory.ui.TypeInfo;

public class ShowInstancesFromClassesViewAction
extends ShowInstancesAction {
    private static final String POPUP_ELEMENT_LABEL = "Show Instances";

    @Override
    protected void perform(AnActionEvent e) {
        XDebugSession debugSession;
        Project project2 = e.getProject();
        TypeInfo selectedClass = this.getSelectedClass(e);
        if (project2 != null && selectedClass != null && (debugSession = XDebuggerManager.getInstance((Project)project2).getCurrentSession()) != null) {
            new InstancesWindow(debugSession, arg_0 -> ((TypeInfo)selectedClass).getInstances(arg_0), selectedClass.name()).show();
        }
    }

    @Override
    protected String getLabel() {
        return POPUP_ELEMENT_LABEL;
    }

    @Override
    protected int getInstancesCount(AnActionEvent e) {
        ClassesTable.ReferenceCountProvider countProvider = (ClassesTable.ReferenceCountProvider)e.getData(ClassesTable.REF_COUNT_PROVIDER_KEY);
        TypeInfo selectedClass = this.getSelectedClass(e);
        if (countProvider == null || selectedClass == null) {
            return -1;
        }
        return countProvider.getTotalCount(selectedClass);
    }
}

