/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.util.io.StreamUtil;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ByteValue;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ClassLoadingUtils {
    private static final int BATCH_SIZE = 4096;

    private ClassLoadingUtils() {
    }

    public static ClassLoaderReference getClassLoader(EvaluationContext context, DebugProcess process2) throws EvaluateException {
        try {
            ArrayType arrayType = (ArrayType)context.getDebugProcess().findClass(context, "java.net.URL[]", context.getClassLoader());
            ArrayReference emptyUrlArray = DebuggerUtilsEx.mirrorOfArray(arrayType, 0, context);
            ClassType loaderClass = (ClassType)process2.findClass(context, "java.net.URLClassLoader", context.getClassLoader());
            Method ctorMethod = loaderClass.concreteMethodByName("<init>", "([Ljava/net/URL;Ljava/lang/ClassLoader;)V");
            ClassLoaderReference reference = (ClassLoaderReference)process2.newInstance(context, loaderClass, ctorMethod, Arrays.asList(emptyUrlArray, context.getClassLoader()));
            context.keep((Value)reference);
            return reference;
        }
        catch (Exception e) {
            throw new EvaluateException("Error creating evaluation class loader: " + e, (Throwable)e);
        }
    }

    public static void defineClass(String name2, byte[] bytes, EvaluationContext context, DebugProcess process2, ClassLoaderReference classLoader) throws EvaluateException {
        try {
            VirtualMachineProxyImpl proxy = (VirtualMachineProxyImpl)process2.getVirtualMachineProxy();
            Method defineMethod = ((ClassType)classLoader.referenceType()).concreteMethodByName("defineClass", "(Ljava/lang/String;[BII)Ljava/lang/Class;");
            process2.invokeMethod(context, (ObjectReference)classLoader, defineMethod, Arrays.asList(DebuggerUtilsEx.mirrorOfString(name2, proxy, context), ClassLoadingUtils.mirrorOf(bytes, context, process2), proxy.mirrorOf(0), proxy.mirrorOf(bytes.length)));
        }
        catch (Exception e) {
            throw new EvaluateException("Error during class " + name2 + " definition: " + e, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static ClassType getHelperClass(Class cls, EvaluationContext evaluationContext) throws EvaluateException {
        String name2 = cls.getName();
        DebugProcess process2 = evaluationContext.getDebugProcess();
        try {
            return (ClassType)process2.findClass(evaluationContext, name2, evaluationContext.getClassLoader());
        }
        catch (EvaluateException e) {
            Throwable cause = e.getCause();
            if (!(cause instanceof InvocationException)) throw e;
            if (!"java.lang.ClassNotFoundException".equals(((InvocationException)cause).exception().type().name())) throw e;
            ClassLoaderReference classLoader = ClassLoadingUtils.getClassLoader(evaluationContext, process2);
            try (InputStream stream = cls.getResourceAsStream("/" + name2.replaceAll("[.]", "/") + ".class");){
                if (stream == null) {
                    ClassType classType = null;
                    return classType;
                }
                ClassLoadingUtils.defineClass(name2, StreamUtil.loadFromStream((InputStream)stream), evaluationContext, process2, classLoader);
                ((EvaluationContextImpl)evaluationContext).setClassLoader(classLoader);
                ClassType classType = (ClassType)process2.findClass(evaluationContext, name2, classLoader);
                return classType;
            }
            catch (IOException ioe) {
                throw new EvaluateException("Unable to read " + name2 + " class bytes", (Throwable)ioe);
            }
        }
    }

    private static ArrayReference mirrorOf(byte[] bytes, EvaluationContext context, DebugProcess process2) throws EvaluateException, InvalidTypeException, ClassNotLoadedException {
        ArrayType arrayClass = (ArrayType)process2.findClass(context, "byte[]", context.getClassLoader());
        ArrayReference reference = DebuggerUtilsEx.mirrorOfArray(arrayClass, bytes.length, context);
        ArrayList<ByteValue> mirrors = new ArrayList<ByteValue>(bytes.length);
        for (byte b : bytes) {
            mirrors.add(((VirtualMachineProxyImpl)process2.getVirtualMachineProxy()).mirrorOf(b));
        }
        if (DebuggerUtils.isAndroidVM((VirtualMachine)arrayClass.virtualMachine())) {
            ClassLoadingUtils.setChuckByChunk(reference, mirrors);
        } else {
            reference.setValues(mirrors);
        }
        return reference;
    }

    private static void setChuckByChunk(ArrayReference reference, List<? extends Value> values) throws ClassNotLoadedException, InvalidTypeException {
        int chunkSize;
        for (int loaded = 0; loaded < values.size(); loaded += chunkSize) {
            chunkSize = Math.min(4096, values.size() - loaded);
            reference.setValues(loaded, values, loaded, chunkSize);
        }
    }
}

