/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.TypeEvaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;

public class TypeCastEvaluator
implements Evaluator {
    private final Evaluator myOperandEvaluator;
    private final String myPrimitiveCastType;
    private final TypeEvaluator myTypeCastEvaluator;

    public TypeCastEvaluator(Evaluator operandEvaluator, @NotNull TypeEvaluator typeCastEvaluator) {
        if (typeCastEvaluator == null) {
            TypeCastEvaluator.$$$reportNull$$$0(0);
        }
        this.myOperandEvaluator = operandEvaluator;
        this.myPrimitiveCastType = null;
        this.myTypeCastEvaluator = typeCastEvaluator;
    }

    public TypeCastEvaluator(Evaluator operandEvaluator, @NotNull String primitiveType) {
        if (primitiveType == null) {
            TypeCastEvaluator.$$$reportNull$$$0(1);
        }
        this.myOperandEvaluator = operandEvaluator;
        this.myPrimitiveCastType = primitiveType;
        this.myTypeCastEvaluator = null;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        Value value = (Value)this.myOperandEvaluator.evaluate(context);
        if (value == null) {
            if (this.myPrimitiveCastType != null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.cast.null", (Object[])new Object[]{this.myPrimitiveCastType}));
            }
            return null;
        }
        VirtualMachineProxyImpl vm = context.getDebugProcess().getVirtualMachineProxy();
        if (DebuggerUtils.isInteger((Value)value)) {
            if ((value = DebuggerUtilsEx.createValue(vm, this.myPrimitiveCastType, ((PrimitiveValue)value).longValue())) == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.cast.numeric", (Object[])new Object[]{this.myPrimitiveCastType}));
            }
        } else if (DebuggerUtils.isNumeric((Value)value)) {
            if ((value = DebuggerUtilsEx.createValue(vm, this.myPrimitiveCastType, ((PrimitiveValue)value).doubleValue())) == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.cast.numeric", (Object[])new Object[]{this.myPrimitiveCastType}));
            }
        } else if (value instanceof BooleanValue) {
            if ((value = DebuggerUtilsEx.createValue(vm, this.myPrimitiveCastType, ((BooleanValue)value).booleanValue())) == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.cast.boolean", (Object[])new Object[]{this.myPrimitiveCastType}));
            }
        } else if (value instanceof CharValue) {
            if ((value = DebuggerUtilsEx.createValue(vm, this.myPrimitiveCastType, ((CharValue)value).charValue())) == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.cast.char", (Object[])new Object[]{this.myPrimitiveCastType}));
            }
        } else if (value instanceof ObjectReference) {
            ReferenceType type = ((ObjectReference)value).referenceType();
            if (this.myTypeCastEvaluator == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.cast.object", (Object[])new Object[]{type.name(), this.myPrimitiveCastType}));
            }
            ReferenceType castType = (ReferenceType)this.myTypeCastEvaluator.evaluate(context);
            if (!DebuggerUtilsImpl.instanceOf(type, castType)) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.cast.object", (Object[])new Object[]{type.name(), castType.name()}));
            }
        }
        return value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "typeCastEvaluator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "primitiveType";
                break;
            }
        }
        objectArray[1] = "com/intellij/debugger/engine/evaluation/expression/TypeCastEvaluator";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

