/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.Patches;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluateRuntimeException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.BoxingEvaluator;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.SuperEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnBoxingEvaluator;
import com.intellij.debugger.impl.ClassLoadingUtils;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.intellij.rt.debugger.DefaultMethodInvoker;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import one.util.streamex.StreamEx;

public class MethodEvaluator
implements Evaluator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.evaluation.expression.MethodEvaluator");
    private final JVMName myClassName;
    private final JVMName myMethodSignature;
    private final String myMethodName;
    private final Evaluator[] myArgumentEvaluators;
    private final Evaluator myObjectEvaluator;
    private final boolean myCheckDefaultInterfaceMethod;
    private final boolean myMustBeVararg;

    public MethodEvaluator(Evaluator objectEvaluator, JVMName className, String methodName, JVMName signature, Evaluator[] argumentEvaluators) {
        this(objectEvaluator, className, methodName, signature, argumentEvaluators, false, false);
    }

    public MethodEvaluator(Evaluator objectEvaluator, JVMName className, String methodName, JVMName signature, Evaluator[] argumentEvaluators, boolean checkDefaultInterfaceMethod, boolean mustBeVararg) {
        this.myObjectEvaluator = DisableGC.create(objectEvaluator);
        this.myClassName = className;
        this.myMethodName = methodName;
        this.myMethodSignature = signature;
        this.myArgumentEvaluators = argumentEvaluators;
        this.myCheckDefaultInterfaceMethod = checkDefaultInterfaceMethod;
        this.myMustBeVararg = mustBeVararg;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        if (!context.getDebugProcess().isAttached()) {
            return null;
        }
        DebugProcessImpl debugProcess = context.getDebugProcess();
        boolean requiresSuperObject = DisableGC.unwrap(this.myObjectEvaluator) instanceof SuperEvaluator;
        Object object = this.myObjectEvaluator.evaluate(context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("MethodEvaluator: object = " + object);
        }
        if (object == null) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)new NullPointerException());
        }
        if (!(object instanceof ObjectReference) && !MethodEvaluator.isInvokableType(object)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.evaluating.method", (Object[])new Object[]{this.myMethodName}));
        }
        ArrayList<Value> args = new ArrayList<Value>(this.myArgumentEvaluators.length);
        for (Evaluator evaluator : this.myArgumentEvaluators) {
            args.add((Value)evaluator.evaluate(context));
        }
        try {
            String signature;
            ReferenceType referenceType = null;
            if (object instanceof ObjectReference) {
                referenceType = ((ObjectReference)object).referenceType();
            } else if (MethodEvaluator.isInvokableType(object)) {
                referenceType = (ReferenceType)object;
            }
            if (referenceType == null) {
                throw new EvaluateRuntimeException(EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.evaluate.qualifier", (Object[])new Object[]{this.myMethodName})));
            }
            String string = signature = this.myMethodSignature != null ? this.myMethodSignature.getName(debugProcess) : null;
            if (requiresSuperObject && referenceType instanceof ClassType) {
                String className;
                referenceType = ((ClassType)referenceType).superclass();
                String string2 = className = this.myClassName != null ? this.myClassName.getName(debugProcess) : null;
                if (referenceType == null || className != null && !className.equals(referenceType.name())) {
                    referenceType = debugProcess.findClass(context, className, context.getClassLoader());
                }
            }
            Method jdiMethod = null;
            if (signature == null) {
                List matchingMethods = ((StreamEx)StreamEx.of(referenceType.methodsByName(this.myMethodName)).filter(m -> m.argumentTypeNames().size() == args.size())).toList();
                if (matchingMethods.size() == 1) {
                    jdiMethod = (Method)matchingMethods.get(0);
                } else if (matchingMethods.size() > 1) {
                    jdiMethod = matchingMethods.stream().filter(m -> MethodEvaluator.matchArgs(m, args)).findFirst().orElse(null);
                }
            }
            if (jdiMethod == null) {
                jdiMethod = DebuggerUtils.findMethod((ReferenceType)referenceType, (String)this.myMethodName, (String)signature);
            }
            if (jdiMethod == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.no.instance.method", (Object[])new Object[]{this.myMethodName}));
            }
            if (this.myMustBeVararg && !jdiMethod.isVarArgs()) {
                MethodEvaluator.wrapVarargParams(jdiMethod, args);
            }
            if (signature == null) {
                MethodEvaluator.argsConversions(jdiMethod, args, context);
            }
            if (MethodEvaluator.isInvokableType(object)) {
                if (MethodEvaluator.isInvokableType(referenceType) && jdiMethod.isStatic()) {
                    if (referenceType instanceof ClassType) {
                        return debugProcess.invokeMethod((EvaluationContext)context, (ClassType)referenceType, jdiMethod, args);
                    }
                    return debugProcess.invokeMethod((EvaluationContext)context, (InterfaceType)referenceType, jdiMethod, args);
                }
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.no.static.method", (Object[])new Object[]{DebuggerUtilsEx.methodName(referenceType.name(), this.myMethodName, signature)}));
            }
            ObjectReference objRef = (ObjectReference)object;
            if (requiresSuperObject) {
                return debugProcess.invokeInstanceMethod(context, objRef, jdiMethod, args, 2);
            }
            if (Patches.JDK_BUG_ID_8042123 && this.myCheckDefaultInterfaceMethod && jdiMethod.declaringType() instanceof InterfaceType) {
                try {
                    return MethodEvaluator.invokeDefaultMethod(debugProcess, context, objRef, this.myMethodName);
                }
                catch (EvaluateException e) {
                    LOG.info((Throwable)e);
                }
            }
            return debugProcess.invokeMethod((EvaluationContext)context, objRef, jdiMethod, args);
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
    }

    private static boolean matchArgs(Method m, List<Value> args) {
        try {
            List<Type> argumentTypes = m.argumentTypes();
            for (int i = 0; i < argumentTypes.size(); ++i) {
                Type argType;
                Type expectedArgType = argumentTypes.get(i);
                if (expectedArgType.equals(argType = args.get(i).type()) || expectedArgType instanceof ReferenceType && (argType == null || !(argType instanceof PrimitiveType) && argType instanceof ReferenceType && DebuggerUtilsImpl.instanceOf((ReferenceType)argType, (ReferenceType)expectedArgType))) continue;
                return false;
            }
        }
        catch (ClassNotLoadedException ignored) {
            return false;
        }
        return true;
    }

    private static void argsConversions(Method jdiMethod, List<Value> args, EvaluationContextImpl context) throws EvaluateException {
        List<String> typeNames;
        int size;
        if (!jdiMethod.isVarArgs() && (size = (typeNames = jdiMethod.argumentTypeNames()).size()) == args.size()) {
            for (int i = 0; i < size; ++i) {
                Value arg = args.get(i);
                PsiPrimitiveType primitiveType = PsiJavaParserFacadeImpl.getPrimitiveType((String)typeNames.get(i));
                if (primitiveType == null && arg.type() instanceof PrimitiveType) {
                    args.set(i, (Value)BoxingEvaluator.box(arg, context));
                    continue;
                }
                if (primitiveType == null || arg.type() instanceof PrimitiveType) continue;
                args.set(i, (Value)UnBoxingEvaluator.unbox(arg, context));
            }
        }
    }

    private static boolean isInvokableType(Object type) {
        return type instanceof ClassType || type instanceof InterfaceType;
    }

    private static Value invokeDefaultMethod(DebugProcess debugProcess, EvaluationContext evaluationContext, Value obj, String name2) throws EvaluateException {
        List<Method> methods;
        ClassType invokerClass = ClassLoadingUtils.getHelperClass(DefaultMethodInvoker.class, evaluationContext);
        if (invokerClass != null && !(methods = invokerClass.methodsByName("invoke")).isEmpty()) {
            return debugProcess.invokeMethod(evaluationContext, invokerClass, methods.get(0), Arrays.asList(obj, ((VirtualMachineProxyImpl)debugProcess.getVirtualMachineProxy()).mirrorOf(name2)));
        }
        return null;
    }

    public String toString() {
        return "call " + this.myMethodName;
    }

    private static void wrapVarargParams(Method method, List<Value> args) throws ClassNotLoadedException, InvalidTypeException {
        int argCount = args.size();
        List<Type> paramTypes = method.argumentTypes();
        Type varargType = (Type)ContainerUtil.getLastItem(paramTypes);
        if (varargType instanceof ArrayType) {
            int paramCount = paramTypes.size();
            int arraySize = argCount - paramCount + 1;
            ArrayReference argArray = ((ArrayType)varargType).newInstance(arraySize);
            argArray.setValues(0, args, paramCount - 1, arraySize);
            if (paramCount <= argCount) {
                args.subList(paramCount - 1, argCount).clear();
            }
            args.add(argArray);
        }
    }
}

