/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation;

import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerComputableValue {
    private boolean myComputed;
    @Nullable
    private Value myValue;
    @Nullable
    private EvaluateException myException;
    @NotNull
    private final EvaluatingComputable<? extends Value> myComputable;

    public DebuggerComputableValue(@NotNull EvaluatingComputable<? extends Value> computable) {
        if (computable == null) {
            DebuggerComputableValue.$$$reportNull$$$0(0);
        }
        this.myComputable = computable;
    }

    public DebuggerComputableValue(@Nullable Value value) {
        this.myComputed = true;
        this.myValue = value;
        this.myComputable = () -> value;
    }

    public static DebuggerComputableValue computed(Value value) {
        DebuggerComputableValue res = new DebuggerComputableValue(() -> value);
        res.myComputed = true;
        res.myValue = value;
        return res;
    }

    @Nullable
    public Value getValue() throws EvaluateException {
        if (!this.myComputed) {
            try {
                this.myValue = this.myComputable.compute();
            }
            catch (EvaluateException e) {
                this.myException = e;
            }
            this.myComputed = true;
        }
        if (this.myException != null) {
            throw this.myException;
        }
        return this.myValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/intellij/debugger/engine/evaluation/DebuggerComputableValue", "<init>"));
    }
}

