/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.actions.AsyncStacksToggleAction;
import com.intellij.debugger.engine.AsyncStackTraceProvider;
import com.intellij.debugger.engine.AsyncStacksUtils;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JVMStackFrameInfoProvider;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadGroupReferenceProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.debugger.ui.breakpoints.BreakpointIntentionAction;
import com.intellij.debugger.ui.impl.watch.MethodsTracker;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaExecutionStack
extends XExecutionStack {
    private static final Logger LOG = Logger.getInstance(JavaExecutionStack.class);
    private final ThreadReferenceProxyImpl myThreadProxy;
    private final DebugProcessImpl myDebugProcess;
    private volatile XStackFrame myTopFrame;
    private volatile boolean myTopFrameReady;
    private final MethodsTracker myTracker;

    public JavaExecutionStack(@NotNull ThreadReferenceProxyImpl threadProxy, @NotNull DebugProcessImpl debugProcess, boolean current) {
        if (threadProxy == null) {
            JavaExecutionStack.$$$reportNull$$$0(0);
        }
        if (debugProcess == null) {
            JavaExecutionStack.$$$reportNull$$$0(1);
        }
        super(JavaExecutionStack.calcRepresentation(threadProxy), JavaExecutionStack.calcIcon(threadProxy, current));
        this.myTopFrameReady = false;
        this.myTracker = new MethodsTracker();
        this.myThreadProxy = threadProxy;
        this.myDebugProcess = debugProcess;
    }

    private static Icon calcIcon(ThreadReferenceProxyImpl threadProxy, boolean current) {
        if (current) {
            return threadProxy.isSuspended() ? AllIcons.Debugger.ThreadCurrent : AllIcons.Debugger.ThreadRunning;
        }
        if (threadProxy.isAtBreakpoint()) {
            return AllIcons.Debugger.ThreadAtBreakpoint;
        }
        if (threadProxy.isSuspended()) {
            return AllIcons.Debugger.ThreadSuspended;
        }
        return AllIcons.Debugger.ThreadRunning;
    }

    @NotNull
    ThreadReferenceProxyImpl getThreadProxy() {
        ThreadReferenceProxyImpl threadReferenceProxyImpl = this.myThreadProxy;
        if (threadReferenceProxyImpl == null) {
            JavaExecutionStack.$$$reportNull$$$0(2);
        }
        return threadReferenceProxyImpl;
    }

    public final void initTopFrame() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            StackFrameProxyImpl frame = this.myThreadProxy.frame(0);
            if (frame != null) {
                this.myTopFrame = this.createStackFrame(frame);
            }
        }
        catch (EvaluateException e) {
            LOG.info((Throwable)e);
        }
        finally {
            this.myTopFrameReady = true;
        }
    }

    @NotNull
    public XStackFrame createStackFrame(@NotNull StackFrameProxyImpl stackFrameProxy) {
        XStackFrame customFrame;
        Method method;
        StackFrameDescriptorImpl descriptor2;
        if (stackFrameProxy == null) {
            JavaExecutionStack.$$$reportNull$$$0(3);
        }
        if ((descriptor2 = new StackFrameDescriptorImpl(stackFrameProxy, this.myTracker)).getUiIndex() == 1 && this.myTopFrame instanceof JavaStackFrame && (method = descriptor2.getMethod()) != null) {
            ((JavaStackFrame)this.myTopFrame).getDescriptor().putUserData(BreakpointIntentionAction.CALLER_KEY, DebuggerUtilsEx.methodKey(method));
        }
        DebugProcessImpl debugProcess = (DebugProcessImpl)descriptor2.getDebugProcess();
        Location location = descriptor2.getLocation();
        if (location != null && (customFrame = debugProcess.getPositionManager().createStackFrame(stackFrameProxy, debugProcess, location)) != null) {
            XStackFrame xStackFrame = customFrame;
            if (xStackFrame == null) {
                JavaExecutionStack.$$$reportNull$$$0(4);
            }
            return xStackFrame;
        }
        JavaStackFrame javaStackFrame = new JavaStackFrame(descriptor2, true);
        if (javaStackFrame == null) {
            JavaExecutionStack.$$$reportNull$$$0(5);
        }
        return javaStackFrame;
    }

    @Nullable
    public XStackFrame getTopFrame() {
        assert (this.myTopFrameReady) : "Top frame must be already calculated here";
        return this.myTopFrame;
    }

    public void computeStackFrames(final int firstFrameIndex, final XExecutionStack.XStackFrameContainer container) {
        if (container.isObsolete()) {
            return;
        }
        this.myDebugProcess.getManagerThread().schedule(new SuspendContextCommandImpl(this.myDebugProcess.getDebuggerContext().getSuspendContext()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (container.isObsolete()) {
                    return;
                }
                int status = JavaExecutionStack.this.myThreadProxy.status();
                if (status == 0) {
                    container.errorOccurred(DebuggerBundle.message((String)"frame.panel.thread.finished", (Object[])new Object[0]));
                } else if (!JavaExecutionStack.this.myThreadProxy.isCollected() && JavaExecutionStack.this.myDebugProcess.getSuspendManager().isSuspended(JavaExecutionStack.this.myThreadProxy)) {
                    if (status != -1 && status != 5) {
                        try {
                            int added = 0;
                            Iterator<StackFrameProxyImpl> iterator = JavaExecutionStack.this.myThreadProxy.frames().iterator();
                            if (iterator.hasNext() && firstFrameIndex > 0) {
                                iterator.next();
                                ++added;
                            }
                            JavaExecutionStack.this.myDebugProcess.getManagerThread().schedule(new AppendFrameCommand(suspendContext, iterator, container, added, firstFrameIndex, null));
                        }
                        catch (EvaluateException e) {
                            container.errorOccurred(e.getMessage());
                        }
                    }
                } else {
                    container.errorOccurred(DebuggerBundle.message((String)"frame.panel.frames.not.available", (Object[])new Object[0]));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaExecutionStack$1", "contextAction"));
            }
        });
    }

    private static boolean showFrame(@NotNull XStackFrame frame) {
        if (frame == null) {
            JavaExecutionStack.$$$reportNull$$$0(6);
        }
        if (!XDebuggerSettingsManager.getInstance().getDataViewSettings().isShowLibraryStackFrames() && frame instanceof JVMStackFrameInfoProvider) {
            JVMStackFrameInfoProvider info = (JVMStackFrameInfoProvider)frame;
            return !info.isSynthetic() && !info.isInLibraryContent();
        }
        return true;
    }

    private static String calcRepresentation(ThreadReferenceProxyImpl thread) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        String name2 = thread.name();
        ThreadGroupReferenceProxyImpl gr = thread.threadGroupProxy();
        String grname = gr != null ? gr.name() : null;
        String threadStatusText = DebuggerUtilsEx.getThreadStatusText(thread.status());
        if (grname != null && !"SYSTEM".equalsIgnoreCase(grname)) {
            return DebuggerBundle.message((String)"label.thread.node.in.group", (Object[])new Object[]{name2, thread.uniqueID(), threadStatusText, grname});
        }
        return DebuggerBundle.message((String)"label.thread.node", (Object[])new Object[]{name2, thread.uniqueID(), threadStatusText});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        JavaExecutionStack stack = (JavaExecutionStack)((Object)o);
        return this.myThreadProxy.equals(stack.myThreadProxy);
    }

    public int hashCode() {
        return this.myThreadProxy.hashCode();
    }

    public String toString() {
        return this.getDisplayName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadProxy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/JavaExecutionStack";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackFrameProxy";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/JavaExecutionStack";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadProxy";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createStackFrame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createStackFrame";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showFrame";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class AppendFrameCommand
    extends SuspendContextCommandImpl {
        private final Iterator<StackFrameProxyImpl> myStackFramesIterator;
        private final XExecutionStack.XStackFrameContainer myContainer;
        private int myAdded;
        private final int mySkip;
        private final List<StackFrameItem> myAsyncStack;

        AppendFrameCommand(SuspendContextImpl suspendContext, Iterator<StackFrameProxyImpl> stackFramesIterator, XExecutionStack.XStackFrameContainer container, int added, int skip, List<StackFrameItem> asyncStack) {
            super(suspendContext);
            this.myStackFramesIterator = stackFramesIterator;
            this.myContainer = container;
            this.myAdded = added;
            this.mySkip = skip;
            this.myAsyncStack = asyncStack;
        }

        @Override
        public PrioritizedTask.Priority getPriority() {
            return this.myAdded <= 10 ? PrioritizedTask.Priority.NORMAL : PrioritizedTask.Priority.LOW;
        }

        private void addFrameIfNeeded(XStackFrame frame, boolean last) {
            if (++this.myAdded > this.mySkip) {
                this.myContainer.addStackFrames(Collections.singletonList(frame), last);
            }
        }

        @Override
        public void contextAction(@NotNull SuspendContextImpl suspendContext) {
            if (suspendContext == null) {
                AppendFrameCommand.$$$reportNull$$$0(0);
            }
            if (this.myContainer.isObsolete()) {
                return;
            }
            if (this.myStackFramesIterator.hasNext()) {
                StackFrameProxyImpl frameProxy;
                XStackFrame frame;
                boolean first;
                boolean bl = first = this.myAdded == 0;
                if (first && JavaExecutionStack.this.myTopFrameReady) {
                    frame = JavaExecutionStack.this.myTopFrame;
                    frameProxy = this.myStackFramesIterator.next();
                } else {
                    frameProxy = this.myStackFramesIterator.next();
                    frame = JavaExecutionStack.this.createStackFrame(frameProxy);
                    if (first && !JavaExecutionStack.this.myTopFrameReady) {
                        JavaExecutionStack.this.myTopFrame = frame;
                        JavaExecutionStack.this.myTopFrameReady = true;
                    }
                }
                if (first || JavaExecutionStack.showFrame(frame)) {
                    this.addFrameIfNeeded(frame, false);
                }
                if (this.myAsyncStack != null) {
                    this.appendRelatedStack(this.myAsyncStack);
                    return;
                }
                List<StackFrameItem> relatedStack = null;
                if (AsyncStacksToggleAction.isAsyncStacksEnabled((XDebugSessionImpl)suspendContext.getDebugProcess().getXdebugProcess().getSession()) && frame instanceof JavaStackFrame) {
                    for (AsyncStackTraceProvider asyncStackTraceProvider : AsyncStackTraceProvider.EP.getExtensionList()) {
                        relatedStack = asyncStackTraceProvider.getAsyncStackTrace((JavaStackFrame)frame, suspendContext);
                        if (relatedStack == null) continue;
                        this.appendRelatedStack(relatedStack);
                        return;
                    }
                    relatedStack = AsyncStacksUtils.getAgentRelatedStack((JavaStackFrame)frame, suspendContext);
                }
                JavaExecutionStack.this.myDebugProcess.getManagerThread().schedule(new AppendFrameCommand(suspendContext, this.myStackFramesIterator, this.myContainer, this.myAdded, this.mySkip, relatedStack));
            } else {
                this.myContainer.addStackFrames(Collections.emptyList(), true);
            }
        }

        void appendRelatedStack(@NotNull List<StackFrameItem> asyncStack) {
            if (asyncStack == null) {
                AppendFrameCommand.$$$reportNull$$$0(1);
            }
            int i = 0;
            boolean separator = true;
            for (StackFrameItem stackFrame : asyncStack) {
                if (i > AsyncStacksUtils.getMaxStackLength()) {
                    this.addFrameIfNeeded(new XStackFrame(){

                        public void customizePresentation(@NotNull ColoredTextContainer component) {
                            if (component == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            component.append("Too many frames, the rest is truncated...", SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/debugger/engine/JavaExecutionStack$AppendFrameCommand$1", "customizePresentation"));
                        }
                    }, true);
                    return;
                }
                ++i;
                if (stackFrame == null) {
                    separator = true;
                    continue;
                }
                StackFrameItem.CapturedStackFrame newFrame = stackFrame.createFrame(JavaExecutionStack.this.myDebugProcess);
                if (!JavaExecutionStack.showFrame(newFrame)) continue;
                newFrame.setWithSeparator(separator);
                this.addFrameIfNeeded(newFrame, false);
                separator = false;
            }
            this.myContainer.addStackFrames(Collections.emptyList(), true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suspendContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "asyncStack";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/engine/JavaExecutionStack$AppendFrameCommand";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contextAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendRelatedStack";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

