/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.CommonBundle;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.VMDisconnectedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PopFrameAction
extends DebuggerAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(PopFrameAction.class);

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            PopFrameAction.$$$reportNull$$$0(0);
        }
        final Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        final JavaStackFrame stackFrame = PopFrameAction.getStackFrame(e);
        if (stackFrame == null || stackFrame.getStackFrameProxy().isBottom()) {
            return;
        }
        try {
            final DebuggerContextImpl debuggerContext = DebuggerAction.getDebuggerContext(e.getDataContext());
            final DebugProcessImpl debugProcess = debuggerContext.getDebugProcess();
            if (debugProcess == null) {
                return;
            }
            debugProcess.getSession().setSteppingThrough(stackFrame.getStackFrameProxy().threadProxy());
            if (PopFrameAction.evaluateFinallyBlocks(project2, UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"Debugger.PopFrame")), stackFrame, new XDebuggerEvaluator.XEvaluationCallback(){

                public void evaluated(@NotNull XValue result) {
                    if (result == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    PopFrameAction.popFrame(debugProcess, debuggerContext, stackFrame);
                }

                public void errorOccurred(@NotNull String errorMessage) {
                    if (errorMessage == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    PopFrameAction.showError(project2, DebuggerBundle.message((String)"error.executing.finally", (Object[])new Object[]{errorMessage}), UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"Debugger.PopFrame")));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "result";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "errorMessage";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/debugger/actions/PopFrameAction$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "evaluated";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "errorOccurred";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            })) {
                return;
            }
            PopFrameAction.popFrame(debugProcess, debuggerContext, stackFrame);
        }
        catch (NativeMethodException e2) {
            Messages.showMessageDialog((Project)project2, (String)DebuggerBundle.message((String)"error.native.method.exception", (Object[])new Object[0]), (String)UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"Debugger.PopFrame")), (Icon)Messages.getErrorIcon());
        }
        catch (InvalidStackFrameException | VMDisconnectedException runtimeException) {
            // empty catch block
        }
    }

    static boolean evaluateFinallyBlocks(Project project2, String title, JavaStackFrame stackFrame, XDebuggerEvaluator.XEvaluationCallback callback) {
        List<PsiStatement> statements;
        if (!"EvaluateFinallyNever".equals(DebuggerSettings.getInstance().EVALUATE_FINALLY_ON_POP_FRAME) && !(statements = PopFrameAction.getFinallyStatements(project2, stackFrame.getDescriptor().getSourcePosition())).isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (PsiStatement statement2 : statements) {
                sb.append("\n").append(statement2.getText());
            }
            if ("EvaluateFinallyAlways".equals(DebuggerSettings.getInstance().EVALUATE_FINALLY_ON_POP_FRAME)) {
                PopFrameAction.evaluateAndAct(project2, stackFrame, sb, callback);
                return true;
            }
            int res = ((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel((String)title, (String)(DebuggerBundle.message((String)"warning.finally.block.detected", (Object[])new Object[0]) + sb)).project(project2)).icon(Messages.getWarningIcon())).yesText(DebuggerBundle.message((String)"button.execute.finally", (Object[])new Object[0]))).noText(DebuggerBundle.message((String)"button.drop.anyway", (Object[])new Object[0]))).cancelText(CommonBundle.message((String)"button.cancel", (Object[])new Object[0])).doNotAsk(new DialogWrapper.DoNotAskOption(){

                public boolean isToBeShown() {
                    return !"EvaluateFinallyAlways".equals(DebuggerSettings.getInstance().EVALUATE_FINALLY_ON_POP_FRAME) && !"EvaluateFinallyNever".equals(DebuggerSettings.getInstance().EVALUATE_FINALLY_ON_POP_FRAME);
                }

                public void setToBeShown(boolean value, int exitCode) {
                    DebuggerSettings.getInstance().EVALUATE_FINALLY_ON_POP_FRAME = !value ? (exitCode == 0 ? "EvaluateFinallyAlways" : "EvaluateFinallyNever") : "EvaluateFinallyAsk";
                }

                public boolean canBeHidden() {
                    return true;
                }

                public boolean shouldSaveOptionsOnCancel() {
                    return false;
                }

                @NotNull
                public String getDoNotShowMessage() {
                    String string = CommonBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]);
                    if (string == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/PopFrameAction$2", "getDoNotShowMessage"));
                }
            })).show();
            switch (res) {
                case 2: {
                    return true;
                }
                case 1: {
                    break;
                }
                case 0: {
                    PopFrameAction.evaluateAndAct(project2, stackFrame, sb, callback);
                    return true;
                }
            }
        }
        return false;
    }

    private static void popFrame(DebugProcessImpl debugProcess, DebuggerContextImpl debuggerContext, JavaStackFrame stackFrame) {
        debugProcess.getManagerThread().schedule(debugProcess.createPopFrameCommand(debuggerContext, stackFrame.getStackFrameProxy()));
    }

    private static void evaluateAndAct(Project project2, JavaStackFrame stackFrame, StringBuilder sb, XDebuggerEvaluator.XEvaluationCallback callback) {
        XDebuggerEvaluator evaluator = stackFrame.getEvaluator();
        if (evaluator != null) {
            evaluator.evaluate((XExpression)XExpressionImpl.fromText((String)sb.toString(), (EvaluationMode)EvaluationMode.CODE_FRAGMENT), callback, stackFrame.getSourcePosition());
        } else {
            Messages.showMessageDialog((Project)project2, (String)XDebuggerBundle.message((String)"xdebugger.evaluate.stack.frame.has.not.evaluator", (Object[])new Object[0]), (String)UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"Debugger.PopFrame")), (Icon)Messages.getErrorIcon());
        }
    }

    static void showError(Project project2, String message, String title) {
        ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((Project)project2, (String)message, (String)title, (Icon)Messages.getErrorIcon()), ModalityState.any());
    }

    private static List<PsiStatement> getFinallyStatements(Project project2, @Nullable SourcePosition position) {
        if (position == null) {
            return Collections.emptyList();
        }
        ArrayList<PsiStatement> res = new ArrayList<PsiStatement>();
        PsiElement element = position.getFile().findElementAt(position.getOffset());
        PsiTryStatement tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTryStatement.class);
        while (tryStatement != null) {
            PsiCodeBlock finallyBlock;
            PsiResourceList resourceList = tryStatement.getResourceList();
            if (resourceList != null) {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
                for (PsiResourceListElement listElement : resourceList) {
                    String varName = PopFrameAction.getResourceName(listElement);
                    if (varName == null) continue;
                    res.add(factory.createStatementFromText("if (" + varName + " != null) " + varName + ".close();", (PsiElement)tryStatement));
                }
            }
            if ((finallyBlock = tryStatement.getFinallyBlock()) != null) {
                ContainerUtil.addAll(res, (Object[])finallyBlock.getStatements());
            }
            tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)tryStatement, PsiTryStatement.class);
        }
        return res;
    }

    private static String getResourceName(PsiResourceListElement resource) {
        if (resource instanceof PsiResourceVariable) {
            return ((PsiResourceVariable)resource).getName();
        }
        if (resource instanceof PsiResourceExpression) {
            return ((PsiResourceExpression)resource).getExpression().getText();
        }
        LOG.error("Unknown PsiResourceListElement type: " + resource.getClass());
        return null;
    }

    static JavaStackFrame getStackFrame(AnActionEvent e) {
        StackFrameDescriptorImpl descriptor2 = PopFrameAction.getSelectedStackFrameDescriptor(e);
        if (descriptor2 != null) {
            return new JavaStackFrame(descriptor2, false);
        }
        return PopFrameAction.getSelectedStackFrame(e);
    }

    static StackFrameProxyImpl getStackFrameProxy(AnActionEvent e) {
        DebuggerTreeNodeImpl node = PopFrameAction.getSelectedNode(e.getDataContext());
        if (node != null) {
            NodeDescriptorImpl descriptor2 = node.getDescriptor();
            if (descriptor2 instanceof StackFrameDescriptorImpl) {
                return ((StackFrameDescriptorImpl)descriptor2).getFrameProxy();
            }
        } else {
            JavaStackFrame stackFrame = PopFrameAction.getSelectedStackFrame(e);
            if (stackFrame != null) {
                return stackFrame.getStackFrameProxy();
            }
        }
        return null;
    }

    @Nullable
    private static StackFrameDescriptorImpl getSelectedStackFrameDescriptor(AnActionEvent e) {
        NodeDescriptorImpl descriptor2;
        DebuggerTreeNodeImpl selectedNode = PopFrameAction.getSelectedNode(e.getDataContext());
        if (selectedNode != null && (descriptor2 = selectedNode.getDescriptor()) instanceof StackFrameDescriptorImpl) {
            return (StackFrameDescriptorImpl)descriptor2;
        }
        return null;
    }

    @Nullable
    private static JavaStackFrame getSelectedStackFrame(AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 != null) {
            XStackFrame frame;
            XDebugSession session = (XDebugSession)e.getData(XDebugSession.DATA_KEY);
            if (session == null) {
                session = XDebuggerManager.getInstance((Project)project2).getCurrentSession();
            }
            if (session != null && (frame = session.getCurrentStackFrame()) instanceof JavaStackFrame) {
                return (JavaStackFrame)frame;
            }
        }
        return null;
    }

    private static boolean isAtBreakpoint(AnActionEvent e) {
        DebuggerTreeNodeImpl parent;
        DebuggerTreeNodeImpl selectedNode = PopFrameAction.getSelectedNode(e.getDataContext());
        if (selectedNode != null && selectedNode.getDescriptor() instanceof StackFrameDescriptorImpl && (parent = selectedNode.getParent()) != null) {
            return ((ThreadDescriptorImpl)parent.getDescriptor()).isAtBreakpoint();
        }
        DebuggerContextImpl debuggerContext = DebuggerAction.getDebuggerContext(e.getDataContext());
        SuspendContextImpl suspendContext = debuggerContext.getSuspendContext();
        return suspendContext != null && debuggerContext.getThreadProxy() == suspendContext.getThread();
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            PopFrameAction.$$$reportNull$$$0(1);
        }
        boolean enable = false;
        StackFrameProxyImpl proxy = PopFrameAction.getStackFrameProxy(e);
        if (proxy != null && !proxy.isBottom()) {
            enable = proxy.getVirtualMachine().canPopFrames();
        }
        if ((ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace()) || "DebuggerToolbar".equals(e.getPlace())) && PopFrameAction.isInJavaSession(e)) {
            e.getPresentation().setEnabled(enable);
        } else {
            e.getPresentation().setVisible(enable);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/debugger/actions/PopFrameAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

