/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.ReferringObject;
import com.intellij.debugger.engine.ReferringObjectsProvider;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XReferrersProvider;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaReferringObjectsValue
extends JavaValue {
    private static final long MAX_REFERRING = 100L;
    private final ReferringObjectsProvider myReferringObjectsProvider;
    private final Function<XValueNode, XValueNode> myNodeConfigurator;

    private JavaReferringObjectsValue(@Nullable JavaValue parent, @NotNull ValueDescriptorImpl valueDescriptor, @NotNull EvaluationContextImpl evaluationContext, @NotNull ReferringObjectsProvider referringObjectsProvider, NodeManagerImpl nodeManager, @Nullable Function<XValueNode, XValueNode> nodeConfigurator) {
        if (valueDescriptor == null) {
            JavaReferringObjectsValue.$$$reportNull$$$0(0);
        }
        if (evaluationContext == null) {
            JavaReferringObjectsValue.$$$reportNull$$$0(1);
        }
        if (referringObjectsProvider == null) {
            JavaReferringObjectsValue.$$$reportNull$$$0(2);
        }
        super(parent, valueDescriptor, evaluationContext, nodeManager, false);
        this.myReferringObjectsProvider = referringObjectsProvider;
        this.myNodeConfigurator = nodeConfigurator;
    }

    public JavaReferringObjectsValue(@NotNull JavaValue javaValue, @NotNull ReferringObjectsProvider referringObjectsProvider, @Nullable Function<XValueNode, XValueNode> nodeConfigurator) {
        if (javaValue == null) {
            JavaReferringObjectsValue.$$$reportNull$$$0(3);
        }
        if (referringObjectsProvider == null) {
            JavaReferringObjectsValue.$$$reportNull$$$0(4);
        }
        super(null, javaValue.getName(), javaValue.getDescriptor(), javaValue.getEvaluationContext(), javaValue.getNodeManager(), false);
        this.myReferringObjectsProvider = referringObjectsProvider;
        this.myNodeConfigurator = nodeConfigurator;
    }

    @Override
    @Nullable
    public XReferrersProvider getReferrersProvider() {
        return new XReferrersProvider(){

            public XValue getReferringObjectsValue() {
                return new JavaReferringObjectsValue(JavaReferringObjectsValue.this, JavaReferringObjectsValue.this.myReferringObjectsProvider, null);
            }
        };
    }

    @Override
    public void computeChildren(final @NotNull XCompositeNode node) {
        if (node == null) {
            JavaReferringObjectsValue.$$$reportNull$$$0(5);
        }
        JavaReferringObjectsValue.scheduleCommand(this.getEvaluationContext(), node, new SuspendContextCommandImpl(this.getEvaluationContext().getSuspendContext()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                List<ReferringObject> referringObjects;
                if (suspendContext == null) {
                    2.$$$reportNull$$$0(0);
                }
                XValueChildrenList children = new XValueChildrenList();
                Value value = JavaReferringObjectsValue.this.getDescriptor().getValue();
                try {
                    referringObjects = JavaReferringObjectsValue.this.myReferringObjectsProvider.getReferringObjects((ObjectReference)value, 100L);
                }
                catch (ObjectCollectedException e) {
                    node.setErrorMessage(DebuggerBundle.message((String)"evaluation.error.object.collected", (Object[])new Object[0]));
                    return;
                }
                catch (EvaluateException e) {
                    node.setErrorMessage(e.getMessage());
                    return;
                }
                int i = 1;
                for (ReferringObject object : referringObjects) {
                    String nodeName = object.getNodeName(i++);
                    ValueDescriptorImpl descriptor2 = object.createValueDescription(JavaReferringObjectsValue.this.getProject(), value);
                    JavaReferringObjectsValue referringValue = new JavaReferringObjectsValue(null, descriptor2, JavaReferringObjectsValue.this.getEvaluationContext(), JavaReferringObjectsValue.this.myReferringObjectsProvider, JavaReferringObjectsValue.this.getNodeManager(), object.getNodeCustomizer());
                    if (nodeName == null) {
                        children.add((XNamedValue)referringValue);
                        continue;
                    }
                    children.add(nodeName, (XValue)referringValue);
                }
                node.addChildren(children, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/actions/JavaReferringObjectsValue$2", "contextAction"));
            }
        });
    }

    @Override
    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        if (node == null) {
            JavaReferringObjectsValue.$$$reportNull$$$0(6);
        }
        if (place == null) {
            JavaReferringObjectsValue.$$$reportNull$$$0(7);
        }
        super.computePresentation(this.myNodeConfigurator == null ? node : this.myNodeConfigurator.apply(node), place);
    }

    @Override
    @Nullable
    public XValueModifier getModifier() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueDescriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referringObjectsProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaValue";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/actions/JavaReferringObjectsValue";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "computeChildren";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "computePresentation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

