/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.inspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.compiler.CompilerReferenceService;
import com.intellij.compiler.backwardRefs.CompilerReferenceServiceEx;
import com.intellij.compiler.backwardRefs.ReferenceIndexUnavailableException;
import com.intellij.compiler.inspection.ChangeSuperClassFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.SystemProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.MoreCollectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.backwardRefs.CompilerRef;

public class FrequentlyUsedInheritorInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(FrequentlyUsedInheritorInspection.class);
    public static final byte MAX_RESULT = 3;
    private static final int PERCENT_THRESHOLD = SystemProperties.getIntProperty((String)"FrequentlyUsedInheritorInspection.percent.threshold", (int)20);

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            FrequentlyUsedInheritorInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            FrequentlyUsedInheritorInspection.$$$reportNull$$$0(1);
        }
        if (aClass instanceof PsiTypeParameter || aClass.isEnum()) {
            return null;
        }
        Pair<PsiClass, PsiElement> superClassAndPlace = FrequentlyUsedInheritorInspection.getSuperIfOnlyOne(aClass);
        if (superClassAndPlace == null) {
            return null;
        }
        PsiClass superClass = (PsiClass)superClassAndPlace.getFirst();
        long ms = System.currentTimeMillis();
        List<ClassAndInheritorCount> topInheritors = FrequentlyUsedInheritorInspection.getTopInheritorsUsingCompilerIndices(superClass, aClass.getResolveScope(), (PsiElement)aClass);
        if (LOG.isDebugEnabled()) {
            LOG.debug("search for inheritance structure of " + superClass.getQualifiedName() + " in " + (System.currentTimeMillis() - ms) + " ms");
        }
        if (topInheritors.isEmpty()) {
            return null;
        }
        ArrayList<ChangeSuperClassFix> topInheritorsQuickFix = new ArrayList<ChangeSuperClassFix>(topInheritors.size());
        for (ClassAndInheritorCount searchResult : topInheritors) {
            PsiClass psi = searchResult.psi;
            if (InheritanceUtil.isInheritorOrSelf((PsiClass)psi, (PsiClass)aClass, (boolean)true)) continue;
            ChangeSuperClassFix quickFix = new ChangeSuperClassFix(aClass, psi, superClass, searchResult.number, searchResult.psi.isInterface() && !aClass.isInterface());
            topInheritorsQuickFix.add(quickFix);
            if (topInheritorsQuickFix.size() < 3) continue;
            break;
        }
        Object highlightingElement = aClass.getFields().length == 0 && aClass.getMethods().length == 0 && aClass.getInnerClasses().length == 0 && aClass.getInitializers().length == 0 ? aClass : (aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassReference() : (PsiElement)superClassAndPlace.getSecond());
        return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)highlightingElement, "Class can have more common super class", isOnTheFly, topInheritorsQuickFix.toArray(LocalQuickFix.EMPTY_ARRAY), ProblemHighlightType.GENERIC_ERROR_OR_WARNING)};
    }

    @Nullable
    private static Pair<PsiClass, PsiElement> getSuperIfOnlyOne(@NotNull PsiClass aClass) {
        PsiClass superClass;
        if (aClass == null) {
            FrequentlyUsedInheritorInspection.$$$reportNull$$$0(2);
        }
        if ((superClass = aClass.getSuperClass()) != null && !"java.lang.Object".equals(superClass.getQualifiedName())) {
            return FrequentlyUsedInheritorInspection.isInSourceContent((PsiElement)aClass) ? Pair.create((Object)superClass, (Object)aClass.getExtendsList()) : null;
        }
        PsiClass anInterface = ((Optional)((StreamEx)((StreamEx)StreamEx.of((Object[])aClass.getInterfaces()).filter(c -> !"java.lang.Object".equals(c.getQualifiedName()))).filter(c -> FrequentlyUsedInheritorInspection.isInSourceContent((PsiElement)c))).collect(MoreCollectors.onlyOne())).orElse(null);
        if (anInterface == null) {
            return null;
        }
        return Pair.create((Object)anInterface, (Object)(aClass.isInterface() ? aClass.getExtendsList() : aClass.getImplementsList()));
    }

    @NotNull
    private static List<ClassAndInheritorCount> getTopInheritorsUsingCompilerIndices(@NotNull PsiClass aClass, @NotNull GlobalSearchScope searchScope, @NotNull PsiElement place) {
        int id;
        CompilerReferenceServiceEx compilerRefService;
        Project project2;
        block11: {
            List<ClassAndInheritorCount> list;
            String qName;
            if (aClass == null) {
                FrequentlyUsedInheritorInspection.$$$reportNull$$$0(3);
            }
            if (searchScope == null) {
                FrequentlyUsedInheritorInspection.$$$reportNull$$$0(4);
            }
            if (place == null) {
                FrequentlyUsedInheritorInspection.$$$reportNull$$$0(5);
            }
            if ((qName = aClass.getQualifiedName()) == null) {
                List<ClassAndInheritorCount> list2 = Collections.emptyList();
                if (list2 == null) {
                    FrequentlyUsedInheritorInspection.$$$reportNull$$$0(6);
                }
                return list2;
            }
            project2 = aClass.getProject();
            compilerRefService = (CompilerReferenceServiceEx)CompilerReferenceService.getInstance((Project)project2);
            try {
                id = compilerRefService.getNameId(qName);
                if (id != 0) break block11;
                list = Collections.emptyList();
            }
            catch (ReferenceIndexUnavailableException e) {
                List<ClassAndInheritorCount> list3 = Collections.emptyList();
                if (list3 == null) {
                    FrequentlyUsedInheritorInspection.$$$reportNull$$$0(9);
                }
                return list3;
            }
            if (list == null) {
                FrequentlyUsedInheritorInspection.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<ClassAndInheritorCount> list = FrequentlyUsedInheritorInspection.findInheritors(aClass, new CompilerRef.JavaCompilerClassRef(id), searchScope, place, -1, project2, compilerRefService);
        if (list == null) {
            FrequentlyUsedInheritorInspection.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static List<ClassAndInheritorCount> findInheritors(@NotNull PsiClass aClass, @NotNull CompilerRef.JavaCompilerClassRef classAsCompilerRef, @NotNull GlobalSearchScope searchScope, @NotNull PsiElement place, int hierarchyCardinality, @NotNull Project project2, @NotNull CompilerReferenceServiceEx compilerRefService) {
        if (aClass == null) {
            FrequentlyUsedInheritorInspection.$$$reportNull$$$0(10);
        }
        if (classAsCompilerRef == null) {
            FrequentlyUsedInheritorInspection.$$$reportNull$$$0(11);
        }
        if (searchScope == null) {
            FrequentlyUsedInheritorInspection.$$$reportNull$$$0(12);
        }
        if (place == null) {
            FrequentlyUsedInheritorInspection.$$$reportNull$$$0(13);
        }
        if (project2 == null) {
            FrequentlyUsedInheritorInspection.$$$reportNull$$$0(14);
        }
        if (compilerRefService == null) {
            FrequentlyUsedInheritorInspection.$$$reportNull$$$0(15);
        }
        CompilerRef.CompilerClassHierarchyElementDef[] directInheritors = compilerRefService.getDirectInheritors((CompilerRef.CompilerClassHierarchyElementDef)classAsCompilerRef);
        if (hierarchyCardinality == -1 && (hierarchyCardinality = compilerRefService.getInheritorCount((CompilerRef.CompilerClassHierarchyElementDef)classAsCompilerRef)) == -1) {
            return Collections.emptyList();
        }
        int finalHierarchyCardinality = hierarchyCardinality;
        List directInheritorStats = Stream.of(directInheritors).filter(inheritor -> !(inheritor instanceof CompilerRef.CompilerAnonymousClassDef)).map(inheritor -> {
            ProgressManager.checkCanceled();
            int count = compilerRefService.getInheritorCount((CompilerRef.CompilerClassHierarchyElementDef)inheritor);
            if (count != 1 && count * 100 > finalHierarchyCardinality * PERCENT_THRESHOLD) {
                return new Object((CompilerRef.CompilerClassHierarchyElementDef)inheritor, count){
                    final CompilerRef.CompilerClassHierarchyElementDef myDef;
                    final int inheritorCount;
                    final /* synthetic */ CompilerRef.CompilerClassHierarchyElementDef val$inheritor;
                    final /* synthetic */ int val$count;
                    {
                        this.val$inheritor = compilerClassHierarchyElementDef;
                        this.val$count = n;
                        this.myDef = this.val$inheritor;
                        this.inheritorCount = this.val$count;
                    }
                };
            }
            return null;
        }).filter(Objects::nonNull).map(defAndCount -> {
            PsiClass inheritor;
            String name2 = compilerRefService.getName(defAndCount.myDef.getName());
            PsiClass[] inheritors = JavaPsiFacade.getInstance((Project)project2).findClasses(name2, searchScope);
            if (inheritors.length == 1 && (inheritor = inheritors[0]).isInheritor(aClass, false)) {
                return new ClassAndInheritorCount(inheritor, defAndCount.myDef, defAndCount.inheritorCount);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        PsiResolveHelper resolveHelper = PsiResolveHelper.SERVICE.getInstance((Project)project2);
        return directInheritorStats.stream().filter(c -> resolveHelper.isAccessible((PsiMember)((ClassAndInheritorCount)c).psi, place, null)).flatMap(c -> StreamEx.of(FrequentlyUsedInheritorInspection.getClassesIfInterface(c, finalHierarchyCardinality, searchScope, place, project2, compilerRefService)).prepend(c)).sorted().limit(3L).collect(Collectors.toList());
    }

    private static List<ClassAndInheritorCount> getClassesIfInterface(@NotNull ClassAndInheritorCount classAndInheritorCount, int hierarchyCardinality, GlobalSearchScope searchScope, PsiElement place, Project project2, CompilerReferenceServiceEx compilerRefService) {
        if (classAndInheritorCount == null) {
            FrequentlyUsedInheritorInspection.$$$reportNull$$$0(16);
        }
        if (classAndInheritorCount.psi.isInterface()) {
            return FrequentlyUsedInheritorInspection.findInheritors(classAndInheritorCount.psi, (CompilerRef.JavaCompilerClassRef)classAndInheritorCount.descriptor, searchScope, place, hierarchyCardinality, project2, compilerRefService);
        }
        return Collections.emptyList();
    }

    private static boolean isInSourceContent(@NotNull PsiElement e) {
        VirtualFile file;
        if (e == null) {
            FrequentlyUsedInheritorInspection.$$$reportNull$$$0(17);
        }
        if ((file = e.getContainingFile().getVirtualFile()) == null) {
            return false;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)e.getProject()).getFileIndex();
        return index.isInContent(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/inspection/FrequentlyUsedInheritorInspection";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classAsCompilerRef";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerRefService";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classAndInheritorCount";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/inspection/FrequentlyUsedInheritorInspection";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopInheritorsUsingCompilerIndices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSuperIfOnlyOne";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTopInheritorsUsingCompilerIndices";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findInheritors";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getClassesIfInterface";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isInSourceContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ClassAndInheritorCount
    implements Comparable<ClassAndInheritorCount> {
        private final PsiClass psi;
        private final CompilerRef.CompilerClassHierarchyElementDef descriptor;
        private final int number;

        private ClassAndInheritorCount(PsiClass psi, CompilerRef.CompilerClassHierarchyElementDef descriptor2, int number) {
            this.psi = psi;
            this.descriptor = descriptor2;
            this.number = number;
        }

        @Override
        public int compareTo(@NotNull ClassAndInheritorCount o) {
            if (o == null) {
                ClassAndInheritorCount.$$$reportNull$$$0(0);
            }
            return -this.number + o.number;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/compiler/inspection/FrequentlyUsedInheritorInspection$ClassAndInheritorCount", "compareTo"));
        }
    }
}

