/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.javac;

import com.intellij.compiler.OutputParser;
import com.intellij.compiler.impl.javaCompiler.javac.JavacParserAction;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FilePathActionJavac
extends JavacParserAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.javaCompiler.javac.FilePathActionJavac");
    private final Matcher myJdk7FormatMatcher = Pattern.compile("^\\w+\\[(.+)\\]$", 2).matcher("");

    public FilePathActionJavac(Matcher matcher) {
        super(matcher);
    }

    @Override
    protected void doExecute(String line, String filePath2, OutputParser.Callback callback) {
        int index;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Process parsing message: " + filePath2);
        }
        if (this.myJdk7FormatMatcher.reset(filePath2).matches()) {
            filePath2 = this.myJdk7FormatMatcher.group(1);
        }
        String name2 = (index = filePath2.lastIndexOf(47)) >= 0 ? filePath2.substring(index + 1) : filePath2;
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(name2);
        if (StdFileTypes.JAVA.equals(fileType)) {
            callback.fileProcessed(filePath2);
            callback.setProgressText(CompilerBundle.message((String)"progress.parsing.file", (Object[])new Object[]{name2}));
        } else if (StdFileTypes.CLASS.equals(fileType)) {
            callback.fileGenerated(filePath2);
        }
    }
}

