/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.Comment;
import com.intellij.compiler.ant.CompositeGenerator;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.GenerationUtils;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.taskdefs.FileSet;
import com.intellij.compiler.ant.taskdefs.Path;
import com.intellij.compiler.ant.taskdefs.PathElement;
import com.intellij.compiler.ant.taskdefs.PatternSetRef;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jetbrains.annotations.Nullable;

public class LibraryDefinitionsGeneratorFactory {
    private final ProjectEx myProject;
    private final GenerationOptions myGenOptions;
    private final Set<String> myUsedLibraries = new HashSet<String>();

    public LibraryDefinitionsGeneratorFactory(ProjectEx project2, GenerationOptions genOptions) {
        Module[] modules;
        this.myProject = project2;
        this.myGenOptions = genOptions;
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project2);
        for (Module module2 : modules = moduleManager.getModules()) {
            ModuleRootManager.getInstance((Module)module2).orderEntries().forEachLibrary(library -> {
                String name2 = library.getName();
                if (name2 != null) {
                    this.myUsedLibraries.add(name2);
                }
                return true;
            });
        }
    }

    @Nullable
    public Generator create(LibraryTable libraryTable, File baseDir, String comment) {
        Library[] libraries2 = libraryTable.getLibraries();
        if (libraries2.length == 0) {
            return null;
        }
        CompositeGenerator gen = new CompositeGenerator();
        gen.add((Generator)new Comment(comment), 1);
        TreeMap<String, Library> sortedLibs = new TreeMap<String, Library>();
        for (Library library : libraries2) {
            String libraryName = library.getName();
            if (!this.myUsedLibraries.contains(libraryName)) continue;
            sortedLibs.put(BuildProperties.getLibraryPathId((String)libraryName), library);
        }
        for (Library library : sortedLibs.values()) {
            String libraryName = library.getName();
            Path libraryPath = new Path(BuildProperties.getLibraryPathId((String)libraryName));
            LibraryDefinitionsGeneratorFactory.genLibraryContent(this.myProject, this.myGenOptions, library, baseDir, (CompositeGenerator)libraryPath);
            gen.add((Generator)libraryPath, 1);
        }
        return gen.getGeneratorCount() > 0 ? gen : null;
    }

    public static void genLibraryContent(ProjectEx project2, GenerationOptions genOptions, Library library, File baseDir, CompositeGenerator libraryPath) {
        LibraryDefinitionsGeneratorFactory.genLibraryContent(genOptions, library, OrderRootType.CLASSES, baseDir, libraryPath);
    }

    public static void genLibraryContent(GenerationOptions genOptions, Library library, OrderRootType rootType, File baseDir, CompositeGenerator libraryPath) {
        if (genOptions.expandJarDirectories) {
            VirtualFile[] files = library.getFiles(rootType);
            TreeSet<String> visitedPaths = new TreeSet<String>();
            for (VirtualFile file : files) {
                String path = GenerationUtils.toRelativePath((VirtualFile)file, (File)baseDir, (String)BuildProperties.getProjectBaseDirProperty(), (GenerationOptions)genOptions);
                visitedPaths.add(path);
            }
            for (String path : visitedPaths) {
                libraryPath.add((Generator)new PathElement(path));
            }
        } else {
            TreeSet<String> urls = new TreeSet<String>(Arrays.asList(library.getUrls(rootType)));
            for (String url : urls) {
                File file = LibraryDefinitionsGeneratorFactory.fileFromUrl(url);
                String path = GenerationUtils.toRelativePath((String)file.getPath(), (File)baseDir, (String)BuildProperties.getProjectBaseDirProperty(), (GenerationOptions)genOptions);
                if (url.startsWith("jar://")) {
                    libraryPath.add((Generator)new PathElement(path));
                    continue;
                }
                if (url.startsWith("file://")) {
                    if (library.isJarDirectory(url, rootType)) {
                        FileSet fileSet = new FileSet(path);
                        fileSet.add((Generator)new PatternSetRef("library.patterns"));
                        libraryPath.add((Generator)fileSet);
                        continue;
                    }
                    libraryPath.add((Generator)new PathElement(path));
                    continue;
                }
                throw new IllegalStateException("Unknown url type: " + url);
            }
        }
    }

    private static File fileFromUrl(String url) {
        String filePart;
        if (url.startsWith("jar://") && url.endsWith("!/")) {
            filePart = url.substring("jar://".length(), url.length() - "!/".length());
        } else if (url.startsWith("file://")) {
            filePart = url.substring("jar://".length());
        } else {
            throw new IllegalArgumentException("Unknown url type: " + url);
        }
        return new File(filePart.replace('/', File.separatorChar));
    }
}

