/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public class MacUIUtil {
    public static final boolean USE_QUARTZ = "true".equals(System.getProperty("apple.awt.graphics.UseQuartz"));
    public static final String MAC_FILL_BORDER = "MAC_FILL_BORDER";
    public static final int MAC_COMBO_BORDER_V_OFFSET = SystemInfo.isMacOSLion ? 1 : 0;
    private static Cursor INVERTED_TEXT_CURSOR;

    private MacUIUtil() {
    }

    public static void hideCursor() {
        if (SystemInfo.isMac && Registry.is("ide.mac.hide.cursor.when.typing")) {
            Foundation.invoke("NSCursor", "setHiddenUntilMouseMoves:", true);
        }
    }

    public static void drawToolbarDecoratorBackground(Graphics g2, int width, int height) {
        Graphics2D g = (Graphics2D)g2;
        int h1 = height / 2;
        g.setPaint(UIUtil.getGradientPaint(0.0f, 0.0f, Gray._247, 0.0f, h1, Gray._240));
        g.fillRect(0, 0, width, h1);
        g.setPaint(UIUtil.getGradientPaint(0.0f, h1, Gray._229, 0.0f, height, Gray._234));
        g.fillRect(0, h1, width, height);
    }

    public static Color getFocusRingColor() {
        Object o = UIManager.get("Focus.color");
        if (o instanceof Color) {
            return (Color)o;
        }
        return new Color(64, 113, 167);
    }

    public static void paintComboboxFocusRing(@NotNull Graphics2D g2d, @NotNull Rectangle bounds) {
        if (g2d == null) {
            MacUIUtil.$$$reportNull$$$0(0);
        }
        if (bounds == null) {
            MacUIUtil.$$$reportNull$$$0(1);
        }
        Color color = MacUIUtil.getFocusRingColor();
        Color[] colors = new Color[]{ColorUtil.toAlpha(color, 180), ColorUtil.toAlpha(color, 130), ColorUtil.toAlpha(color, 80), ColorUtil.toAlpha(color, 80)};
        Object oldAntialiasingValue = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object oldStrokeControlValue = g2d.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
        int _y = MAC_COMBO_BORDER_V_OFFSET;
        GeneralPath path1 = new GeneralPath();
        path1.moveTo(2.0f, _y + 4);
        path1.quadTo(2.0f, _y + 2, 4.0f, _y + 2);
        path1.lineTo(bounds.width - 7, _y + 2);
        path1.quadTo(bounds.width - 5, _y + 3, bounds.width - 4, _y + 5);
        path1.lineTo(bounds.width - 4, bounds.height - 7 + _y);
        path1.quadTo(bounds.width - 5, bounds.height - 5 + _y, bounds.width - 7, bounds.height - 4 + _y);
        path1.lineTo(4.0f, bounds.height - 4 + _y);
        path1.quadTo(2.0f, bounds.height - 4 + _y, 2.0f, bounds.height - 6 + _y);
        path1.closePath();
        g2d.setColor(colors[0]);
        g2d.draw(path1);
        GeneralPath path2 = new GeneralPath();
        path2.moveTo(1.0f, 5 + _y);
        path2.quadTo(1.0f, 1 + _y, 5.0f, 1 + _y);
        path2.lineTo(bounds.width - 8, 1 + _y);
        path2.quadTo(bounds.width - 4, 2 + _y, bounds.width - 3, 6 + _y);
        path2.lineTo(bounds.width - 3, bounds.height - 7 + _y);
        path2.quadTo(bounds.width - 4, bounds.height - 4 + _y, bounds.width - 8, bounds.height - 3 + _y);
        path2.lineTo(4.0f, bounds.height - 3 + _y);
        path2.quadTo(1.0f, bounds.height - 3 + _y, 1.0f, bounds.height - 6 + _y);
        path2.closePath();
        g2d.setColor(colors[1]);
        g2d.draw(path2);
        GeneralPath path3 = new GeneralPath();
        path3.moveTo(0.0f, 4 + _y);
        path3.quadTo(0.0f, _y, 7.0f, _y);
        path3.lineTo(bounds.width - 9, _y);
        path3.quadTo(bounds.width - 2, 1 + _y, bounds.width - 2, 7 + _y);
        path3.lineTo(bounds.width - 2, bounds.height - 8 + _y);
        path3.quadTo(bounds.width - 3, bounds.height - 1 + _y, bounds.width - 12, bounds.height - 2 + _y);
        path3.lineTo(7.0f, bounds.height - 2 + _y);
        path3.quadTo(0.0f, bounds.height - 1 + _y, 0.0f, bounds.height - 7 + _y);
        path3.closePath();
        g2d.setColor(colors[2]);
        g2d.draw(path3);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntialiasingValue);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, oldStrokeControlValue);
    }

    public static void drawComboboxFocusRing(@NotNull JComboBox combobox, @NotNull Graphics g) {
        Container ancestor;
        Component focusOwner;
        if (combobox == null) {
            MacUIUtil.$$$reportNull$$$0(2);
        }
        if (g == null) {
            MacUIUtil.$$$reportNull$$$0(3);
        }
        if (SystemInfo.isMac && combobox.isEnabled() && combobox.isEditable() && UIUtil.isUnderAquaLookAndFeel() && (focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) != null && (ancestor = SwingUtilities.getAncestorOfClass(JComboBox.class, focusOwner)) == combobox) {
            MacUIUtil.paintComboboxFocusRing((Graphics2D)g, combobox.getBounds());
        }
    }

    @NotNull
    public static Cursor getInvertedTextCursor() {
        if (INVERTED_TEXT_CURSOR == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image cursorImage = toolkit.getImage(MacUIUtil.class.getClassLoader().getResource("/mac/text.png"));
            INVERTED_TEXT_CURSOR = toolkit.createCustomCursor(cursorImage, new Point(15, 13), "InvertedTextCursor");
        }
        Cursor cursor = INVERTED_TEXT_CURSOR;
        if (cursor == null) {
            MacUIUtil.$$$reportNull$$$0(4);
        }
        return cursor;
    }

    public static MouseEvent fixMacContextMenuIssue(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && e.isControlDown() && e.getID() == 501) {
            int modifiers = e.getModifiers() & 0xFFFFFFED | 4;
            return new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), modifiers, e.getX(), e.getY(), e.getClickCount(), true, 3);
        }
        return e;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g2d";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "combobox";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/MacUIUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/MacUIUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvertedTextCursor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "paintComboboxFocusRing";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "drawComboboxFocusRing";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

