/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentMultiMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.containers.LinkedMultiMap;
import com.intellij.util.containers.OrderedSet;
import com.intellij.util.containers.SmartHashSet;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Debug.Renderer(text="\"size = \" + size()", hasChildren="!isEmpty()", childrenArray="entrySet().toArray()")
public class MultiMap<K, V>
implements Serializable {
    public static final MultiMap EMPTY = new EmptyMap();
    private static final long serialVersionUID = -2632269270151455493L;
    protected final Map<K, Collection<V>> myMap;
    private Collection<V> values;

    public MultiMap() {
        this.myMap = this.createMap();
    }

    public MultiMap(@NotNull MultiMap<? extends K, ? extends V> toCopy) {
        if (toCopy == null) {
            MultiMap.$$$reportNull$$$0(0);
        }
        this();
        this.putAllValues(toCopy);
    }

    @NotNull
    public MultiMap<K, V> copy() {
        MultiMap<K, V> multiMap = new MultiMap<K, V>(this);
        if (multiMap == null) {
            MultiMap.$$$reportNull$$$0(1);
        }
        return multiMap;
    }

    public MultiMap(int initialCapacity, float loadFactor) {
        this.myMap = this.createMap(initialCapacity, loadFactor);
    }

    @NotNull
    protected Map<K, Collection<V>> createMap() {
        HashMap hashMap = new HashMap();
        if (hashMap == null) {
            MultiMap.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    @NotNull
    protected Map<K, Collection<V>> createMap(int initialCapacity, float loadFactor) {
        HashMap hashMap = new HashMap(initialCapacity, loadFactor);
        if (hashMap == null) {
            MultiMap.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    @NotNull
    protected Collection<V> createCollection() {
        SmartList smartList = new SmartList();
        if (smartList == null) {
            MultiMap.$$$reportNull$$$0(4);
        }
        return smartList;
    }

    @NotNull
    protected Collection<V> createEmptyCollection() {
        List list = Collections.emptyList();
        if (list == null) {
            MultiMap.$$$reportNull$$$0(5);
        }
        return list;
    }

    public void putAllValues(@NotNull MultiMap<? extends K, ? extends V> from) {
        if (from == null) {
            MultiMap.$$$reportNull$$$0(6);
        }
        for (Map.Entry<K, Collection<V>> entry : from.entrySet()) {
            this.putValues(entry.getKey(), entry.getValue());
        }
    }

    public void putAllValues(@NotNull Map<? extends K, ? extends V> from) {
        if (from == null) {
            MultiMap.$$$reportNull$$$0(7);
        }
        for (Map.Entry<K, V> entry : from.entrySet()) {
            this.putValue(entry.getKey(), entry.getValue());
        }
    }

    public void putValues(K key, @NotNull Collection<? extends V> values) {
        Collection<V> list;
        if (values == null) {
            MultiMap.$$$reportNull$$$0(8);
        }
        if ((list = this.myMap.get(key)) == null) {
            list = this.createCollection();
            this.myMap.put(key, list);
        }
        list.addAll(values);
    }

    public void putValue(@Nullable K key, V value) {
        Collection<V> list = this.myMap.get(key);
        if (list == null) {
            list = this.createCollection();
            this.myMap.put(key, list);
        }
        list.add(value);
    }

    @NotNull
    public Set<Map.Entry<K, Collection<V>>> entrySet() {
        Set<Map.Entry<K, Collection<V>>> set = this.myMap.entrySet();
        if (set == null) {
            MultiMap.$$$reportNull$$$0(9);
        }
        return set;
    }

    public boolean isEmpty() {
        if (this.myMap.isEmpty()) {
            return true;
        }
        for (Collection<V> valueList : this.myMap.values()) {
            if (valueList.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean containsKey(K key) {
        return this.myMap.containsKey(key);
    }

    public boolean containsScalarValue(V value) {
        for (Collection<V> valueList : this.myMap.values()) {
            if (!valueList.contains(value)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Collection<V> get(K key) {
        Collection<V> collection = this.myMap.get(key);
        Collection<V> collection2 = collection == null ? this.createEmptyCollection() : collection;
        if (collection2 == null) {
            MultiMap.$$$reportNull$$$0(10);
        }
        return collection2;
    }

    @NotNull
    public Collection<V> getModifiable(K key) {
        Collection<V> collection = this.myMap.get(key);
        if (collection == null) {
            collection = this.createCollection();
            this.myMap.put(key, collection);
        }
        Collection<V> collection2 = collection;
        if (collection2 == null) {
            MultiMap.$$$reportNull$$$0(11);
        }
        return collection2;
    }

    @NotNull
    public Set<K> keySet() {
        Set<K> set = this.myMap.keySet();
        if (set == null) {
            MultiMap.$$$reportNull$$$0(12);
        }
        return set;
    }

    public int size() {
        return this.myMap.size();
    }

    public void put(K key, Collection<V> values) {
        this.myMap.put(key, values);
    }

    @Deprecated
    public void removeValue(K key, V value) {
        this.remove(key, value);
    }

    public boolean remove(K key, V value) {
        Collection<V> values = this.myMap.get(key);
        if (values != null) {
            boolean removed = values.remove(value);
            if (values.isEmpty()) {
                this.myMap.remove(key);
            }
            return removed;
        }
        return false;
    }

    @NotNull
    public Collection<? extends V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                @NotNull
                public Iterator<V> iterator() {
                    Iterator iterator = new Iterator<V>(){
                        private final Iterator<Collection<V>> mapIterator;
                        private Iterator<V> itr;
                        {
                            this.mapIterator = MultiMap.this.myMap.values().iterator();
                            this.itr = EmptyIterator.getInstance();
                        }

                        @Override
                        public boolean hasNext() {
                            while (!this.itr.hasNext()) {
                                if (!this.mapIterator.hasNext()) {
                                    return false;
                                }
                                this.itr = this.mapIterator.next().iterator();
                            }
                            return true;
                        }

                        @Override
                        public V next() {
                            while (!this.itr.hasNext()) {
                                if (!this.mapIterator.hasNext()) {
                                    throw new NoSuchElementException();
                                }
                                this.itr = this.mapIterator.next().iterator();
                            }
                            return this.itr.next();
                        }

                        @Override
                        public void remove() {
                            this.itr.remove();
                        }
                    };
                    if (iterator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return iterator;
                }

                @Override
                public int size() {
                    int res = 0;
                    for (Collection vs : MultiMap.this.myMap.values()) {
                        res += vs.size();
                    }
                    return res;
                }

                @Override
                public boolean contains(Object o) {
                    for (Collection vs : MultiMap.this.myMap.values()) {
                        if (!vs.contains(o)) continue;
                        return true;
                    }
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap$1", "iterator"));
                }
            };
        }
        Collection<V> collection = this.values;
        if (collection == null) {
            MultiMap.$$$reportNull$$$0(13);
        }
        return collection;
    }

    public void clear() {
        this.myMap.clear();
    }

    @Nullable
    public Collection<V> remove(K key) {
        return this.myMap.remove(key);
    }

    @NotNull
    public static <K, V> MultiMap<K, V> emptyInstance() {
        MultiMap empty;
        MultiMap multiMap = empty = EMPTY;
        if (multiMap == null) {
            MultiMap.$$$reportNull$$$0(14);
        }
        return multiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> create() {
        MultiMap<K, V> multiMap = new MultiMap<K, V>();
        if (multiMap == null) {
            MultiMap.$$$reportNull$$$0(15);
        }
        return multiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> create(final @NotNull TObjectHashingStrategy<K> strategy) {
        if (strategy == null) {
            MultiMap.$$$reportNull$$$0(16);
        }
        MultiMap multiMap = new MultiMap<K, V>(){

            @Override
            @NotNull
            protected Map<K, Collection<V>> createMap() {
                THashMap tHashMap = new THashMap(strategy);
                if (tHashMap == null) {
                    2.$$$reportNull$$$0(0);
                }
                return tHashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap$2", "createMap"));
            }
        };
        if (multiMap == null) {
            MultiMap.$$$reportNull$$$0(17);
        }
        return multiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createLinked() {
        LinkedMultiMap linkedMultiMap = new LinkedMultiMap();
        if (linkedMultiMap == null) {
            MultiMap.$$$reportNull$$$0(18);
        }
        return linkedMultiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createLinkedSet() {
        LinkedMultiMap linkedMultiMap = new LinkedMultiMap<K, V>(){

            @Override
            @NotNull
            protected Collection<V> createCollection() {
                LinkedHashSet linkedHashSet = ContainerUtil.newLinkedHashSet();
                if (linkedHashSet == null) {
                    3.$$$reportNull$$$0(0);
                }
                return linkedHashSet;
            }

            @Override
            @NotNull
            protected Collection<V> createEmptyCollection() {
                Set set = Collections.emptySet();
                if (set == null) {
                    3.$$$reportNull$$$0(1);
                }
                return set;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/containers/MultiMap$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createCollection";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createEmptyCollection";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (linkedMultiMap == null) {
            MultiMap.$$$reportNull$$$0(19);
        }
        return linkedMultiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createOrderedSet() {
        LinkedMultiMap linkedMultiMap = new LinkedMultiMap<K, V>(){

            @Override
            @NotNull
            protected Collection<V> createCollection() {
                OrderedSet orderedSet = new OrderedSet();
                if (orderedSet == null) {
                    4.$$$reportNull$$$0(0);
                }
                return orderedSet;
            }

            @Override
            @NotNull
            protected Collection<V> createEmptyCollection() {
                Set set = Collections.emptySet();
                if (set == null) {
                    4.$$$reportNull$$$0(1);
                }
                return set;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/containers/MultiMap$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createCollection";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createEmptyCollection";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (linkedMultiMap == null) {
            MultiMap.$$$reportNull$$$0(20);
        }
        return linkedMultiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createSmart() {
        MultiMap multiMap = new MultiMap<K, V>(){

            @Override
            @NotNull
            protected Map<K, Collection<V>> createMap() {
                THashMap tHashMap = new THashMap();
                if (tHashMap == null) {
                    5.$$$reportNull$$$0(0);
                }
                return tHashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap$5", "createMap"));
            }
        };
        if (multiMap == null) {
            MultiMap.$$$reportNull$$$0(21);
        }
        return multiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createConcurrentSet() {
        ConcurrentMultiMap concurrentMultiMap = new ConcurrentMultiMap<K, V>(){

            @Override
            @NotNull
            protected Collection<V> createCollection() {
                Set set = ContainerUtil.newConcurrentSet();
                if (set == null) {
                    6.$$$reportNull$$$0(0);
                }
                return set;
            }

            @Override
            @NotNull
            protected Collection<V> createEmptyCollection() {
                Set set = Collections.emptySet();
                if (set == null) {
                    6.$$$reportNull$$$0(1);
                }
                return set;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/containers/MultiMap$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createCollection";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createEmptyCollection";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (concurrentMultiMap == null) {
            MultiMap.$$$reportNull$$$0(22);
        }
        return concurrentMultiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createSet() {
        MultiMap multiMap = MultiMap.createSet(ContainerUtil.canonicalStrategy());
        if (multiMap == null) {
            MultiMap.$$$reportNull$$$0(23);
        }
        return multiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createSet(final @NotNull TObjectHashingStrategy<K> strategy) {
        if (strategy == null) {
            MultiMap.$$$reportNull$$$0(24);
        }
        MultiMap multiMap = new MultiMap<K, V>(){

            @Override
            @NotNull
            protected Collection<V> createCollection() {
                SmartHashSet smartHashSet = new SmartHashSet();
                if (smartHashSet == null) {
                    7.$$$reportNull$$$0(0);
                }
                return smartHashSet;
            }

            @Override
            @NotNull
            protected Collection<V> createEmptyCollection() {
                Set set = Collections.emptySet();
                if (set == null) {
                    7.$$$reportNull$$$0(1);
                }
                return set;
            }

            @Override
            @NotNull
            protected Map<K, Collection<V>> createMap() {
                THashMap tHashMap = new THashMap(strategy);
                if (tHashMap == null) {
                    7.$$$reportNull$$$0(2);
                }
                return tHashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/containers/MultiMap$7";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createCollection";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createEmptyCollection";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createMap";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (multiMap == null) {
            MultiMap.$$$reportNull$$$0(25);
        }
        return multiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createWeakKey() {
        MultiMap multiMap = new MultiMap<K, V>(){

            @Override
            @NotNull
            protected Map<K, Collection<V>> createMap() {
                Map map = ContainerUtil.createWeakMap();
                if (map == null) {
                    8.$$$reportNull$$$0(0);
                }
                return map;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap$8", "createMap"));
            }
        };
        if (multiMap == null) {
            MultiMap.$$$reportNull$$$0(26);
        }
        return multiMap;
    }

    public static <K, V> MultiMap<K, V> create(int initialCapacity, float loadFactor) {
        return new MultiMap<K, V>(initialCapacity, loadFactor);
    }

    public boolean equals(Object o) {
        return this == o || o instanceof MultiMap && this.myMap.equals(((MultiMap)o).myMap);
    }

    public int hashCode() {
        return this.myMap.hashCode();
    }

    public String toString() {
        return new HashMap<K, Collection<V>>(this.myMap).toString();
    }

    public static <K, V> MultiMap<K, V> empty() {
        return EMPTY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toCopy";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/MultiMap";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 16: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/MultiMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createMap";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCollection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyCollection";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySet";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiable";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyInstance";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createLinked";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createLinkedSet";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createOrderedSet";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createSmart";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentSet";
                break;
            }
            case 23: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createSet";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "putAllValues";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "putValues";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createSet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EmptyMap
    extends MultiMap {
        private EmptyMap() {
        }

        @NotNull
        protected Map createMap() {
            Map map = Collections.emptyMap();
            if (map == null) {
                EmptyMap.$$$reportNull$$$0(0);
            }
            return map;
        }

        public void putValues(Object key, @NotNull Collection values) {
            if (values == null) {
                EmptyMap.$$$reportNull$$$0(1);
            }
            throw new UnsupportedOperationException();
        }

        public void putValue(@Nullable Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public void put(Object key, Collection values) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public Collection remove(Object key) {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/MultiMap$EmptyMap";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createMap";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/MultiMap$EmptyMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "putValues";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

