/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;

@Debug.Renderer(text="\"size = \" + size()", hasChildren="!isEmpty()", childrenArray="myMap.entrySet().toArray()")
public class MostlySingularMultiMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 2784473565881807109L;
    protected final Map<K, Object> myMap = this.createMap();
    private static final MostlySingularMultiMap EMPTY = new EmptyMap();

    @NotNull
    protected Map<K, Object> createMap() {
        THashMap tHashMap = new THashMap();
        if (tHashMap == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(0);
        }
        return tHashMap;
    }

    public void add(@NotNull K key, @NotNull V value) {
        Object current;
        if (key == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(1);
        }
        if (value == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(2);
        }
        if ((current = this.myMap.get(key)) == null) {
            this.myMap.put(key, value);
        } else if (current instanceof ValueList) {
            ValueList curList = (ValueList)current;
            curList.add(value);
        } else {
            ValueList newList = new ValueList();
            newList.add(current);
            newList.add(value);
            this.myMap.put(key, newList);
        }
    }

    public boolean remove(@NotNull K key, @NotNull V value) {
        Object current;
        if (key == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(3);
        }
        if (value == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(4);
        }
        if ((current = this.myMap.get(key)) == null) {
            return false;
        }
        if (current instanceof ValueList) {
            ValueList curList = (ValueList)current;
            return curList.remove(value);
        }
        if (value.equals(current)) {
            this.myMap.remove(key);
            return true;
        }
        return false;
    }

    public boolean removeAllValues(@NotNull K key) {
        if (key == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(5);
        }
        return this.myMap.remove(key) != null;
    }

    @NotNull
    public Set<K> keySet() {
        Set<K> set = this.myMap.keySet();
        if (set == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(6);
        }
        return set;
    }

    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    public boolean processForKey(@NotNull K key, @NotNull Processor<? super V> p) {
        if (key == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(7);
        }
        if (p == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(8);
        }
        return this.processValue(p, this.myMap.get(key));
    }

    private boolean processValue(@NotNull Processor<? super V> p, Object v) {
        if (p == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(9);
        }
        if (v instanceof ValueList) {
            for (Object o : (ValueList)v) {
                if (p.process(o)) continue;
                return false;
            }
        } else if (v != null) {
            return p.process(v);
        }
        return true;
    }

    public boolean processAllValues(@NotNull Processor<? super V> p) {
        if (p == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(10);
        }
        for (Object v : this.myMap.values()) {
            if (this.processValue(p, v)) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.myMap.size();
    }

    public boolean containsKey(@NotNull K key) {
        if (key == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(11);
        }
        return this.myMap.containsKey(key);
    }

    public int valuesForKey(@NotNull K key) {
        Object current;
        if (key == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(12);
        }
        if ((current = this.myMap.get(key)) == null) {
            return 0;
        }
        if (current instanceof ValueList) {
            return ((ValueList)current).size();
        }
        return 1;
    }

    @NotNull
    public Iterable<V> get(@NotNull K name) {
        if (name == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(13);
        }
        Object value = this.myMap.get(name);
        List<V> list = this.rawValueToCollection(value);
        if (list == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    protected List<V> rawValueToCollection(Object value) {
        if (value == null) {
            List list = Collections.emptyList();
            if (list == null) {
                MostlySingularMultiMap.$$$reportNull$$$0(15);
            }
            return list;
        }
        if (value instanceof ValueList) {
            ValueList valueList = (ValueList)value;
            if (valueList == null) {
                MostlySingularMultiMap.$$$reportNull$$$0(16);
            }
            return valueList;
        }
        List<Object> list = Collections.singletonList(value);
        if (list == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(17);
        }
        return list;
    }

    public void compact() {
        ((THashMap)this.myMap).compact();
        for (Object eachValue : this.myMap.values()) {
            if (!(eachValue instanceof ValueList)) continue;
            ((ValueList)eachValue).trimToSize();
        }
    }

    public String toString() {
        return "{" + StringUtil.join(this.myMap.entrySet(), entry -> {
            Object value = entry.getValue();
            String s = (value instanceof ValueList ? (ValueList)value : Collections.singletonList(value)).toString();
            return entry.getKey() + ": " + s;
        }, "; ") + "}";
    }

    public void clear() {
        this.myMap.clear();
    }

    @NotNull
    public static <K, V> MostlySingularMultiMap<K, V> emptyMap() {
        MostlySingularMultiMap mostlySingularMultiMap = EMPTY;
        if (mostlySingularMultiMap == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(18);
        }
        return mostlySingularMultiMap;
    }

    @NotNull
    public static <K, V> MostlySingularMultiMap<K, V> newMap() {
        MostlySingularMultiMap<K, V> mostlySingularMultiMap = new MostlySingularMultiMap<K, V>();
        if (mostlySingularMultiMap == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(19);
        }
        return mostlySingularMultiMap;
    }

    public void addAll(MostlySingularMultiMap<K, V> other) {
        if (other instanceof EmptyMap) {
            return;
        }
        for (Map.Entry<K, Object> entry : other.myMap.entrySet()) {
            K key = entry.getKey();
            Object otherValue = entry.getValue();
            Object myValue = this.myMap.get(key);
            if (myValue == null) {
                if (otherValue instanceof ValueList) {
                    this.myMap.put(key, new ValueList((ValueList)otherValue));
                    continue;
                }
                this.myMap.put(key, otherValue);
                continue;
            }
            if (myValue instanceof ValueList) {
                ValueList myListValue = (ValueList)myValue;
                if (otherValue instanceof ValueList) {
                    myListValue.addAll((ValueList)otherValue);
                    continue;
                }
                myListValue.add(otherValue);
                continue;
            }
            if (otherValue instanceof ValueList) {
                ValueList otherListValue = (ValueList)otherValue;
                ValueList newList = new ValueList(otherListValue.size() + 1);
                newList.add(myValue);
                newList.addAll(otherListValue);
                this.myMap.put(key, newList);
                continue;
            }
            ValueList newList = new ValueList();
            newList.add(myValue);
            newList.add(otherValue);
            this.myMap.put(key, newList);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/MostlySingularMultiMap";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createMap";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/MostlySingularMultiMap";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "rawValueToCollection";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyMap";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "newMap";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeAllValues";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processForKey";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processValue";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processAllValues";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "containsKey";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "valuesForKey";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EmptyMap
    extends MostlySingularMultiMap {
        private EmptyMap() {
        }

        public void add(@NotNull Object key, @NotNull Object value) {
            if (key == null) {
                EmptyMap.$$$reportNull$$$0(0);
            }
            if (value == null) {
                EmptyMap.$$$reportNull$$$0(1);
            }
            throw new IncorrectOperationException();
        }

        public boolean remove(@NotNull Object key, @NotNull Object value) {
            if (key == null) {
                EmptyMap.$$$reportNull$$$0(2);
            }
            if (value == null) {
                EmptyMap.$$$reportNull$$$0(3);
            }
            throw new IncorrectOperationException();
        }

        public boolean removeAllValues(@NotNull Object key) {
            if (key == null) {
                EmptyMap.$$$reportNull$$$0(4);
            }
            throw new IncorrectOperationException();
        }

        @Override
        public void clear() {
            throw new IncorrectOperationException();
        }

        @NotNull
        public Set keySet() {
            Set set = Collections.emptySet();
            if (set == null) {
                EmptyMap.$$$reportNull$$$0(5);
            }
            return set;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        public boolean processForKey(@NotNull Object key, @NotNull Processor p) {
            if (key == null) {
                EmptyMap.$$$reportNull$$$0(6);
            }
            if (p == null) {
                EmptyMap.$$$reportNull$$$0(7);
            }
            return true;
        }

        public boolean processAllValues(@NotNull Processor p) {
            if (p == null) {
                EmptyMap.$$$reportNull$$$0(8);
            }
            return true;
        }

        @Override
        public int size() {
            return 0;
        }

        public int valuesForKey(@NotNull Object key) {
            if (key == null) {
                EmptyMap.$$$reportNull$$$0(9);
            }
            return 0;
        }

        @NotNull
        public Iterable get(@NotNull Object name) {
            if (name == null) {
                EmptyMap.$$$reportNull$$$0(10);
            }
            List list = ContainerUtil.emptyList();
            if (list == null) {
                EmptyMap.$$$reportNull$$$0(11);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 5: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/MostlySingularMultiMap$EmptyMap";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/MostlySingularMultiMap$EmptyMap";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "keySet";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "removeAllValues";
                    break;
                }
                case 5: 
                case 11: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "processForKey";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "processAllValues";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "valuesForKey";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class ValueList<V>
    extends ArrayList<V> {
        public ValueList() {
        }

        public ValueList(int initialCapacity) {
            super(initialCapacity);
        }

        public ValueList(@NotNull Collection<? extends V> c) {
            if (c == null) {
                ValueList.$$$reportNull$$$0(0);
            }
            super(c);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/MostlySingularMultiMap$ValueList", "<init>"));
        }
    }
}

