/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.Pluralizer;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.LineSeparator;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import com.intellij.util.text.MergingCharSequence;
import com.intellij.util.text.OrdinalFormat;
import com.intellij.util.text.StringFactory;
import com.intellij.util.text.StringTokenizer;
import java.beans.Introspector;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringUtil
extends StringUtilRt {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.text.StringUtil");
    private static final String VOWELS = "aeiouy";
    private static final Pattern EOL_SPLIT_KEEP_SEPARATORS = Pattern.compile("(?<=(\r\n|\n))|(?<=\r)(?=[^\n])");
    private static final Pattern EOL_SPLIT_PATTERN = Pattern.compile(" *(\r|\n|\r\n)+ *");
    private static final Pattern EOL_SPLIT_PATTERN_WITH_EMPTY = Pattern.compile(" *(\r|\n|\r\n) *");
    private static final Pattern EOL_SPLIT_DONT_TRIM_PATTERN = Pattern.compile("(\r|\n|\r\n)+");
    private static final MyHtml2Text html2TextParser = new MyHtml2Text(false);
    public static final NotNullFunction<String, String> QUOTER = s -> "\"" + s + "\"";
    public static final NotNullFunction<String, String> SINGLE_QUOTER = s -> "'" + s + "'";
    @NotNull
    public static final Function<String, String> TRIMMER = StringUtil::trim;
    private static final String[] ourPrepositions = new String[]{"a", "an", "and", "as", "at", "but", "by", "down", "for", "from", "if", "in", "into", "not", "of", "on", "onto", "or", "out", "over", "per", "nor", "the", "to", "up", "upon", "via", "with"};
    private static final String[] TIME_UNITS = new String[]{"ms", "s", "m", "h", "d", "mo", "yr", "c", "ml", "ep"};
    private static final long[] TIME_MULTIPLIERS = new long[]{1L, 1000L, 60L, 60L, 24L, 30L, 12L, 100L, 10L, 10000L};
    private static final List<String> REPLACES_REFS = Arrays.asList("&lt;", "&gt;", "&amp;", "&#39;", "&quot;");
    private static final List<String> REPLACES_DISP = Arrays.asList("<", ">", "&", "'", "\"");
    private static final List<String> MN_QUOTED = Arrays.asList("&&", "__");
    private static final List<String> MN_CHARS = Arrays.asList("&", "_");
    private static final Pattern UNICODE_CHAR = Pattern.compile("\\\\u[0-9a-fA-F]{4}");

    @NotNull
    public static MergingCharSequence replaceSubSequence(@NotNull CharSequence charSeq, int start, int end, @NotNull CharSequence replacement) {
        if (charSeq == null) {
            StringUtil.$$$reportNull$$$0(0);
        }
        if (replacement == null) {
            StringUtil.$$$reportNull$$$0(1);
        }
        MergingCharSequence mergingCharSequence = new MergingCharSequence(new MergingCharSequence(new CharSequenceSubSequence(charSeq, 0, start), replacement), new CharSequenceSubSequence(charSeq, end, charSeq.length()));
        if (mergingCharSequence == null) {
            StringUtil.$$$reportNull$$$0(2);
        }
        return mergingCharSequence;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> getWordsInStringLongestFirst(@NotNull String find) {
        if (find == null) {
            StringUtil.$$$reportNull$$$0(3);
        }
        List<String> words = StringUtil.getWordsIn(find);
        words.sort((o1, o2) -> o2.length() - o1.length());
        List<String> list = words;
        if (list == null) {
            StringUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapePattern(@NotNull String text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(5);
        }
        String string = StringUtil.replace(StringUtil.replace(text, "'", "''"), "{", "'{'");
        if (string == null) {
            StringUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Function<T, String> createToStringFunction(@NotNull Class<T> cls) {
        if (cls == null) {
            StringUtil.$$$reportNull$$$0(7);
        }
        Function<Object, String> function = Object::toString;
        if (function == null) {
            StringUtil.$$$reportNull$$$0(8);
        }
        return function;
    }

    @NotNull
    @Contract(pure=true)
    public static String replace(@NotNull String text, @NotNull String oldS, @NotNull String newS) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(9);
        }
        if (oldS == null) {
            StringUtil.$$$reportNull$$$0(10);
        }
        if (newS == null) {
            StringUtil.$$$reportNull$$$0(11);
        }
        String string = StringUtil.replace(text, oldS, newS, false);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String replaceIgnoreCase(@NotNull String text, @NotNull String oldS, @NotNull String newS) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(13);
        }
        if (oldS == null) {
            StringUtil.$$$reportNull$$$0(14);
        }
        if (newS == null) {
            StringUtil.$$$reportNull$$$0(15);
        }
        String string = StringUtil.replace(text, oldS, newS, true);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    public static String replaceChar(@NotNull String buffer, char oldChar, char newChar) {
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(17);
        }
        String string = buffer.replace(oldChar, newChar);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Contract(pure=true)
    public static String replace(@NotNull String text, @NotNull String oldS, @NotNull String newS, boolean ignoreCase) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(19);
        }
        if (oldS == null) {
            StringUtil.$$$reportNull$$$0(20);
        }
        if (newS == null) {
            StringUtil.$$$reportNull$$$0(21);
        }
        if (text.length() < oldS.length()) {
            return text;
        }
        StringBuilder newText = null;
        int i = 0;
        while (i < text.length()) {
            int index;
            int n = index = ignoreCase ? StringUtil.indexOfIgnoreCase(text, oldS, i) : text.indexOf(oldS, i);
            if (index < 0) {
                if (i == 0) {
                    return text;
                }
                newText.append(text, i, text.length());
                break;
            }
            if (newText == null) {
                if (text.length() == oldS.length()) {
                    return newS;
                }
                newText = new StringBuilder(text.length() - i);
            }
            newText.append(text, i, index);
            newText.append(newS);
            i = index + oldS.length();
        }
        return newText != null ? newText.toString() : "";
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull String where, @NotNull String what, int fromIndex) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(22);
        }
        if (what == null) {
            StringUtil.$$$reportNull$$$0(23);
        }
        return StringUtil.indexOfIgnoreCase((CharSequence)where, (CharSequence)what, fromIndex);
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull CharSequence where, @NotNull CharSequence what, int fromIndex) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(24);
        }
        if (what == null) {
            StringUtil.$$$reportNull$$$0(25);
        }
        int targetCount = what.length();
        int sourceCount = where.length();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = what.charAt(0);
        int max = sourceCount - targetCount;
        for (int i = fromIndex; i <= max; ++i) {
            if (!StringUtil.charsEqualIgnoreCase(where.charAt(i), first)) {
                while (++i <= max && !StringUtil.charsEqualIgnoreCase(where.charAt(i), first)) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = 1;
            while (j < end && StringUtil.charsEqualIgnoreCase(where.charAt(j), what.charAt(k))) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull String where, char what, int fromIndex) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(26);
        }
        int sourceCount = where.length();
        for (int i = Math.max(fromIndex, 0); i < sourceCount; ++i) {
            if (!StringUtil.charsEqualIgnoreCase(where.charAt(i), what)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexOfIgnoreCase(@NotNull String where, char what, int fromIndex) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(27);
        }
        for (int i = Math.min(fromIndex, where.length() - 1); i >= 0; --i) {
            if (!StringUtil.charsEqualIgnoreCase(where.charAt(i), what)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static boolean containsIgnoreCase(@NotNull String where, @NotNull String what) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(28);
        }
        if (what == null) {
            StringUtil.$$$reportNull$$$0(29);
        }
        return StringUtil.indexOfIgnoreCase(where, what, 0) >= 0;
    }

    @Contract(pure=true)
    public static boolean endsWithIgnoreCase(@NotNull String str, @NotNull String suffix) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(30);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(31);
        }
        return StringUtilRt.endsWithIgnoreCase(str, suffix);
    }

    @Contract(pure=true)
    public static boolean startsWithIgnoreCase(@NotNull String str, @NotNull String prefix) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(32);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(33);
        }
        return StringUtilRt.startsWithIgnoreCase(str, prefix);
    }

    @Contract(pure=true)
    @NotNull
    public static String stripHtml(@NotNull String html, boolean convertBreaks) {
        if (html == null) {
            StringUtil.$$$reportNull$$$0(34);
        }
        if (convertBreaks) {
            html = html.replaceAll("<br/?>", "\n\n");
        }
        String string = html.replaceAll("<(.|\n)*?>", "");
        if (string == null) {
            StringUtil.$$$reportNull$$$0(35);
        }
        return string;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String toLowerCase(@Nullable String str) {
        return str == null ? null : str.toLowerCase();
    }

    @NotNull
    @Contract(pure=true)
    public static String getPackageName(@NotNull String fqName) {
        if (fqName == null) {
            StringUtil.$$$reportNull$$$0(36);
        }
        String string = StringUtil.getPackageName(fqName, '.');
        if (string == null) {
            StringUtil.$$$reportNull$$$0(37);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String getPackageName(@NotNull String fqName, char separator) {
        int lastPointIdx;
        if (fqName == null) {
            StringUtil.$$$reportNull$$$0(38);
        }
        if ((lastPointIdx = fqName.lastIndexOf(separator)) >= 0) {
            String string = fqName.substring(0, lastPointIdx);
            if (string == null) {
                StringUtil.$$$reportNull$$$0(39);
            }
            return string;
        }
        if ("" == null) {
            StringUtil.$$$reportNull$$$0(40);
        }
        return "";
    }

    @Contract(pure=true)
    public static int getLineBreakCount(@NotNull CharSequence text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(41);
        }
        int count = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\n') {
                ++count;
                continue;
            }
            if (c != '\r') continue;
            if (i + 1 < text.length() && text.charAt(i + 1) == '\n') {
                ++i;
            }
            ++count;
        }
        return count;
    }

    @Contract(pure=true)
    public static boolean containsLineBreak(@NotNull CharSequence text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(42);
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!StringUtil.isLineBreak(c)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean isLineBreak(char c) {
        return c == '\n' || c == '\r';
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeLineBreak(@NotNull String text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(43);
        }
        StringBuilder buffer = new StringBuilder(text.length());
        block4: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append("\\n");
                    continue block4;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block4;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        String string = buffer.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(44);
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean endsWithLineBreak(@NotNull CharSequence text) {
        int len;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(45);
        }
        return (len = text.length()) > 0 && StringUtil.isLineBreak(text.charAt(len - 1));
    }

    @Contract(pure=true)
    public static int lineColToOffset(@NotNull CharSequence text, int line, int col) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(46);
        }
        int curLine = 0;
        int offset = 0;
        while (line != curLine) {
            if (offset == text.length()) {
                return -1;
            }
            char c = text.charAt(offset);
            if (c == '\n') {
                ++curLine;
            } else if (c == '\r') {
                ++curLine;
                if (offset < text.length() - 1 && text.charAt(offset + 1) == '\n') {
                    ++offset;
                }
            }
            ++offset;
        }
        return offset + col;
    }

    @Contract(pure=true)
    public static int offsetToLineNumber(@NotNull CharSequence text, int offset) {
        LineColumn lineColumn;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(47);
        }
        return (lineColumn = StringUtil.offsetToLineColumn(text, offset)) != null ? lineColumn.line : -1;
    }

    @Contract(pure=true)
    public static LineColumn offsetToLineColumn(@NotNull CharSequence text, int offset) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(48);
        }
        int curLine = 0;
        int curLineStart = 0;
        for (int curOffset = 0; curOffset < offset; ++curOffset) {
            if (curOffset == text.length()) {
                return null;
            }
            char c = text.charAt(curOffset);
            if (c == '\n') {
                ++curLine;
                curLineStart = curOffset + 1;
                continue;
            }
            if (c != '\r') continue;
            ++curLine;
            if (curOffset < text.length() - 1 && text.charAt(curOffset + 1) == '\n') {
                ++curOffset;
            }
            curLineStart = curOffset + 1;
        }
        return LineColumn.of(curLine, offset - curLineStart);
    }

    @Contract(pure=true)
    public static int difference(@NotNull String s1, @NotNull String s2) {
        int i;
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(49);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(50);
        }
        int[][] a = new int[s1.length()][s2.length()];
        for (i = 0; i < s1.length(); ++i) {
            a[i][0] = i;
        }
        for (int j = 0; j < s2.length(); ++j) {
            a[0][j] = j;
        }
        for (i = 1; i < s1.length(); ++i) {
            for (int j = 1; j < s2.length(); ++j) {
                a[i][j] = Math.min(Math.min(a[i - 1][j - 1] + (s1.charAt(i) == s2.charAt(j) ? 0 : 1), a[i - 1][j] + 1), a[i][j - 1] + 1);
            }
        }
        return a[s1.length() - 1][s2.length() - 1];
    }

    @NotNull
    @Contract(pure=true)
    public static String wordsToBeginFromUpperCase(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(51);
        }
        String string = StringUtil.fixCapitalization(s, ourPrepositions, true);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(52);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String wordsToBeginFromLowerCase(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(53);
        }
        String string = StringUtil.fixCapitalization(s, ourPrepositions, false);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(54);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String toTitleCase(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(55);
        }
        String string = StringUtil.fixCapitalization(s, ArrayUtil.EMPTY_STRING_ARRAY, true);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(56);
        }
        return string;
    }

    @NotNull
    private static String fixCapitalization(@NotNull String s, @NotNull String[] prepositions, boolean title) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(57);
        }
        if (prepositions == null) {
            StringUtil.$$$reportNull$$$0(58);
        }
        StringBuilder buffer = null;
        for (int i = 0; i < s.length(); ++i) {
            int j;
            char prevChar = i == 0 ? (char)' ' : (char)s.charAt(i - 1);
            char currChar = s.charAt(i);
            if (Character.isLetterOrDigit(prevChar) || prevChar == 39 || !Character.isLetterOrDigit(currChar) || !title && !Character.isUpperCase(currChar)) continue;
            for (j = i; j < s.length() && Character.isLetterOrDigit(s.charAt(j)); ++j) {
            }
            if (!title && j > i + 1 && !Character.isLowerCase(s.charAt(i + 1)) || StringUtil.isPreposition(s, i, j - 1, prepositions)) continue;
            if (buffer == null) {
                buffer = new StringBuilder(s);
            }
            buffer.setCharAt(i, title ? StringUtil.toUpperCase(currChar) : StringUtil.toLowerCase(currChar));
        }
        String string = buffer == null ? s : buffer.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(59);
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean isPreposition(@NotNull String s, int firstChar, int lastChar) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(60);
        }
        return StringUtil.isPreposition(s, firstChar, lastChar, ourPrepositions);
    }

    @Contract(pure=true)
    public static boolean isPreposition(@NotNull String s, int firstChar, int lastChar, @NotNull String[] prepositions) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(61);
        }
        if (prepositions == null) {
            StringUtil.$$$reportNull$$$0(62);
        }
        for (String preposition : prepositions) {
            boolean found = false;
            if (lastChar - firstChar + 1 == preposition.length()) {
                found = true;
                for (int j = 0; j < preposition.length(); ++j) {
                    if (StringUtil.toLowerCase(s.charAt(firstChar + j)) == preposition.charAt(j)) continue;
                    found = false;
                }
            }
            if (!found) continue;
            return true;
        }
        return false;
    }

    @NotNull
    @Contract(pure=true)
    public static NotNullFunction<String, String> escaper(boolean escapeSlash, @Nullable String additionalChars) {
        NotNullFunction<String, String> notNullFunction = dom -> {
            StringBuilder builder = new StringBuilder(dom.length());
            StringUtil.escapeStringCharacters(dom.length(), dom, additionalChars, escapeSlash, builder);
            return builder.toString();
        };
        if (notNullFunction == null) {
            StringUtil.$$$reportNull$$$0(63);
        }
        return notNullFunction;
    }

    public static void escapeStringCharacters(int length, @NotNull String str, @NotNull StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(64);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(65);
        }
        StringUtil.escapeStringCharacters(length, str, "\"", buffer);
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, @NotNull StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(66);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(67);
        }
        StringBuilder stringBuilder = StringUtil.escapeStringCharacters(length, str, additionalChars, true, buffer);
        if (stringBuilder == null) {
            StringUtil.$$$reportNull$$$0(68);
        }
        return stringBuilder;
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, boolean escapeSlash, @NotNull StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(69);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(70);
        }
        StringBuilder stringBuilder = StringUtil.escapeStringCharacters(length, str, additionalChars, escapeSlash, true, buffer);
        if (stringBuilder == null) {
            StringUtil.$$$reportNull$$$0(71);
        }
        return stringBuilder;
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, boolean escapeSlash, boolean escapeUnicode, @NotNull StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(72);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(73);
        }
        char prev = '\u0000';
        for (int idx = 0; idx < length; ++idx) {
            char ch = str.charAt(idx);
            switch (ch) {
                case '\b': {
                    buffer.append("\\b");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                default: {
                    if (escapeSlash && ch == '\\') {
                        buffer.append("\\\\");
                        break;
                    }
                    if (additionalChars != null && additionalChars.indexOf(ch) > -1 && (escapeSlash || prev != '\\')) {
                        buffer.append("\\").append(ch);
                        break;
                    }
                    if (escapeUnicode && !StringUtil.isPrintableUnicode(ch)) {
                        CharSequence hexCode = StringUtilRt.toUpperCase(Integer.toHexString(ch));
                        buffer.append("\\u");
                        int paddingCount = 4 - hexCode.length();
                        while (paddingCount-- > 0) {
                            buffer.append(0);
                        }
                        buffer.append(hexCode);
                        break;
                    }
                    buffer.append(ch);
                }
            }
            prev = ch;
        }
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            StringUtil.$$$reportNull$$$0(74);
        }
        return stringBuilder;
    }

    @Contract(pure=true)
    public static boolean isPrintableUnicode(char c) {
        int t = Character.getType(c);
        return t != 0 && t != 13 && t != 14 && t != 15 && t != 16 && t != 18 && t != 19;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeStringCharacters(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(75);
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.escapeStringCharacters(s.length(), s, "\"", buffer);
        String string = buffer.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(76);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeCharCharacters(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(77);
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.escapeStringCharacters(s.length(), s, "'", buffer);
        String string = buffer.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(78);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String unescapeStringCharacters(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(79);
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.unescapeStringCharacters(s.length(), s, buffer);
        String string = buffer.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(80);
        }
        return string;
    }

    private static boolean isQuoteAt(@NotNull String s, int ind) {
        char ch;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(81);
        }
        return (ch = s.charAt(ind)) == '\'' || ch == '\"';
    }

    @Contract(pure=true)
    public static boolean isQuotedString(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(82);
        }
        return StringUtilRt.isQuotedString(s);
    }

    @NotNull
    @Contract(pure=true)
    public static String unquoteString(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(83);
        }
        String string = StringUtilRt.unquoteString(s);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(84);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String unquoteString(@NotNull String s, char quotationChar) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(85);
        }
        String string = StringUtilRt.unquoteString(s, quotationChar);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(86);
        }
        return string;
    }

    private static void unescapeStringCharacters(int length, @NotNull String s, @NotNull StringBuilder buffer) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(87);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(88);
        }
        boolean escaped = false;
        for (int idx = 0; idx < length; ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            int octalEscapeMaxLength = 2;
            switch (ch) {
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 'b': {
                    buffer.append('\b');
                    break;
                }
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                case '\'': {
                    buffer.append('\'');
                    break;
                }
                case '\"': {
                    buffer.append('\"');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    break;
                }
                case 'u': {
                    if (idx + 4 < length) {
                        try {
                            int code = Integer.parseInt(s.substring(idx + 1, idx + 5), 16);
                            idx += 4;
                            buffer.append((char)code);
                        }
                        catch (NumberFormatException e) {
                            buffer.append("\\u");
                        }
                        break;
                    }
                    buffer.append("\\u");
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': {
                    octalEscapeMaxLength = 3;
                }
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    int escapeEnd;
                    for (escapeEnd = idx + 1; escapeEnd < length && escapeEnd < idx + octalEscapeMaxLength && StringUtil.isOctalDigit(s.charAt(escapeEnd)); ++escapeEnd) {
                    }
                    try {
                        buffer.append((char)Integer.parseInt(s.substring(idx, escapeEnd), 8));
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Couldn't parse " + s.substring(idx, escapeEnd), e);
                    }
                    idx = escapeEnd - 1;
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            escaped = false;
        }
        if (escaped) {
            buffer.append('\\');
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String pluralize(@NotNull String word) {
        String plural;
        if (word == null) {
            StringUtil.$$$reportNull$$$0(89);
        }
        if ((plural = Pluralizer.PLURALIZER.plural(word)) != null) {
            String string = plural;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(90);
            }
            return string;
        }
        if (word.endsWith("s")) {
            String string = Pluralizer.restoreCase(word, word + "es");
            if (string == null) {
                StringUtil.$$$reportNull$$$0(91);
            }
            return string;
        }
        String string = Pluralizer.restoreCase(word, word + "s");
        if (string == null) {
            StringUtil.$$$reportNull$$$0(92);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalizeWords(@NotNull String text, boolean allWords) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(93);
        }
        String string = StringUtil.capitalizeWords(text, " \t\n\r\f", allWords, false);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(94);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalizeWords(@NotNull String text, @NotNull String tokenizerDelim, boolean allWords, boolean leaveOriginalDelims) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(95);
        }
        if (tokenizerDelim == null) {
            StringUtil.$$$reportNull$$$0(96);
        }
        java.util.StringTokenizer tokenizer = new java.util.StringTokenizer(text, tokenizerDelim, leaveOriginalDelims);
        StringBuilder out = new StringBuilder(text.length());
        boolean toCapitalize = true;
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            if (!leaveOriginalDelims && out.length() > 0) {
                out.append(' ');
            }
            out.append(toCapitalize ? StringUtil.capitalize(word) : word);
            if (allWords) continue;
            toCapitalize = false;
        }
        String string = out.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(97);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String decapitalize(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(98);
        }
        String string = Introspector.decapitalize(s);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(99);
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean isVowel(char c) {
        return VOWELS.indexOf(c) >= 0;
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalize(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(100);
        }
        if (s.isEmpty()) {
            String string = s;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(101);
            }
            return string;
        }
        if (s.length() == 1) {
            String string = StringUtilRt.toUpperCase(s).toString();
            if (string == null) {
                StringUtil.$$$reportNull$$$0(102);
            }
            return string;
        }
        if (Character.isUpperCase(s.charAt(0))) {
            String string = s;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(103);
            }
            return string;
        }
        String string = StringUtil.toUpperCase(s.charAt(0)) + s.substring(1);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(104);
        }
        return string;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isCapitalized(@Nullable String s) {
        return s != null && !s.isEmpty() && Character.isUpperCase(s.charAt(0));
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalizeWithJavaBeanConvention(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(105);
        }
        if (s.length() > 1 && Character.isUpperCase(s.charAt(1))) {
            String string = s;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(106);
            }
            return string;
        }
        String string = StringUtil.capitalize(s);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(107);
        }
        return string;
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(108);
        }
        if (chars instanceof String || chars instanceof CharSequenceWithStringHash) {
            return chars.hashCode();
        }
        return StringUtil.stringHashCode(chars, 0, chars.length());
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars, int from, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(109);
        }
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + chars.charAt(off);
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCode(char[] chars, int from, int to) {
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + chars[off];
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull char[] chars, int from, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(110);
        }
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + StringUtil.toLowerCase(chars[off]);
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars, int from, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(111);
        }
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + StringUtil.toLowerCase(chars.charAt(off));
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(112);
        }
        return StringUtil.stringHashCodeInsensitive(chars, 0, chars.length());
    }

    @Contract(pure=true)
    public static int stringHashCodeIgnoreWhitespaces(@NotNull char[] chars, int from, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(113);
        }
        int h = 0;
        for (int off = from; off < to; ++off) {
            char c = chars[off];
            if (StringUtil.isWhiteSpace(c)) continue;
            h = 31 * h + c;
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeIgnoreWhitespaces(@NotNull CharSequence chars, int from, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(114);
        }
        int h = 0;
        for (int off = from; off < to; ++off) {
            char c = chars.charAt(off);
            if (StringUtil.isWhiteSpace(c)) continue;
            h = 31 * h + c;
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeIgnoreWhitespaces(@NotNull CharSequence chars) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(115);
        }
        return StringUtil.stringHashCodeIgnoreWhitespaces(chars, 0, chars.length());
    }

    @Contract(pure=true)
    public static boolean startsWithConcatenation(@NotNull String string, String ... prefixes) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(116);
        }
        if (prefixes == null) {
            StringUtil.$$$reportNull$$$0(117);
        }
        int offset = 0;
        for (String prefix : prefixes) {
            int prefixLen = prefix.length();
            if (!string.regionMatches(offset, prefix, 0, prefixLen)) {
                return false;
            }
            offset += prefixLen;
        }
        return true;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String trim(@Nullable String s) {
        return s == null ? null : s.trim();
    }

    @NotNull
    @Contract(pure=true)
    public static String trimEnd(@NotNull String s, @NotNull String suffix) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(118);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(119);
        }
        String string = StringUtil.trimEnd(s, suffix, false);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(120);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimEnd(@NotNull String s, @NotNull String suffix, boolean ignoreCase) {
        boolean endsWith;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(121);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(122);
        }
        boolean bl = endsWith = ignoreCase ? StringUtil.endsWithIgnoreCase(s, suffix) : s.endsWith(suffix);
        if (endsWith) {
            String string = s.substring(0, s.length() - suffix.length());
            if (string == null) {
                StringUtil.$$$reportNull$$$0(123);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(124);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimEnd(@NotNull String s, char suffix) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(125);
        }
        if (StringUtil.endsWithChar(s, suffix)) {
            String string = s.substring(0, s.length() - 1);
            if (string == null) {
                StringUtil.$$$reportNull$$$0(126);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(127);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimLog(@NotNull String text, int limit) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(128);
        }
        if (limit > 5 && text.length() > limit) {
            String string = text.substring(0, limit - 5) + " ...\n";
            if (string == null) {
                StringUtil.$$$reportNull$$$0(129);
            }
            return string;
        }
        String string = text;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(130);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimLeading(@NotNull String string) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(131);
        }
        String string2 = StringUtil.trimLeading((CharSequence)string).toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(132);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence trimLeading(@NotNull CharSequence string) {
        int index;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(133);
        }
        for (index = 0; index < string.length() && Character.isWhitespace(string.charAt(index)); ++index) {
        }
        CharSequence charSequence = string.subSequence(index, string.length());
        if (charSequence == null) {
            StringUtil.$$$reportNull$$$0(134);
        }
        return charSequence;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimLeading(@NotNull String string, char symbol) {
        int index;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(135);
        }
        for (index = 0; index < string.length() && string.charAt(index) == symbol; ++index) {
        }
        String string2 = string.substring(index);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(136);
        }
        return string2;
    }

    @NotNull
    public static StringBuilder trimLeading(@NotNull StringBuilder builder, char symbol) {
        int index;
        if (builder == null) {
            StringUtil.$$$reportNull$$$0(137);
        }
        for (index = 0; index < builder.length() && builder.charAt(index) == symbol; ++index) {
        }
        if (index > 0) {
            builder.delete(0, index);
        }
        StringBuilder stringBuilder = builder;
        if (stringBuilder == null) {
            StringUtil.$$$reportNull$$$0(138);
        }
        return stringBuilder;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimTrailing(@NotNull String string) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(139);
        }
        String string2 = StringUtil.trimTrailing((CharSequence)string).toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(140);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence trimTrailing(@NotNull CharSequence string) {
        int index;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(141);
        }
        for (index = string.length() - 1; index >= 0 && Character.isWhitespace(string.charAt(index)); --index) {
        }
        CharSequence charSequence = string.subSequence(0, index + 1);
        if (charSequence == null) {
            StringUtil.$$$reportNull$$$0(142);
        }
        return charSequence;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimTrailing(@NotNull String string, char symbol) {
        int index;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(143);
        }
        for (index = string.length() - 1; index >= 0 && string.charAt(index) == symbol; --index) {
        }
        String string2 = string.substring(0, index + 1);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(144);
        }
        return string2;
    }

    @NotNull
    public static StringBuilder trimTrailing(@NotNull StringBuilder builder, char symbol) {
        int index;
        if (builder == null) {
            StringUtil.$$$reportNull$$$0(145);
        }
        for (index = builder.length() - 1; index >= 0 && builder.charAt(index) == symbol; --index) {
        }
        builder.setLength(index + 1);
        StringBuilder stringBuilder = builder;
        if (stringBuilder == null) {
            StringUtil.$$$reportNull$$$0(146);
        }
        return stringBuilder;
    }

    @Contract(pure=true)
    public static boolean startsWithChar(@Nullable CharSequence s, char prefix) {
        return s != null && s.length() != 0 && s.charAt(0) == prefix;
    }

    @Contract(pure=true)
    public static boolean endsWithChar(@Nullable CharSequence s, char suffix) {
        return StringUtilRt.endsWithChar(s, suffix);
    }

    @NotNull
    @Contract(pure=true)
    public static String trimStart(@NotNull String s, @NotNull String prefix) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(147);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(148);
        }
        if (s.startsWith(prefix)) {
            String string = s.substring(prefix.length());
            if (string == null) {
                StringUtil.$$$reportNull$$$0(149);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(150);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimExtensions(@NotNull String name) {
        int index;
        if (name == null) {
            StringUtil.$$$reportNull$$$0(151);
        }
        String string = (index = name.indexOf(46)) < 0 ? name : name.substring(0, index);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(152);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String pluralize(@NotNull String base, int count) {
        if (base == null) {
            StringUtil.$$$reportNull$$$0(153);
        }
        if (count == 1) {
            String string = base;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(154);
            }
            return string;
        }
        String string = StringUtil.pluralize(base);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(155);
        }
        return string;
    }

    public static void repeatSymbol(@NotNull Appendable buffer, char symbol, int times) {
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(156);
        }
        assert (times >= 0) : times;
        try {
            for (int i = 0; i < times; ++i) {
                buffer.append(symbol);
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    @Contract(pure=true)
    public static String defaultIfEmpty(@Nullable String value, String defaultValue) {
        return StringUtil.isEmpty(value) ? defaultValue : value;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isNotEmpty(@Nullable String s) {
        return !StringUtil.isEmpty(s);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable String s) {
        return s == null || s.isEmpty();
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable CharSequence cs) {
        return StringUtilRt.isEmpty(cs);
    }

    @Contract(pure=true)
    public static int length(@Nullable CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    @NotNull
    @Contract(pure=true)
    public static String notNullize(@Nullable String s) {
        String string = StringUtilRt.notNullize(s);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(157);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String notNullize(@Nullable String s, @NotNull String defaultValue) {
        if (defaultValue == null) {
            StringUtil.$$$reportNull$$$0(158);
        }
        String string = StringUtilRt.notNullize(s, defaultValue);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(159);
        }
        return string;
    }

    @Nullable
    @Contract(pure=true)
    public static String nullize(@Nullable String s) {
        return StringUtil.nullize(s, false);
    }

    @Nullable
    @Contract(pure=true)
    public static String nullize(@Nullable String s, @Nullable String defaultValue) {
        boolean empty = StringUtil.isEmpty(s) || Comparing.equal(s, defaultValue);
        return empty ? null : s;
    }

    @Nullable
    @Contract(pure=true)
    public static String nullize(@Nullable String s, boolean nullizeSpaces) {
        boolean empty = nullizeSpaces ? StringUtil.isEmptyOrSpaces(s) : StringUtil.isEmpty(s);
        return empty ? null : s;
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable String s) {
        return StringUtil.isEmptyOrSpaces((CharSequence)s);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable CharSequence s) {
        return StringUtilRt.isEmptyOrSpaces(s);
    }

    @Contract(pure=true)
    public static boolean isWhiteSpace(char c) {
        return c == '\n' || c == '\t' || c == ' ';
    }

    @NotNull
    @Contract(pure=true)
    public static String getThrowableText(@NotNull Throwable aThrowable) {
        if (aThrowable == null) {
            StringUtil.$$$reportNull$$$0(160);
        }
        String string = ExceptionUtil.getThrowableText(aThrowable);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(161);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String getThrowableText(@NotNull Throwable aThrowable, @NotNull String stackFrameSkipPattern) {
        if (aThrowable == null) {
            StringUtil.$$$reportNull$$$0(162);
        }
        if (stackFrameSkipPattern == null) {
            StringUtil.$$$reportNull$$$0(163);
        }
        String string = ExceptionUtil.getThrowableText(aThrowable, stackFrameSkipPattern);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(164);
        }
        return string;
    }

    @Nullable
    @Contract(pure=true)
    public static String getMessage(@NotNull Throwable e) {
        if (e == null) {
            StringUtil.$$$reportNull$$$0(165);
        }
        return ExceptionUtil.getMessage(e);
    }

    @NotNull
    @Contract(pure=true)
    public static String repeatSymbol(char aChar, int count) {
        char[] buffer = new char[count];
        Arrays.fill(buffer, aChar);
        String string = StringFactory.createShared(buffer);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(166);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String repeat(@NotNull String s, int count) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(167);
        }
        if (count == 0) {
            if ("" == null) {
                StringUtil.$$$reportNull$$$0(168);
            }
            return "";
        }
        assert (count >= 0) : count;
        StringBuilder sb = new StringBuilder(s.length() * count);
        for (int i = 0; i < count; ++i) {
            sb.append(s);
        }
        String string = sb.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(169);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> splitHonorQuotes(@NotNull String s, char separator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(170);
        }
        List<String> list = StringUtilRt.splitHonorQuotes(s, separator);
        if (list == null) {
            StringUtil.$$$reportNull$$$0(171);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> split(@NotNull String s, @NotNull String separator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(172);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(173);
        }
        List<String> list = StringUtil.split(s, separator, true);
        if (list == null) {
            StringUtil.$$$reportNull$$$0(174);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static List<CharSequence> split(@NotNull CharSequence s, @NotNull CharSequence separator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(175);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(176);
        }
        List<CharSequence> list = StringUtil.split(s, separator, true, true);
        if (list == null) {
            StringUtil.$$$reportNull$$$0(177);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> split(@NotNull String s, @NotNull String separator, boolean excludeSeparator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(178);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(179);
        }
        List<String> list = StringUtil.split(s, separator, excludeSeparator, true);
        if (list == null) {
            StringUtil.$$$reportNull$$$0(180);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> split(@NotNull String s, @NotNull String separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(181);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(182);
        }
        List<CharSequence> list = StringUtil.split((CharSequence)s, (CharSequence)separator, excludeSeparator, excludeEmptyStrings);
        if (list == null) {
            StringUtil.$$$reportNull$$$0(183);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static List<CharSequence> split(@NotNull CharSequence s, @NotNull CharSequence separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        int index;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(184);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(185);
        }
        if (separator.length() == 0) {
            List<CharSequence> list = Collections.singletonList(s);
            if (list == null) {
                StringUtil.$$$reportNull$$$0(186);
            }
            return list;
        }
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        int pos = 0;
        while ((index = StringUtil.indexOf(s, separator, pos)) != -1) {
            int nextPos = index + separator.length();
            CharSequence token = s.subSequence(pos, excludeSeparator ? index : nextPos);
            if (token.length() != 0 || !excludeEmptyStrings) {
                result.add(token);
            }
            pos = nextPos;
        }
        if (pos < s.length() || !excludeEmptyStrings && pos == s.length()) {
            result.add(s.subSequence(pos, s.length()));
        }
        ArrayList<CharSequence> arrayList = result;
        if (arrayList == null) {
            StringUtil.$$$reportNull$$$0(187);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static Iterable<String> tokenize(@NotNull String s, @NotNull String separators) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(188);
        }
        if (separators == null) {
            StringUtil.$$$reportNull$$$0(189);
        }
        final StringTokenizer tokenizer = new StringTokenizer(s, separators);
        Iterable<String> iterable = new Iterable<String>(){

            @Override
            @NotNull
            public Iterator<String> iterator() {
                Iterator<String> iterator = new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return tokenizer.hasMoreTokens();
                    }

                    @Override
                    public String next() {
                        return tokenizer.nextToken();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
                if (iterator == null) {
                    1.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil$1", "iterator"));
            }
        };
        if (iterable == null) {
            StringUtil.$$$reportNull$$$0(190);
        }
        return iterable;
    }

    @NotNull
    @Contract(pure=true)
    public static Iterable<String> tokenize(final @NotNull java.util.StringTokenizer tokenizer) {
        if (tokenizer == null) {
            StringUtil.$$$reportNull$$$0(191);
        }
        Iterable<String> iterable = new Iterable<String>(){

            @Override
            @NotNull
            public Iterator<String> iterator() {
                Iterator<String> iterator = new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return tokenizer.hasMoreTokens();
                    }

                    @Override
                    public String next() {
                        return tokenizer.nextToken();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
                if (iterator == null) {
                    2.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil$2", "iterator"));
            }
        };
        if (iterable == null) {
            StringUtil.$$$reportNull$$$0(192);
        }
        return iterable;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> getWordsIn(@NotNull String text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(193);
        }
        SmartList<String> result = null;
        int start = -1;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            boolean isIdentifierPart = Character.isJavaIdentifierPart(c);
            if (isIdentifierPart && start == -1) {
                start = i;
            }
            if (isIdentifierPart && i == text.length() - 1) {
                if (result == null) {
                    result = new SmartList();
                }
                result.add(text.substring(start, i + 1));
                continue;
            }
            if (isIdentifierPart || start == -1) continue;
            if (result == null) {
                result = new SmartList<String>();
            }
            result.add(text.substring(start, i));
            start = -1;
        }
        if (result == null) {
            List<String> list = ContainerUtil.emptyList();
            if (list == null) {
                StringUtil.$$$reportNull$$$0(194);
            }
            return list;
        }
        SmartList<String> smartList = result;
        if (smartList == null) {
            StringUtil.$$$reportNull$$$0(195);
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static List<TextRange> getWordIndicesIn(@NotNull String text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(196);
        }
        List<TextRange> list = StringUtil.getWordIndicesIn(text, null);
        if (list == null) {
            StringUtil.$$$reportNull$$$0(197);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static List<TextRange> getWordIndicesIn(@NotNull String text, @Nullable Set<Character> separatorsSet) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(198);
        }
        SmartList<TextRange> result = new SmartList<TextRange>();
        int start = -1;
        for (int i = 0; i < text.length(); ++i) {
            boolean isIdentifierPart;
            char c = text.charAt(i);
            boolean bl = separatorsSet == null ? Character.isJavaIdentifierPart(c) : (isIdentifierPart = !separatorsSet.contains(Character.valueOf(c)));
            if (isIdentifierPart && start == -1) {
                start = i;
            }
            if (isIdentifierPart && i == text.length() - 1) {
                result.add(new TextRange(start, i + 1));
                continue;
            }
            if (isIdentifierPart || start == -1) continue;
            result.add(new TextRange(start, i));
            start = -1;
        }
        SmartList<TextRange> smartList = result;
        if (smartList == null) {
            StringUtil.$$$reportNull$$$0(199);
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static String join(@NotNull String[] strings, @NotNull String separator) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(200);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(201);
        }
        String string = StringUtil.join(strings, 0, strings.length, separator);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(202);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String join(@NotNull String[] strings, int startIndex, int endIndex, @NotNull String separator) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(203);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(204);
        }
        StringBuilder result = new StringBuilder();
        for (int i = startIndex; i < endIndex; ++i) {
            if (i > startIndex) {
                result.append(separator);
            }
            result.append(strings[i]);
        }
        String string = result.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(205);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] zip(@NotNull String[] strings1, @NotNull String[] strings2, String separator) {
        if (strings1 == null) {
            StringUtil.$$$reportNull$$$0(206);
        }
        if (strings2 == null) {
            StringUtil.$$$reportNull$$$0(207);
        }
        if (strings1.length != strings2.length) {
            throw new IllegalArgumentException();
        }
        String[] result = ArrayUtil.newStringArray(strings1.length);
        for (int i = 0; i < result.length; ++i) {
            result[i] = strings1[i] + separator + strings2[i];
        }
        if (result == null) {
            StringUtil.$$$reportNull$$$0(208);
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] surround(@NotNull String[] strings, @NotNull String prefix, @NotNull String suffix) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(209);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(210);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(211);
        }
        String[] result = ArrayUtil.newStringArray(strings.length);
        for (int i = 0; i < result.length; ++i) {
            result[i] = prefix + strings[i] + suffix;
        }
        if (result == null) {
            StringUtil.$$$reportNull$$$0(212);
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> String join(@NotNull T[] items, @NotNull Function<? super T, String> f, @NotNull String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(213);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(214);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(215);
        }
        String string = StringUtil.join(Arrays.asList(items), f, separator);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(216);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> String join(@NotNull Collection<? extends T> items, @NotNull Function<? super T, String> f, @NotNull String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(217);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(218);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(219);
        }
        if (items.isEmpty()) {
            if ("" == null) {
                StringUtil.$$$reportNull$$$0(220);
            }
            return "";
        }
        if (items.size() == 1) {
            String string = StringUtil.notNullize(f.fun(items.iterator().next()));
            if (string == null) {
                StringUtil.$$$reportNull$$$0(221);
            }
            return string;
        }
        String string = StringUtil.join(items, f, separator);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(222);
        }
        return string;
    }

    @Contract(pure=true)
    public static String join(@NotNull Iterable<?> items, @NotNull String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(223);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(224);
        }
        StringBuilder result = new StringBuilder();
        for (Object item : items) {
            result.append(item).append(separator);
        }
        if (result.length() > 0) {
            result.setLength(result.length() - separator.length());
        }
        return result.toString();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> String join(@NotNull Iterable<? extends T> items, @NotNull Function<? super T, String> f, @NotNull String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(225);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(226);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(227);
        }
        StringBuilder result = new StringBuilder();
        StringUtil.join(items, f, separator, result);
        String string = result.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(228);
        }
        return string;
    }

    public static <T> void join(@NotNull Iterable<? extends T> items, @NotNull Function<? super T, String> f, @NotNull String separator, @NotNull StringBuilder result) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(229);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(230);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(231);
        }
        if (result == null) {
            StringUtil.$$$reportNull$$$0(232);
        }
        boolean isFirst = true;
        for (T item : items) {
            String string = f.fun(item);
            if (StringUtil.isEmpty(string)) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                result.append(separator);
            }
            result.append(string);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String join(@NotNull Collection<String> strings, @NotNull String separator) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(233);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(234);
        }
        if (strings.size() <= 1) {
            String string = StringUtil.notNullize(ContainerUtil.getFirstItem(strings));
            if (string == null) {
                StringUtil.$$$reportNull$$$0(235);
            }
            return string;
        }
        StringBuilder result = new StringBuilder();
        StringUtil.join(strings, separator, result);
        String string = result.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(236);
        }
        return string;
    }

    public static void join(@NotNull Collection<String> strings, @NotNull String separator, @NotNull StringBuilder result) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(237);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(238);
        }
        if (result == null) {
            StringUtil.$$$reportNull$$$0(239);
        }
        boolean isFirst = true;
        for (String string : strings) {
            if (string == null) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                result.append(separator);
            }
            result.append(string);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String join(@NotNull int[] strings, @NotNull String separator) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(240);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(241);
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                result.append(separator);
            }
            result.append(strings[i]);
        }
        String string = result.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(242);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String join(String ... strings) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(243);
        }
        if (strings.length == 0) {
            if ("" == null) {
                StringUtil.$$$reportNull$$$0(244);
            }
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String string : strings) {
            builder.append(string);
        }
        String string = builder.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(245);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String stripQuotesAroundValue(@NotNull String text) {
        int len;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(246);
        }
        if ((len = text.length()) > 0) {
            int to;
            int from = StringUtil.isQuoteAt(text, 0) ? 1 : 0;
            int n = to = len > 1 && StringUtil.isQuoteAt(text, len - 1) ? len - 1 : len;
            if (from > 0 || to < len) {
                String string = text.substring(from, to);
                if (string == null) {
                    StringUtil.$$$reportNull$$$0(247);
                }
                return string;
            }
        }
        String string = text;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(248);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String formatFileSize(long fileSize) {
        String string = StringUtilRt.formatFileSize(fileSize);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(249);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    @Contract(pure=true)
    public static String formatFileSize(long fileSize, @NotNull String string) {
        void unitSeparator;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(250);
        }
        String string2 = StringUtilRt.formatFileSize(fileSize, (String)unitSeparator);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(251);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static String formatDuration(long duration) {
        String string = StringUtil.formatDuration(duration, " ");
        if (string == null) {
            StringUtil.$$$reportNull$$$0(252);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    @Contract(pure=true)
    public static String formatDuration(long duration, @NotNull String string) {
        void unitSeparator;
        long multiplier;
        int i;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(253);
        }
        String[] units = TIME_UNITS;
        StringBuilder sb = new StringBuilder();
        long count = duration;
        for (i = 1; i < units.length && count > 0L && count >= (multiplier = TIME_MULTIPLIERS[i]); ++i) {
            long remainder = count % multiplier;
            count /= multiplier;
            if (remainder != 0L || sb.length() > 0) {
                if (!units[i - 1].isEmpty()) {
                    sb.insert(0, units[i - 1]);
                    sb.insert(0, (String)unitSeparator);
                }
                sb.insert(0, remainder).insert(0, " ");
                continue;
            }
            remainder = Math.round((double)(remainder * 100L) / (double)multiplier);
            count += remainder / 100L;
        }
        if (!units[i - 1].isEmpty()) {
            sb.insert(0, units[i - 1]);
            sb.insert(0, (String)unitSeparator);
        }
        sb.insert(0, count);
        String string2 = sb.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(254);
        }
        return string2;
    }

    public static String formatOrdinal(long num) {
        return OrdinalFormat.formatEnglish(num);
    }

    @Nullable
    @Contract(pure=true)
    public static String unpluralize(@NotNull String word) {
        String singular;
        if (word == null) {
            StringUtil.$$$reportNull$$$0(255);
        }
        if ((singular = Pluralizer.PLURALIZER.singular(word)) != null) {
            return singular;
        }
        if (word.endsWith("es")) {
            return StringUtil.nullize(StringUtil.trimEnd(word, "es", true));
        }
        if (word.endsWith("s")) {
            return StringUtil.nullize(StringUtil.trimEnd(word, "s", true));
        }
        return null;
    }

    @Contract(pure=true)
    public static boolean containsAlphaCharacters(@NotNull String value) {
        if (value == null) {
            StringUtil.$$$reportNull$$$0(256);
        }
        for (int i = 0; i < value.length(); ++i) {
            if (!Character.isLetter(value.charAt(i))) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean containsAnyChar(@NotNull String value, @NotNull String chars) {
        if (value == null) {
            StringUtil.$$$reportNull$$$0(257);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(258);
        }
        return chars.length() > value.length() ? StringUtil.containsAnyChar(value, chars, 0, value.length()) : StringUtil.containsAnyChar(chars, value, 0, chars.length());
    }

    @Contract(pure=true)
    public static boolean containsAnyChar(@NotNull String value, @NotNull String chars, int start, int end) {
        if (value == null) {
            StringUtil.$$$reportNull$$$0(259);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(260);
        }
        for (int i = start; i < end; ++i) {
            if (chars.indexOf(value.charAt(i)) < 0) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean containsChar(@NotNull String value, char ch) {
        if (value == null) {
            StringUtil.$$$reportNull$$$0(261);
        }
        return value.indexOf(ch) >= 0;
    }

    @Deprecated
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String firstLetterToUpperCase(@Nullable String displayString) {
        if (displayString == null || displayString.isEmpty()) {
            return displayString;
        }
        char firstChar = displayString.charAt(0);
        char uppedFirstChar = StringUtil.toUpperCase(firstChar);
        if (uppedFirstChar == firstChar) {
            return displayString;
        }
        char[] buffer = displayString.toCharArray();
        buffer[0] = uppedFirstChar;
        return StringFactory.createShared(buffer);
    }

    @NotNull
    @Contract(pure=true)
    public static String strip(@NotNull String s, @NotNull CharFilter filter) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(262);
        }
        if (filter == null) {
            StringUtil.$$$reportNull$$$0(263);
        }
        StringBuilder result = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!filter.accept(ch)) continue;
            result.append(ch);
        }
        String string = result.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(264);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> findMatches(@NotNull String s, @NotNull Pattern pattern) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(265);
        }
        if (pattern == null) {
            StringUtil.$$$reportNull$$$0(266);
        }
        List<String> list = StringUtil.findMatches(s, pattern, 1);
        if (list == null) {
            StringUtil.$$$reportNull$$$0(267);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> findMatches(@NotNull String s, @NotNull Pattern pattern, int groupIndex) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(268);
        }
        if (pattern == null) {
            StringUtil.$$$reportNull$$$0(269);
        }
        SmartList<String> result = new SmartList<String>();
        Matcher m = pattern.matcher(s);
        while (m.find()) {
            String group = m.group(groupIndex);
            if (group == null) continue;
            result.add(group);
        }
        SmartList<String> smartList = result;
        if (smartList == null) {
            StringUtil.$$$reportNull$$$0(270);
        }
        return smartList;
    }

    @Contract(pure=true)
    public static int findFirst(@NotNull CharSequence s, @NotNull CharFilter filter) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(271);
        }
        if (filter == null) {
            StringUtil.$$$reportNull$$$0(272);
        }
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!filter.accept(ch)) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    @Contract(pure=true)
    public static String replaceSubstring(@NotNull String string, @NotNull TextRange range, @NotNull String replacement) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(273);
        }
        if (range == null) {
            StringUtil.$$$reportNull$$$0(274);
        }
        if (replacement == null) {
            StringUtil.$$$reportNull$$$0(275);
        }
        String string2 = range.replace(string, replacement);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(276);
        }
        return string2;
    }

    @Contract(pure=true)
    public static boolean startsWithWhitespace(@NotNull String text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(277);
        }
        return !text.isEmpty() && Character.isWhitespace(text.charAt(0));
    }

    @Contract(pure=true)
    public static boolean isChar(CharSequence seq, int index, char c) {
        return index >= 0 && index < seq.length() && seq.charAt(index) == c;
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull CharSequence text, @NotNull CharSequence prefix) {
        int l2;
        int l1;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(278);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(279);
        }
        if ((l1 = text.length()) < (l2 = prefix.length())) {
            return false;
        }
        for (int i = 0; i < l2; ++i) {
            if (text.charAt(i) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull CharSequence text, int startIndex, @NotNull CharSequence prefix) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(280);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(281);
        }
        int tl = text.length();
        if (startIndex < 0 || startIndex > tl) {
            throw new IllegalArgumentException("Index is out of bounds: " + startIndex + ", length: " + tl);
        }
        int l1 = tl - startIndex;
        int l2 = prefix.length();
        if (l1 < l2) {
            return false;
        }
        for (int i = 0; i < l2; ++i) {
            if (text.charAt(i + startIndex) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean endsWith(@NotNull CharSequence text, @NotNull CharSequence suffix) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(282);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(283);
        }
        return StringUtilRt.endsWith(text, suffix);
    }

    @NotNull
    @Contract(pure=true)
    public static String commonPrefix(@NotNull String s1, @NotNull String s2) {
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(284);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(285);
        }
        String string = s1.substring(0, StringUtil.commonPrefixLength(s1, s2));
        if (string == null) {
            StringUtil.$$$reportNull$$$0(286);
        }
        return string;
    }

    @Contract(pure=true)
    public static int commonPrefixLength(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(287);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(288);
        }
        return StringUtil.commonPrefixLength(s1, s2, false);
    }

    @Contract(pure=true)
    public static int commonPrefixLength(@NotNull CharSequence s1, @NotNull CharSequence s2, boolean ignoreCase) {
        int i;
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(289);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(290);
        }
        int minLength = Math.min(s1.length(), s2.length());
        for (i = 0; i < minLength && StringUtil.charsMatch(s1.charAt(i), s2.charAt(i), ignoreCase); ++i) {
        }
        return i;
    }

    @NotNull
    @Contract(pure=true)
    public static String commonSuffix(@NotNull String s1, @NotNull String s2) {
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(291);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(292);
        }
        String string = s1.substring(s1.length() - StringUtil.commonSuffixLength(s1, s2));
        if (string == null) {
            StringUtil.$$$reportNull$$$0(293);
        }
        return string;
    }

    @Contract(pure=true)
    public static int commonSuffixLength(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        int i;
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(294);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(295);
        }
        int s1Length = s1.length();
        int s2Length = s2.length();
        if (s1Length == 0 || s2Length == 0) {
            return 0;
        }
        for (i = 0; i < s1Length && i < s2Length && s1.charAt(s1Length - i - 1) == s2.charAt(s2Length - i - 1); ++i) {
        }
        return i;
    }

    @Contract(pure=true)
    public static boolean contains(@NotNull CharSequence s, int start, int end, char c) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(296);
        }
        return StringUtil.indexOf(s, c, start, end) >= 0;
    }

    @Contract(pure=true)
    public static boolean containsWhitespaces(@Nullable CharSequence s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isWhitespace(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(297);
        }
        return StringUtil.indexOf(s, c, 0, s.length());
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(298);
        }
        return StringUtil.indexOf(s, c, start, s.length());
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(299);
        }
        end = Math.min(end, s.length());
        for (int i = Math.max(start, 0); i < end; ++i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static boolean contains(@NotNull CharSequence sequence, @NotNull CharSequence infix) {
        if (sequence == null) {
            StringUtil.$$$reportNull$$$0(300);
        }
        if (infix == null) {
            StringUtil.$$$reportNull$$$0(301);
        }
        return StringUtil.indexOf(sequence, infix) >= 0;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence, @NotNull CharSequence infix) {
        if (sequence == null) {
            StringUtil.$$$reportNull$$$0(302);
        }
        if (infix == null) {
            StringUtil.$$$reportNull$$$0(303);
        }
        return StringUtil.indexOf(sequence, infix, 0);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence, @NotNull CharSequence infix, int start) {
        if (sequence == null) {
            StringUtil.$$$reportNull$$$0(304);
        }
        if (infix == null) {
            StringUtil.$$$reportNull$$$0(305);
        }
        return StringUtil.indexOf(sequence, infix, start, sequence.length());
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence, @NotNull CharSequence infix, int start, int end) {
        if (sequence == null) {
            StringUtil.$$$reportNull$$$0(306);
        }
        if (infix == null) {
            StringUtil.$$$reportNull$$$0(307);
        }
        for (int i = start; i <= end - infix.length(); ++i) {
            if (!StringUtil.startsWith(sequence, i, infix)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start, int end, boolean caseSensitive) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(308);
        }
        end = Math.min(end, s.length());
        for (int i = Math.max(start, 0); i < end; ++i) {
            if (!StringUtil.charsMatch(s.charAt(i), c, !caseSensitive)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull char[] s, char c, int start, int end, boolean caseSensitive) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(309);
        }
        end = Math.min(end, s.length);
        for (int i = Math.max(start, 0); i < end; ++i) {
            if (!StringUtil.charsMatch(s[i], c, !caseSensitive)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOfSubstringEnd(@NotNull String text, @NotNull String subString) {
        int i;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(310);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(311);
        }
        if ((i = text.indexOf(subString)) == -1) {
            return -1;
        }
        return i + subString.length();
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull String s, @NotNull String chars) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(312);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(313);
        }
        return StringUtil.indexOfAny(s, chars, 0, s.length());
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull CharSequence s, @NotNull String chars) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(314);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(315);
        }
        return StringUtil.indexOfAny(s, chars, 0, s.length());
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull String s, @NotNull String chars, int start, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(316);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(317);
        }
        return StringUtil.indexOfAny((CharSequence)s, chars, start, end);
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull CharSequence s, @NotNull String chars, int start, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(318);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(319);
        }
        end = Math.min(end, s.length());
        for (int i = Math.max(start, 0); i < end; ++i) {
            if (!StringUtil.containsChar(chars, s.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexOfAny(@NotNull CharSequence s, @NotNull String chars) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(320);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(321);
        }
        for (int i = s.length() - 1; i >= 0; --i) {
            if (!StringUtil.containsChar(chars, s.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    @Contract(pure=true)
    public static String substringBefore(@NotNull String text, @NotNull String subString) {
        int i;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(322);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(323);
        }
        if ((i = text.indexOf(subString)) == -1) {
            return null;
        }
        return text.substring(0, i);
    }

    @NotNull
    @Contract(pure=true)
    public static String substringBeforeLast(@NotNull String text, @NotNull String subString) {
        int i;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(324);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(325);
        }
        if ((i = text.lastIndexOf(subString)) == -1) {
            String string = text;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(326);
            }
            return string;
        }
        String string = text.substring(0, i);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(327);
        }
        return string;
    }

    @Nullable
    @Contract(pure=true)
    public static String substringAfter(@NotNull String text, @NotNull String subString) {
        int i;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(328);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(329);
        }
        if ((i = text.indexOf(subString)) == -1) {
            return null;
        }
        return text.substring(i + subString.length());
    }

    @Nullable
    @Contract(pure=true)
    public static String substringAfterLast(@NotNull String text, @NotNull String subString) {
        int i;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(330);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(331);
        }
        if ((i = text.lastIndexOf(subString)) == -1) {
            return null;
        }
        return text.substring(i + subString.length());
    }

    @Contract(pure=true)
    public static int lastIndexOf(@NotNull CharSequence s, char c, int start, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(332);
        }
        return StringUtilRt.lastIndexOf(s, c, start, end);
    }

    @NotNull
    @Contract(pure=true)
    public static String first(@NotNull String text, int maxLength, boolean appendEllipsis) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(333);
        }
        String string = text.length() > maxLength ? text.substring(0, maxLength) + (appendEllipsis ? "..." : "") : text;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(334);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence first(@NotNull CharSequence text, int length, boolean appendEllipsis) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(335);
        }
        if (text.length() <= length) {
            CharSequence charSequence = text;
            if (charSequence == null) {
                StringUtil.$$$reportNull$$$0(336);
            }
            return charSequence;
        }
        if (appendEllipsis) {
            String string = text.subSequence(0, length) + "...";
            if (string == null) {
                StringUtil.$$$reportNull$$$0(337);
            }
            return string;
        }
        CharSequence charSequence = text.subSequence(0, length);
        if (charSequence == null) {
            StringUtil.$$$reportNull$$$0(338);
        }
        return charSequence;
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence last(@NotNull CharSequence text, int length, boolean prependEllipsis) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(339);
        }
        if (text.length() <= length) {
            CharSequence charSequence = text;
            if (charSequence == null) {
                StringUtil.$$$reportNull$$$0(340);
            }
            return charSequence;
        }
        if (prependEllipsis) {
            String string = "..." + text.subSequence(text.length() - length, text.length());
            if (string == null) {
                StringUtil.$$$reportNull$$$0(341);
            }
            return string;
        }
        CharSequence charSequence = text.subSequence(text.length() - length, text.length());
        if (charSequence == null) {
            StringUtil.$$$reportNull$$$0(342);
        }
        return charSequence;
    }

    @NotNull
    @Contract(pure=true)
    public static String firstLast(@NotNull String text, int length) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(343);
        }
        String string = text.length() > length ? text.subSequence(0, length / 2) + "\u2026" + text.subSequence(text.length() - length / 2 - 1, text.length()) : text;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(344);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeChar(@NotNull String str, char character) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(345);
        }
        String string = StringUtil.escapeChars(str, character);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(346);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeChars(@NotNull String str, char ... character) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(347);
        }
        StringBuilder buf = new StringBuilder(str);
        for (char c : character) {
            StringUtil.escapeChar(buf, c);
        }
        String string = buf.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(348);
        }
        return string;
    }

    public static void escapeChar(@NotNull StringBuilder buf, char character) {
        if (buf == null) {
            StringUtil.$$$reportNull$$$0(349);
        }
        int idx = 0;
        while ((idx = StringUtil.indexOf((CharSequence)buf, character, idx)) >= 0) {
            buf.insert(idx, "\\");
            idx += 2;
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeQuotes(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(350);
        }
        String string = StringUtil.escapeChar(str, '\"');
        if (string == null) {
            StringUtil.$$$reportNull$$$0(351);
        }
        return string;
    }

    public static void escapeQuotes(@NotNull StringBuilder buf) {
        if (buf == null) {
            StringUtil.$$$reportNull$$$0(352);
        }
        StringUtil.escapeChar(buf, '\"');
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeSlashes(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(353);
        }
        String string = StringUtil.escapeChar(str, '/');
        if (string == null) {
            StringUtil.$$$reportNull$$$0(354);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeBackSlashes(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(355);
        }
        String string = StringUtil.escapeChar(str, '\\');
        if (string == null) {
            StringUtil.$$$reportNull$$$0(356);
        }
        return string;
    }

    public static void escapeSlashes(@NotNull StringBuilder buf) {
        if (buf == null) {
            StringUtil.$$$reportNull$$$0(357);
        }
        StringUtil.escapeChar(buf, '/');
    }

    @NotNull
    @Contract(pure=true)
    public static String unescapeSlashes(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(358);
        }
        StringBuilder buf = new StringBuilder(str.length());
        StringUtil.unescapeChar(buf, str, '/');
        String string = buf.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(359);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String unescapeBackSlashes(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(360);
        }
        StringBuilder buf = new StringBuilder(str.length());
        StringUtil.unescapeChar(buf, str, '\\');
        String string = buf.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(361);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String unescapeChar(@NotNull String str, char unescapeChar) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(362);
        }
        StringBuilder buf = new StringBuilder(str.length());
        StringUtil.unescapeChar(buf, str, unescapeChar);
        String string = buf.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(363);
        }
        return string;
    }

    private static void unescapeChar(@NotNull StringBuilder buf, @NotNull String str, char unescapeChar) {
        if (buf == null) {
            StringUtil.$$$reportNull$$$0(364);
        }
        if (str == null) {
            StringUtil.$$$reportNull$$$0(365);
        }
        int length = str.length();
        int last = length - 1;
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (ch == '\\' && i != last && (ch = str.charAt(++i)) != unescapeChar) {
                buf.append('\\');
            }
            buf.append(ch);
        }
    }

    public static void quote(@NotNull StringBuilder builder) {
        if (builder == null) {
            StringUtil.$$$reportNull$$$0(366);
        }
        StringUtil.quote(builder, '\"');
    }

    public static void quote(@NotNull StringBuilder builder, char quotingChar) {
        if (builder == null) {
            StringUtil.$$$reportNull$$$0(367);
        }
        builder.insert(0, quotingChar);
        builder.append(quotingChar);
    }

    @NotNull
    @Contract(pure=true)
    public static String wrapWithDoubleQuote(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(368);
        }
        String string = '\"' + str + "\"";
        if (string == null) {
            StringUtil.$$$reportNull$$$0(369);
        }
        return string;
    }

    @Deprecated
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String unescapeXml(@Nullable String text) {
        return text == null ? null : StringUtil.unescapeXmlEntities(text);
    }

    @Deprecated
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String escapeXml(@Nullable String text) {
        return text == null ? null : StringUtil.escapeXmlEntities(text);
    }

    @NotNull
    @Contract(pure=true)
    public static String unescapeXmlEntities(@NotNull String text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(370);
        }
        String string = StringUtil.replace(text, REPLACES_REFS, REPLACES_DISP);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(371);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeXmlEntities(@NotNull String text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(372);
        }
        String string = StringUtil.replace(text, REPLACES_DISP, REPLACES_REFS);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(373);
        }
        return string;
    }

    @NotNull
    public static String removeHtmlTags(@NotNull String htmlString) {
        if (htmlString == null) {
            StringUtil.$$$reportNull$$$0(374);
        }
        String string = StringUtil.removeHtmlTags(htmlString, false);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(375);
        }
        return string;
    }

    @NotNull
    public static String removeHtmlTags(@NotNull String htmlString, boolean isRemoveStyleTag) {
        if (htmlString == null) {
            StringUtil.$$$reportNull$$$0(376);
        }
        if (StringUtil.isEmpty(htmlString)) {
            if ("" == null) {
                StringUtil.$$$reportNull$$$0(377);
            }
            return "";
        }
        MyHtml2Text parser = isRemoveStyleTag ? new MyHtml2Text(true) : html2TextParser;
        try {
            parser.parse(new StringReader(htmlString));
        }
        catch (IOException e) {
            LOG.error(e);
        }
        String string = parser.getText();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(378);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeMnemonics(@NotNull String text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(379);
        }
        String string = StringUtil.replace(text, MN_CHARS, MN_QUOTED);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(380);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String htmlEmphasize(@NotNull String text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(381);
        }
        String string = "<b><code>" + StringUtil.escapeXmlEntities(text) + "</code></b>";
        if (string == null) {
            StringUtil.$$$reportNull$$$0(382);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeToRegexp(@NotNull String text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(383);
        }
        StringBuilder result = new StringBuilder(text.length());
        String string = StringUtil.escapeToRegexp(text, result).toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(384);
        }
        return string;
    }

    @NotNull
    public static StringBuilder escapeToRegexp(@NotNull CharSequence text, @NotNull StringBuilder builder) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(385);
        }
        if (builder == null) {
            StringUtil.$$$reportNull$$$0(386);
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == ' ' || Character.isLetter(c) || Character.isDigit(c) || c == '_') {
                builder.append(c);
                continue;
            }
            if (c == '\n') {
                builder.append("\\n");
                continue;
            }
            if (c == '\r') {
                builder.append("\\r");
                continue;
            }
            builder.append('\\').append(c);
        }
        StringBuilder stringBuilder = builder;
        if (stringBuilder == null) {
            StringUtil.$$$reportNull$$$0(387);
        }
        return stringBuilder;
    }

    @Contract(pure=true)
    public static boolean isEscapedBackslash(@NotNull char[] chars, int startOffset, int backslashOffset) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(388);
        }
        if (chars[backslashOffset] != '\\') {
            return true;
        }
        boolean escaped = false;
        for (int i = startOffset; i < backslashOffset; ++i) {
            escaped = chars[i] == '\\' ? !escaped : false;
        }
        return escaped;
    }

    @Contract(pure=true)
    public static boolean isEscapedBackslash(@NotNull CharSequence text, int startOffset, int backslashOffset) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(389);
        }
        if (text.charAt(backslashOffset) != '\\') {
            return true;
        }
        boolean escaped = false;
        for (int i = startOffset; i < backslashOffset; ++i) {
            escaped = text.charAt(i) == '\\' ? !escaped : false;
        }
        return escaped;
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    public static String replace(@NotNull String text, @NotNull String[] from, @NotNull String[] to) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(390);
        }
        if (from == null) {
            StringUtil.$$$reportNull$$$0(391);
        }
        if (to == null) {
            StringUtil.$$$reportNull$$$0(392);
        }
        String string = StringUtil.replace(text, Arrays.asList(from), Arrays.asList(to));
        if (string == null) {
            StringUtil.$$$reportNull$$$0(393);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String replace(@NotNull String text, @NotNull List<String> from, @NotNull List<String> to) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(394);
        }
        if (from == null) {
            StringUtil.$$$reportNull$$$0(395);
        }
        if (to == null) {
            StringUtil.$$$reportNull$$$0(396);
        }
        assert (from.size() == to.size());
        StringBuilder result = null;
        block0: for (int i = 0; i < text.length(); ++i) {
            for (int j = 0; j < from.size(); ++j) {
                String toReplace = from.get(j);
                String replaceWith = to.get(j);
                int len = toReplace.length();
                if (!text.regionMatches(i, toReplace, 0, len)) continue;
                if (result == null) {
                    result = new StringBuilder(text.length());
                    result.append(text, 0, i);
                }
                result.append(replaceWith);
                i += len - 1;
                continue block0;
            }
            if (result == null) continue;
            result.append(text.charAt(i));
        }
        String string = result == null ? text : result.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(397);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] filterEmptyStrings(@NotNull String[] strings) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(398);
        }
        int emptyCount = 0;
        for (String string : strings) {
            if (string != null && !string.isEmpty()) continue;
            ++emptyCount;
        }
        if (emptyCount == 0) {
            if (strings == null) {
                StringUtil.$$$reportNull$$$0(399);
            }
            return strings;
        }
        String[] result = ArrayUtil.newStringArray(strings.length - emptyCount);
        int count = 0;
        for (String string : strings) {
            if (string == null || string.isEmpty()) continue;
            result[count++] = string;
        }
        if (result == null) {
            StringUtil.$$$reportNull$$$0(400);
        }
        return result;
    }

    @Contract(pure=true)
    public static int countNewLines(@NotNull CharSequence text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(401);
        }
        return StringUtil.countChars(text, '\n');
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text, char c) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(402);
        }
        return StringUtil.countChars(text, c, 0, false);
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text, char c, int offset, boolean stopAtOtherChar) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(403);
        }
        return StringUtil.countChars(text, c, offset, text.length(), stopAtOtherChar);
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text, char c, int start, int end, boolean stopAtOtherChar) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(404);
        }
        boolean forward = start <= end;
        start = forward ? Math.max(0, start) : Math.min(text.length(), start);
        end = forward ? Math.min(text.length(), end) : Math.max(0, end);
        int count = 0;
        int i = forward ? start : start - 1;
        while (forward == i < end) {
            if (text.charAt(i) == c) {
                ++count;
            } else if (stopAtOtherChar) break;
            i += forward ? 1 : -1;
        }
        return count;
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalsOnly(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(405);
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isUpperCase(s.charAt(i))) continue;
            b.append(s.charAt(i));
        }
        String string = b.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(406);
        }
        return string;
    }

    @Nullable
    @Contract(pure=true)
    public static String joinOrNull(String ... args) {
        if (args == null) {
            StringUtil.$$$reportNull$$$0(407);
        }
        StringBuilder r = new StringBuilder();
        for (String arg : args) {
            if (arg == null) {
                return null;
            }
            r.append(arg);
        }
        return r.toString();
    }

    @Nullable
    @Contract(pure=true)
    public static String getPropertyName(@NotNull String methodName) {
        if (methodName == null) {
            StringUtil.$$$reportNull$$$0(408);
        }
        if (methodName.startsWith("get")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.startsWith("is")) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        if (methodName.startsWith("set")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        return null;
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifierStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || Character.isJavaIdentifierStart(c);
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifierPart(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || Character.isJavaIdentifierPart(c);
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifier(@NotNull String text) {
        int len;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(409);
        }
        if ((len = text.length()) == 0) {
            return false;
        }
        if (!StringUtil.isJavaIdentifierStart(text.charAt(0))) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            if (StringUtil.isJavaIdentifierPart(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeProperty(@NotNull String input, boolean isKey) {
        if (input == null) {
            StringUtil.$$$reportNull$$$0(410);
        }
        StringBuilder escaped = new StringBuilder(input.length());
        block8: for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            switch (ch) {
                case ' ': {
                    if (isKey && i == 0) {
                        escaped.append('\\');
                    }
                    escaped.append(' ');
                    continue block8;
                }
                case '\t': {
                    escaped.append("\\t");
                    continue block8;
                }
                case '\r': {
                    escaped.append("\\r");
                    continue block8;
                }
                case '\n': {
                    escaped.append("\\n");
                    continue block8;
                }
                case '\f': {
                    escaped.append("\\f");
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': 
                case '\\': {
                    escaped.append('\\');
                    escaped.append(ch);
                    continue block8;
                }
                default: {
                    if ('\u0014' < ch && ch < '\u007f') {
                        escaped.append(ch);
                        continue block8;
                    }
                    escaped.append("\\u");
                    escaped.append(Character.forDigit(ch >> 12 & 0xF, 16));
                    escaped.append(Character.forDigit(ch >> 8 & 0xF, 16));
                    escaped.append(Character.forDigit(ch >> 4 & 0xF, 16));
                    escaped.append(Character.forDigit(ch & 0xF, 16));
                }
            }
        }
        String string = escaped.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(411);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String getQualifiedName(@Nullable String packageName, @NotNull String className) {
        if (className == null) {
            StringUtil.$$$reportNull$$$0(412);
        }
        if (packageName == null || packageName.isEmpty()) {
            String string = className;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(413);
            }
            return string;
        }
        String string = packageName + '.' + className;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(414);
        }
        return string;
    }

    @Contract(pure=true)
    public static int compareVersionNumbers(@Nullable String v1, @Nullable String v2) {
        int idx;
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        String[] part1 = v1.split("[._\\-]");
        String[] part2 = v2.split("[._\\-]");
        for (idx = 0; idx < part1.length && idx < part2.length; ++idx) {
            String p1 = part1[idx];
            String p2 = part2[idx];
            int cmp = p1.matches("\\d+") && p2.matches("\\d+") ? new Integer(p1).compareTo(new Integer(p2)) : part1[idx].compareTo(part2[idx]);
            if (cmp == 0) continue;
            return cmp;
        }
        if (part1.length != part2.length) {
            String[] parts;
            boolean left = part1.length > idx;
            String[] stringArray = parts = left ? part1 : part2;
            while (idx < parts.length) {
                String p = parts[idx];
                int cmp = p.matches("\\d+") ? new Integer(p).compareTo(0) : 1;
                if (cmp != 0) {
                    return left ? cmp : -cmp;
                }
                ++idx;
            }
        }
        return 0;
    }

    @Contract(pure=true)
    public static int getOccurrenceCount(@NotNull String text, char c) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(415);
        }
        int res = 0;
        for (int i = 0; i < text.length() && (i = text.indexOf(c, i)) >= 0; ++i) {
            ++res;
        }
        return res;
    }

    @Contract(pure=true)
    public static int getOccurrenceCount(@NotNull String text, @NotNull String s) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(416);
        }
        if (s == null) {
            StringUtil.$$$reportNull$$$0(417);
        }
        int res = 0;
        for (int i = 0; i < text.length() && (i = text.indexOf(s, i)) >= 0; ++i) {
            ++res;
        }
        return res;
    }

    @Contract(pure=true)
    public static int getIgnoreCaseOccurrenceCount(@NotNull String text, @NotNull String s) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(418);
        }
        if (s == null) {
            StringUtil.$$$reportNull$$$0(419);
        }
        int res = 0;
        for (int i = 0; i < text.length() && (i = StringUtil.indexOfIgnoreCase(text, s, i)) >= 0; ++i) {
            ++res;
        }
        return res;
    }

    @NotNull
    @Contract(pure=true)
    public static String fixVariableNameDerivedFromPropertyName(@NotNull String name) {
        if (name == null) {
            StringUtil.$$$reportNull$$$0(420);
        }
        if (StringUtil.isEmptyOrSpaces(name)) {
            String string = name;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(421);
            }
            return string;
        }
        char c = name.charAt(0);
        if (StringUtil.isVowel(c)) {
            String string = "an" + Character.toUpperCase(c) + name.substring(1);
            if (string == null) {
                StringUtil.$$$reportNull$$$0(422);
            }
            return string;
        }
        String string = "a" + Character.toUpperCase(c) + name.substring(1);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(423);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String sanitizeJavaIdentifier(@NotNull String name) {
        if (name == null) {
            StringUtil.$$$reportNull$$$0(424);
        }
        StringBuilder result = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (!Character.isJavaIdentifierPart(ch)) continue;
            if (result.length() == 0 && !Character.isJavaIdentifierStart(ch)) {
                result.append("_");
            }
            result.append(ch);
        }
        String string = result.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(425);
        }
        return string;
    }

    public static void assertValidSeparators(@NotNull CharSequence s) {
        int i;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(426);
        }
        char[] chars = CharArrayUtil.fromSequenceWithoutCopying(s);
        int slashRIndex = -1;
        if (chars != null) {
            int len = s.length();
            for (i = 0; i < len; ++i) {
                if (chars[i] != '\r') continue;
                slashRIndex = i;
                break;
            }
        } else {
            int len = s.length();
            for (i = 0; i < len; ++i) {
                if (s.charAt(i) != '\r') continue;
                slashRIndex = i;
                break;
            }
        }
        if (slashRIndex != -1) {
            String context = String.valueOf(StringUtil.last(s.subSequence(0, slashRIndex), 10, true)) + StringUtil.first(s.subSequence(slashRIndex, s.length()), 10, true);
            context = StringUtil.escapeStringCharacters(context);
            throw new AssertionError((Object)("Wrong line separators: '" + context + "' at offset " + slashRIndex));
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String tail(@NotNull String s, int idx) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(427);
        }
        String string = idx >= s.length() ? "" : s.substring(idx);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(428);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] splitByLines(@NotNull String string) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(429);
        }
        String[] stringArray = StringUtil.splitByLines(string, true);
        if (stringArray == null) {
            StringUtil.$$$reportNull$$$0(430);
        }
        return stringArray;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] splitByLines(@NotNull String string, boolean excludeEmptyStrings) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(431);
        }
        String[] stringArray = (excludeEmptyStrings ? EOL_SPLIT_PATTERN : EOL_SPLIT_PATTERN_WITH_EMPTY).split(string);
        if (stringArray == null) {
            StringUtil.$$$reportNull$$$0(432);
        }
        return stringArray;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] splitByLinesDontTrim(@NotNull String string) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(433);
        }
        String[] stringArray = EOL_SPLIT_DONT_TRIM_PATTERN.split(string);
        if (stringArray == null) {
            StringUtil.$$$reportNull$$$0(434);
        }
        return stringArray;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] splitByLinesKeepSeparators(@NotNull String string) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(435);
        }
        String[] stringArray = EOL_SPLIT_KEEP_SEPARATORS.split(string);
        if (stringArray == null) {
            StringUtil.$$$reportNull$$$0(436);
        }
        return stringArray;
    }

    @NotNull
    @Contract(pure=true)
    public static List<Pair<String, Integer>> getWordsWithOffset(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(437);
        }
        ArrayList<Pair<String, Integer>> res = ContainerUtil.newArrayList();
        s = s + " ";
        StringBuilder name = new StringBuilder();
        int startInd = -1;
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) {
                if (name.length() <= 0) continue;
                res.add(Pair.create(name.toString(), startInd));
                name.setLength(0);
                startInd = -1;
                continue;
            }
            if (startInd == -1) {
                startInd = i;
            }
            name.append(s.charAt(i));
        }
        ArrayList<Pair<String, Integer>> arrayList = res;
        if (arrayList == null) {
            StringUtil.$$$reportNull$$$0(438);
        }
        return arrayList;
    }

    @Contract(pure=true)
    public static int naturalCompare(@Nullable String string1, @Nullable String string2) {
        return NaturalComparator.INSTANCE.compare(string1, string2);
    }

    @Contract(pure=true)
    public static boolean isDecimalDigit(char c) {
        return c >= '0' && c <= '9';
    }

    @Contract(value="null -> false")
    public static boolean isNotNegativeNumber(@Nullable CharSequence s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (StringUtil.isDecimalDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static int compare(@Nullable String s1, @Nullable String s2, boolean ignoreCase) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return ignoreCase ? s1.compareToIgnoreCase(s2) : s1.compareTo(s2);
    }

    @Contract(pure=true)
    public static int comparePairs(@Nullable String s1, @Nullable String t1, @Nullable String s2, @Nullable String t2, boolean ignoreCase) {
        int compare = StringUtil.compare(s1, s2, ignoreCase);
        return compare != 0 ? compare : StringUtil.compare(t1, t2, ignoreCase);
    }

    @Contract(pure=true)
    public static int hashCode(@NotNull CharSequence s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(439);
        }
        return StringUtil.stringHashCode(s);
    }

    @Contract(pure=true)
    public static boolean equals(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        if (s1 == null ^ s2 == null) {
            return false;
        }
        if (s1 == null) {
            return true;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        for (int i = 0; i < s1.length(); ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean equalsIgnoreCase(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        if (s1 == null ^ s2 == null) {
            return false;
        }
        if (s1 == null) {
            return true;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        for (int i = 0; i < s1.length(); ++i) {
            if (StringUtil.charsEqualIgnoreCase(s1.charAt(i), s2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean equalsIgnoreWhitespaces(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        if (s1 == null ^ s2 == null) {
            return false;
        }
        if (s1 == null) {
            return true;
        }
        int len1 = s1.length();
        int len2 = s2.length();
        int index1 = 0;
        int index2 = 0;
        while (index1 < len1 && index2 < len2) {
            if (s1.charAt(index1) == s2.charAt(index2)) {
                ++index1;
                ++index2;
                continue;
            }
            boolean skipped = false;
            while (index1 != len1 && StringUtil.isWhiteSpace(s1.charAt(index1))) {
                skipped = true;
                ++index1;
            }
            while (index2 != len2 && StringUtil.isWhiteSpace(s2.charAt(index2))) {
                skipped = true;
                ++index2;
            }
            if (skipped) continue;
            return false;
        }
        while (index1 != len1) {
            if (!StringUtil.isWhiteSpace(s1.charAt(index1))) {
                return false;
            }
            ++index1;
        }
        while (index2 != len2) {
            if (!StringUtil.isWhiteSpace(s2.charAt(index2))) {
                return false;
            }
            ++index2;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean equalsTrimWhitespaces(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        char c;
        int start2;
        char c2;
        int start1;
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(440);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(441);
        }
        int end1 = s1.length();
        int end2 = s2.length();
        for (start1 = 0; start1 < end1 && StringUtil.isWhiteSpace(c2 = s1.charAt(start1)); ++start1) {
        }
        while (start1 < end1 && StringUtil.isWhiteSpace(c2 = s1.charAt(end1 - 1))) {
            --end1;
        }
        for (start2 = 0; start2 < end2 && StringUtil.isWhiteSpace(c = s2.charAt(start2)); ++start2) {
        }
        while (start2 < end2 && StringUtil.isWhiteSpace(c = s2.charAt(end2 - 1))) {
            --end2;
        }
        CharSequenceSubSequence ts1 = new CharSequenceSubSequence(s1, start1, end1);
        CharSequenceSubSequence ts2 = new CharSequenceSubSequence(s2, start2, end2);
        return StringUtil.equals(ts1, ts2);
    }

    public static String collapseWhiteSpace(@NotNull CharSequence s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(442);
        }
        StringBuilder result = new StringBuilder();
        boolean space = false;
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char ch = s.charAt(i);
            if (StringUtil.isWhiteSpace(ch)) {
                if (space) continue;
                space = true;
                continue;
            }
            if (space && result.length() > 0) {
                result.append(' ');
            }
            result.append(ch);
            space = false;
        }
        return result.toString();
    }

    @Contract(pure=true)
    public static boolean findIgnoreCase(@Nullable String toFind, String ... where) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(443);
        }
        for (String string : where) {
            if (!StringUtil.equalsIgnoreCase(toFind, string)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static int compare(char c1, char c2, boolean ignoreCase) {
        char u2;
        int d = c1 - c2;
        if (d == 0 || !ignoreCase) {
            return d;
        }
        char u1 = StringUtilRt.toUpperCase(c1);
        d = u1 - (u2 = StringUtilRt.toUpperCase(c2));
        if (d != 0) {
            d = StringUtilRt.toLowerCase(u1) - StringUtilRt.toLowerCase(u2);
        }
        return d;
    }

    @Contract(pure=true)
    public static boolean charsMatch(char c1, char c2, boolean ignoreCase) {
        return StringUtil.compare(c1, c2, ignoreCase) == 0;
    }

    @NotNull
    @Contract(pure=true)
    public static String formatLinks(@NotNull String message) {
        if (message == null) {
            StringUtil.$$$reportNull$$$0(444);
        }
        Pattern linkPattern = Pattern.compile("http://[a-zA-Z0-9./\\-+]+");
        StringBuffer result = new StringBuffer();
        Matcher m = linkPattern.matcher(message);
        while (m.find()) {
            m.appendReplacement(result, "<a href=\"" + m.group() + "\">" + m.group() + "</a>");
        }
        m.appendTail(result);
        String string = result.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(445);
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean isHexDigit(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    @Contract(pure=true)
    public static boolean isOctalDigit(char c) {
        return '0' <= c && c <= '7';
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenTextWithEllipsis(@NotNull String text, int maxLength, int suffixLength) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(446);
        }
        String string = StringUtil.shortenTextWithEllipsis(text, maxLength, suffixLength, false);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(447);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimMiddle(@NotNull String text, int maxLength) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(448);
        }
        String string = StringUtil.shortenTextWithEllipsis(text, maxLength, maxLength >> 1, true);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(449);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenTextWithEllipsis(@NotNull String text, int maxLength, int suffixLength, @NotNull String symbol) {
        int textLength;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(450);
        }
        if (symbol == null) {
            StringUtil.$$$reportNull$$$0(451);
        }
        if ((textLength = text.length()) > maxLength) {
            int prefixLength = maxLength - suffixLength - symbol.length();
            assert (prefixLength > 0);
            String string = text.substring(0, prefixLength) + symbol + text.substring(textLength - suffixLength);
            if (string == null) {
                StringUtil.$$$reportNull$$$0(452);
            }
            return string;
        }
        String string = text;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(453);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenTextWithEllipsis(@NotNull String text, int maxLength, int suffixLength, boolean useEllipsisSymbol) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(454);
        }
        String symbol = useEllipsisSymbol ? "\u2026" : "...";
        String string = StringUtil.shortenTextWithEllipsis(text, maxLength, suffixLength, symbol);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(455);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenPathWithEllipsis(@NotNull String path, int maxLength, boolean useEllipsisSymbol) {
        if (path == null) {
            StringUtil.$$$reportNull$$$0(456);
        }
        String string = StringUtil.shortenTextWithEllipsis(path, maxLength, (int)((double)maxLength * 0.7), useEllipsisSymbol);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(457);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenPathWithEllipsis(@NotNull String path, int maxLength) {
        if (path == null) {
            StringUtil.$$$reportNull$$$0(458);
        }
        String string = StringUtil.shortenPathWithEllipsis(path, maxLength, false);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(459);
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean charsEqualIgnoreCase(char a, char b) {
        return StringUtil.charsMatch(a, b, true);
    }

    @Contract(pure=true)
    public static char toUpperCase(char a) {
        return StringUtilRt.toUpperCase(a);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String toUpperCase(String a) {
        return a == null ? null : StringUtilRt.toUpperCase(a).toString();
    }

    @Contract(pure=true)
    public static char toLowerCase(char a) {
        return StringUtilRt.toLowerCase(a);
    }

    @Contract(pure=true)
    public static boolean isUpperCase(@NotNull CharSequence sequence) {
        if (sequence == null) {
            StringUtil.$$$reportNull$$$0(460);
        }
        for (int i = 0; i < sequence.length(); ++i) {
            if (Character.isUpperCase(sequence.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static LineSeparator detectSeparators(@NotNull CharSequence text) {
        int index;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(461);
        }
        if ((index = StringUtil.indexOfAny(text, "\n\r")) == -1) {
            return null;
        }
        LineSeparator lineSeparator = StringUtil.getLineSeparatorAt(text, index);
        if (lineSeparator == null) {
            throw new AssertionError();
        }
        return lineSeparator;
    }

    @Nullable
    public static LineSeparator getLineSeparatorAt(@NotNull CharSequence text, int index) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(462);
        }
        if (index < 0 || index >= text.length()) {
            return null;
        }
        char ch = text.charAt(index);
        if (ch == '\r') {
            return index + 1 < text.length() && text.charAt(index + 1) == '\n' ? LineSeparator.CRLF : LineSeparator.CR;
        }
        return ch == '\n' ? LineSeparator.LF : null;
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(463);
        }
        String string = StringUtilRt.convertLineSeparators(text);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(464);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text, boolean keepCarriageReturn) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(465);
        }
        String string = StringUtilRt.convertLineSeparators(text, keepCarriageReturn);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(466);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text, @NotNull String newSeparator) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(467);
        }
        if (newSeparator == null) {
            StringUtil.$$$reportNull$$$0(468);
        }
        String string = StringUtilRt.convertLineSeparators(text, newSeparator);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(469);
        }
        return string;
    }

    @NotNull
    public static String convertLineSeparators(@NotNull String text, @NotNull String newSeparator, @Nullable int[] offsetsToKeep) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(470);
        }
        if (newSeparator == null) {
            StringUtil.$$$reportNull$$$0(471);
        }
        String string = StringUtilRt.convertLineSeparators(text, newSeparator, offsetsToKeep);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(472);
        }
        return string;
    }

    @Contract(pure=true)
    public static int parseInt(@Nullable String string, int defaultValue) {
        return StringUtilRt.parseInt(string, defaultValue);
    }

    @Contract(pure=true)
    public static long parseLong(@Nullable String string, long defaultValue) {
        return StringUtilRt.parseLong(string, defaultValue);
    }

    @Contract(pure=true)
    public static double parseDouble(@Nullable String string, double defaultValue) {
        return StringUtilRt.parseDouble(string, defaultValue);
    }

    @Contract(pure=true)
    public static <E extends Enum<E>> E parseEnum(@NotNull String string, E defaultValue, @NotNull Class<E> clazz) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(473);
        }
        if (clazz == null) {
            StringUtil.$$$reportNull$$$0(474);
        }
        return StringUtilRt.parseEnum(string, defaultValue, clazz);
    }

    @NotNull
    @Contract(pure=true)
    public static String getShortName(@NotNull Class aClass) {
        if (aClass == null) {
            StringUtil.$$$reportNull$$$0(475);
        }
        String string = StringUtilRt.getShortName(aClass);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(476);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String getShortName(@NotNull String fqName) {
        if (fqName == null) {
            StringUtil.$$$reportNull$$$0(477);
        }
        String string = StringUtilRt.getShortName(fqName);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(478);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String getShortName(@NotNull String fqName, char separator) {
        if (fqName == null) {
            StringUtil.$$$reportNull$$$0(479);
        }
        String string = StringUtilRt.getShortName(fqName, separator);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(480);
        }
        return string;
    }

    public static boolean isShortNameOf(@NotNull String fqName, @NotNull String shortName) {
        if (fqName == null) {
            StringUtil.$$$reportNull$$$0(481);
        }
        if (shortName == null) {
            StringUtil.$$$reportNull$$$0(482);
        }
        if (fqName.length() < shortName.length()) {
            return false;
        }
        if (fqName.length() == shortName.length()) {
            return fqName.equals(shortName);
        }
        int diff = fqName.length() - shortName.length();
        if (fqName.charAt(diff - 1) != '.') {
            return false;
        }
        return fqName.regionMatches(diff, shortName, 0, shortName.length());
    }

    @Contract(value="null->null;!null->!null")
    static String toShortString(@Nullable Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof CharSequence) {
            return o.toString();
        }
        String className = o.getClass().getName();
        String s = o.toString();
        if (!s.startsWith(className)) {
            return s;
        }
        return s.length() > className.length() && !Character.isLetter(s.charAt(className.length())) ? StringUtil.trimStart(s, className) : s;
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence newBombedCharSequence(@NotNull CharSequence sequence, long delay) {
        if (sequence == null) {
            StringUtil.$$$reportNull$$$0(483);
        }
        final long myTime = System.currentTimeMillis() + delay;
        BombedCharSequence bombedCharSequence = new BombedCharSequence(sequence){

            @Override
            protected void checkCanceled() {
                long l = System.currentTimeMillis();
                if (l >= myTime) {
                    throw new ProcessCanceledException();
                }
            }
        };
        if (bombedCharSequence == null) {
            StringUtil.$$$reportNull$$$0(484);
        }
        return bombedCharSequence;
    }

    public static boolean trimEnd(@NotNull StringBuilder buffer, @NotNull CharSequence end) {
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(485);
        }
        if (end == null) {
            StringUtil.$$$reportNull$$$0(486);
        }
        if (StringUtil.endsWith(buffer, end)) {
            buffer.delete(buffer.length() - end.length(), buffer.length());
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean isBetween(@NotNull String string, @NotNull String smallPart, @NotNull String bigPart) {
        String s;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(487);
        }
        if (smallPart == null) {
            StringUtil.$$$reportNull$$$0(488);
        }
        if (bigPart == null) {
            StringUtil.$$$reportNull$$$0(489);
        }
        return (s = string.toLowerCase()).startsWith(smallPart.toLowerCase()) && bigPart.toLowerCase().startsWith(s);
    }

    public static boolean hasUpperCaseChar(String s) {
        char[] chars;
        for (char c : chars = s.toCharArray()) {
            if (!Character.isUpperCase(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLowerCaseChar(String s) {
        char[] chars;
        for (char c : chars = s.toCharArray()) {
            if (!Character.isLowerCase(c)) continue;
            return true;
        }
        return false;
    }

    public static String replaceUnicodeEscapeSequences(String text) {
        if (text == null) {
            return null;
        }
        Matcher matcher = UNICODE_CHAR.matcher(text);
        if (!matcher.find()) {
            return text;
        }
        matcher.reset();
        int lastEnd = 0;
        StringBuilder sb = new StringBuilder(text.length());
        while (matcher.find()) {
            sb.append(text, lastEnd, matcher.start());
            char c = (char)Integer.parseInt(matcher.group().substring(2), 16);
            sb.append(c);
            lastEnd = matcher.end();
        }
        sb.append(text.substring(lastEnd));
        return sb.toString();
    }

    @Contract(pure=true)
    @NotNull
    public static String toHexString(@NotNull byte[] bytes) {
        if (bytes == null) {
            StringUtil.$$$reportNull$$$0(490);
        }
        String digits = "0123456789abcdef";
        StringBuilder sb = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            sb.append(digits.charAt(b >> 4 & 0xF)).append(digits.charAt(b & 0xF));
        }
        String string = sb.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(491);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static byte[] parseHexString(@NotNull String str) {
        int len;
        if (str == null) {
            StringUtil.$$$reportNull$$$0(492);
        }
        if ((len = str.length()) % 2 != 0) {
            throw new IllegalArgumentException("Non-even-length: " + str);
        }
        byte[] bytes = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            bytes[i / 2] = (byte)((Character.digit(str.charAt(i), 16) << 4) + Character.digit(str.charAt(i + 1), 16));
        }
        if (bytes == null) {
            StringUtil.$$$reportNull$$$0(493);
        }
        return bytes;
    }

    @Deprecated
    public static boolean startsWithConcatenationOf(@NotNull String string, @NotNull String firstPrefix, @NotNull String secondPrefix) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(494);
        }
        if (firstPrefix == null) {
            StringUtil.$$$reportNull$$$0(495);
        }
        if (secondPrefix == null) {
            StringUtil.$$$reportNull$$$0(496);
        }
        return StringUtil.startsWithConcatenation(string, firstPrefix, secondPrefix);
    }

    @Contract(pure=true)
    public static boolean isLatinAlphanumeric(@Nullable CharSequence str) {
        if (StringUtil.isEmpty(str)) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 16: 
            case 18: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 44: 
            case 52: 
            case 54: 
            case 56: 
            case 59: 
            case 63: 
            case 68: 
            case 71: 
            case 74: 
            case 76: 
            case 78: 
            case 80: 
            case 84: 
            case 86: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 97: 
            case 99: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 120: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 129: 
            case 130: 
            case 132: 
            case 134: 
            case 136: 
            case 138: 
            case 140: 
            case 142: 
            case 144: 
            case 146: 
            case 149: 
            case 150: 
            case 152: 
            case 154: 
            case 155: 
            case 157: 
            case 159: 
            case 161: 
            case 164: 
            case 166: 
            case 168: 
            case 169: 
            case 171: 
            case 174: 
            case 177: 
            case 180: 
            case 183: 
            case 186: 
            case 187: 
            case 190: 
            case 192: 
            case 194: 
            case 195: 
            case 197: 
            case 199: 
            case 202: 
            case 205: 
            case 208: 
            case 212: 
            case 216: 
            case 220: 
            case 221: 
            case 222: 
            case 228: 
            case 235: 
            case 236: 
            case 242: 
            case 244: 
            case 245: 
            case 247: 
            case 248: 
            case 249: 
            case 251: 
            case 252: 
            case 254: 
            case 264: 
            case 267: 
            case 270: 
            case 276: 
            case 286: 
            case 293: 
            case 326: 
            case 327: 
            case 334: 
            case 336: 
            case 337: 
            case 338: 
            case 340: 
            case 341: 
            case 342: 
            case 344: 
            case 346: 
            case 348: 
            case 351: 
            case 354: 
            case 356: 
            case 359: 
            case 361: 
            case 363: 
            case 369: 
            case 371: 
            case 373: 
            case 375: 
            case 377: 
            case 378: 
            case 380: 
            case 382: 
            case 384: 
            case 387: 
            case 393: 
            case 397: 
            case 399: 
            case 400: 
            case 406: 
            case 411: 
            case 413: 
            case 414: 
            case 421: 
            case 422: 
            case 423: 
            case 425: 
            case 428: 
            case 430: 
            case 432: 
            case 434: 
            case 436: 
            case 438: 
            case 445: 
            case 447: 
            case 449: 
            case 452: 
            case 453: 
            case 455: 
            case 457: 
            case 459: 
            case 464: 
            case 466: 
            case 469: 
            case 472: 
            case 476: 
            case 478: 
            case 480: 
            case 484: 
            case 491: 
            case 493: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 16: 
            case 18: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 44: 
            case 52: 
            case 54: 
            case 56: 
            case 59: 
            case 63: 
            case 68: 
            case 71: 
            case 74: 
            case 76: 
            case 78: 
            case 80: 
            case 84: 
            case 86: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 97: 
            case 99: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 120: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 129: 
            case 130: 
            case 132: 
            case 134: 
            case 136: 
            case 138: 
            case 140: 
            case 142: 
            case 144: 
            case 146: 
            case 149: 
            case 150: 
            case 152: 
            case 154: 
            case 155: 
            case 157: 
            case 159: 
            case 161: 
            case 164: 
            case 166: 
            case 168: 
            case 169: 
            case 171: 
            case 174: 
            case 177: 
            case 180: 
            case 183: 
            case 186: 
            case 187: 
            case 190: 
            case 192: 
            case 194: 
            case 195: 
            case 197: 
            case 199: 
            case 202: 
            case 205: 
            case 208: 
            case 212: 
            case 216: 
            case 220: 
            case 221: 
            case 222: 
            case 228: 
            case 235: 
            case 236: 
            case 242: 
            case 244: 
            case 245: 
            case 247: 
            case 248: 
            case 249: 
            case 251: 
            case 252: 
            case 254: 
            case 264: 
            case 267: 
            case 270: 
            case 276: 
            case 286: 
            case 293: 
            case 326: 
            case 327: 
            case 334: 
            case 336: 
            case 337: 
            case 338: 
            case 340: 
            case 341: 
            case 342: 
            case 344: 
            case 346: 
            case 348: 
            case 351: 
            case 354: 
            case 356: 
            case 359: 
            case 361: 
            case 363: 
            case 369: 
            case 371: 
            case 373: 
            case 375: 
            case 377: 
            case 378: 
            case 380: 
            case 382: 
            case 384: 
            case 387: 
            case 393: 
            case 397: 
            case 399: 
            case 400: 
            case 406: 
            case 411: 
            case 413: 
            case 414: 
            case 421: 
            case 422: 
            case 423: 
            case 425: 
            case 428: 
            case 430: 
            case 432: 
            case 434: 
            case 436: 
            case 438: 
            case 445: 
            case 447: 
            case 449: 
            case 452: 
            case 453: 
            case 455: 
            case 457: 
            case 459: 
            case 464: 
            case 466: 
            case 469: 
            case 472: 
            case 476: 
            case 478: 
            case 480: 
            case 484: 
            case 491: 
            case 493: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charSeq";
                break;
            }
            case 1: 
            case 275: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 16: 
            case 18: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 44: 
            case 52: 
            case 54: 
            case 56: 
            case 59: 
            case 63: 
            case 68: 
            case 71: 
            case 74: 
            case 76: 
            case 78: 
            case 80: 
            case 84: 
            case 86: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 97: 
            case 99: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 120: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 129: 
            case 130: 
            case 132: 
            case 134: 
            case 136: 
            case 138: 
            case 140: 
            case 142: 
            case 144: 
            case 146: 
            case 149: 
            case 150: 
            case 152: 
            case 154: 
            case 155: 
            case 157: 
            case 159: 
            case 161: 
            case 164: 
            case 166: 
            case 168: 
            case 169: 
            case 171: 
            case 174: 
            case 177: 
            case 180: 
            case 183: 
            case 186: 
            case 187: 
            case 190: 
            case 192: 
            case 194: 
            case 195: 
            case 197: 
            case 199: 
            case 202: 
            case 205: 
            case 208: 
            case 212: 
            case 216: 
            case 220: 
            case 221: 
            case 222: 
            case 228: 
            case 235: 
            case 236: 
            case 242: 
            case 244: 
            case 245: 
            case 247: 
            case 248: 
            case 249: 
            case 251: 
            case 252: 
            case 254: 
            case 264: 
            case 267: 
            case 270: 
            case 276: 
            case 286: 
            case 293: 
            case 326: 
            case 327: 
            case 334: 
            case 336: 
            case 337: 
            case 338: 
            case 340: 
            case 341: 
            case 342: 
            case 344: 
            case 346: 
            case 348: 
            case 351: 
            case 354: 
            case 356: 
            case 359: 
            case 361: 
            case 363: 
            case 369: 
            case 371: 
            case 373: 
            case 375: 
            case 377: 
            case 378: 
            case 380: 
            case 382: 
            case 384: 
            case 387: 
            case 393: 
            case 397: 
            case 399: 
            case 400: 
            case 406: 
            case 411: 
            case 413: 
            case 414: 
            case 421: 
            case 422: 
            case 423: 
            case 425: 
            case 428: 
            case 430: 
            case 432: 
            case 434: 
            case 436: 
            case 438: 
            case 445: 
            case 447: 
            case 449: 
            case 452: 
            case 453: 
            case 455: 
            case 457: 
            case 459: 
            case 464: 
            case 466: 
            case 469: 
            case 472: 
            case 476: 
            case 478: 
            case 480: 
            case 484: 
            case 491: 
            case 493: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/text/StringUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "find";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 19: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 93: 
            case 95: 
            case 128: 
            case 193: 
            case 196: 
            case 198: 
            case 246: 
            case 277: 
            case 278: 
            case 280: 
            case 282: 
            case 310: 
            case 322: 
            case 324: 
            case 328: 
            case 330: 
            case 333: 
            case 335: 
            case 339: 
            case 343: 
            case 370: 
            case 372: 
            case 379: 
            case 381: 
            case 383: 
            case 385: 
            case 389: 
            case 390: 
            case 394: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 409: 
            case 415: 
            case 416: 
            case 418: 
            case 446: 
            case 448: 
            case 450: 
            case 454: 
            case 461: 
            case 462: 
            case 463: 
            case 465: 
            case 467: 
            case 470: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 10: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldS";
                break;
            }
            case 11: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newS";
                break;
            }
            case 17: 
            case 65: 
            case 67: 
            case 70: 
            case 73: 
            case 88: 
            case 156: 
            case 485: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 443: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
            case 23: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 30: 
            case 32: 
            case 64: 
            case 66: 
            case 69: 
            case 72: 
            case 345: 
            case 347: 
            case 350: 
            case 353: 
            case 355: 
            case 358: 
            case 360: 
            case 362: 
            case 365: 
            case 368: 
            case 492: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 31: 
            case 119: 
            case 122: 
            case 211: 
            case 283: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 33: 
            case 148: 
            case 210: 
            case 279: 
            case 281: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 36: 
            case 38: 
            case 477: 
            case 479: 
            case 481: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 49: 
            case 284: 
            case 287: 
            case 289: 
            case 291: 
            case 294: 
            case 440: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 50: 
            case 285: 
            case 288: 
            case 290: 
            case 292: 
            case 295: 
            case 441: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 51: 
            case 53: 
            case 55: 
            case 57: 
            case 60: 
            case 61: 
            case 75: 
            case 77: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 87: 
            case 98: 
            case 100: 
            case 105: 
            case 118: 
            case 121: 
            case 125: 
            case 147: 
            case 167: 
            case 170: 
            case 172: 
            case 175: 
            case 178: 
            case 181: 
            case 184: 
            case 188: 
            case 262: 
            case 265: 
            case 268: 
            case 271: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 308: 
            case 309: 
            case 312: 
            case 314: 
            case 316: 
            case 318: 
            case 320: 
            case 332: 
            case 405: 
            case 417: 
            case 419: 
            case 426: 
            case 427: 
            case 437: 
            case 439: 
            case 442: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 58: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prepositions";
                break;
            }
            case 89: 
            case 255: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenizerDelim";
                break;
            }
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 258: 
            case 260: 
            case 313: 
            case 315: 
            case 317: 
            case 319: 
            case 321: 
            case 388: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 116: 
            case 131: 
            case 133: 
            case 135: 
            case 139: 
            case 141: 
            case 143: 
            case 273: 
            case 429: 
            case 431: 
            case 433: 
            case 435: 
            case 473: 
            case 487: 
            case 494: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixes";
                break;
            }
            case 137: 
            case 145: 
            case 366: 
            case 367: 
            case 386: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 151: 
            case 420: 
            case 424: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 158: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 160: 
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aThrowable";
                break;
            }
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackFrameSkipPattern";
                break;
            }
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 173: 
            case 176: 
            case 179: 
            case 182: 
            case 185: 
            case 201: 
            case 204: 
            case 215: 
            case 219: 
            case 224: 
            case 227: 
            case 231: 
            case 234: 
            case 238: 
            case 241: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 189: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separators";
                break;
            }
            case 191: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenizer";
                break;
            }
            case 200: 
            case 203: 
            case 209: 
            case 233: 
            case 237: 
            case 240: 
            case 243: 
            case 398: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 206: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings1";
                break;
            }
            case 207: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings2";
                break;
            }
            case 213: 
            case 217: 
            case 223: 
            case 225: 
            case 229: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 214: 
            case 218: 
            case 226: 
            case 230: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 232: 
            case 239: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 250: 
            case 253: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unitSeparator";
                break;
            }
            case 256: 
            case 257: 
            case 259: 
            case 261: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 263: 
            case 272: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 266: 
            case 269: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 274: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 300: 
            case 302: 
            case 304: 
            case 306: 
            case 460: 
            case 483: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 301: 
            case 303: 
            case 305: 
            case 307: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infix";
                break;
            }
            case 311: 
            case 323: 
            case 325: 
            case 329: 
            case 331: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subString";
                break;
            }
            case 349: 
            case 352: 
            case 357: 
            case 364: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 374: 
            case 376: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlString";
                break;
            }
            case 391: 
            case 395: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 392: 
            case 396: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 407: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 408: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 410: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 412: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 444: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 451: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 456: 
            case 458: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 468: 
            case 471: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSeparator";
                break;
            }
            case 474: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 475: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 482: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 486: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 488: {
                objectArray2 = objectArray3;
                objectArray3[0] = "smallPart";
                break;
            }
            case 489: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bigPart";
                break;
            }
            case 490: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 495: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstPrefix";
                break;
            }
            case 496: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/text/StringUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceSubSequence";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordsInStringLongestFirst";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "escapePattern";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createToStringFunction";
                break;
            }
            case 12: 
            case 393: 
            case 397: {
                objectArray = objectArray2;
                objectArray2[1] = "replace";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceIgnoreCase";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceChar";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "stripHtml";
                break;
            }
            case 37: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeLineBreak";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "wordsToBeginFromUpperCase";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "wordsToBeginFromLowerCase";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "toTitleCase";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "fixCapitalization";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "escaper";
                break;
            }
            case 68: 
            case 71: 
            case 74: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeStringCharacters";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeCharCharacters";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeStringCharacters";
                break;
            }
            case 84: 
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "unquoteString";
                break;
            }
            case 90: 
            case 91: 
            case 92: 
            case 154: 
            case 155: {
                objectArray = objectArray2;
                objectArray2[1] = "pluralize";
                break;
            }
            case 94: 
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalizeWords";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "decapitalize";
                break;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalize";
                break;
            }
            case 106: 
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalizeWithJavaBeanConvention";
                break;
            }
            case 120: 
            case 123: 
            case 124: 
            case 126: 
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "trimEnd";
                break;
            }
            case 129: 
            case 130: {
                objectArray = objectArray2;
                objectArray2[1] = "trimLog";
                break;
            }
            case 132: 
            case 134: 
            case 136: 
            case 138: {
                objectArray = objectArray2;
                objectArray2[1] = "trimLeading";
                break;
            }
            case 140: 
            case 142: 
            case 144: 
            case 146: {
                objectArray = objectArray2;
                objectArray2[1] = "trimTrailing";
                break;
            }
            case 149: 
            case 150: {
                objectArray = objectArray2;
                objectArray2[1] = "trimStart";
                break;
            }
            case 152: {
                objectArray = objectArray2;
                objectArray2[1] = "trimExtensions";
                break;
            }
            case 157: 
            case 159: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 161: 
            case 164: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowableText";
                break;
            }
            case 166: {
                objectArray = objectArray2;
                objectArray2[1] = "repeatSymbol";
                break;
            }
            case 168: 
            case 169: {
                objectArray = objectArray2;
                objectArray2[1] = "repeat";
                break;
            }
            case 171: {
                objectArray = objectArray2;
                objectArray2[1] = "splitHonorQuotes";
                break;
            }
            case 174: 
            case 177: 
            case 180: 
            case 183: 
            case 186: 
            case 187: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
            case 190: 
            case 192: {
                objectArray = objectArray2;
                objectArray2[1] = "tokenize";
                break;
            }
            case 194: 
            case 195: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordsIn";
                break;
            }
            case 197: 
            case 199: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordIndicesIn";
                break;
            }
            case 202: 
            case 205: 
            case 216: 
            case 220: 
            case 221: 
            case 222: 
            case 228: 
            case 235: 
            case 236: 
            case 242: 
            case 244: 
            case 245: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 208: {
                objectArray = objectArray2;
                objectArray2[1] = "zip";
                break;
            }
            case 212: {
                objectArray = objectArray2;
                objectArray2[1] = "surround";
                break;
            }
            case 247: 
            case 248: {
                objectArray = objectArray2;
                objectArray2[1] = "stripQuotesAroundValue";
                break;
            }
            case 249: 
            case 251: {
                objectArray = objectArray2;
                objectArray2[1] = "formatFileSize";
                break;
            }
            case 252: 
            case 254: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDuration";
                break;
            }
            case 264: {
                objectArray = objectArray2;
                objectArray2[1] = "strip";
                break;
            }
            case 267: 
            case 270: {
                objectArray = objectArray2;
                objectArray2[1] = "findMatches";
                break;
            }
            case 276: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceSubstring";
                break;
            }
            case 286: {
                objectArray = objectArray2;
                objectArray2[1] = "commonPrefix";
                break;
            }
            case 293: {
                objectArray = objectArray2;
                objectArray2[1] = "commonSuffix";
                break;
            }
            case 326: 
            case 327: {
                objectArray = objectArray2;
                objectArray2[1] = "substringBeforeLast";
                break;
            }
            case 334: 
            case 336: 
            case 337: 
            case 338: {
                objectArray = objectArray2;
                objectArray2[1] = "first";
                break;
            }
            case 340: 
            case 341: 
            case 342: {
                objectArray = objectArray2;
                objectArray2[1] = "last";
                break;
            }
            case 344: {
                objectArray = objectArray2;
                objectArray2[1] = "firstLast";
                break;
            }
            case 346: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeChar";
                break;
            }
            case 348: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeChars";
                break;
            }
            case 351: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeQuotes";
                break;
            }
            case 354: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeSlashes";
                break;
            }
            case 356: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeBackSlashes";
                break;
            }
            case 359: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeSlashes";
                break;
            }
            case 361: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeBackSlashes";
                break;
            }
            case 363: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeChar";
                break;
            }
            case 369: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithDoubleQuote";
                break;
            }
            case 371: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeXmlEntities";
                break;
            }
            case 373: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeXmlEntities";
                break;
            }
            case 375: 
            case 377: 
            case 378: {
                objectArray = objectArray2;
                objectArray2[1] = "removeHtmlTags";
                break;
            }
            case 380: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeMnemonics";
                break;
            }
            case 382: {
                objectArray = objectArray2;
                objectArray2[1] = "htmlEmphasize";
                break;
            }
            case 384: 
            case 387: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeToRegexp";
                break;
            }
            case 399: 
            case 400: {
                objectArray = objectArray2;
                objectArray2[1] = "filterEmptyStrings";
                break;
            }
            case 406: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalsOnly";
                break;
            }
            case 411: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeProperty";
                break;
            }
            case 413: 
            case 414: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 421: 
            case 422: 
            case 423: {
                objectArray = objectArray2;
                objectArray2[1] = "fixVariableNameDerivedFromPropertyName";
                break;
            }
            case 425: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeJavaIdentifier";
                break;
            }
            case 428: {
                objectArray = objectArray2;
                objectArray2[1] = "tail";
                break;
            }
            case 430: 
            case 432: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLines";
                break;
            }
            case 434: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLinesDontTrim";
                break;
            }
            case 436: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLinesKeepSeparators";
                break;
            }
            case 438: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordsWithOffset";
                break;
            }
            case 445: {
                objectArray = objectArray2;
                objectArray2[1] = "formatLinks";
                break;
            }
            case 447: 
            case 452: 
            case 453: 
            case 455: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenTextWithEllipsis";
                break;
            }
            case 449: {
                objectArray = objectArray2;
                objectArray2[1] = "trimMiddle";
                break;
            }
            case 457: 
            case 459: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenPathWithEllipsis";
                break;
            }
            case 464: 
            case 466: 
            case 469: 
            case 472: {
                objectArray = objectArray2;
                objectArray2[1] = "convertLineSeparators";
                break;
            }
            case 476: 
            case 478: 
            case 480: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 484: {
                objectArray = objectArray2;
                objectArray2[1] = "newBombedCharSequence";
                break;
            }
            case 491: {
                objectArray = objectArray2;
                objectArray2[1] = "toHexString";
                break;
            }
            case 493: {
                objectArray = objectArray2;
                objectArray2[1] = "parseHexString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replaceSubSequence";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 16: 
            case 18: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 44: 
            case 52: 
            case 54: 
            case 56: 
            case 59: 
            case 63: 
            case 68: 
            case 71: 
            case 74: 
            case 76: 
            case 78: 
            case 80: 
            case 84: 
            case 86: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 97: 
            case 99: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 120: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 129: 
            case 130: 
            case 132: 
            case 134: 
            case 136: 
            case 138: 
            case 140: 
            case 142: 
            case 144: 
            case 146: 
            case 149: 
            case 150: 
            case 152: 
            case 154: 
            case 155: 
            case 157: 
            case 159: 
            case 161: 
            case 164: 
            case 166: 
            case 168: 
            case 169: 
            case 171: 
            case 174: 
            case 177: 
            case 180: 
            case 183: 
            case 186: 
            case 187: 
            case 190: 
            case 192: 
            case 194: 
            case 195: 
            case 197: 
            case 199: 
            case 202: 
            case 205: 
            case 208: 
            case 212: 
            case 216: 
            case 220: 
            case 221: 
            case 222: 
            case 228: 
            case 235: 
            case 236: 
            case 242: 
            case 244: 
            case 245: 
            case 247: 
            case 248: 
            case 249: 
            case 251: 
            case 252: 
            case 254: 
            case 264: 
            case 267: 
            case 270: 
            case 276: 
            case 286: 
            case 293: 
            case 326: 
            case 327: 
            case 334: 
            case 336: 
            case 337: 
            case 338: 
            case 340: 
            case 341: 
            case 342: 
            case 344: 
            case 346: 
            case 348: 
            case 351: 
            case 354: 
            case 356: 
            case 359: 
            case 361: 
            case 363: 
            case 369: 
            case 371: 
            case 373: 
            case 375: 
            case 377: 
            case 378: 
            case 380: 
            case 382: 
            case 384: 
            case 387: 
            case 393: 
            case 397: 
            case 399: 
            case 400: 
            case 406: 
            case 411: 
            case 413: 
            case 414: 
            case 421: 
            case 422: 
            case 423: 
            case 425: 
            case 428: 
            case 430: 
            case 432: 
            case 434: 
            case 436: 
            case 438: 
            case 445: 
            case 447: 
            case 449: 
            case 452: 
            case 453: 
            case 455: 
            case 457: 
            case 459: 
            case 464: 
            case 466: 
            case 469: 
            case 472: 
            case 476: 
            case 478: 
            case 480: 
            case 484: 
            case 491: 
            case 493: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getWordsInStringLongestFirst";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "escapePattern";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createToStringFunction";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 19: 
            case 20: 
            case 21: 
            case 390: 
            case 391: 
            case 392: 
            case 394: 
            case 395: 
            case 396: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "replaceIgnoreCase";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "replaceChar";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "indexOfIgnoreCase";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOfIgnoreCase";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "containsIgnoreCase";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "endsWithIgnoreCase";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "startsWithIgnoreCase";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "stripHtml";
                break;
            }
            case 36: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getLineBreakCount";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "containsLineBreak";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "escapeLineBreak";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "endsWithLineBreak";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "lineColToOffset";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "offsetToLineNumber";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "offsetToLineColumn";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "difference";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "wordsToBeginFromUpperCase";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "wordsToBeginFromLowerCase";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "toTitleCase";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "fixCapitalization";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "isPreposition";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "escapeStringCharacters";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "escapeCharCharacters";
                break;
            }
            case 79: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "unescapeStringCharacters";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "isQuoteAt";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "isQuotedString";
                break;
            }
            case 83: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "unquoteString";
                break;
            }
            case 89: 
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "pluralize";
                break;
            }
            case 93: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "capitalizeWords";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "decapitalize";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "capitalize";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "capitalizeWithJavaBeanConvention";
                break;
            }
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCode";
                break;
            }
            case 110: 
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCodeInsensitive";
                break;
            }
            case 113: 
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCodeIgnoreWhitespaces";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "startsWithConcatenation";
                break;
            }
            case 118: 
            case 119: 
            case 121: 
            case 122: 
            case 125: 
            case 485: 
            case 486: {
                objectArray = objectArray;
                objectArray[2] = "trimEnd";
                break;
            }
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "trimLog";
                break;
            }
            case 131: 
            case 133: 
            case 135: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "trimLeading";
                break;
            }
            case 139: 
            case 141: 
            case 143: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "trimTrailing";
                break;
            }
            case 147: 
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "trimStart";
                break;
            }
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "trimExtensions";
                break;
            }
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "repeatSymbol";
                break;
            }
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "notNullize";
                break;
            }
            case 160: 
            case 162: 
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "getThrowableText";
                break;
            }
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "repeat";
                break;
            }
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "splitHonorQuotes";
                break;
            }
            case 172: 
            case 173: 
            case 175: 
            case 176: 
            case 178: 
            case 179: 
            case 181: 
            case 182: 
            case 184: 
            case 185: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 188: 
            case 189: 
            case 191: {
                objectArray = objectArray;
                objectArray[2] = "tokenize";
                break;
            }
            case 193: {
                objectArray = objectArray;
                objectArray[2] = "getWordsIn";
                break;
            }
            case 196: 
            case 198: {
                objectArray = objectArray;
                objectArray[2] = "getWordIndicesIn";
                break;
            }
            case 200: 
            case 201: 
            case 203: 
            case 204: 
            case 213: 
            case 214: 
            case 215: 
            case 217: 
            case 218: 
            case 219: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 243: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 206: 
            case 207: {
                objectArray = objectArray;
                objectArray[2] = "zip";
                break;
            }
            case 209: 
            case 210: 
            case 211: {
                objectArray = objectArray;
                objectArray[2] = "surround";
                break;
            }
            case 246: {
                objectArray = objectArray;
                objectArray[2] = "stripQuotesAroundValue";
                break;
            }
            case 250: {
                objectArray = objectArray;
                objectArray[2] = "formatFileSize";
                break;
            }
            case 253: {
                objectArray = objectArray;
                objectArray[2] = "formatDuration";
                break;
            }
            case 255: {
                objectArray = objectArray;
                objectArray[2] = "unpluralize";
                break;
            }
            case 256: {
                objectArray = objectArray;
                objectArray[2] = "containsAlphaCharacters";
                break;
            }
            case 257: 
            case 258: 
            case 259: 
            case 260: {
                objectArray = objectArray;
                objectArray[2] = "containsAnyChar";
                break;
            }
            case 261: {
                objectArray = objectArray;
                objectArray[2] = "containsChar";
                break;
            }
            case 262: 
            case 263: {
                objectArray = objectArray;
                objectArray[2] = "strip";
                break;
            }
            case 265: 
            case 266: 
            case 268: 
            case 269: {
                objectArray = objectArray;
                objectArray[2] = "findMatches";
                break;
            }
            case 271: 
            case 272: {
                objectArray = objectArray;
                objectArray[2] = "findFirst";
                break;
            }
            case 273: 
            case 274: 
            case 275: {
                objectArray = objectArray;
                objectArray[2] = "replaceSubstring";
                break;
            }
            case 277: {
                objectArray = objectArray;
                objectArray[2] = "startsWithWhitespace";
                break;
            }
            case 278: 
            case 279: 
            case 280: 
            case 281: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 282: 
            case 283: {
                objectArray = objectArray;
                objectArray[2] = "endsWith";
                break;
            }
            case 284: 
            case 285: {
                objectArray = objectArray;
                objectArray[2] = "commonPrefix";
                break;
            }
            case 287: 
            case 288: 
            case 289: 
            case 290: {
                objectArray = objectArray;
                objectArray[2] = "commonPrefixLength";
                break;
            }
            case 291: 
            case 292: {
                objectArray = objectArray;
                objectArray[2] = "commonSuffix";
                break;
            }
            case 294: 
            case 295: {
                objectArray = objectArray;
                objectArray[2] = "commonSuffixLength";
                break;
            }
            case 296: 
            case 300: 
            case 301: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 297: 
            case 298: 
            case 299: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 310: 
            case 311: {
                objectArray = objectArray;
                objectArray[2] = "indexOfSubstringEnd";
                break;
            }
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 316: 
            case 317: 
            case 318: 
            case 319: {
                objectArray = objectArray;
                objectArray[2] = "indexOfAny";
                break;
            }
            case 320: 
            case 321: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOfAny";
                break;
            }
            case 322: 
            case 323: {
                objectArray = objectArray;
                objectArray[2] = "substringBefore";
                break;
            }
            case 324: 
            case 325: {
                objectArray = objectArray;
                objectArray[2] = "substringBeforeLast";
                break;
            }
            case 328: 
            case 329: {
                objectArray = objectArray;
                objectArray[2] = "substringAfter";
                break;
            }
            case 330: 
            case 331: {
                objectArray = objectArray;
                objectArray[2] = "substringAfterLast";
                break;
            }
            case 332: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 333: 
            case 335: {
                objectArray = objectArray;
                objectArray[2] = "first";
                break;
            }
            case 339: {
                objectArray = objectArray;
                objectArray[2] = "last";
                break;
            }
            case 343: {
                objectArray = objectArray;
                objectArray[2] = "firstLast";
                break;
            }
            case 345: 
            case 349: {
                objectArray = objectArray;
                objectArray[2] = "escapeChar";
                break;
            }
            case 347: {
                objectArray = objectArray;
                objectArray[2] = "escapeChars";
                break;
            }
            case 350: 
            case 352: {
                objectArray = objectArray;
                objectArray[2] = "escapeQuotes";
                break;
            }
            case 353: 
            case 357: {
                objectArray = objectArray;
                objectArray[2] = "escapeSlashes";
                break;
            }
            case 355: {
                objectArray = objectArray;
                objectArray[2] = "escapeBackSlashes";
                break;
            }
            case 358: {
                objectArray = objectArray;
                objectArray[2] = "unescapeSlashes";
                break;
            }
            case 360: {
                objectArray = objectArray;
                objectArray[2] = "unescapeBackSlashes";
                break;
            }
            case 362: 
            case 364: 
            case 365: {
                objectArray = objectArray;
                objectArray[2] = "unescapeChar";
                break;
            }
            case 366: 
            case 367: {
                objectArray = objectArray;
                objectArray[2] = "quote";
                break;
            }
            case 368: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithDoubleQuote";
                break;
            }
            case 370: {
                objectArray = objectArray;
                objectArray[2] = "unescapeXmlEntities";
                break;
            }
            case 372: {
                objectArray = objectArray;
                objectArray[2] = "escapeXmlEntities";
                break;
            }
            case 374: 
            case 376: {
                objectArray = objectArray;
                objectArray[2] = "removeHtmlTags";
                break;
            }
            case 379: {
                objectArray = objectArray;
                objectArray[2] = "escapeMnemonics";
                break;
            }
            case 381: {
                objectArray = objectArray;
                objectArray[2] = "htmlEmphasize";
                break;
            }
            case 383: 
            case 385: 
            case 386: {
                objectArray = objectArray;
                objectArray[2] = "escapeToRegexp";
                break;
            }
            case 388: 
            case 389: {
                objectArray = objectArray;
                objectArray[2] = "isEscapedBackslash";
                break;
            }
            case 398: {
                objectArray = objectArray;
                objectArray[2] = "filterEmptyStrings";
                break;
            }
            case 401: {
                objectArray = objectArray;
                objectArray[2] = "countNewLines";
                break;
            }
            case 402: 
            case 403: 
            case 404: {
                objectArray = objectArray;
                objectArray[2] = "countChars";
                break;
            }
            case 405: {
                objectArray = objectArray;
                objectArray[2] = "capitalsOnly";
                break;
            }
            case 407: {
                objectArray = objectArray;
                objectArray[2] = "joinOrNull";
                break;
            }
            case 408: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyName";
                break;
            }
            case 409: {
                objectArray = objectArray;
                objectArray[2] = "isJavaIdentifier";
                break;
            }
            case 410: {
                objectArray = objectArray;
                objectArray[2] = "escapeProperty";
                break;
            }
            case 412: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 415: 
            case 416: 
            case 417: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrenceCount";
                break;
            }
            case 418: 
            case 419: {
                objectArray = objectArray;
                objectArray[2] = "getIgnoreCaseOccurrenceCount";
                break;
            }
            case 420: {
                objectArray = objectArray;
                objectArray[2] = "fixVariableNameDerivedFromPropertyName";
                break;
            }
            case 424: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeJavaIdentifier";
                break;
            }
            case 426: {
                objectArray = objectArray;
                objectArray[2] = "assertValidSeparators";
                break;
            }
            case 427: {
                objectArray = objectArray;
                objectArray[2] = "tail";
                break;
            }
            case 429: 
            case 431: {
                objectArray = objectArray;
                objectArray[2] = "splitByLines";
                break;
            }
            case 433: {
                objectArray = objectArray;
                objectArray[2] = "splitByLinesDontTrim";
                break;
            }
            case 435: {
                objectArray = objectArray;
                objectArray[2] = "splitByLinesKeepSeparators";
                break;
            }
            case 437: {
                objectArray = objectArray;
                objectArray[2] = "getWordsWithOffset";
                break;
            }
            case 439: {
                objectArray = objectArray;
                objectArray[2] = "hashCode";
                break;
            }
            case 440: 
            case 441: {
                objectArray = objectArray;
                objectArray[2] = "equalsTrimWhitespaces";
                break;
            }
            case 442: {
                objectArray = objectArray;
                objectArray[2] = "collapseWhiteSpace";
                break;
            }
            case 443: {
                objectArray = objectArray;
                objectArray[2] = "findIgnoreCase";
                break;
            }
            case 444: {
                objectArray = objectArray;
                objectArray[2] = "formatLinks";
                break;
            }
            case 446: 
            case 450: 
            case 451: 
            case 454: {
                objectArray = objectArray;
                objectArray[2] = "shortenTextWithEllipsis";
                break;
            }
            case 448: {
                objectArray = objectArray;
                objectArray[2] = "trimMiddle";
                break;
            }
            case 456: 
            case 458: {
                objectArray = objectArray;
                objectArray[2] = "shortenPathWithEllipsis";
                break;
            }
            case 460: {
                objectArray = objectArray;
                objectArray[2] = "isUpperCase";
                break;
            }
            case 461: {
                objectArray = objectArray;
                objectArray[2] = "detectSeparators";
                break;
            }
            case 462: {
                objectArray = objectArray;
                objectArray[2] = "getLineSeparatorAt";
                break;
            }
            case 463: 
            case 465: 
            case 467: 
            case 468: 
            case 470: 
            case 471: {
                objectArray = objectArray;
                objectArray[2] = "convertLineSeparators";
                break;
            }
            case 473: 
            case 474: {
                objectArray = objectArray;
                objectArray[2] = "parseEnum";
                break;
            }
            case 475: 
            case 477: 
            case 479: {
                objectArray = objectArray;
                objectArray[2] = "getShortName";
                break;
            }
            case 481: 
            case 482: {
                objectArray = objectArray;
                objectArray[2] = "isShortNameOf";
                break;
            }
            case 483: {
                objectArray = objectArray;
                objectArray[2] = "newBombedCharSequence";
                break;
            }
            case 487: 
            case 488: 
            case 489: {
                objectArray = objectArray;
                objectArray[2] = "isBetween";
                break;
            }
            case 490: {
                objectArray = objectArray;
                objectArray[2] = "toHexString";
                break;
            }
            case 492: {
                objectArray = objectArray;
                objectArray[2] = "parseHexString";
                break;
            }
            case 494: 
            case 495: 
            case 496: {
                objectArray = objectArray;
                objectArray[2] = "startsWithConcatenationOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 16: 
            case 18: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 44: 
            case 52: 
            case 54: 
            case 56: 
            case 59: 
            case 63: 
            case 68: 
            case 71: 
            case 74: 
            case 76: 
            case 78: 
            case 80: 
            case 84: 
            case 86: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 97: 
            case 99: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 120: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 129: 
            case 130: 
            case 132: 
            case 134: 
            case 136: 
            case 138: 
            case 140: 
            case 142: 
            case 144: 
            case 146: 
            case 149: 
            case 150: 
            case 152: 
            case 154: 
            case 155: 
            case 157: 
            case 159: 
            case 161: 
            case 164: 
            case 166: 
            case 168: 
            case 169: 
            case 171: 
            case 174: 
            case 177: 
            case 180: 
            case 183: 
            case 186: 
            case 187: 
            case 190: 
            case 192: 
            case 194: 
            case 195: 
            case 197: 
            case 199: 
            case 202: 
            case 205: 
            case 208: 
            case 212: 
            case 216: 
            case 220: 
            case 221: 
            case 222: 
            case 228: 
            case 235: 
            case 236: 
            case 242: 
            case 244: 
            case 245: 
            case 247: 
            case 248: 
            case 249: 
            case 251: 
            case 252: 
            case 254: 
            case 264: 
            case 267: 
            case 270: 
            case 276: 
            case 286: 
            case 293: 
            case 326: 
            case 327: 
            case 334: 
            case 336: 
            case 337: 
            case 338: 
            case 340: 
            case 341: 
            case 342: 
            case 344: 
            case 346: 
            case 348: 
            case 351: 
            case 354: 
            case 356: 
            case 359: 
            case 361: 
            case 363: 
            case 369: 
            case 371: 
            case 373: 
            case 375: 
            case 377: 
            case 378: 
            case 380: 
            case 382: 
            case 384: 
            case 387: 
            case 393: 
            case 397: 
            case 399: 
            case 400: 
            case 406: 
            case 411: 
            case 413: 
            case 414: 
            case 421: 
            case 422: 
            case 423: 
            case 425: 
            case 428: 
            case 430: 
            case 432: 
            case 434: 
            case 436: 
            case 438: 
            case 445: 
            case 447: 
            case 449: 
            case 452: 
            case 453: 
            case 455: 
            case 457: 
            case 459: 
            case 464: 
            case 466: 
            case 469: 
            case 472: 
            case 476: 
            case 478: 
            case 480: 
            case 484: 
            case 491: 
            case 493: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class BombedCharSequence
    implements CharSequence {
        private final CharSequence delegate;
        private int i;
        private boolean myDefused;

        public BombedCharSequence(@NotNull CharSequence sequence) {
            if (sequence == null) {
                BombedCharSequence.$$$reportNull$$$0(0);
            }
            this.delegate = sequence;
        }

        @Override
        public int length() {
            this.check();
            return this.delegate.length();
        }

        @Override
        public char charAt(int i) {
            this.check();
            return this.delegate.charAt(i);
        }

        protected void check() {
            if (this.myDefused) {
                return;
            }
            if ((++this.i & 0x3FF) == 0) {
                this.checkCanceled();
            }
        }

        public final void defuse() {
            this.myDefused = true;
        }

        @Override
        @NotNull
        public String toString() {
            this.check();
            String string = this.delegate.toString();
            if (string == null) {
                BombedCharSequence.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected abstract void checkCanceled();

        @Override
        @NotNull
        public CharSequence subSequence(int i, int i1) {
            this.check();
            CharSequence charSequence = this.delegate.subSequence(i, i1);
            if (charSequence == null) {
                BombedCharSequence.$$$reportNull$$$0(2);
            }
            return charSequence;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sequence";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/text/StringUtil$BombedCharSequence";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/text/StringUtil$BombedCharSequence";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "subSequence";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyHtml2Text
    extends HTMLEditorKit.ParserCallback {
        @NotNull
        private final StringBuilder myBuffer = new StringBuilder();
        private final boolean myIsSkipStyleTag;
        private boolean myIsStyleTagOpened;

        private MyHtml2Text(boolean isSkipStyleTag) {
            this.myIsSkipStyleTag = isSkipStyleTag;
        }

        public void parse(@NotNull Reader in) throws IOException {
            if (in == null) {
                MyHtml2Text.$$$reportNull$$$0(0);
            }
            this.myBuffer.setLength(0);
            new ParserDelegator().parse(in, this, Boolean.TRUE);
        }

        @Override
        public void handleText(@NotNull char[] text, int pos) {
            if (text == null) {
                MyHtml2Text.$$$reportNull$$$0(1);
            }
            if (!this.myIsStyleTagOpened) {
                this.myBuffer.append(text);
            }
        }

        @Override
        public void handleStartTag(@NotNull HTML.Tag tag, MutableAttributeSet set, int i) {
            if (tag == null) {
                MyHtml2Text.$$$reportNull$$$0(2);
            }
            if (this.myIsSkipStyleTag && "style".equals(tag.toString())) {
                this.myIsStyleTagOpened = true;
            }
            this.handleTag(tag);
        }

        @Override
        public void handleEndTag(@NotNull HTML.Tag tag, int pos) {
            if (tag == null) {
                MyHtml2Text.$$$reportNull$$$0(3);
            }
            if (this.myIsSkipStyleTag && "style".equals(tag.toString())) {
                this.myIsStyleTagOpened = false;
            }
        }

        @Override
        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet set, int i) {
            this.handleTag(tag);
        }

        private void handleTag(@NotNull HTML.Tag tag) {
            if (tag == null) {
                MyHtml2Text.$$$reportNull$$$0(4);
            }
            if (tag.breaksFlow() && this.myBuffer.length() > 0) {
                this.myBuffer.append(SystemProperties.getLineSeparator());
            }
        }

        @NotNull
        public String getText() {
            String string = this.myBuffer.toString();
            if (string == null) {
                MyHtml2Text.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/text/StringUtil$MyHtml2Text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/text/StringUtil$MyHtml2Text";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "parse";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "handleText";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "handleStartTag";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "handleEndTag";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "handleTag";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

