/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.Patches;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.win32.FileInfo;
import com.intellij.openapi.util.io.win32.IdeaWin32;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSystemUtil {
    static final String FORCE_USE_NIO2_KEY = "idea.io.use.nio2";
    static final String FORCE_USE_FALLBACK_KEY = "idea.io.use.fallback";
    static final String COARSE_TIMESTAMP_KEY = "idea.io.coarse.ts";
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.io.FileSystemUtil");
    @NotNull
    private static Mediator ourMediator = FileSystemUtil.getMediator();

    private static Mediator getMediator() {
        boolean forceNio2 = SystemProperties.getBooleanProperty(FORCE_USE_NIO2_KEY, false);
        boolean forceFallback = SystemProperties.getBooleanProperty(FORCE_USE_FALLBACK_KEY, false);
        Throwable error = null;
        if (!forceNio2 && !forceFallback) {
            if (SystemInfo.isWindows && IdeaWin32.isAvailable()) {
                try {
                    return FileSystemUtil.check(new IdeaWin32MediatorImpl());
                }
                catch (Throwable t) {
                    error = t;
                }
            } else if (SystemInfo.isLinux || SystemInfo.isMac || SystemInfo.isSolaris || SystemInfo.isFreeBSD) {
                try {
                    return FileSystemUtil.check(new JnaUnixMediatorImpl());
                }
                catch (Throwable t) {
                    error = t;
                }
            }
        }
        if (!forceFallback && SystemInfo.isJavaVersionAtLeast(7, 0, 0) && !"1.7.0-ea".equals(SystemInfo.JAVA_VERSION)) {
            try {
                return FileSystemUtil.check(new Nio2MediatorImpl());
            }
            catch (Throwable t) {
                error = t;
            }
        }
        if (!forceFallback) {
            LOG.warn("Failed to load filesystem access layer: " + SystemInfo.OS_NAME + ", " + SystemInfo.JAVA_VERSION + ", nio2=" + forceNio2, error);
        }
        return new FallbackMediatorImpl();
    }

    private static Mediator check(Mediator mediator) throws Exception {
        String quickTestPath = SystemInfo.isWindows ? "C:\\" : "/";
        mediator.getAttributes(quickTestPath);
        return mediator;
    }

    private FileSystemUtil() {
    }

    @Nullable
    public static FileAttributes getAttributes(@NotNull String path) {
        if (path == null) {
            FileSystemUtil.$$$reportNull$$$0(0);
        }
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("getAttributes(" + path + ")");
                long t = System.nanoTime();
                FileAttributes result = ourMediator.getAttributes(path);
                t = (System.nanoTime() - t) / 1000L;
                LOG.trace("  " + t + " mks");
                return result;
            }
            return ourMediator.getAttributes(path);
        }
        catch (Exception e) {
            LOG.warn(e);
            return null;
        }
    }

    @Nullable
    public static FileAttributes getAttributes(@NotNull File file) {
        if (file == null) {
            FileSystemUtil.$$$reportNull$$$0(1);
        }
        return FileSystemUtil.getAttributes(file.getPath());
    }

    public static long lastModified(@NotNull File file) {
        FileAttributes attributes;
        if (file == null) {
            FileSystemUtil.$$$reportNull$$$0(2);
        }
        return (attributes = FileSystemUtil.getAttributes(file)) != null ? attributes.lastModified : 0L;
    }

    public static boolean isSymLink(@NotNull String path) {
        if (path == null) {
            FileSystemUtil.$$$reportNull$$$0(3);
        }
        if (SystemInfo.areSymLinksSupported) {
            FileAttributes attributes = FileSystemUtil.getAttributes(path);
            return attributes != null && attributes.isSymLink();
        }
        return false;
    }

    public static boolean isSymLink(@NotNull File file) {
        if (file == null) {
            FileSystemUtil.$$$reportNull$$$0(4);
        }
        return FileSystemUtil.isSymLink(file.getAbsolutePath());
    }

    @Nullable
    public static String resolveSymLink(@NotNull String path) {
        if (path == null) {
            FileSystemUtil.$$$reportNull$$$0(5);
        }
        try {
            String realPath;
            if (LOG.isTraceEnabled()) {
                LOG.trace("resolveSymLink(" + path + ")");
                long t = System.nanoTime();
                realPath = ourMediator.resolveSymLink(path);
                t = (System.nanoTime() - t) / 1000L;
                LOG.trace("  " + t + " mks");
            } else {
                realPath = ourMediator.resolveSymLink(path);
            }
            if (realPath != null && (SystemInfo.isWindows && realPath.startsWith("\\\\") || new File(realPath).exists())) {
                return realPath;
            }
        }
        catch (Exception e) {
            LOG.warn(e);
        }
        return null;
    }

    @Nullable
    public static String resolveSymLink(@NotNull File file) {
        if (file == null) {
            FileSystemUtil.$$$reportNull$$$0(6);
        }
        return FileSystemUtil.resolveSymLink(file.getAbsolutePath());
    }

    public static boolean clonePermissions(@NotNull String source, @NotNull String target) {
        if (source == null) {
            FileSystemUtil.$$$reportNull$$$0(7);
        }
        if (target == null) {
            FileSystemUtil.$$$reportNull$$$0(8);
        }
        try {
            return ourMediator.clonePermissions(source, target, false);
        }
        catch (Exception e) {
            LOG.warn(e);
            return false;
        }
    }

    public static boolean clonePermissionsToExecute(@NotNull String source, @NotNull String target) {
        if (source == null) {
            FileSystemUtil.$$$reportNull$$$0(9);
        }
        if (target == null) {
            FileSystemUtil.$$$reportNull$$$0(10);
        }
        try {
            return ourMediator.clonePermissions(source, target, true);
        }
        catch (Exception e) {
            LOG.warn(e);
            return false;
        }
    }

    static void resetMediator() {
        ourMediator = FileSystemUtil.getMediator();
    }

    static String getMediatorName() {
        return FileSystemUtil.ourMediator.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/util/io/FileSystemUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAttributes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lastModified";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isSymLink";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveSymLink";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "clonePermissions";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "clonePermissionsToExecute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class FallbackMediatorImpl
    extends Mediator {
        private static final int BA_REGULAR = 2;
        private static final int BA_DIRECTORY = 4;
        private static final int BA_HIDDEN = 8;
        private final Object myFileSystem;
        private final Method myGetBooleanAttributes;

        private FallbackMediatorImpl() {
            Method getBooleanAttributes;
            Object fileSystem;
            try {
                Field fs = File.class.getDeclaredField("fs");
                fs.setAccessible(true);
                fileSystem = fs.get(null);
                getBooleanAttributes = fileSystem.getClass().getMethod("getBooleanAttributes", File.class);
                getBooleanAttributes.setAccessible(true);
            }
            catch (Throwable t) {
                fileSystem = null;
                getBooleanAttributes = null;
            }
            this.myFileSystem = fileSystem;
            this.myGetBooleanAttributes = getBooleanAttributes;
        }

        @Override
        protected FileAttributes getAttributes(@NotNull String path) throws Exception {
            if (path == null) {
                FallbackMediatorImpl.$$$reportNull$$$0(0);
            }
            File file = new File(path);
            if (this.myFileSystem != null) {
                int flags = (Integer)this.myGetBooleanAttributes.invoke(this.myFileSystem, file);
                if (flags != 0) {
                    boolean isDirectory = BitUtil.isSet(flags, 4);
                    boolean isSpecial = !BitUtil.isSet(flags, 2) && !BitUtil.isSet(flags, 4);
                    boolean isHidden = BitUtil.isSet(flags, 8) && !FallbackMediatorImpl.isWindowsRoot(path);
                    boolean isWritable = SystemInfo.isWindows && isDirectory || file.canWrite();
                    return new FileAttributes(isDirectory, isSpecial, false, isHidden, file.length(), file.lastModified(), isWritable);
                }
            } else if (file.exists()) {
                boolean isDirectory = file.isDirectory();
                boolean isSpecial = !isDirectory && !file.isFile();
                boolean isHidden = file.isHidden() && !FallbackMediatorImpl.isWindowsRoot(path);
                boolean isWritable = SystemInfo.isWindows && isDirectory || file.canWrite();
                return new FileAttributes(isDirectory, isSpecial, false, isHidden, file.length(), file.lastModified(), isWritable);
            }
            return null;
        }

        private static boolean isWindowsRoot(String p) {
            return SystemInfo.isWindows && p.length() >= 2 && p.length() <= 3 && Character.isLetter(p.charAt(0)) && p.charAt(1) == ':';
        }

        @Override
        protected String resolveSymLink(@NotNull String path) throws Exception {
            if (path == null) {
                FallbackMediatorImpl.$$$reportNull$$$0(1);
            }
            return new File(path).getCanonicalPath();
        }

        @Override
        protected boolean clonePermissions(@NotNull String source, @NotNull String target, boolean onlyPermissionsToExecute) {
            if (source == null) {
                FallbackMediatorImpl.$$$reportNull$$$0(2);
            }
            if (target == null) {
                FallbackMediatorImpl.$$$reportNull$$$0(3);
            }
            if (SystemInfo.isUnix) {
                File srcFile = new File(source);
                File dstFile = new File(target);
                if (!onlyPermissionsToExecute && !dstFile.setWritable(srcFile.canWrite(), true)) {
                    return false;
                }
                return dstFile.setExecutable(srcFile.canExecute(), true);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/util/io/FileSystemUtil$FallbackMediatorImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getAttributes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveSymLink";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clonePermissions";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class JnaUnixMediatorImpl
    extends Mediator {
        private static final int[] LINUX_32 = new int[]{16, 44, 72, 24, 28};
        private static final int[] LINUX_64 = new int[]{24, 48, 88, 28, 32};
        private static final int[] LNX_PPC32 = new int[]{16, 48, 80, 24, 28};
        private static final int[] LNX_PPC64 = LINUX_64;
        private static final int[] LNX_ARM32 = LNX_PPC32;
        private static final int[] BSD_32 = new int[]{8, 48, 32, 12, 16};
        private static final int[] BSD_64 = new int[]{8, 72, 40, 12, 16};
        private static final int[] BSD_32_12 = new int[]{24, 96, 64, 28, 32};
        private static final int[] BSD_64_12 = new int[]{24, 112, 64, 28, 32};
        private static final int[] SUN_OS_32 = new int[]{20, 48, 64, 28, 32};
        private static final int[] SUN_OS_64 = new int[]{16, 40, 64, 24, 28};
        private static final int STAT_VER = 1;
        private static final int OFF_MODE = 0;
        private static final int OFF_SIZE = 1;
        private static final int OFF_TIME = 2;
        private static final int OFF_UID = 3;
        private static final int OFF_GID = 4;
        private final int[] myOffsets;
        private final int myUid;
        private final int myGid;
        private final boolean myCoarseTs = SystemProperties.getBooleanProperty("idea.io.coarse.ts", false);

        private JnaUnixMediatorImpl() {
            if ("linux-x86".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = LINUX_32;
            } else if ("linux-x86-64".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = LINUX_64;
            } else if ("linux-arm".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = LNX_ARM32;
            } else if ("linux-ppc".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = LNX_PPC32;
            } else if ("linux-ppc64le".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = LNX_PPC64;
            } else if ("darwin".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = BSD_64;
            } else if ("freebsd-x86".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = SystemInfo.isOsVersionAtLeast("12") ? BSD_32_12 : BSD_32;
            } else if ("freebsd-x86-64".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = SystemInfo.isOsVersionAtLeast("12") ? BSD_64_12 : BSD_64;
            } else if ("sunos-x86".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = SUN_OS_32;
            } else if ("sunos-x86-64".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = SUN_OS_64;
            } else {
                throw new IllegalStateException("Unsupported OS/arch: " + SystemInfo.OS_NAME + "/" + SystemInfo.OS_ARCH);
            }
            Map<String, String> options = Collections.singletonMap("string-encoding", CharsetToolkit.getPlatformCharset().name());
            NativeLibrary lib = NativeLibrary.getInstance((String)"c", options);
            Native.register(LibC.class, (NativeLibrary)lib);
            Native.register(SystemInfo.isLinux ? LinuxLibC.class : UnixLibC.class, (NativeLibrary)lib);
            this.myUid = LibC.getuid();
            this.myGid = LibC.getgid();
        }

        @Override
        protected FileAttributes getAttributes(@NotNull String path) {
            long mTime1;
            boolean isSymlink;
            int res;
            if (path == null) {
                JnaUnixMediatorImpl.$$$reportNull$$$0(0);
            }
            Memory buffer = new Memory(256L);
            int n = res = SystemInfo.isLinux ? LinuxLibC.__lxstat64(1, path, (Pointer)buffer) : UnixLibC.lstat(path, (Pointer)buffer);
            if (res != 0) {
                return null;
            }
            int mode = this.getModeFlags(buffer) & 0xFFFF;
            boolean bl = isSymlink = (mode & 0xF000) == 40960;
            if (isSymlink) {
                if (!JnaUnixMediatorImpl.loadFileStatus(path, buffer)) {
                    return FileAttributes.BROKEN_SYMLINK;
                }
                mode = this.getModeFlags(buffer) & 0xFFFF;
            }
            boolean isDirectory = (mode & 0xF000) == 16384;
            boolean isSpecial = !isDirectory && (mode & 0xF000) != 32768;
            long size = buffer.getLong((long)this.myOffsets[1]);
            long l = mTime1 = SystemInfo.is32Bit ? (long)buffer.getInt((long)this.myOffsets[2]) : buffer.getLong((long)this.myOffsets[2]);
            long mTime2 = this.myCoarseTs ? 0L : (SystemInfo.is32Bit ? (long)buffer.getInt((long)(this.myOffsets[2] + 4)) : buffer.getLong((long)(this.myOffsets[2] + 8)));
            long mTime = mTime1 * 1000L + mTime2 / 1000000L;
            boolean writable = this.ownFile(buffer) ? (mode & 0x92) != 0 : LibC.access(path, 2) == 0;
            return new FileAttributes(isDirectory, isSpecial, isSymlink, false, size, mTime, writable);
        }

        @Override
        protected String resolveSymLink(@NotNull String path) throws Exception {
            if (path == null) {
                JnaUnixMediatorImpl.$$$reportNull$$$0(1);
            }
            try {
                return new File(path).getCanonicalPath();
            }
            catch (IOException e) {
                String message = e.getMessage();
                if (message != null && message.toLowerCase(Locale.US).contains("too many levels of symbolic links")) {
                    LOG.debug(e);
                    return null;
                }
                throw new IOException("Cannot resolve '" + path + "'", e);
            }
        }

        @Override
        protected boolean clonePermissions(@NotNull String source, @NotNull String target, boolean onlyPermissionsToExecute) {
            int permissions;
            Memory buffer;
            if (source == null) {
                JnaUnixMediatorImpl.$$$reportNull$$$0(2);
            }
            if (target == null) {
                JnaUnixMediatorImpl.$$$reportNull$$$0(3);
            }
            if (!JnaUnixMediatorImpl.loadFileStatus(source, buffer = new Memory(256L))) {
                return false;
            }
            int sourcePermissions = this.getModeFlags(buffer) & 0x1FF;
            if (onlyPermissionsToExecute) {
                if (!JnaUnixMediatorImpl.loadFileStatus(target, buffer)) {
                    return false;
                }
                int targetPermissions = this.getModeFlags(buffer) & 0x1FF;
                permissions = targetPermissions & 0xFFFFFFB6 | sourcePermissions & 0x49;
            } else {
                permissions = sourcePermissions;
            }
            return LibC.chmod(target, permissions) == 0;
        }

        private static boolean loadFileStatus(String path, Memory buffer) {
            return (SystemInfo.isLinux ? LinuxLibC.__xstat64(1, path, (Pointer)buffer) : UnixLibC.stat(path, (Pointer)buffer)) == 0;
        }

        private int getModeFlags(Memory buffer) {
            return SystemInfo.isLinux ? buffer.getInt((long)this.myOffsets[0]) : (int)buffer.getShort((long)this.myOffsets[0]);
        }

        private boolean ownFile(Memory buffer) {
            return buffer.getInt((long)this.myOffsets[3]) == this.myUid && buffer.getInt((long)this.myOffsets[4]) == this.myGid;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/util/io/FileSystemUtil$JnaUnixMediatorImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getAttributes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveSymLink";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clonePermissions";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class LinuxLibC {
            private LinuxLibC() {
            }

            static native int __lxstat64(int var0, String var1, Pointer var2);

            static native int __xstat64(int var0, String var1, Pointer var2);
        }

        private static class UnixLibC {
            private UnixLibC() {
            }

            static native int lstat(String var0, Pointer var1);

            static native int stat(String var0, Pointer var1);
        }

        private static class LibC {
            static final int S_MASK = 65535;
            static final int S_IFMT = 61440;
            static final int S_IFLNK = 40960;
            static final int S_IFREG = 32768;
            static final int S_IFDIR = 16384;
            static final int PERM_MASK = 511;
            static final int EXECUTE_MASK = 73;
            static final int WRITE_MASK = 146;
            static final int W_OK = 2;

            private LibC() {
            }

            static native int getuid();

            static native int getgid();

            static native int chmod(String var0, int var1);

            static native int access(String var0, int var1);
        }
    }

    private static class IdeaWin32MediatorImpl
    extends Mediator {
        private final IdeaWin32 myInstance = IdeaWin32.getInstance();

        private IdeaWin32MediatorImpl() {
        }

        @Override
        protected FileAttributes getAttributes(@NotNull String path) {
            FileInfo fileInfo;
            if (path == null) {
                IdeaWin32MediatorImpl.$$$reportNull$$$0(0);
            }
            return (fileInfo = this.myInstance.getInfo(path)) != null ? fileInfo.toFileAttributes() : null;
        }

        @Override
        protected String resolveSymLink(@NotNull String path) {
            if (path == null) {
                IdeaWin32MediatorImpl.$$$reportNull$$$0(1);
            }
            path = new File(path).getAbsolutePath();
            char drive = Character.toUpperCase(path.charAt(0));
            if (path.length() <= 3 || drive < 'A' || drive > 'Z' || path.charAt(1) != ':' || path.charAt(2) != '\\') {
                return path;
            }
            int remainder = 4;
            while (remainder < path.length()) {
                int next = path.indexOf(92, remainder);
                String subPath = next > 0 ? path.substring(0, next) : path;
                FileAttributes attributes = this.getAttributes(subPath);
                if (attributes == null) {
                    return null;
                }
                if (attributes.isSymLink()) {
                    return this.myInstance.resolveSymLink(path);
                }
                remainder = next > 0 ? next + 1 : path.length();
            }
            return path;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "path";
            objectArray2[1] = "com/intellij/openapi/util/io/FileSystemUtil$IdeaWin32MediatorImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getAttributes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveSymLink";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Nio2MediatorImpl
    extends Mediator {
        private final Method myGetPath;
        private final Object myLinkOptions;
        private final Object myNoFollowLinkOptions;
        private final Method myReadAttributes;
        private final Method mySetAttribute;
        private final Method myToRealPath;
        private final Method myToMillis;
        private final Class<?> mySchema;
        private final Method myIsSymbolicLink;
        private final Method myIsDirectory;
        private final Method myIsOther;
        private final Method mySize;
        private final Method myLastModifiedTime;
        private final Method myIsHidden;
        private final Method myIsReadOnly;
        private final Method myPermissions;

        private Nio2MediatorImpl() throws Exception {
            assert (Patches.USE_REFLECTION_TO_ACCESS_JDK7);
            this.myGetPath = Nio2MediatorImpl.accessible(Class.forName("java.nio.file.Paths").getMethod("get", String.class, String[].class));
            Class<?> pathClass = Class.forName("java.nio.file.Path");
            Class<?> filesClass = Class.forName("java.nio.file.Files");
            Class<?> linkOptClass = Class.forName("java.nio.file.LinkOption");
            this.myLinkOptions = Array.newInstance(linkOptClass, 0);
            this.myNoFollowLinkOptions = Array.newInstance(linkOptClass, 1);
            Array.set(this.myNoFollowLinkOptions, 0, linkOptClass.getField("NOFOLLOW_LINKS").get(null));
            Class<?> linkOptArrayClass = this.myLinkOptions.getClass();
            this.myReadAttributes = Nio2MediatorImpl.accessible(filesClass.getMethod("readAttributes", pathClass, Class.class, linkOptArrayClass));
            this.mySetAttribute = Nio2MediatorImpl.accessible(filesClass.getMethod("setAttribute", pathClass, String.class, Object.class, linkOptArrayClass));
            this.myToRealPath = Nio2MediatorImpl.accessible(pathClass.getMethod("toRealPath", linkOptArrayClass));
            this.myToMillis = Nio2MediatorImpl.accessible(Class.forName("java.nio.file.attribute.FileTime").getMethod("toMillis", new Class[0]));
            this.mySchema = Class.forName("java.nio.file.attribute." + (SystemInfo.isWindows ? "DosFileAttributes" : "PosixFileAttributes"));
            this.myIsSymbolicLink = Nio2MediatorImpl.accessible(this.mySchema.getMethod("isSymbolicLink", new Class[0]));
            this.myIsDirectory = Nio2MediatorImpl.accessible(this.mySchema.getMethod("isDirectory", new Class[0]));
            this.myIsOther = Nio2MediatorImpl.accessible(this.mySchema.getMethod("isOther", new Class[0]));
            this.mySize = Nio2MediatorImpl.accessible(this.mySchema.getMethod("size", new Class[0]));
            this.myLastModifiedTime = Nio2MediatorImpl.accessible(this.mySchema.getMethod("lastModifiedTime", new Class[0]));
            if (SystemInfo.isWindows) {
                this.myIsHidden = Nio2MediatorImpl.accessible(this.mySchema.getMethod("isHidden", new Class[0]));
                this.myIsReadOnly = Nio2MediatorImpl.accessible(this.mySchema.getMethod("isReadOnly", new Class[0]));
                this.myPermissions = null;
            } else {
                this.myIsReadOnly = null;
                this.myIsHidden = null;
                this.myPermissions = Nio2MediatorImpl.accessible(this.mySchema.getMethod("permissions", new Class[0]));
            }
        }

        private static Method accessible(Method method) {
            method.setAccessible(true);
            return method;
        }

        @Override
        protected FileAttributes getAttributes(@NotNull String path) throws Exception {
            if (path == null) {
                Nio2MediatorImpl.$$$reportNull$$$0(0);
            }
            try {
                boolean isSymbolicLink;
                Object attributes;
                block8: {
                    Object pathObj = this.myGetPath.invoke(null, path, ArrayUtil.EMPTY_STRING_ARRAY);
                    attributes = this.myReadAttributes.invoke(null, pathObj, this.mySchema, this.myNoFollowLinkOptions);
                    boolean bl = isSymbolicLink = (Boolean)this.myIsSymbolicLink.invoke(attributes, new Object[0]) != false || SystemInfo.isWindows && (Boolean)this.myIsOther.invoke(attributes, new Object[0]) != false && (Boolean)this.myIsDirectory.invoke(attributes, new Object[0]) != false;
                    if (isSymbolicLink) {
                        try {
                            attributes = this.myReadAttributes.invoke(null, pathObj, this.mySchema, this.myLinkOptions);
                        }
                        catch (InvocationTargetException e) {
                            Throwable cause = e.getCause();
                            if (cause == null || !"java.nio.file.NoSuchFileException".equals(cause.getClass().getName())) break block8;
                            return FileAttributes.BROKEN_SYMLINK;
                        }
                    }
                }
                boolean isDirectory = (Boolean)this.myIsDirectory.invoke(attributes, new Object[0]);
                boolean isOther = (Boolean)this.myIsOther.invoke(attributes, new Object[0]);
                long size = (Long)this.mySize.invoke(attributes, new Object[0]);
                long lastModified = (Long)this.myToMillis.invoke(this.myLastModifiedTime.invoke(attributes, new Object[0]), new Object[0]);
                if (SystemInfo.isWindows) {
                    boolean isHidden = new File(path).getParent() == null ? false : (Boolean)this.myIsHidden.invoke(attributes, new Object[0]);
                    boolean isWritable = isDirectory || (Boolean)this.myIsReadOnly.invoke(attributes, new Object[0]) == false;
                    return new FileAttributes(isDirectory, isOther, isSymbolicLink, isHidden, size, lastModified, isWritable);
                }
                boolean isWritable = new File(path).canWrite();
                return new FileAttributes(isDirectory, isOther, isSymbolicLink, false, size, lastModified, isWritable);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException || cause != null && "java.nio.file.InvalidPathException".equals(cause.getClass().getName())) {
                    LOG.debug(cause);
                    return null;
                }
                throw e;
            }
        }

        @Override
        protected String resolveSymLink(@NotNull String path) throws Exception {
            if (path == null) {
                Nio2MediatorImpl.$$$reportNull$$$0(1);
            }
            Object pathObj = this.myGetPath.invoke(null, path, ArrayUtil.EMPTY_STRING_ARRAY);
            try {
                return this.myToRealPath.invoke(pathObj, this.myLinkOptions).toString();
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause != null && "java.nio.file.NoSuchFileException".equals(cause.getClass().getName())) {
                    return null;
                }
                throw e;
            }
        }

        @Override
        protected boolean clonePermissions(@NotNull String source, @NotNull String target, boolean onlyPermissionsToExecute) throws Exception {
            if (source == null) {
                Nio2MediatorImpl.$$$reportNull$$$0(2);
            }
            if (target == null) {
                Nio2MediatorImpl.$$$reportNull$$$0(3);
            }
            if (SystemInfo.isUnix) {
                Object sourcePath = this.myGetPath.invoke(null, source, ArrayUtil.EMPTY_STRING_ARRAY);
                Object targetPath = this.myGetPath.invoke(null, target, ArrayUtil.EMPTY_STRING_ARRAY);
                Collection sourcePermissions = this.getPermissions(sourcePath);
                Collection targetPermissions = this.getPermissions(targetPath);
                if (sourcePermissions != null && targetPermissions != null) {
                    if (onlyPermissionsToExecute) {
                        HashSet permissionsToSet = ContainerUtil.newHashSet();
                        for (Object permission : targetPermissions) {
                            if (permission.toString().endsWith("_EXECUTE")) continue;
                            permissionsToSet.add(permission);
                        }
                        for (Object permission : sourcePermissions) {
                            if (!permission.toString().endsWith("_EXECUTE")) continue;
                            permissionsToSet.add(permission);
                        }
                        this.mySetAttribute.invoke(null, targetPath, "posix:permissions", permissionsToSet, this.myLinkOptions);
                    } else {
                        this.mySetAttribute.invoke(null, targetPath, "posix:permissions", sourcePermissions, this.myLinkOptions);
                    }
                    return true;
                }
            }
            return false;
        }

        private Collection getPermissions(Object sourcePath) throws IllegalAccessException, InvocationTargetException {
            Object attributes = this.myReadAttributes.invoke(null, sourcePath, this.mySchema, this.myLinkOptions);
            return attributes != null ? (Collection)this.myPermissions.invoke(attributes, new Object[0]) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/util/io/FileSystemUtil$Nio2MediatorImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getAttributes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveSymLink";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clonePermissions";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class Mediator {
        private Mediator() {
        }

        @Nullable
        protected abstract FileAttributes getAttributes(@NotNull String var1) throws Exception;

        @Nullable
        protected abstract String resolveSymLink(@NotNull String var1) throws Exception;

        protected boolean clonePermissions(@NotNull String source, @NotNull String target, boolean onlyPermissionsToExecute) throws Exception {
            if (source == null) {
                Mediator.$$$reportNull$$$0(0);
            }
            if (target == null) {
                Mediator.$$$reportNull$$$0(1);
            }
            return false;
        }

        @NotNull
        private String getName() {
            String string = this.getClass().getSimpleName().replace("MediatorImpl", "");
            if (string == null) {
                Mediator.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/io/FileSystemUtil$Mediator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/io/FileSystemUtil$Mediator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "clonePermissions";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

