/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.quickfix;

import com.android.SdkConstants;
import com.android.support.AndroidxName;
import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.checks.CommentDetector;
import com.android.tools.lint.checks.ParcelDetector;
import com.android.tools.lint.detector.api.Issue;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFixProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.android.quickfix.AddTargetApiQuickFix;
import org.jetbrains.kotlin.android.quickfix.AddTargetVersionCheckQuickFix;
import org.jetbrains.kotlin.android.quickfix.ParcelableQuickFix;
import org.jetbrains.kotlin.android.quickfix.SuppressLintQuickFix;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ=\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/android/quickfix/KotlinAndroidQuickFixProvider;", "Lorg/jetbrains/android/inspections/lint/AndroidLintQuickFixProvider;", "()V", "getApiQuickFixes", "", "Lorg/jetbrains/android/inspections/lint/AndroidLintQuickFix;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "element", "Lcom/intellij/psi/PsiElement;", "message", "", "(Lcom/android/tools/lint/detector/api/Issue;Lcom/intellij/psi/PsiElement;Ljava/lang/String;)[Lorg/jetbrains/android/inspections/lint/AndroidLintQuickFix;", "getQuickFixes", "startElement", "endElement", "data", "", "(Lcom/android/tools/lint/detector/api/Issue;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Ljava/lang/String;Ljava/lang/Object;)[Lorg/jetbrains/android/inspections/lint/AndroidLintQuickFix;", "getRequiredVersion", "", "errorMessage", "Companion", "intellij.android.kotlin.idea"})
public final class KotlinAndroidQuickFixProvider
implements AndroidLintQuickFixProvider {
    private static final AndroidxName REQUIRES_API_ANNOTATION;
    public static final Companion Companion;

    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull Issue issue, @NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, @Nullable Object data) {
        Object[] fixes;
        Object[] objectArray;
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)startElement, (String)"startElement");
        Intrinsics.checkParameterIsNotNull((Object)endElement, (String)"endElement");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Issue issue2 = issue;
        if (Intrinsics.areEqual((Object)issue2, (Object)ApiDetector.UNSUPPORTED) || Intrinsics.areEqual((Object)issue2, (Object)ApiDetector.INLINED)) {
            objectArray = this.getApiQuickFixes(issue, startElement, message);
        } else if (Intrinsics.areEqual((Object)issue2, (Object)ParcelDetector.ISSUE)) {
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[1];
            objectArray = androidLintQuickFixArray;
            androidLintQuickFixArray[0] = new ParcelableQuickFix();
        } else {
            objectArray = fixes = new AndroidLintQuickFix[]{};
        }
        if (Intrinsics.areEqual((Object)issue, (Object)CommentDetector.STOP_SHIP) ^ true) {
            return (AndroidLintQuickFix[])ArraysKt.plus((Object[])fixes, (Object)new SuppressLintQuickFix(issue.getId()));
        }
        return fixes;
    }

    @NotNull
    public final AndroidLintQuickFix[] getApiQuickFixes(@NotNull Issue issue, @NotNull PsiElement element, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        int api = this.getRequiredVersion(message);
        if (api == -1) {
            Intrinsics.checkExpressionValueIsNotNull((Object)AndroidLintQuickFix.EMPTY_ARRAY, (String)"AndroidLintQuickFix.EMPTY_ARRAY");
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
        Project project = element.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"element.project");
        Project project2 = project;
        if (JavaPsiFacade.getInstance((Project)project2).findClass(REQUIRES_API_ANNOTATION.newName(), GlobalSearchScope.allScope((Project)project2)) != null) {
            return new AndroidLintQuickFix[]{new AddTargetApiQuickFix(api, true, true), new AddTargetApiQuickFix(api, false, true), new AddTargetVersionCheckQuickFix(api)};
        }
        if (JavaPsiFacade.getInstance((Project)project2).findClass(REQUIRES_API_ANNOTATION.oldName(), GlobalSearchScope.allScope((Project)project2)) != null) {
            return new AndroidLintQuickFix[]{new AddTargetApiQuickFix(api, true, false, 4, null), new AddTargetApiQuickFix(api, false, false, 4, null), new AddTargetVersionCheckQuickFix(api)};
        }
        return new AndroidLintQuickFix[]{new AddTargetApiQuickFix(api, false, false, 4, null), new AddTargetVersionCheckQuickFix(api)};
    }

    private final int getRequiredVersion(String errorMessage) {
        Pattern pattern = Pattern.compile("\\s(\\d+)\\s");
        Matcher matcher = pattern.matcher(errorMessage);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(1));
        }
        return -1;
    }

    static {
        Companion = new Companion(null);
        REQUIRES_API_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"RequiresApi");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/android/quickfix/KotlinAndroidQuickFixProvider$Companion;", "", "()V", "REQUIRES_API_ANNOTATION", "Lcom/android/support/AndroidxName;", "kotlin.jvm.PlatformType", "getREQUIRES_API_ANNOTATION", "()Lcom/android/support/AndroidxName;", "intellij.android.kotlin.idea"})
    public static final class Companion {
        public final AndroidxName getREQUIRES_API_ANNOTATION() {
            return REQUIRES_API_ANNOTATION;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

