/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.configure;

import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmSuppressWildcards;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.AndroidGradle;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.configuration.GradleBuildScriptManipulator;
import org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatform;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 $2\u00020\u0001:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0004H\u0014J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0017J\u000e\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0010J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0010H\u0014J\u001a\u0010\u001f\u001a\u00020\u00042\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0014\u001a\u00020\u0004H\u0014J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u001bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/android/configure/KotlinAndroidGradleModuleConfigurator;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator;", "()V", "kotlinPluginName", "", "getKotlinPluginName", "()Ljava/lang/String;", "name", "getName", "presentableText", "getPresentableText", "targetPlatform", "Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "getTargetPlatform", "()Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "addElementsToFile", "", "file", "Lcom/intellij/psi/PsiFile;", "isTopLevelProjectFile", "version", "configure", "", "project", "Lcom/intellij/openapi/project/Project;", "excludeModules", "", "Lcom/intellij/openapi/module/Module;", "getKotlinAndroidExtensionsExpression", "forKotlinDsl", "getKotlinPluginExpression", "getStdlibArtifactName", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "isApplicable", "module", "Companion", "intellij.android.kotlin.idea"})
public final class KotlinAndroidGradleModuleConfigurator
extends KotlinWithGradleConfigurator {
    @NotNull
    private final String name = NAME;
    @NotNull
    private final TargetPlatform targetPlatform = (TargetPlatform)JvmPlatform.INSTANCE;
    @NotNull
    private final String presentableText = "Android with Gradle";
    @NotNull
    private final String kotlinPluginName = KOTLIN_ANDROID;
    private static final String NAME = "android-gradle";
    private static final String KOTLIN_ANDROID = "kotlin-android";
    private static final String KOTLIN_ANDROID_EXTENSIONS = "kotlin-android-extensions";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public TargetPlatform getTargetPlatform() {
        return this.targetPlatform;
    }

    @NotNull
    public String getPresentableText() {
        return this.presentableText;
    }

    public boolean isApplicable(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return Intrinsics.areEqual((Object)BuildSystemTypeKt.getBuildSystemType((Module)module), (Object)AndroidGradle.INSTANCE);
    }

    @NotNull
    protected String getKotlinPluginName() {
        return this.kotlinPluginName;
    }

    @NotNull
    protected String getKotlinPluginExpression(boolean forKotlinDsl) {
        return forKotlinDsl ? "kotlin(\"android\")" : "id 'org.jetbrains.kotlin.android' ";
    }

    @NotNull
    public final String getKotlinAndroidExtensionsExpression(boolean forKotlinDsl) {
        return forKotlinDsl ? "kotlin(\"android.extensions\")" : "id 'org.jetbrains.kotlin.android.extensions' ";
    }

    protected boolean addElementsToFile(@NotNull PsiFile file, boolean isTopLevelProjectFile, @NotNull String version) {
        boolean bl;
        Sdk sdk;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        GradleBuildScriptManipulator manipulator = KotlinWithGradleConfigurator.Companion.getManipulator(file, false);
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)file));
        if (module != null) {
            Module module2;
            Module it = module2 = module;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)it);
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(it)");
            sdk = moduleRootManager.getSdk();
        } else {
            sdk = null;
        }
        Sdk sdk2 = sdk;
        String jvmTarget = this.getJvmTarget(sdk2, version);
        if (isTopLevelProjectFile) {
            bl = manipulator.configureProjectBuildScript(this.getKotlinPluginName(), version);
        } else {
            manipulator.configureModuleBuildScript(this.getKotlinPluginName(), this.getKotlinPluginExpression(this.isKtDsl(file)), this.getStdlibArtifactName(sdk2, version), version, jvmTarget);
            bl = manipulator.configureModuleBuildScript(KOTLIN_ANDROID_EXTENSIONS, this.getKotlinAndroidExtensionsExpression(this.isKtDsl(file)), this.getStdlibArtifactName(sdk2, version), version, null);
        }
        return bl;
    }

    @NotNull
    protected String getStdlibArtifactName(@Nullable Sdk sdk, @NotNull String version) {
        JavaSdkVersion sdkVersion;
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        if (sdk != null && KotlinRuntimeLibraryUtilKt.hasJreSpecificRuntime((String)version) && (sdkVersion = ProjectStructureUtilKt.getVersion((Sdk)sdk)) != null && sdkVersion.isAtLeast(JavaSdkVersion.JDK_1_8)) {
            return "kotlin-stdlib-jdk7";
        }
        return super.getStdlibArtifactName(sdk, version);
    }

    @JvmSuppressWildcards
    public void configure(@NotNull Project project, @NotNull Collection<Module> excludeModules) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(excludeModules, (String)"excludeModules");
        super.configure(project, excludeModules);
        GradleSyncInvoker.getInstance().requestProjectSync(project, GradleSyncInvoker.Request.projectModified());
    }

    static {
        NAME = NAME;
        KOTLIN_ANDROID = KOTLIN_ANDROID;
        KOTLIN_ANDROID_EXTENSIONS = KOTLIN_ANDROID_EXTENSIONS;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/android/configure/KotlinAndroidGradleModuleConfigurator$Companion;", "", "()V", "KOTLIN_ANDROID", "", "KOTLIN_ANDROID_EXTENSIONS", "NAME", "intellij.android.kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

