/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.AndroidAnnotatorUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.android.AndroidUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.load.java.descriptors.JavaPropertyDescriptor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/android/AndroidResourceReferenceAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "getResourceReferenceTargetDescriptor", "Lorg/jetbrains/kotlin/load/java/descriptors/JavaPropertyDescriptor;", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "intellij.android.kotlin.idea"})
public final class AndroidResourceReferenceAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        PsiElement psiElement = element;
        if (!(psiElement instanceof KtReferenceExpression)) {
            psiElement = null;
        }
        KtReferenceExpression ktReferenceExpression = (KtReferenceExpression)psiElement;
        if (ktReferenceExpression == null) {
            return;
        }
        KtReferenceExpression reference = ktReferenceExpression;
        AndroidFacet androidFacet = AndroidFacet.getInstance((PsiElement)element);
        if (androidFacet == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)androidFacet, (String)"AndroidFacet.getInstance(element) ?: return");
        AndroidFacet androidFacet2 = androidFacet;
        JavaPropertyDescriptor javaPropertyDescriptor = this.getResourceReferenceTargetDescriptor(reference);
        if (javaPropertyDescriptor == null) {
            return;
        }
        JavaPropertyDescriptor referenceTarget = javaPropertyDescriptor;
        ResourceType resourceType = AndroidUtilKt.getAndroidResourceType(referenceTarget);
        if (resourceType == null) {
            return;
        }
        ResourceType resourceType2 = resourceType;
        if (resourceType2 != ResourceType.COLOR && resourceType2 != ResourceType.DRAWABLE && resourceType2 != ResourceType.MIPMAP) {
            return;
        }
        AndroidPsiUtils.ResourceReferenceType referenceType = AndroidUtilKt.getResourceReferenceType(referenceTarget);
        Configuration configuration = AndroidAnnotatorUtil.pickConfiguration((AndroidFacet)androidFacet2, (Module)androidFacet2.getModule(), (PsiFile)((KtReferenceExpression)element).getContainingFile());
        if (configuration == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"pickConfiguration(androi\u2026containingFile) ?: return");
        Configuration configuration2 = configuration;
        ResourceValue resourceValue = AndroidAnnotatorUtil.findResourceValue((ResourceType)resourceType2, (String)reference.getText(), (referenceType == AndroidPsiUtils.ResourceReferenceType.FRAMEWORK ? 1 : 0) != 0, (Module)androidFacet2.getModule(), (Configuration)configuration2);
        if (resourceValue == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)resourceValue, (String)"findResourceValue(\n     \u2026ation\n        ) ?: return");
        ResourceValue resourceValue2 = resourceValue;
        ResourceResolver resourceResolver = configuration2.getResourceResolver();
        if (resourceResolver == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)resourceResolver, (String)"configuration.resourceResolver ?: return");
        ResourceResolver resourceResolver2 = resourceResolver;
        if (resourceType2 == ResourceType.COLOR) {
            RenderResources renderResources = (RenderResources)resourceResolver2;
            Project project = ((KtReferenceExpression)element).getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"element.project");
            Color color = ResourceHelper.resolveColor((RenderResources)renderResources, (ResourceValue)resourceValue2, (Project)project);
            if (color != null) {
                Annotation annotation;
                Annotation annotation2 = annotation = holder.createInfoAnnotation(element, null);
                Intrinsics.checkExpressionValueIsNotNull((Object)annotation2, (String)"annotation");
                annotation2.setGutterIconRenderer((GutterIconRenderer)new AndroidAnnotatorUtil.ColorRenderer(element, color));
            }
        } else {
            VirtualFile iconFile;
            RenderResources renderResources = (RenderResources)resourceResolver2;
            Project project = ((KtReferenceExpression)element).getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"element.project");
            VirtualFile file = ResourceHelper.resolveDrawable((RenderResources)renderResources, (ResourceValue)resourceValue2, (Project)project);
            if (file != null) {
                String string = file.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
                if (StringsKt.endsWith$default((String)string, (String)".xml", (boolean)false, (int)2, null)) {
                    file = AndroidAnnotatorUtil.pickBitmapFromXml((VirtualFile)file, (ResourceResolver)resourceResolver2, (Project)((KtReferenceExpression)element).getProject(), (AndroidFacet)androidFacet2, (ResourceValue)resourceValue2);
                }
            }
            if ((iconFile = AndroidAnnotatorUtil.pickBestBitmap((VirtualFile)file)) != null) {
                Annotation annotation;
                Annotation annotation3 = annotation = holder.createInfoAnnotation(element, null);
                Intrinsics.checkExpressionValueIsNotNull((Object)annotation3, (String)"annotation");
                annotation3.setGutterIconRenderer((GutterIconRenderer)new com.android.tools.idea.rendering.GutterIconRenderer(resourceResolver2, element, iconFile));
            }
        }
    }

    private final JavaPropertyDescriptor getResourceReferenceTargetDescriptor(@NotNull KtReferenceExpression $receiver) {
        ResolvedCall resolvedCall = ResolutionUtils.resolveToCall$default((KtElement)((KtElement)$receiver), null, (int)1, null);
        Object object = resolvedCall != null ? resolvedCall.getResultingDescriptor() : null;
        if (!(object instanceof JavaPropertyDescriptor)) {
            object = null;
        }
        return (JavaPropertyDescriptor)object;
    }
}

