/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.resolve.GradleMethodContextContributor;
import org.jetbrains.plugins.gradle.service.resolve.GradleResolverUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyClosurePattern;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyPatternsKt;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.DelegatesToInfo;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J.\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleDependenciesContributor;", "Lorg/jetbrains/plugins/gradle/service/resolve/GradleMethodContextContributor;", "()V", "getDelegatesToInfo", "Lorg/jetbrains/plugins/groovy/lang/resolve/delegatesTo/DelegatesToInfo;", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "process", "", "methodCallInfo", "", "", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "state", "Lcom/intellij/psi/ResolveState;", "place", "Lcom/intellij/psi/PsiElement;", "Companion", "intellij.gradle.java"})
public final class GradleDependenciesContributor
implements GradleMethodContextContributor {
    @NotNull
    private static final GroovyClosurePattern dependenciesClosure;
    @NotNull
    private static final GroovyClosurePattern dependencyConfigurationClosure;
    @NotNull
    private static final GroovyClosurePattern moduleDependencyConfigurationClosure;
    @NotNull
    private static final GroovyClosurePattern modulesClosure;
    @NotNull
    private static final GroovyClosurePattern componentsClosure;
    @NotNull
    private static final GroovyClosurePattern moduleClosure;
    public static final Companion Companion;

    @Override
    @Nullable
    public DelegatesToInfo getDelegatesToInfo(@NotNull GrClosableBlock closure) {
        Intrinsics.checkParameterIsNotNull((Object)closure, (String)"closure");
        if (dependencyConfigurationClosure.accepts((Object)closure)) {
            return new DelegatesToInfo((PsiType)TypesUtil.createType((String)"org.gradle.api.artifacts.ModuleDependency", (PsiElement)((PsiElement)closure)), 1);
        }
        if (moduleDependencyConfigurationClosure.accepts((Object)closure)) {
            return new DelegatesToInfo((PsiType)TypesUtil.createType((String)"org.gradle.api.artifacts.ClientModule", (PsiElement)((PsiElement)closure)), 1);
        }
        if (dependenciesClosure.accepts((Object)closure)) {
            return new DelegatesToInfo((PsiType)TypesUtil.createType((String)"org.gradle.api.artifacts.dsl.DependencyHandler", (PsiElement)((PsiElement)closure)), 1);
        }
        if (modulesClosure.accepts((Object)closure)) {
            return new DelegatesToInfo((PsiType)TypesUtil.createType((String)"org.gradle.api.artifacts.dsl.ComponentModuleMetadataHandler", (PsiElement)((PsiElement)closure)), 1);
        }
        if (moduleClosure.accepts((Object)closure)) {
            return new DelegatesToInfo((PsiType)TypesUtil.createType((String)"org.gradle.api.artifacts.ComponentModuleMetadataDetails", (PsiElement)((PsiElement)closure)), 1);
        }
        if (componentsClosure.accepts((Object)closure)) {
            return new DelegatesToInfo((PsiType)TypesUtil.createType((String)"org.gradle.api.artifacts.dsl.ComponentMetadataHandler", (PsiElement)((PsiElement)closure)), 1);
        }
        return null;
    }

    @Override
    public boolean process(@NotNull List<String> methodCallInfo, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        Intrinsics.checkParameterIsNotNull(methodCallInfo, (String)"methodCallInfo");
        Intrinsics.checkParameterIsNotNull((Object)processor, (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        GroovyPsiManager groovyPsiManager = GroovyPsiManager.getInstance((Project)place.getProject());
        String string = (String)CollectionsKt.firstOrNull(methodCallInfo);
        if (string == null) {
            return true;
        }
        String methodName = string;
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        boolean shouldProcessMethods = ResolveUtil.shouldProcessMethods((ElementClassHint)classHint);
        if (shouldProcessMethods && place instanceof GrReferenceExpression && ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside((ElementPattern)dependenciesClosure)).accepts((Object)place) && methodCallInfo.size() == 2) {
            GrLightMethodBuilder grLightMethodBuilder;
            GlobalSearchScope globalSearchScope = place.getResolveScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"place.getResolveScope()");
            GlobalSearchScope resolveScope = globalSearchScope;
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)((GrReferenceExpression)place).getProject()).findClass("org.gradle.api.artifacts.dsl.DependencyHandler", resolveScope);
            if (psiClass == null) {
                return true;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"JavaPsiFacade.getInstanc\u2026olveScope) ?: return true");
            PsiClass psiClass2 = psiClass;
            if (GradleResolverUtil.canBeMethodOf(methodName, psiClass2)) {
                return true;
            }
            PsiClassType psiClassType = groovyPsiManager.createTypeByFQClassName("org.gradle.api.artifacts.Dependency", resolveScope);
            if (psiClassType == null) {
                return true;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiClassType, (String)"groovyPsiManager.createT\u2026olveScope) ?: return true");
            PsiClassType returnClass = psiClassType;
            GrLightMethodBuilder $receiver = grLightMethodBuilder = new GrLightMethodBuilder(((GrReferenceExpression)place).getManager(), methodName);
            boolean bl = false;
            $receiver.setReturnType((PsiType)returnClass);
            $receiver.setContainingClass(psiClass2);
            GrLightMethodBuilder wrappedBase = grLightMethodBuilder;
            wrappedBase.addParameter("dependencyNotation", (PsiType)TypesUtil.getJavaLangObject((PsiElement)place).createArrayType());
            if (!processor.execute((PsiElement)wrappedBase, state)) {
                return false;
            }
        }
        return !((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside((ElementPattern)dependencyConfigurationClosure)).accepts((Object)place) || !GradleResolverUtil.processDeclarations(processor, state, place, "org.gradle.api.artifacts.ModuleDependency", "org.gradle.api.artifacts.ClientModule");
    }

    static {
        Companion = new Companion(null);
        GroovyClosurePattern groovyClosurePattern = GroovyPatternsKt.groovyClosure();
        ElementPattern elementPattern = StandardPatterns.or((ElementPattern[])new ElementPattern[]{(ElementPattern)GroovyPatternsKt.psiMethod((String)"org.gradle.api.Project", (String[])new String[]{"dependencies"}), (ElementPattern)GroovyPatternsKt.psiMethod((String)"org.gradle.api.initialization.dsl.ScriptHandler", (String[])new String[]{"dependencies"})});
        Intrinsics.checkExpressionValueIsNotNull((Object)elementPattern, (String)"or(psiMethod(GRADLE_API_\u2026HANDLER, \"dependencies\"))");
        dependenciesClosure = groovyClosurePattern.inMethod(elementPattern);
        dependencyConfigurationClosure = GroovyPatternsKt.groovyClosure().inMethod((ElementPattern)GroovyPatternsKt.psiMethod((String)"org.gradle.api.artifacts.dsl.DependencyHandler", (String[])new String[]{"add"}));
        moduleDependencyConfigurationClosure = GroovyPatternsKt.groovyClosure().inMethod((ElementPattern)GroovyPatternsKt.psiMethod((String)"org.gradle.api.artifacts.dsl.DependencyHandler", (String[])new String[]{"module"}));
        modulesClosure = GroovyPatternsKt.groovyClosure().inMethod((ElementPattern)GroovyPatternsKt.psiMethod((String)"org.gradle.api.artifacts.dsl.DependencyHandler", (String[])new String[]{"modules"}));
        componentsClosure = GroovyPatternsKt.groovyClosure().inMethod((ElementPattern)GroovyPatternsKt.psiMethod((String)"org.gradle.api.artifacts.dsl.DependencyHandler", (String[])new String[]{"components"}));
        moduleClosure = GroovyPatternsKt.groovyClosure().inMethod((ElementPattern)GroovyPatternsKt.psiMethod((String)"org.gradle.api.artifacts.dsl.ComponentModuleMetadataHandler", (String[])new String[]{"module"}));
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleDependenciesContributor$Companion;", "", "()V", "componentsClosure", "Lorg/jetbrains/plugins/groovy/lang/psi/patterns/GroovyClosurePattern;", "getComponentsClosure", "()Lorg/jetbrains/plugins/groovy/lang/psi/patterns/GroovyClosurePattern;", "dependenciesClosure", "getDependenciesClosure", "dependencyConfigurationClosure", "getDependencyConfigurationClosure", "moduleClosure", "getModuleClosure", "moduleDependencyConfigurationClosure", "getModuleDependencyConfigurationClosure", "modulesClosure", "getModulesClosure", "intellij.gradle.java"})
    public static final class Companion {
        @NotNull
        public final GroovyClosurePattern getDependenciesClosure() {
            return dependenciesClosure;
        }

        @NotNull
        public final GroovyClosurePattern getDependencyConfigurationClosure() {
            return dependencyConfigurationClosure;
        }

        @NotNull
        public final GroovyClosurePattern getModuleDependencyConfigurationClosure() {
            return moduleDependencyConfigurationClosure;
        }

        @NotNull
        public final GroovyClosurePattern getModulesClosure() {
            return modulesClosure;
        }

        @NotNull
        public final GroovyClosurePattern getComponentsClosure() {
            return componentsClosure;
        }

        @NotNull
        public final GroovyClosurePattern getModuleClosure() {
            return moduleClosure;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

