/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.TestData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestTasksProvider;
import org.jetbrains.plugins.gradle.execution.test.runner.TestGradleConfigurationProducerUtilKt;
import org.jetbrains.plugins.gradle.execution.test.runner.TestTasksChooser;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.settings.GradleSettingsService;
import org.jetbrains.plugins.gradle.settings.TestRunner;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.TasksToRun;

public abstract class GradleTestRunConfigurationProducer
extends RunConfigurationProducer<ExternalSystemRunConfiguration> {
    private static final List<String> TEST_SOURCE_SET_TASKS = ContainerUtil.list((Object[])new String[]{"cleanTest", "test"});
    protected static final Logger LOG = Logger.getInstance(GradleTestRunConfigurationProducer.class);
    private TestTasksChooser testTasksChooser = new TestTasksChooser();

    @Deprecated
    protected GradleTestRunConfigurationProducer(ConfigurationType configurationType) {
        super(configurationType);
    }

    protected GradleTestRunConfigurationProducer() {
        super(true);
    }

    public boolean isPreferredConfiguration(ConfigurationFromContext self, ConfigurationFromContext other) {
        TestRunner testRunner = GradleTestRunConfigurationProducer.getTestRunner(self.getSourceElement());
        return testRunner == TestRunner.CHOOSE_PER_TEST || testRunner == TestRunner.GRADLE;
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        if (self == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (other == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        return GradleTestRunConfigurationProducer.getTestRunner(self.getSourceElement()) == TestRunner.GRADLE;
    }

    protected boolean setupConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        if (!GradleConstants.SYSTEM_ID.equals((Object)configuration.getSettings().getExternalSystemId())) {
            return false;
        }
        if (sourceElement.isNull()) {
            return false;
        }
        TestRunner testRunner = GradleTestRunConfigurationProducer.getTestRunner((PsiElement)sourceElement.get());
        if (testRunner == TestRunner.PLATFORM) {
            return false;
        }
        if (configuration instanceof GradleRunConfiguration) {
            GradleRunConfiguration gradleRunConfiguration = (GradleRunConfiguration)configuration;
            gradleRunConfiguration.setScriptDebugEnabled(false);
        }
        return this.doSetupConfigurationFromContext(configuration, context, sourceElement);
    }

    protected abstract boolean doSetupConfigurationFromContext(ExternalSystemRunConfiguration var1, ConfigurationContext var2, Ref<PsiElement> var3);

    public boolean isConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context) {
        if (configuration == null) {
            return false;
        }
        if (!GradleConstants.SYSTEM_ID.equals((Object)configuration.getSettings().getExternalSystemId())) {
            return false;
        }
        String projectPath = configuration.getSettings().getExternalProjectPath();
        TestRunner testRunner = GradleTestRunConfigurationProducer.getTestRunner(context.getProject(), projectPath);
        if (testRunner == TestRunner.PLATFORM) {
            return false;
        }
        return this.doIsConfigurationFromContext(configuration, context);
    }

    protected abstract boolean doIsConfigurationFromContext(ExternalSystemRunConfiguration var1, ConfigurationContext var2);

    @Nullable
    protected String resolveProjectPath(@NotNull Module module) {
        if (module == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        return GradleRunnerUtil.resolveProjectPath(module);
    }

    protected TestTasksChooser getTestTasksChooser() {
        return this.testTasksChooser;
    }

    public void setTestTasksChooser(TestTasksChooser testTasksChooser) {
        this.testTasksChooser = testTasksChooser;
    }

    public static boolean hasTasksInConfiguration(VirtualFile source, Project project, ExternalSystemTaskExecutionSettings settings) {
        List<TasksToRun> tasksToRun = GradleTestRunConfigurationProducer.findAllTestsTaskToRun(source, project);
        List escapedTasks = ContainerUtil.map(tasksToRun, tasks -> ContainerUtil.map((Collection)tasks, it -> TestGradleConfigurationProducerUtilKt.escapeIfNeeded(it)));
        List taskNames = settings.getTaskNames();
        if (escapedTasks.stream().anyMatch(taskNames::containsAll)) {
            return true;
        }
        String scriptParameters = settings.getScriptParameters();
        if (StringUtil.isEmpty((String)scriptParameters)) {
            return false;
        }
        List escapedJoinedTasks = ContainerUtil.map((Collection)escapedTasks, it -> StringUtil.join((Collection)it, (String)" "));
        return escapedJoinedTasks.stream().anyMatch(scriptParameters::contains);
    }

    @NotNull
    public static TasksToRun findTestsTaskToRun(@NotNull VirtualFile source, @NotNull Project project) {
        List<TasksToRun> tasksToRun;
        if (source == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (project == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        if ((tasksToRun = GradleTestRunConfigurationProducer.findAllTestsTaskToRun(source, project)).isEmpty()) {
            TasksToRun.Empty empty = TasksToRun.EMPTY;
            if (empty == null) {
                GradleTestRunConfigurationProducer.$$$reportNull$$$0(5);
            }
            return empty;
        }
        TasksToRun tasksToRun2 = tasksToRun.get(0);
        if (tasksToRun2 == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        return tasksToRun2;
    }

    @NotNull
    public static List<TasksToRun> findAllTestsTaskToRun(@NotNull VirtualFile source, @NotNull Project project) {
        if (source == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(7);
        }
        if (project == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(8);
        }
        String sourcePath = source.getPath();
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        Module module = projectFileIndex.getModuleForFile(source);
        if (module == null) {
            List<TasksToRun> list = Collections.emptyList();
            if (list == null) {
                GradleTestRunConfigurationProducer.$$$reportNull$$$0(9);
            }
            return list;
        }
        ArrayList<TasksToRun> testTasks = new ArrayList<TasksToRun>();
        for (GradleTestTasksProvider provider : (GradleTestTasksProvider[])GradleTestTasksProvider.EP_NAME.getExtensions()) {
            List<String> tasks = provider.getTasks(module, source);
            if (ContainerUtil.isEmpty(tasks)) continue;
            String testName = StringUtil.join(tasks, (String)" ");
            testTasks.add(new TasksToRun.Impl(testName, tasks));
        }
        DataNode moduleDataNode = ExternalSystemApiUtil.findModuleData((Module)module, (ProjectSystemId)GradleConstants.SYSTEM_ID);
        if (moduleDataNode == null) {
            ArrayList<TasksToRun> arrayList = testTasks;
            if (arrayList == null) {
                GradleTestRunConfigurationProducer.$$$reportNull$$$0(10);
            }
            return arrayList;
        }
        Collection testsData = ExternalSystemApiUtil.findAll((DataNode)moduleDataNode, (Key)ProjectKeys.TEST);
        for (DataNode testDataNode : testsData) {
            TestData testData = (TestData)testDataNode.getData();
            Set sourceFolders = testData.getSourceFolders();
            for (String sourceFolder : sourceFolders) {
                if (!FileUtil.isAncestor((String)sourceFolder, (String)sourcePath, (boolean)false)) continue;
                String testName = testData.getTestName();
                String testTaskName = testData.getTestTaskName();
                String clearTestTaskName = testData.getCleanTestTaskName();
                ArrayList tasks = ContainerUtil.newArrayList((Object[])new String[]{clearTestTaskName, testTaskName});
                testTasks.add(new TasksToRun.Impl(testName, tasks));
            }
        }
        ArrayList<TasksToRun> arrayList = testTasks;
        if (arrayList == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Deprecated
    @NotNull
    public static List<String> getTasksToRun(@NotNull Module module) {
        String taskPrefix;
        if (module == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(12);
        }
        for (GradleTestTasksProvider provider : (GradleTestTasksProvider[])GradleTestTasksProvider.EP_NAME.getExtensions()) {
            List<String> tasks = provider.getTasks(module);
            if (ContainerUtil.isEmpty(tasks)) continue;
            List<String> list = tasks;
            if (list == null) {
                GradleTestRunConfigurationProducer.$$$reportNull$$$0(13);
            }
            return list;
        }
        String externalProjectId = ExternalSystemApiUtil.getExternalProjectId((Module)module);
        if (externalProjectId == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                GradleTestRunConfigurationProducer.$$$reportNull$$$0(14);
            }
            return list;
        }
        String projectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
        if (projectPath == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                GradleTestRunConfigurationProducer.$$$reportNull$$$0(15);
            }
            return list;
        }
        ExternalProjectInfo externalProjectInfo = ExternalSystemUtil.getExternalProjectInfo((Project)module.getProject(), (ProjectSystemId)GradleConstants.SYSTEM_ID, (String)projectPath);
        if (externalProjectInfo == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                GradleTestRunConfigurationProducer.$$$reportNull$$$0(16);
            }
            return list;
        }
        String gradlePath = GradleProjectResolverUtil.getGradlePath((Module)module);
        if (gradlePath == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                GradleTestRunConfigurationProducer.$$$reportNull$$$0(17);
            }
            return list;
        }
        String string = taskPrefix = StringUtil.endsWithChar((CharSequence)gradlePath, (char)':') ? gradlePath : gradlePath + ':';
        if (StringUtil.endsWith((CharSequence)externalProjectId, (CharSequence)":test") || StringUtil.endsWith((CharSequence)externalProjectId, (CharSequence)":main")) {
            List list = ContainerUtil.map(TEST_SOURCE_SET_TASKS, task -> taskPrefix + task);
            if (list == null) {
                GradleTestRunConfigurationProducer.$$$reportNull$$$0(18);
            }
            return list;
        }
        DataNode moduleNode = GradleProjectResolverUtil.findModule((DataNode)externalProjectInfo.getExternalProjectStructure(), (String)projectPath);
        if (moduleNode == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                GradleTestRunConfigurationProducer.$$$reportNull$$$0(19);
            }
            return list;
        }
        String sourceSetId = StringUtil.substringAfter((String)externalProjectId, (String)(((ModuleData)moduleNode.getData()).getExternalName() + ':'));
        DataNode taskNode = sourceSetId == null ? ExternalSystemApiUtil.find((DataNode)moduleNode, (Key)ProjectKeys.TASK, node -> ((TaskData)node.getData()).isTest() && StringUtil.equals((CharSequence)"test", (CharSequence)((TaskData)node.getData()).getName()) || StringUtil.equals((CharSequence)(taskPrefix + "test"), (CharSequence)((TaskData)node.getData()).getName())) : ExternalSystemApiUtil.find((DataNode)moduleNode, (Key)ProjectKeys.TASK, node -> ((TaskData)node.getData()).isTest() && StringUtil.startsWith((CharSequence)((TaskData)node.getData()).getName(), (CharSequence)sourceSetId));
        if (taskNode == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                GradleTestRunConfigurationProducer.$$$reportNull$$$0(20);
            }
            return list;
        }
        String taskName = StringUtil.trimStart((String)((TaskData)taskNode.getData()).getName(), (String)taskPrefix);
        List tasks = ContainerUtil.list((Object[])new String[]{"clean" + StringUtil.capitalize((String)taskName), taskName});
        List list = ContainerUtil.map((Collection)tasks, task -> taskPrefix + task);
        if (list == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(21);
        }
        return list;
    }

    private static TestRunner getTestRunner(@NotNull Project project, @NotNull String projectPath) {
        if (project == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(22);
        }
        if (projectPath == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(23);
        }
        return GradleSettingsService.getInstance((Project)project).getTestRunner(projectPath);
    }

    private static TestRunner getTestRunner(@NotNull PsiElement sourceElement) {
        Module module;
        if (sourceElement == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(24);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)sourceElement)) == null) {
            return TestRunner.PLATFORM;
        }
        return GradleSettingsService.getTestRunner((Module)module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "self";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: 
            case 8: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/execution/test/runner/GradleTestRunConfigurationProducer";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/execution/test/runner/GradleTestRunConfigurationProducer";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findTestsTaskToRun";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllTestsTaskToRun";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTasksToRun";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shouldReplace";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveProjectPath";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findTestsTaskToRun";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findAllTestsTaskToRun";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTasksToRun";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getTestRunner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

