/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl.httpclient;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.impl.RequestFailedException;
import com.intellij.tasks.impl.TaskUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;

public class TaskResponseUtil {
    public static final Logger LOG = Logger.getInstance(TaskResponseUtil.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    private TaskResponseUtil() {
    }

    public static Reader getResponseContentAsReader(@NotNull HttpResponse response) throws IOException {
        org.apache.http.Header header;
        if (response == null) {
            TaskResponseUtil.$$$reportNull$$$0(0);
        }
        Charset charset = (header = response.getEntity().getContentEncoding()) == null ? DEFAULT_CHARSET : Charset.forName(header.getValue());
        return new InputStreamReader(response.getEntity().getContent(), charset);
    }

    public static String getResponseContentAsString(@NotNull HttpResponse response) throws IOException {
        if (response == null) {
            TaskResponseUtil.$$$reportNull$$$0(1);
        }
        return EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)DEFAULT_CHARSET);
    }

    public static String getResponseContentAsString(@NotNull HttpMethod response) throws IOException {
        Header header;
        if (response == null) {
            TaskResponseUtil.$$$reportNull$$$0(2);
        }
        if ((header = response.getResponseHeader("Content-Type")) != null && header.getValue().contains("charset")) {
            return StringUtil.notNullize((String)response.getResponseBodyAsString());
        }
        InputStream stream = response.getResponseBodyAsStream();
        return stream == null ? "" : StreamUtil.readText((InputStream)stream, (Charset)DEFAULT_CHARSET);
    }

    public static Reader getResponseContentAsReader(@NotNull HttpMethod response) throws IOException {
        if (response == null) {
            TaskResponseUtil.$$$reportNull$$$0(3);
        }
        InputStream stream = response.getResponseBodyAsStream();
        String charsetName = null;
        Header header = response.getResponseHeader("Content-Type");
        if (header != null) {
            for (HeaderElement part : header.getElements()) {
                NameValuePair pair = part.getParameterByName("charset");
                if (pair == null) continue;
                charsetName = pair.getValue();
            }
        }
        return new InputStreamReader(stream, charsetName == null ? DEFAULT_CHARSET_NAME : charsetName);
    }

    @NotNull
    public static RequestFailedException forStatusCode(int code) {
        RequestFailedException requestFailedException = new RequestFailedException(TaskResponseUtil.messageForStatusCode(code));
        if (requestFailedException == null) {
            TaskResponseUtil.$$$reportNull$$$0(4);
        }
        return requestFailedException;
    }

    @NotNull
    public static String messageForStatusCode(int statusCode) {
        if (statusCode == 401) {
            String string = TaskBundle.message((String)"failure.login", (Object[])new Object[0]);
            if (string == null) {
                TaskResponseUtil.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (statusCode == 403) {
            String string = TaskBundle.message((String)"failure.permissions", (Object[])new Object[0]);
            if (string == null) {
                TaskResponseUtil.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = TaskBundle.message((String)"failure.http.error", (Object[])new Object[]{statusCode, HttpStatus.getStatusText((int)statusCode)});
        if (string == null) {
            TaskResponseUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    public static void prettyFormatResponseToLog(@NotNull Logger logger, @NotNull HttpMethod response) {
        if (logger == null) {
            TaskResponseUtil.$$$reportNull$$$0(8);
        }
        if (response == null) {
            TaskResponseUtil.$$$reportNull$$$0(9);
        }
        if (logger.isDebugEnabled() && response.hasBeenUsed()) {
            try {
                String contentType;
                String content = TaskResponseUtil.getResponseContentAsString(response);
                Header header = response.getRequestHeader("Content-Type");
                String string = contentType = header == null ? "text/plain" : header.getElements()[0].getName().toLowerCase(Locale.ENGLISH);
                if (contentType.contains("xml")) {
                    TaskUtil.prettyFormatXmlToLog((Logger)logger, (String)content);
                } else if (contentType.contains("json")) {
                    TaskUtil.prettyFormatJsonToLog((Logger)logger, (String)content);
                } else {
                    logger.debug(content);
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
    }

    public static void prettyFormatResponseToLog(@NotNull Logger logger, @NotNull HttpResponse response) {
        if (logger == null) {
            TaskResponseUtil.$$$reportNull$$$0(10);
        }
        if (response == null) {
            TaskResponseUtil.$$$reportNull$$$0(11);
        }
        if (logger.isDebugEnabled()) {
            try {
                String contentType;
                String content = TaskResponseUtil.getResponseContentAsString(response);
                org.apache.http.Header header = response.getEntity().getContentType();
                String string = contentType = header == null ? "text/plain" : header.getElements()[0].getName().toLowerCase(Locale.ENGLISH);
                if (contentType.contains("xml")) {
                    TaskUtil.prettyFormatXmlToLog((Logger)logger, (String)content);
                } else if (contentType.contains("json")) {
                    TaskUtil.prettyFormatJsonToLog((Logger)logger, (String)content);
                } else {
                    logger.debug(content);
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
    }

    public static boolean isSuccessful(int statusCode) {
        return statusCode / 100 == 2;
    }

    public static boolean isClientError(int statusCode) {
        return statusCode / 100 == 4;
    }

    public static boolean isServerError(int statusCode) {
        return statusCode / 100 == 5;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/impl/httpclient/TaskResponseUtil";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/impl/httpclient/TaskResponseUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "forStatusCode";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "messageForStatusCode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResponseContentAsReader";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getResponseContentAsString";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "prettyFormatResponseToLog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class GsonMultipleObjectsDeserializer<T>
    implements ResponseHandler<List<T>> {
        private final Gson myGson;
        private final TypeToken<List<T>> myTypeToken;
        private final boolean myIgnoreNotFound;

        public GsonMultipleObjectsDeserializer(Gson gson, TypeToken<List<T>> typeToken) {
            this(gson, typeToken, false);
        }

        public GsonMultipleObjectsDeserializer(@NotNull Gson gson, @NotNull TypeToken<List<T>> token, boolean ignoreNotFound) {
            if (gson == null) {
                GsonMultipleObjectsDeserializer.$$$reportNull$$$0(0);
            }
            if (token == null) {
                GsonMultipleObjectsDeserializer.$$$reportNull$$$0(1);
            }
            this.myGson = gson;
            this.myTypeToken = token;
            this.myIgnoreNotFound = ignoreNotFound;
        }

        public List<T> handleResponse(HttpResponse response) throws IOException {
            int statusCode = response.getStatusLine().getStatusCode();
            if (!TaskResponseUtil.isSuccessful(statusCode)) {
                if (statusCode == 404 && this.myIgnoreNotFound) {
                    return Collections.emptyList();
                }
                throw TaskResponseUtil.forStatusCode(statusCode);
            }
            try {
                if (LOG.isDebugEnabled()) {
                    String content = TaskResponseUtil.getResponseContentAsString(response);
                    TaskUtil.prettyFormatJsonToLog((Logger)LOG, (String)content);
                    return (List)this.myGson.fromJson(content, this.myTypeToken.getType());
                }
                return (List)this.myGson.fromJson(TaskResponseUtil.getResponseContentAsReader(response), this.myTypeToken.getType());
            }
            catch (JsonSyntaxException e) {
                LOG.warn("Malformed server response", (Throwable)e);
                return Collections.emptyList();
            }
            catch (NumberFormatException e) {
                LOG.error("NFE in response: " + TaskResponseUtil.getResponseContentAsString(response), (Throwable)e);
                throw new RequestFailedException("Malformed response");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "gson";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "token";
                    break;
                }
            }
            objectArray[1] = "com/intellij/tasks/impl/httpclient/TaskResponseUtil$GsonMultipleObjectsDeserializer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class GsonSingleObjectDeserializer<T>
    implements ResponseHandler<T> {
        private final Gson myGson;
        private final Class<T> myClass;
        private final boolean myIgnoreNotFound;

        public GsonSingleObjectDeserializer(@NotNull Gson gson, @NotNull Class<T> cls) {
            if (gson == null) {
                GsonSingleObjectDeserializer.$$$reportNull$$$0(0);
            }
            if (cls == null) {
                GsonSingleObjectDeserializer.$$$reportNull$$$0(1);
            }
            this(gson, cls, false);
        }

        public GsonSingleObjectDeserializer(@NotNull Gson gson, @NotNull Class<T> cls, boolean ignoreNotFound) {
            if (gson == null) {
                GsonSingleObjectDeserializer.$$$reportNull$$$0(2);
            }
            if (cls == null) {
                GsonSingleObjectDeserializer.$$$reportNull$$$0(3);
            }
            this.myGson = gson;
            this.myClass = cls;
            this.myIgnoreNotFound = ignoreNotFound;
        }

        public T handleResponse(HttpResponse response) throws IOException {
            int statusCode = response.getStatusLine().getStatusCode();
            if (!TaskResponseUtil.isSuccessful(statusCode)) {
                if (statusCode == 404 && this.myIgnoreNotFound) {
                    return null;
                }
                throw TaskResponseUtil.forStatusCode(statusCode);
            }
            try {
                if (LOG.isDebugEnabled()) {
                    String content = TaskResponseUtil.getResponseContentAsString(response);
                    TaskUtil.prettyFormatJsonToLog((Logger)LOG, (String)content);
                    return (T)this.myGson.fromJson(content, this.myClass);
                }
                return (T)this.myGson.fromJson(TaskResponseUtil.getResponseContentAsReader(response), this.myClass);
            }
            catch (JsonSyntaxException e) {
                LOG.warn("Malformed server response", (Throwable)e);
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "gson";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cls";
                    break;
                }
            }
            objectArray[1] = "com/intellij/tasks/impl/httpclient/TaskResponseUtil$GsonSingleObjectDeserializer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

