/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.inspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.theoryinpractice.testng.util.TestNGUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ConvertJavadocInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NonNls
    private static final String TESTNG_PREFIX = "testng.";
    static final String FIX_NAME = "Convert TestNG Javadoc to 1.5 annotations";
    private static final String INSPECTION_NAME = "TestNG Javadoc can be converted to annotations";

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("TestNG" == null) {
            ConvertJavadocInspection.$$$reportNull$$$0(0);
        }
        return "TestNG";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if (INSPECTION_NAME == null) {
            ConvertJavadocInspection.$$$reportNull$$$0(1);
        }
        return INSPECTION_NAME;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("ConvertJavadoc" == null) {
            ConvertJavadocInspection.$$$reportNull$$$0(2);
        }
        return "ConvertJavadoc";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ConvertJavadocInspection.$$$reportNull$$$0(3);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitDocTag(PsiDocTag tag) {
                if (tag.getName().startsWith(ConvertJavadocInspection.TESTNG_PREFIX)) {
                    holder.registerProblem((PsiElement)tag, ConvertJavadocInspection.INSPECTION_NAME, new LocalQuickFix[]{new ConvertJavadocQuickfix()});
                }
            }
        };
        if (javaElementVisitor == null) {
            ConvertJavadocInspection.$$$reportNull$$$0(4);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/theoryinpractice/testng/inspection/ConvertJavadocInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/theoryinpractice/testng/inspection/ConvertJavadocInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConvertJavadocQuickfix
    implements LocalQuickFix {
        private static final Logger LOG = Logger.getInstance(ConvertJavadocQuickfix.class);

        private ConvertJavadocQuickfix() {
        }

        @NotNull
        public String getFamilyName() {
            if (ConvertJavadocInspection.FIX_NAME == null) {
                ConvertJavadocQuickfix.$$$reportNull$$$0(0);
            }
            return ConvertJavadocInspection.FIX_NAME;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiDocTag tag;
            if (project == null) {
                ConvertJavadocQuickfix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ConvertJavadocQuickfix.$$$reportNull$$$0(2);
            }
            if (!TestNGUtil.checkTestNGInClasspath((PsiElement)(tag = (PsiDocTag)descriptor.getPsiElement()))) {
                return;
            }
            if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{tag})) {
                return;
            }
            WriteAction.run(() -> ConvertJavadocQuickfix.doFix(project, tag));
        }

        private static void doFix(@NotNull Project project, PsiDocTag tag) {
            PsiMember member;
            if (project == null) {
                ConvertJavadocQuickfix.$$$reportNull$$$0(3);
            }
            LOG.assertTrue((member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)tag, PsiMember.class)) != null);
            String annotationName = ConvertJavadocQuickfix.getFQAnnotationName(tag);
            StringBuilder annotationText = new StringBuilder("@");
            annotationText.append(annotationName);
            PsiClass annotationClass = (PsiClass)DumbService.getInstance((Project)project).computeWithAlternativeResolveEnabled(() -> JavaPsiFacade.getInstance((Project)member.getProject()).findClass(annotationName, member.getResolveScope()));
            PsiElement[] dataElements = tag.getDataElements();
            if (dataElements.length > 1) {
                annotationText.append('(');
            }
            if (annotationClass != null) {
                for (PsiMethod attribute : annotationClass.getMethods()) {
                    boolean stripQuotes = false;
                    PsiType returnType = attribute.getReturnType();
                    if (returnType instanceof PsiPrimitiveType) {
                        stripQuotes = true;
                    }
                    for (int i = 0; i < dataElements.length; ++i) {
                        String next;
                        String key;
                        String text = dataElements[i].getText();
                        int equals = text.indexOf(61);
                        String string = key = equals == -1 ? text : text.substring(0, equals).trim();
                        if (!key.equals(attribute.getName())) continue;
                        annotationText.append(key).append(" = ");
                        String value = equals == -1 ? ((next = dataElements[++i].getText().trim()).length() == 1 ? dataElements[++i].getText().trim() : next.substring(1).trim()) : (equals < text.length() - 1 ? text.substring(equals + 1).trim() : dataElements[++i].getText().trim());
                        if (stripQuotes && value.charAt(0) == '\"') {
                            value = value.substring(1, value.length() - 1);
                        }
                        annotationText.append(value);
                    }
                }
            }
            if (dataElements.length > 1) {
                annotationText.append(')');
            }
            try {
                PsiModifierList modifierList = member.getModifierList();
                PsiAnnotation annotation = JavaPsiFacade.getElementFactory((Project)tag.getProject()).createAnnotationFromText(annotationText.toString(), (PsiElement)member);
                PsiElement inserted = modifierList.addBefore((PsiElement)annotation, modifierList.getFirstChild());
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(inserted);
                PsiDocComment docComment = (PsiDocComment)PsiTreeUtil.getParentOfType((PsiElement)tag, PsiDocComment.class);
                LOG.assertTrue(docComment != null);
                tag.delete();
                for (PsiElement element : docComment.getChildren()) {
                    if (element instanceof PsiWhiteSpace) continue;
                    if (!(element instanceof PsiDocToken)) {
                        return;
                    }
                    PsiDocToken docToken = (PsiDocToken)element;
                    if (docToken.getTokenType() != JavaDocTokenType.DOC_COMMENT_DATA || docToken.getText().trim().isEmpty()) continue;
                    return;
                }
                docComment.delete();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        private static String getFQAnnotationName(PsiDocTag tag) {
            String annotationName = StringUtil.capitalize((String)tag.getName().substring(ConvertJavadocInspection.TESTNG_PREFIX.length()));
            int dash = annotationName.indexOf(45);
            if (dash > -1) {
                annotationName = annotationName.substring(0, dash) + Character.toUpperCase(annotationName.charAt(dash + 1)) + annotationName.substring(dash + 2);
            }
            annotationName = "org.testng.annotations." + annotationName;
            return annotationName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/theoryinpractice/testng/inspection/ConvertJavadocInspection$ConvertJavadocQuickfix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/theoryinpractice/testng/inspection/ConvertJavadocInspection$ConvertJavadocQuickfix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

