/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.impl.DirtyFilesHolderBase;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.GlobalContextKey;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.java.JavaBuilder;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.kotlin.build.GeneratedFile;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.kotlin.compilerRunner.JpsCompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.JpsKotlinCompilerRunner;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollector;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollectorImpl;
import org.jetbrains.kotlin.compilerRunner.ProgressReporterImpl;
import org.jetbrains.kotlin.compilerRunner.SimpleOutputItem;
import org.jetbrains.kotlin.compilerRunner.SimpleOutputItemKt;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.KotlinModuleKind;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.ExpectActualTrackerImpl;
import org.jetbrains.kotlin.incremental.LookupStorage;
import org.jetbrains.kotlin.incremental.LookupTrackerImpl;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.jps.build.FSOperationsHelper;
import org.jetbrains.kotlin.jps.build.HasKotlinMarker;
import org.jetbrains.kotlin.jps.build.IdeaPlatformKt;
import org.jetbrains.kotlin.jps.build.JpsUtilKt;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.build.KotlinBuilderKt;
import org.jetbrains.kotlin.jps.build.KotlinChunk;
import org.jetbrains.kotlin.jps.build.KotlinCompileContext;
import org.jetbrains.kotlin.jps.build.KotlinCompileContextKt;
import org.jetbrains.kotlin.jps.build.KotlinDirtySourceFilesHolder;
import org.jetbrains.kotlin.jps.build.KotlinJpsCompilerArgumentsProvider;
import org.jetbrains.kotlin.jps.build.MessageCollectorAdapter;
import org.jetbrains.kotlin.jps.build.TeamcityStatisticsLogger;
import org.jetbrains.kotlin.jps.build.TestingBuildLogger;
import org.jetbrains.kotlin.jps.build.TestingContext;
import org.jetbrains.kotlin.jps.build.TestingContextKt;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCache;
import org.jetbrains.kotlin.jps.incremental.JpsLookupStorageKt;
import org.jetbrains.kotlin.jps.model.ModuleSettingsKt;
import org.jetbrains.kotlin.jps.targets.KotlinJvmModuleBuildTarget;
import org.jetbrains.kotlin.jps.targets.KotlinModuleBuildTarget;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.preloading.ClassCondition;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.KotlinPathsFromHomeDir;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 I2\u00020\u0001:\u0001IB\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002JV\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0016\u0010\u001c\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010#\u001a\u00020$H\u0002JD\u0010%\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010'\u001a\u00020(2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010)\u001a\u00020*H\u0002J^\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020.2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010/\u001a\u0002002\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u00101\u001a\u00020\u00192\u0016\u0010\u001c\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J\u0010\u00102\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u00103\u001a\u0002042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u00105\u001a\u0012\u0012\u0004\u0012\u00020706j\b\u0012\u0004\u0012\u000207`8H\u0016J2\u00109\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020;0:0\u001d2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010<\u001a\u00020=H\u0002J\b\u0010>\u001a\u000207H\u0016J\u0010\u0010?\u001a\u0002042\u0006\u0010\u0007\u001a\u00020\bH\u0002J$\u0010@\u001a\u00020\u00122\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010/\u001a\u0002002\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010A\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010B\u001a\u00020\u00122\u0006\u0010-\u001a\u00020.2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010C\u001a\u000204H\u0002J*\u0010D\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0018\u0010E\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020;0:0\u001dH\u0002J \u0010F\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010G\u001a\u00020H2\u0006\u0010\u000b\u001a\u00020(H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinBuilder;", "Lorg/jetbrains/jps/incremental/ModuleLevelBuilder;", "()V", "statisticsLogger", "Lorg/jetbrains/kotlin/jps/build/TeamcityStatisticsLogger;", "build", "Lorg/jetbrains/jps/incremental/ModuleLevelBuilder$ExitCode;", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "chunk", "Lorg/jetbrains/jps/ModuleChunk;", "dirtyFilesHolder", "Lorg/jetbrains/jps/builders/DirtyFilesHolder;", "Lorg/jetbrains/jps/builders/java/JavaSourceRootDescriptor;", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "outputConsumer", "Lorg/jetbrains/jps/incremental/ModuleLevelBuilder$OutputConsumer;", "buildFinished", "", "buildStarted", "chunkBuildFinished", "chunkBuildStarted", "computeKotlinPathsForJpsPlugin", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "createCompileEnvironment", "Lorg/jetbrains/kotlin/compilerRunner/JpsCompilerEnvironment;", "kotlinModuleBuilderTarget", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "incrementalCaches", "", "Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCache;", "lookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "exceptActualTracer", "Lorg/jetbrains/kotlin/incremental/components/ExpectActualTracker;", "messageCollector", "Lorg/jetbrains/kotlin/jps/build/MessageCollectorAdapter;", "doBuild", "representativeTarget", "kotlinDirtyFilesHolder", "Lorg/jetbrains/kotlin/jps/build/KotlinDirtySourceFilesHolder;", "fsOperations", "Lorg/jetbrains/kotlin/jps/build/FSOperationsHelper;", "doCompileModuleChunk", "Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollector;", "kotlinChunk", "Lorg/jetbrains/kotlin/jps/build/KotlinChunk;", "commonArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "environment", "ensureKotlinContextDisposed", "ensureKotlinContextInitialized", "Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;", "getCompilableFileExtensions", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "getGeneratedFiles", "", "Lorg/jetbrains/kotlin/build/GeneratedFile;", "outputItemCollector", "Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollectorImpl;", "getPresentableName", "initializeKotlinContext", "loadPlugins", "logSettings", "markAdditionalFilesForInitialRound", "kotlinContext", "registerOutputItems", "outputItems", "updateLookupStorage", "dataManager", "Lorg/jetbrains/jps/incremental/storage/BuildDataManager;", "Companion", "jps-plugin"})
public final class KotlinBuilder
extends ModuleLevelBuilder {
    private final TeamcityStatisticsLogger statisticsLogger = new TeamcityStatisticsLogger();
    @NotNull
    public static final String KOTLIN_BUILDER_NAME = "Kotlin Builder";
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String SKIP_CACHE_VERSION_CHECK_PROPERTY = "kotlin.jps.skip.cache.version.check";
    @NotNull
    public static final String JPS_KOTLIN_HOME_PROPERTY = "jps.kotlin.home";
    public static final Companion Companion;

    @NotNull
    public String getPresentableName() {
        return KOTLIN_BUILDER_NAME;
    }

    @NotNull
    public ArrayList<String> getCompilableFileExtensions() {
        return CollectionsKt.arrayListOf((Object[])new String[]{"kt", "kts"});
    }

    public void buildStarted(@NotNull CompileContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.logSettings(context);
    }

    private final void logSettings(CompileContext context) {
        LOG.debug("==========================================");
        LOG.info("is Kotlin incremental compilation enabled for JVM: " + IncrementalCompilation.isEnabledForJvm());
        LOG.info("is Kotlin incremental compilation enabled for JS: " + IncrementalCompilation.isEnabledForJs());
        LOG.info("is Kotlin compiler daemon enabled: " + DaemonParamsKt.isDaemonEnabled());
        String historyLabel = context.getBuilderParameter("history label");
        if (historyLabel != null) {
            LOG.info("Label in local history: " + historyLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final KotlinCompileContext ensureKotlinContextInitialized(CompileContext context) {
        KotlinCompileContext kotlinCompileContext = (KotlinCompileContext)context.getUserData((Key)KotlinCompileContextKt.getKotlinCompileContextKey());
        if (kotlinCompileContext != null) {
            return kotlinCompileContext;
        }
        GlobalContextKey<KotlinCompileContext> globalContextKey = KotlinCompileContextKt.getKotlinCompileContextKey();
        synchronized (globalContextKey) {
            KotlinCompileContext actualKotlinCompileContext = (KotlinCompileContext)context.getUserData((Key)KotlinCompileContextKt.getKotlinCompileContextKey());
            if (actualKotlinCompileContext != null) {
                return actualKotlinCompileContext;
            }
            try {
                return this.initializeKotlinContext(context);
            }
            catch (Throwable t) {
                IdeaPlatformKt.jpsReportInternalBuilderError(context, new Error("Cannot initialize Kotlin context: " + t.getMessage(), t));
                throw t;
            }
        }
    }

    private final KotlinCompileContext initializeKotlinContext(CompileContext context) {
        KotlinCompileContext kotlinContext = null;
        long start$iv = System.currentTimeMillis();
        kotlinContext = new KotlinCompileContext(context);
        context.putUserData((Key)KotlinCompileContextKt.getKotlinCompileContextKey(), (Object)kotlinContext);
        TestingContext testingContext = TestingContextKt.getTestingContext(context);
        if (testingContext != null) {
            testingContext.setKotlinCompileContext(kotlinContext);
        }
        if (kotlinContext.getShouldCheckCacheVersions() && kotlinContext.hasKotlin()) {
            kotlinContext.checkCacheVersions();
        }
        kotlinContext.cleanupCaches();
        kotlinContext.reportUnsupportedTargets();
        long time = System.currentTimeMillis() - start$iv;
        LOG.info("Total Kotlin global compile context initialization time: " + time + " ms");
        return kotlinContext;
    }

    public void buildFinished(@NotNull CompileContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.ensureKotlinContextDisposed(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ensureKotlinContextDisposed(CompileContext context) {
        if (context.getUserData((Key)KotlinCompileContextKt.getKotlinCompileContextKey()) != null) {
            GlobalContextKey<KotlinCompileContext> globalContextKey = KotlinCompileContextKt.getKotlinCompileContextKey();
            synchronized (globalContextKey) {
                KotlinCompileContext kotlinCompileContext = (KotlinCompileContext)context.getUserData((Key)KotlinCompileContextKt.getKotlinCompileContextKey());
                if (kotlinCompileContext != null) {
                    kotlinCompileContext.dispose();
                    context.putUserData((Key)KotlinCompileContextKt.getKotlinCompileContextKey(), null);
                    this.statisticsLogger.reportTotal();
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public void chunkBuildStarted(@NotNull CompileContext context, @NotNull ModuleChunk chunk) {
        block10: {
            boolean bl;
            TestingBuildLogger buildLogger;
            KotlinCompileContext kotlinContext;
            block9: {
                Set targets;
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"chunk");
                super.chunkBuildStarted(context, chunk);
                if (JpsUtilKt.isDummy(chunk, context)) {
                    return;
                }
                kotlinContext = this.ensureKotlinContextInitialized(context);
                TestingContext testingContext = TestingContextKt.getTestingContext(context);
                TestingBuildLogger testingBuildLogger = buildLogger = testingContext != null ? testingContext.getBuildLogger() : null;
                if (testingBuildLogger != null) {
                    testingBuildLogger.chunkBuildStarted(context, chunk);
                }
                if (JavaBuilderUtil.isForcedRecompilationAllJavaModules((CompileContext)context)) {
                    return;
                }
                Set set = targets = chunk.getTargets();
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"targets");
                Iterable $receiver$iv = set;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        ModuleBuildTarget it = (ModuleBuildTarget)element$iv;
                        HasKotlinMarker hasKotlinMarker = kotlinContext.getHasKotlinMarker();
                        ModuleBuildTarget moduleBuildTarget = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"it");
                        if (!Intrinsics.areEqual((Object)hasKotlinMarker.get(moduleBuildTarget), (Object)true)) continue;
                        bl = false;
                        break block9;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return;
            }
            KotlinChunk kotlinChunk = kotlinContext.getChunk(chunk);
            if (kotlinChunk == null) {
                return;
            }
            KotlinChunk kotlinChunk2 = kotlinChunk;
            kotlinContext.checkChunkCacheVersion(kotlinChunk2);
            if (!kotlinContext.getRebuildingAllKotlin() && kotlinChunk2.isEnabled()) {
                this.markAdditionalFilesForInitialRound(kotlinChunk2, chunk, kotlinContext);
            }
            TestingBuildLogger testingBuildLogger = buildLogger;
            if (testingBuildLogger == null) break block10;
            testingBuildLogger.afterChunkBuildStarted(context, chunk);
        }
    }

    private final void markAdditionalFilesForInitialRound(KotlinChunk kotlinChunk, ModuleChunk chunk, KotlinCompileContext kotlinContext) {
        CompileContext context = kotlinContext.getJpsContext();
        KotlinDirtySourceFilesHolder dirtyFilesHolder2 = new KotlinDirtySourceFilesHolder(chunk, context, (DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget>)((DirtyFilesHolder)new DirtyFilesHolderBase<JavaSourceRootDescriptor, ModuleBuildTarget>(context, chunk, context){
            final /* synthetic */ CompileContext $context;
            final /* synthetic */ ModuleChunk $chunk;

            public void processDirtyFiles(@NotNull FileProcessor<JavaSourceRootDescriptor, ModuleBuildTarget> processor) {
                Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
                FSOperations.processFilesToRecompile((CompileContext)this.$context, (ModuleChunk)this.$chunk, processor);
            }
            {
                this.$context = $captured_local_variable$0;
                this.$chunk = $captured_local_variable$1;
                super($super_call_param$2);
            }
        }));
        FSOperationsHelper fsOperations = new FSOperationsHelper(context, chunk, dirtyFilesHolder2, LOG);
        KotlinModuleBuildTarget<?> kotlinModuleBuildTarget = kotlinContext.getTargetsBinding().get(chunk.representativeTarget());
        if (kotlinModuleBuildTarget == null) {
            return;
        }
        KotlinModuleBuildTarget<?> representativeTarget = kotlinModuleBuildTarget;
        Map<KotlinModuleBuildTarget<?>, JpsIncrementalCache> incrementalCaches = kotlinChunk.loadCaches(false);
        MessageCollectorAdapter messageCollector = new MessageCollectorAdapter(context, representativeTarget);
        JpsCompilerEnvironment jpsCompilerEnvironment = this.createCompileEnvironment(kotlinContext.getJpsContext(), representativeTarget, incrementalCaches, LookupTracker.DO_NOTHING.INSTANCE, ExpectActualTracker.DoNothing.INSTANCE, chunk, messageCollector);
        if (jpsCompilerEnvironment == null) {
            return;
        }
        JpsCompilerEnvironment environment = jpsCompilerEnvironment;
        HashSet<String> removedClasses = new HashSet<String>();
        for (KotlinModuleBuildTarget<?> target : kotlinChunk.getTargets()) {
            JpsIncrementalCache cache;
            if (incrementalCaches.get(target) == null) {
                continue;
            }
            Set<File> dirtyFiles = dirtyFilesHolder2.getDirtyFiles(target.getJpsModuleBuildTarget()).keySet();
            Collection<File> removedFiles = dirtyFilesHolder2.getRemovedFiles(target.getJpsModuleBuildTarget());
            Set<String> existingClasses = new JpsKotlinCompilerRunner().classesFqNamesByFiles(environment, dirtyFiles);
            Collection<FqName> previousClasses = cache.classesFqNamesBySources(SetsKt.plus(dirtyFiles, (Iterable)removedFiles));
            for (FqName jvmClassName : previousClasses) {
                String fqName2;
                Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName.asString(), (String)"jvmClassName.asString()");
                if (existingClasses.contains(fqName2)) continue;
                removedClasses.add(fqName2);
            }
        }
        ChangesCollector changesCollector = new ChangesCollector();
        Iterable $receiver$iv = removedClasses;
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            changesCollector.collectSignature(new FqName(it), true);
        }
        Iterable iterable = incrementalCaches.values();
        BuildDataManager buildDataManager = context.getProjectDescriptor().dataManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"context.projectDescriptor.dataManager");
        Set affectedByRemovedClasses = KotlinBuilderKt.access$getDirtyFiles(changesCollector, iterable, buildDataManager);
        fsOperations.markFilesForCurrentRound$jps_plugin(affectedByRemovedClasses);
    }

    public void chunkBuildFinished(@NotNull CompileContext context, @NotNull ModuleChunk chunk) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"chunk");
        super.chunkBuildFinished(context, chunk);
        if (JpsUtilKt.isDummy(chunk, context)) {
            return;
        }
        LOG.debug("------------------------------------------");
    }

    @NotNull
    public ModuleLevelBuilder.ExitCode build(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder2, @NotNull ModuleLevelBuilder.OutputConsumer outputConsumer) {
        boolean bl;
        MessageCollectorAdapter messageCollector;
        KotlinModuleBuildTarget<?> kotlinTarget;
        block12: {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"chunk");
            Intrinsics.checkParameterIsNotNull(dirtyFilesHolder2, (String)"dirtyFilesHolder");
            Intrinsics.checkParameterIsNotNull((Object)outputConsumer, (String)"outputConsumer");
            if (JpsUtilKt.isDummy(chunk, context)) {
                return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
            }
            KotlinModuleBuildTarget<?> kotlinModuleBuildTarget = JpsUtilKt.getKotlinBuildTargets(context).get(chunk.representativeTarget());
            if (kotlinModuleBuildTarget == null) {
                return ModuleLevelBuilder.ExitCode.OK;
            }
            kotlinTarget = kotlinModuleBuildTarget;
            messageCollector = new MessageCollectorAdapter(context, kotlinTarget);
            Set set = chunk.getModules();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"chunk.modules");
            Iterable $receiver$iv = set;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    JpsModule it;
                    JpsModule jpsModule = it = (JpsModule)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"it");
                    if (!(ModuleSettingsKt.getKotlinKind(jpsModule) == KotlinModuleKind.SOURCE_SET_HOLDER)) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
        }
        if (bl) {
            if (chunk.getModules().size() > 1) {
                MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Cyclically dependent modules are not supported in multiplatform projects", null, 4, null);
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        KotlinDirtySourceFilesHolder kotlinDirtyFilesHolder = new KotlinDirtySourceFilesHolder(chunk, context, dirtyFilesHolder2);
        FSOperationsHelper fsOperations = new FSOperationsHelper(context, chunk, kotlinDirtyFilesHolder, LOG);
        try {
            ModuleLevelBuilder.ExitCode proposedExitCode = this.doBuild(chunk, kotlinTarget, context, kotlinDirtyFilesHolder, messageCollector, outputConsumer, fsOperations);
            ModuleLevelBuilder.ExitCode actualExitCode = proposedExitCode == ModuleLevelBuilder.ExitCode.OK && fsOperations.getHasMarkedDirty$jps_plugin() ? ModuleLevelBuilder.ExitCode.ADDITIONAL_PASS_REQUIRED : proposedExitCode;
            LOG.debug("Build result: " + actualExitCode);
            Object object = TestingContextKt.getTestingContext(context);
            if (object != null && (object = ((TestingContext)object).getBuildLogger()) != null) {
                object.buildFinished(actualExitCode);
            }
            return actualExitCode;
        }
        catch (StopBuildException e) {
            LOG.info("Caught exception: " + (Object)((Object)e));
            throw (Throwable)e;
        }
        catch (BuildDataCorruptedException e) {
            LOG.info("Caught exception: " + (Object)((Object)e));
            throw (Throwable)e;
        }
        catch (Throwable e) {
            LOG.info("Caught exception: " + e);
            MessageCollectorUtil.reportException(messageCollector, e);
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final ModuleLevelBuilder.ExitCode doBuild(ModuleChunk chunk, KotlinModuleBuildTarget<?> representativeTarget, CompileContext context, KotlinDirtySourceFilesHolder kotlinDirtyFilesHolder, MessageCollectorAdapter messageCollector, ModuleLevelBuilder.OutputConsumer outputConsumer, FSOperationsHelper fsOperations) {
        block36: {
            block35: {
                if (representativeTarget instanceof KotlinJvmModuleBuildTarget && !((Boolean)JavaBuilder.IS_ENABLED.get((UserDataHolder)context, (Object)true)).booleanValue()) {
                    MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.INFO, "Kotlin JPS plugin is disabled", null, 4, null);
                    return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
                }
                kotlinContext = KotlinCompileContextKt.getKotlin(context);
                v0 = JpsUtilKt.toKotlinChunk(chunk, context);
                if (v0 == null) {
                    Intrinsics.throwNpe();
                }
                if (!(kotlinChunk = v0).getHaveSameCompiler()) {
                    MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Cyclically dependent modules " + kotlinChunk.getPresentableModulesToCompilersList() + " should have same compiler.", null, 4, null);
                    return ModuleLevelBuilder.ExitCode.ABORT;
                }
                if (!kotlinChunk.isEnabled()) {
                    return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
                }
                projectDescriptor = context.getProjectDescriptor();
                dataManager = projectDescriptor.dataManager;
                targets = chunk.getTargets();
                if (JavaBuilderUtil.isForcedRecompilationAllJavaModules((CompileContext)context)) ** GOTO lbl-1000
                v1 = targets;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"targets");
                $receiver$iv = v1;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    v2 = false;
                } else {
                    for (Iterable element$iv : $receiver$iv) {
                        it = (ModuleBuildTarget)element$iv /* !! */ ;
                        v3 = kotlinContext.getRebuildAfterCacheVersionChanged();
                        v4 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"it");
                        if (!Intrinsics.areEqual((Object)v3.get(v4), (Object)true)) continue;
                        v2 = true;
                        break block35;
                    }
                    v2 = false;
                }
            }
            if (v2) lbl-1000:
            // 2 sources

            {
                v5 = true;
            } else {
                v5 = isChunkRebuilding = false;
            }
            if (!kotlinDirtyFilesHolder.getHasDirtyOrRemovedFiles()) {
                if (isChunkRebuilding) {
                    v6 = targets;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"targets");
                    $receiver$iv = v6;
                    for (Iterable element$iv : $receiver$iv) {
                        it = (ModuleBuildTarget)element$iv /* !! */ ;
                        v7 = kotlinContext.getHasKotlinMarker();
                        v8 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"it");
                        v7.set(v8, false);
                    }
                }
                v9 = targets;
                Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"targets");
                $receiver$iv = v9;
                for (Iterable element$iv : $receiver$iv) {
                    it = (ModuleBuildTarget)element$iv /* !! */ ;
                    v10 = kotlinContext.getRebuildAfterCacheVersionChanged();
                    v11 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"it");
                    v10.clean(v11);
                }
                return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
            }
            if (!isChunkRebuilding && !representativeTarget.isIncrementalCompilationEnabled()) {
                v12 = targets;
                Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"targets");
                $receiver$iv = v12;
                for (Iterable element$iv : $receiver$iv) {
                    it = (ModuleBuildTarget)element$iv /* !! */ ;
                    v13 = kotlinContext.getRebuildAfterCacheVersionChanged();
                    v14 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v14, (String)"it");
                    v13.set(v14, true);
                }
                return ModuleLevelBuilder.ExitCode.CHUNK_REBUILD_REQUIRED;
            }
            v15 = targets;
            Intrinsics.checkExpressionValueIsNotNull((Object)v15, (String)"targets");
            element$iv /* !! */  = $receiver$iv = (Iterable)v15;
            destination$iv$iv = new ArrayList<E>();
            for (T element$iv$iv : $receiver$iv$iv) {
                v16 = it = (ModuleBuildTarget)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)v16, (String)"it");
                if (!(v16.getOutputDir() == null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            targetsWithoutOutputDir = (List)destination$iv$iv;
            $receiver$iv = targetsWithoutOutputDir;
            if ($receiver$iv.isEmpty() == false) {
                MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Output directory not specified for " + CollectionsKt.joinToString$default((Iterable)targetsWithoutOutputDir, null, null, null, (int)0, null, null, (int)63, null), null, 4, null);
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            v17 = projectDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)v17, (String)"projectDescriptor");
            v18 = project = v17.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)v18, (String)"project");
            lookupTracker = KotlinBuilderKt.access$getLookupTracker(v18, representativeTarget);
            exceptActualTracer = new ExpectActualTrackerImpl();
            incrementalCaches = KotlinChunk.loadCaches$default(kotlinChunk, false, 1, null);
            v19 = this.createCompileEnvironment(context, representativeTarget, incrementalCaches, lookupTracker, exceptActualTracer, chunk, messageCollector);
            if (v19 == null) {
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            environment = v19;
            if (KotlinBuilder.LOG.isDebugEnabled()) {
                KotlinBuilder.LOG.debug("Compiling files: " + kotlinDirtyFilesHolder.getAllDirtyFiles());
            }
            start = System.nanoTime();
            outputItemCollector = this.doCompileModuleChunk(kotlinChunk, representativeTarget, kotlinChunk.getCompilerArguments(), context, kotlinDirtyFilesHolder, fsOperations, environment, incrementalCaches);
            this.statisticsLogger.registerStatistic(chunk, System.nanoTime() - start);
            if (outputItemCollector == null) {
                return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
            }
            v20 = compilationErrors = (Boolean)Utils.ERRORS_DETECTED_KEY.get((UserDataHolder)context, (Object)false);
            Intrinsics.checkExpressionValueIsNotNull((Object)v20, (String)"compilationErrors");
            if (v20.booleanValue()) {
                KotlinBuilder.LOG.info("Compiled with errors");
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            KotlinBuilder.LOG.info("Compiled successfully");
            generatedFiles = this.getGeneratedFiles(context, chunk, environment.getOutputItemsCollector());
            this.registerOutputItems(outputConsumer, generatedFiles);
            kotlinChunk.saveVersions();
            $receiver$iv = targets;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                v21 = false;
            } else {
                var26_26 = $receiver$iv.iterator();
                while (var26_26.hasNext()) {
                    element$iv /* !! */  = var26_26.next();
                    it = (ModuleBuildTarget)element$iv /* !! */ ;
                    v22 = kotlinContext.getHasKotlinMarker();
                    v23 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v23, (String)"it");
                    if (!(v22.get(v23) == null)) continue;
                    v21 = true;
                    break block36;
                }
                v21 = false;
            }
        }
        if (v21) {
            fsOperations.markChunk(false, true, kotlinDirtyFilesHolder.getAllDirtyFiles());
        }
        for (ModuleBuildTarget target : targets) {
            v24 = kotlinContext.getHasKotlinMarker();
            v25 = target;
            Intrinsics.checkExpressionValueIsNotNull((Object)v25, (String)"target");
            v24.set(v25, true);
            kotlinContext.getRebuildAfterCacheVersionChanged().clean(target);
        }
        $receiver$iv = kotlinChunk.getTargets();
        var26_26 = $receiver$iv.iterator();
        while (var26_26.hasNext()) {
            element$iv /* !! */  = var26_26.next();
            it = (KotlinModuleBuildTarget)element$iv /* !! */ ;
            it.doAfterBuild();
        }
        representativeTarget.updateChunkMappings(context, chunk, kotlinDirtyFilesHolder, generatedFiles, incrementalCaches);
        if (!representativeTarget.isIncrementalCompilationEnabled()) {
            return ModuleLevelBuilder.ExitCode.OK;
        }
        context.checkCanceled();
        $receiver$iv = environment;
        try {
            progress = $receiver$iv.getProgressReporter();
            progress.progress("performing incremental compilation analysis");
            changesCollector = new ChangesCollector();
            it = generatedFiles;
            var29_29 = it.entrySet().iterator();
            while (var29_29.hasNext()) {
                var31_31 = var30_30 = var29_29.next();
                target = (ModuleBuildTarget)var31_31.getKey();
                var31_31 = var30_30;
                files = (List)var31_31.getValue();
                if (kotlinContext.getTargetsBinding().get(target) == null) {
                    Intrinsics.throwNpe();
                }
                v26 = incrementalCaches.get(kotlinModuleBuilderTarget);
                if (v26 == null) {
                    Intrinsics.throwNpe();
                }
                kotlinModuleBuilderTarget.updateCaches(kotlinDirtyFilesHolder, (JpsIncrementalCache)v26, files, changesCollector, environment);
            }
            v27 = dataManager;
            Intrinsics.checkExpressionValueIsNotNull((Object)v27, (String)"dataManager");
            this.updateLookupStorage(lookupTracker, v27, kotlinDirtyFilesHolder);
            if (!isChunkRebuilding) {
                KotlinBuilderKt.access$processChangesUsingLookups(changesCollector, kotlinDirtyFilesHolder.getAllDirtyFiles(), dataManager, fsOperations, incrementalCaches.values());
            }
            var34_33 = Unit.INSTANCE;
        }
        finally {
            $receiver$iv.getProgressReporter().clearProgress();
        }
        return ModuleLevelBuilder.ExitCode.OK;
    }

    private final OutputItemsCollector doCompileModuleChunk(KotlinChunk kotlinChunk, KotlinModuleBuildTarget<?> representativeTarget, CommonCompilerArguments commonArguments, CompileContext context, KotlinDirtySourceFilesHolder dirtyFilesHolder2, FSOperationsHelper fsOperations, JpsCompilerEnvironment environment, Map<KotlinModuleBuildTarget<?>, ? extends JpsIncrementalCache> incrementalCaches) {
        boolean bl;
        this.loadPlugins(representativeTarget, commonArguments, context);
        Iterable iterable = kotlinChunk.getTargets();
        for (Object element$iv : iterable) {
            KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv;
            it.nextRound(context);
        }
        if (representativeTarget.isIncrementalCompilationEnabled()) {
            for (KotlinModuleBuildTarget kotlinModuleBuildTarget : kotlinChunk.getTargets()) {
                JpsIncrementalCache cache = incrementalCaches.get(kotlinModuleBuildTarget);
                ModuleBuildTarget jpsTarget = kotlinModuleBuildTarget.getJpsModuleBuildTarget();
                KotlinDirtySourceFilesHolder.TargetFiles targetDirtyFiles2 = dirtyFilesHolder2.getByTarget().get(jpsTarget);
                if (cache == null || targetDirtyFiles2 == null) continue;
                Collection<File> complementaryFiles = cache.getComplementaryFilesRecursive(SetsKt.plus(targetDirtyFiles2.getDirty().keySet(), (Iterable)targetDirtyFiles2.getRemoved()));
                fsOperations.markFilesForCurrentRound(jpsTarget, (Iterable<? extends File>)complementaryFiles);
                cache.markDirty(SetsKt.plus(targetDirtyFiles2.getDirty().keySet(), (Iterable)targetDirtyFiles2.getRemoved()));
            }
        }
        return (bl = representativeTarget.compileModuleChunk(commonArguments, dirtyFilesHolder2, environment)) ? (OutputItemsCollector)environment.getOutputItemsCollector() : null;
    }

    private final void loadPlugins(KotlinModuleBuildTarget<?> representativeTarget, CommonCompilerArguments commonArguments, CompileContext context) {
        loadPlugins.1 concatenate$ = loadPlugins.1.INSTANCE;
        for (KotlinJpsCompilerArgumentsProvider argumentProvider : ServiceLoader.load(KotlinJpsCompilerArgumentsProvider.class)) {
            ModuleBuildTarget jpsModuleBuildTarget = representativeTarget.getJpsModuleBuildTarget();
            commonArguments.setPluginOptions(concatenate$.invoke(commonArguments.getPluginOptions(), argumentProvider.getExtraArguments(jpsModuleBuildTarget, context)));
            commonArguments.setPluginClasspaths(concatenate$.invoke(commonArguments.getPluginClasspaths(), argumentProvider.getClasspath(jpsModuleBuildTarget, context)));
            LOG.debug("Plugin loaded: " + argumentProvider.getClass().getSimpleName());
        }
    }

    private final JpsCompilerEnvironment createCompileEnvironment(CompileContext context, KotlinModuleBuildTarget<?> kotlinModuleBuilderTarget, Map<KotlinModuleBuildTarget<?>, ? extends JpsIncrementalCache> incrementalCaches, LookupTracker lookupTracker, ExpectActualTracker exceptActualTracer, ModuleChunk chunk, MessageCollectorAdapter messageCollector) {
        Services.Builder builder;
        Services.Builder $receiver = builder = new Services.Builder();
        kotlinModuleBuilderTarget.makeServices($receiver, incrementalCaches, lookupTracker, exceptActualTracer);
        Services compilerServices = $receiver.build();
        KotlinPaths paths = this.computeKotlinPathsForJpsPlugin();
        if (paths == null || !paths.getHomePath().exists()) {
            MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Cannot find kotlinc home. Make sure the plugin is properly installed, or specify jps.kotlin.home system property", null, 4, null);
            return null;
        }
        return new JpsCompilerEnvironment(paths, compilerServices, Companion.getClassesToLoadByParent(), messageCollector, new OutputItemsCollectorImpl(), new ProgressReporterImpl(context, chunk));
    }

    private final KotlinPaths computeKotlinPathsForJpsPlugin() {
        File jar;
        if (StringsKt.equals((String)System.getProperty("kotlin.jps.tests"), (String)"true", (boolean)true)) {
            return PathUtil.getKotlinPathsForDistDirectory();
        }
        String jpsKotlinHome = System.getProperty(JPS_KOTLIN_HOME_PROPERTY);
        if (jpsKotlinHome != null) {
            return new KotlinPathsFromHomeDir(new File(jpsKotlinHome));
        }
        File file = PathUtil.INSTANCE.getPathUtilJar();
        File p1 = file;
        File file2 = jar = p1.exists() ? file : null;
        if (Intrinsics.areEqual((Object)(file2 != null ? file2.getName() : null), (Object)"kotlin-jps-plugin.jar")) {
            File file3 = jar.getParentFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"jar.parentFile");
            File file4 = file3.getParentFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"jar.parentFile.parentFile");
            File pluginHome = file4.getParentFile();
            return new KotlinPathsFromHomeDir(new File(pluginHome, "kotlinc"));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<ModuleBuildTarget, List<GeneratedFile>> getGeneratedFiles(CompileContext context, ModuleChunk chunk, OutputItemsCollectorImpl outputItemCollector) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        HashMap sourceToTarget = new HashMap();
        if (chunk.getTargets().size() > 1) {
            for (ModuleBuildTarget target : chunk.getTargets()) {
                KotlinModuleBuildTarget<?> kotlinModuleBuildTarget = JpsUtilKt.getKotlinBuildTargets(context).get(target);
                if (kotlinModuleBuildTarget != null && (kotlinModuleBuildTarget = kotlinModuleBuildTarget.getSourceFiles()) != null) {
                    $receiver$iv = (Iterable)((Object)kotlinModuleBuildTarget);
                    for (Object element$iv : $receiver$iv) {
                        ModuleBuildTarget moduleBuildTarget;
                        File it = (File)element$iv;
                        Map map2 = sourceToTarget;
                        Intrinsics.checkExpressionValueIsNotNull((Object)target, (String)"target");
                        map2.put(it, moduleBuildTarget);
                    }
                }
            }
        }
        ModuleBuildTarget representativeTarget = chunk.representativeTarget();
        Function1<SimpleOutputItem, ModuleBuildTarget> target$ = new Function1<SimpleOutputItem, ModuleBuildTarget>(sourceToTarget, chunk, representativeTarget){
            final /* synthetic */ HashMap $sourceToTarget;
            final /* synthetic */ ModuleChunk $chunk;
            final /* synthetic */ ModuleBuildTarget $representativeTarget;

            /*
             * WARNING - void declaration
             */
            public final ModuleBuildTarget invoke(@NotNull SimpleOutputItem $receiver) {
                File file;
                File file2;
                File it;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                File file3 = (File)CollectionsKt.firstOrNull((Iterable)$receiver.getSourceFiles());
                if (file3 == null || (file3 = (ModuleBuildTarget)this.$sourceToTarget.get(it = (file2 = file3))) == null) {
                    Object object;
                    block6: {
                        void var3_3;
                        Set set = this.$chunk.getTargets();
                        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"chunk.targets");
                        Iterable $receiver$iv = set;
                        Object single$iv = null;
                        boolean found$iv = false;
                        for (T element$iv : $receiver$iv) {
                            boolean bl;
                            ModuleBuildTarget target;
                            ModuleBuildTarget moduleBuildTarget = target = (ModuleBuildTarget)element$iv;
                            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"target");
                            if (moduleBuildTarget.getOutputDir() != null) {
                                File file4;
                                File outputDir2 = file4;
                                File file5 = $receiver.getOutputFile();
                                File file6 = outputDir2;
                                Intrinsics.checkExpressionValueIsNotNull((Object)file6, (String)"outputDir");
                                bl = FilesKt.startsWith((File)file5, (File)file6);
                            } else {
                                bl = false;
                            }
                            if (!bl) continue;
                            if (found$iv) {
                                object = null;
                                break block6;
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        object = !found$iv ? null : var3_3;
                    }
                    file3 = file = (ModuleBuildTarget)object;
                }
                if (file3 == null) {
                    file = this.$representativeTarget;
                }
                return file;
            }
            {
                this.$sourceToTarget = hashMap;
                this.$chunk = moduleChunk;
                this.$representativeTarget = moduleBuildTarget;
                super(1);
            }
        };
        List<SimpleOutputItem> list = outputItemCollector.getOutputs();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"outputItemCollector.outputs");
        $receiver$iv = list;
        Iterable iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap();
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Map $receiver$iv$iv$iv = destination$iv$iv;
            Object element$iv$iv = iterator2.next();
            SimpleOutputItem p1 = (SimpleOutputItem)element$iv$iv;
            ModuleBuildTarget key$iv$iv = target$.invoke(p1);
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            p1 = (SimpleOutputItem)element$iv$iv;
            List list2 = list$iv$iv;
            GeneratedFile generatedFile = SimpleOutputItemKt.toGeneratedFile(p1);
            list2.add(generatedFile);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void registerOutputItems(ModuleLevelBuilder.OutputConsumer outputConsumer, Map<ModuleBuildTarget, ? extends List<? extends GeneratedFile>> outputItems) {
        Map<ModuleBuildTarget, ? extends List<? extends GeneratedFile>> map2 = outputItems;
        Iterator<Map.Entry<ModuleBuildTarget, ? extends List<? extends GeneratedFile>>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<ModuleBuildTarget, ? extends List<? extends GeneratedFile>> entry;
            Map.Entry<ModuleBuildTarget, ? extends List<? extends GeneratedFile>> entry2 = entry = iterator2.next();
            ModuleBuildTarget target = entry2.getKey();
            Map.Entry<ModuleBuildTarget, ? extends List<? extends GeneratedFile>> entry3 = entry;
            List<? extends GeneratedFile> outputs = entry3.getValue();
            for (GeneratedFile generatedFile : outputs) {
                Collection<String> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                Iterable iterable = generatedFile.getSourceFiles();
                File file = generatedFile.getOutputFile();
                BuildTarget buildTarget = (BuildTarget)target;
                ModuleLevelBuilder.OutputConsumer outputConsumer2 = outputConsumer;
                void var10_13 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    File file2 = (File)item$iv$iv;
                    collection = destination$iv$iv;
                    String string = it.getPath();
                    collection.add(string);
                }
                collection = (List)destination$iv$iv;
                outputConsumer2.registerOutputFile(buildTarget, file, (Collection)collection);
            }
        }
    }

    private final void updateLookupStorage(LookupTracker lookupTracker, BuildDataManager dataManager, KotlinDirtySourceFilesHolder dirtyFilesHolder2) {
        if (!(lookupTracker instanceof LookupTrackerImpl)) {
            throw (Throwable)((Object)new AssertionError((Object)("Lookup tracker is expected to be LookupTrackerImpl, got " + lookupTracker.getClass())));
        }
        JpsLookupStorageKt.withLookupStorage(dataManager, (Function1)new Function1<LookupStorage, Unit>(dirtyFilesHolder2, lookupTracker){
            final /* synthetic */ KotlinDirtySourceFilesHolder $dirtyFilesHolder;
            final /* synthetic */ LookupTracker $lookupTracker;

            public final void invoke(@NotNull LookupStorage lookupStorage) {
                Intrinsics.checkParameterIsNotNull((Object)lookupStorage, (String)"lookupStorage");
                lookupStorage.removeLookupsFrom((Sequence<? extends File>)SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)this.$dirtyFilesHolder.getAllDirtyFiles()), (Sequence)CollectionsKt.asSequence((Iterable)this.$dirtyFilesHolder.getAllRemovedFilesFiles())));
                Set set = ((LookupTrackerImpl)this.$lookupTracker).getLookups().entrySet();
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"lookupTracker.lookups.entrySet()");
                Set set2 = ((LookupTrackerImpl)this.$lookupTracker).getPathInterner().getValues();
                Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"lookupTracker.pathInterner.values");
                lookupStorage.addAll(set, set2);
            }
            {
                this.$dirtyFilesHolder = kotlinDirtySourceFilesHolder;
                this.$lookupTracker = lookupTracker;
                super(1);
            }
        });
    }

    public KotlinBuilder() {
        super(BuilderCategory.SOURCE_PROCESSOR);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance((String)"#org.jetbrains.kotlin.jps.build.KotlinBuilder");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(\"#org\u2026jps.build.KotlinBuilder\")");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinBuilder$Companion;", "", "()V", "JPS_KOTLIN_HOME_PROPERTY", "", "KOTLIN_BUILDER_NAME", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "SKIP_CACHE_VERSION_CHECK_PROPERTY", "classesToLoadByParent", "Lorg/jetbrains/kotlin/preloading/ClassCondition;", "getClassesToLoadByParent", "()Lorg/jetbrains/kotlin/preloading/ClassCondition;", "jps-plugin"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final ClassCondition getClassesToLoadByParent() {
            return classesToLoadByParent.1.INSTANCE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

