/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.shaking.ProguardPathList;

public class ProguardPathFilter {
    private final boolean enabled;
    private final ImmutableList<ProguardPathList> patterns;

    public static Builder builder() {
        return new Builder();
    }

    private ProguardPathFilter(ImmutableList<ProguardPathList> patterns, boolean enabled) {
        this.enabled = enabled;
        if (patterns.isEmpty()) {
            this.patterns = ImmutableList.of(ProguardPathList.emptyList());
        } else {
            assert (enabled);
            this.patterns = patterns;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean matches(String path) {
        if (this.enabled) {
            for (ProguardPathList pattern : this.patterns) {
                if (!pattern.matches(path)) continue;
                return true;
            }
        }
        return false;
    }

    public static class Builder {
        private boolean enabled = true;
        private final ImmutableList.Builder<ProguardPathList> patterns = ImmutableList.builder();

        private Builder() {
        }

        public Builder addPattern(ProguardPathList pattern) {
            this.patterns.add((Object)pattern);
            return this;
        }

        public Builder disable() {
            this.enabled = false;
            return this;
        }

        public Builder enable() {
            this.enabled = true;
            return this;
        }

        ProguardPathFilter build() {
            return new ProguardPathFilter((ImmutableList)this.patterns.build(), this.enabled);
        }
    }
}

