/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize;

import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.UseRegistry;

public class InvokeSingleTargetExtractor
extends UseRegistry {
    private InvokeKind kind = InvokeKind.NONE;
    private DexMethod target;

    public InvokeSingleTargetExtractor(DexItemFactory factory) {
        super(factory);
    }

    private boolean setTarget(DexMethod target, InvokeKind kind) {
        if (this.kind != InvokeKind.NONE) {
            this.kind = InvokeKind.ILLEGAL;
            this.target = null;
        } else {
            assert (this.target == null);
            this.target = target;
            this.kind = kind;
        }
        return false;
    }

    private boolean invalid() {
        this.kind = InvokeKind.ILLEGAL;
        return false;
    }

    public DexMethod getTarget() {
        return this.target;
    }

    public InvokeKind getKind() {
        return this.kind;
    }

    @Override
    public boolean registerInvokeVirtual(DexMethod method) {
        return this.setTarget(method, InvokeKind.VIRTUAL);
    }

    @Override
    public boolean registerInvokeDirect(DexMethod method) {
        return this.invalid();
    }

    @Override
    public boolean registerInvokeStatic(DexMethod method) {
        return this.setTarget(method, InvokeKind.STATIC);
    }

    @Override
    public boolean registerInvokeInterface(DexMethod method) {
        return this.invalid();
    }

    @Override
    public boolean registerInvokeSuper(DexMethod method) {
        return this.setTarget(method, InvokeKind.SUPER);
    }

    @Override
    public boolean registerInstanceFieldWrite(DexField field) {
        return this.invalid();
    }

    @Override
    public boolean registerInstanceFieldRead(DexField field) {
        return this.invalid();
    }

    @Override
    public boolean registerNewInstance(DexType type) {
        return this.invalid();
    }

    @Override
    public boolean registerStaticFieldRead(DexField field) {
        return this.invalid();
    }

    @Override
    public boolean registerStaticFieldWrite(DexField field) {
        return this.invalid();
    }

    @Override
    public boolean registerTypeReference(DexType type) {
        return this.invalid();
    }

    public static enum InvokeKind {
        VIRTUAL,
        STATIC,
        SUPER,
        ILLEGAL,
        NONE;

    }
}

