/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.lambda;

import com.android.tools.r8.com.google.common.collect.Lists;
import com.android.tools.r8.com.google.common.io.BaseEncoding;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.optimize.lambda.CodeProcessor;
import com.android.tools.r8.ir.optimize.lambda.LambdaGroupClassBuilder;
import com.android.tools.r8.ir.optimize.lambda.LambdaGroupId;
import com.android.tools.r8.kotlin.Kotlin;
import com.android.tools.r8.utils.ThrowingConsumer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;

public abstract class LambdaGroup {
    public final LambdaGroupId id;
    private DexType classType;
    private final Map<DexType, LambdaInfo> lambdas = new LinkedHashMap<DexType, LambdaInfo>();

    public LambdaGroup(LambdaGroupId id) {
        this.id = id;
    }

    public final DexType getGroupClassType() {
        assert (this.classType != null);
        return this.classType;
    }

    public final int size() {
        return this.lambdas.size();
    }

    public final void forEachLambda(Consumer<LambdaInfo> action) {
        assert (this.verifyLambdaIds(false));
        for (LambdaInfo info : this.lambdas.values()) {
            action.accept(info);
        }
    }

    public final boolean anyLambda(Predicate<LambdaInfo> predicate) {
        assert (this.verifyLambdaIds(false));
        for (LambdaInfo info : this.lambdas.values()) {
            if (!predicate.test(info)) continue;
            return true;
        }
        return false;
    }

    final boolean shouldAddToMainDex(AppInfo appInfo) {
        for (DexType type : this.lambdas.keySet()) {
            if (!appInfo.isInMainDexList(type)) continue;
            return true;
        }
        return false;
    }

    public final boolean containsLambda(DexType lambda2) {
        return this.lambdas.containsKey(lambda2);
    }

    public final int lambdaId(DexType lambda2) {
        assert (this.lambdas.containsKey(lambda2));
        return this.lambdas.get((Object)lambda2).id;
    }

    protected final DexEncodedField[] lambdaCaptureFields(DexType lambda2) {
        assert (this.lambdas.containsKey(lambda2));
        return this.lambdas.get((Object)lambda2).clazz.instanceFields();
    }

    protected final DexEncodedField lambdaSingletonField(DexType lambda2) {
        assert (this.lambdas.containsKey(lambda2));
        DexEncodedField[] fields = this.lambdas.get((Object)lambda2).clazz.staticFields();
        assert (fields.length < 2);
        return fields.length == 0 ? null : fields[0];
    }

    final boolean isTrivial() {
        return this.lambdas.size() < 2;
    }

    final void add(DexProgramClass lambda2) {
        assert (!this.lambdas.containsKey(lambda2.type));
        this.lambdas.put(lambda2.type, new LambdaInfo(this.lambdas.size(), lambda2));
    }

    final void remove(DexType lambda2) {
        assert (this.lambdas.containsKey(lambda2));
        this.lambdas.remove(lambda2);
    }

    final void compact() {
        assert (this.verifyLambdaIds(false));
        int lastUsed = -1;
        int lastSeen = -1;
        for (Map.Entry<DexType, LambdaInfo> entry : this.lambdas.entrySet()) {
            Integer index = entry.getValue().id;
            assert (lastUsed <= lastSeen && lastSeen < index);
            lastSeen = index;
            if (++lastUsed >= index) continue;
            entry.getValue().id = lastUsed;
        }
        assert (this.verifyLambdaIds(true));
    }

    public abstract CodeProcessor.Strategy getCodeStrategy();

    public abstract ThrowingConsumer<DexClass, LambdaStructureError> lambdaClassValidator(Kotlin var1, AppInfoWithSubtyping var2);

    protected abstract String getTypePackage();

    protected abstract String getGroupSuffix();

    final DexProgramClass synthesizeClass(DexItemFactory factory) {
        assert (this.classType == null);
        assert (this.verifyLambdaIds(true));
        ArrayList<LambdaInfo> lambdas = Lists.newArrayList(this.lambdas.values());
        this.classType = factory.createType("L" + this.getTypePackage() + "-$$LambdaGroup$" + this.getGroupSuffix() + this.createHash(lambdas) + ";");
        return this.getBuilder(factory).synthesizeClass();
    }

    protected abstract LambdaGroupClassBuilder getBuilder(DexItemFactory var1);

    private String createHash(List<LambdaInfo> lambdas) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bytes);
            for (LambdaInfo lambda2 : lambdas) {
                DexString descriptor = lambda2.clazz.type.descriptor;
                out.writeInt(descriptor.size);
                out.write(descriptor.content);
            }
            out.close();
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(bytes.toByteArray());
            return BaseEncoding.base64Url().omitPadding().encode(digest.digest());
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            throw new Unreachable("Cannot get SHA-1 message digest");
        }
    }

    private boolean verifyLambdaIds(boolean strict) {
        int previous = -1;
        for (LambdaInfo info : this.lambdas.values()) {
            assert (!strict ? previous < info.id : previous + 1 == info.id);
            previous = info.id;
        }
        return true;
    }

    public static class LambdaStructureError
    extends Exception {
        final boolean reportable;

        public LambdaStructureError(String cause) {
            this(cause, true);
        }

        public LambdaStructureError(String cause, boolean reportable) {
            super(cause);
            this.reportable = reportable;
        }
    }

    public static class LambdaInfo {
        public int id;
        public final DexProgramClass clazz;

        LambdaInfo(int id, DexProgramClass clazz) {
            this.id = id;
            this.clazz = clazz;
        }
    }
}

