/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CheckCast;
import com.android.tools.r8.ir.code.DebugLocalRead;
import com.android.tools.r8.ir.code.DominatorTree;
import com.android.tools.r8.ir.code.Goto;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.Return;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.utils.IteratorUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;

public class BasicBlockInstructionIterator
implements InstructionIterator,
InstructionListIterator {
    protected final BasicBlock block;
    protected final ListIterator<Instruction> listIterator;
    protected Instruction current;
    protected Position position = null;

    protected BasicBlockInstructionIterator(BasicBlock block) {
        this.block = block;
        this.listIterator = block.getInstructions().listIterator();
    }

    protected BasicBlockInstructionIterator(BasicBlock block, int index) {
        this.block = block;
        this.listIterator = block.getInstructions().listIterator(index);
    }

    protected BasicBlockInstructionIterator(BasicBlock block, Instruction instruction) {
        this(block);
        this.nextUntil((T x) -> x == instruction);
    }

    @Override
    public boolean hasNext() {
        return this.listIterator.hasNext();
    }

    @Override
    public Instruction next() {
        this.current = this.listIterator.next();
        return this.current;
    }

    @Override
    public int nextIndex() {
        return this.listIterator.nextIndex();
    }

    @Override
    public boolean hasPrevious() {
        return this.listIterator.hasPrevious();
    }

    @Override
    public Instruction previous() {
        this.current = this.listIterator.previous();
        return this.current;
    }

    @Override
    public int previousIndex() {
        return this.listIterator.previousIndex();
    }

    @Override
    public void setInsertionPosition(Position position) {
        this.position = position;
    }

    @Override
    public void add(Instruction instruction) {
        instruction.setBlock(this.block);
        assert (instruction.getBlock() == this.block);
        if (this.position != null) {
            instruction.setPosition(this.position);
        }
        this.listIterator.add(instruction);
    }

    @Override
    public void set(Instruction instruction) {
        instruction.setBlock(this.block);
        assert (instruction.getBlock() == this.block);
        this.listIterator.set(instruction);
    }

    @Override
    public void remove() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        assert (this.current.outValue() == null || !this.current.outValue().isUsed());
        assert (this.current.getDebugValues().isEmpty());
        for (int i = 0; i < this.current.inValues().size(); ++i) {
            Value value = this.current.inValues().get(i);
            value.removeUser(this.current);
        }
        for (Value value : this.current.getDebugValues()) {
            value.removeDebugUser(this.current);
        }
        if (this.current.getLocalInfo() != null) {
            for (Instruction user : this.current.outValue().debugUsers()) {
                user.removeDebugValue(this.current.outValue());
            }
        }
        this.listIterator.remove();
        this.current = null;
    }

    @Override
    public void removeOrReplaceByDebugLocalRead() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        if (this.current.getDebugValues().isEmpty()) {
            this.remove();
        } else {
            this.replaceCurrentInstruction(new DebugLocalRead());
        }
    }

    @Override
    public void detach() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        this.listIterator.remove();
        this.current = null;
    }

    @Override
    public void replaceCurrentInstruction(Instruction newInstruction) {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        for (Value value : this.current.inValues()) {
            value.removeUser(this.current);
        }
        if (this.current.outValue() != null && this.current.outValue().isUsed()) {
            assert (newInstruction.outValue() != null);
            this.current.outValue().replaceUsers(newInstruction.outValue());
        }
        this.current.moveDebugValues(newInstruction);
        newInstruction.setBlock(this.block);
        newInstruction.setPosition(this.current.getPosition());
        this.listIterator.remove();
        this.listIterator.add(newInstruction);
        this.current.clearBlock();
    }

    @Override
    public BasicBlock split(IRCode code, ListIterator<BasicBlock> blocksIterator) {
        LinkedList<BasicBlock> blocks = code.blocks;
        assert (blocksIterator == null || IteratorUtils.peekPrevious(blocksIterator) == this.block);
        int blockNumber = code.getHighestBlockNumber() + 1;
        assert (this.hasNext());
        Position position = this.current != null ? this.current.getPosition() : this.block.getPosition();
        boolean keepCatchHandlers = this.hasPrevious() && this.peekPrevious().instructionTypeCanThrow();
        BasicBlock newBlock = this.block.createSplitBlock(blockNumber, keepCatchHandlers);
        Goto newGoto = new Goto(this.block);
        this.listIterator.add(newGoto);
        newGoto.setPosition(position);
        while (this.listIterator.hasNext()) {
            Instruction instruction = this.listIterator.next();
            newBlock.getInstructions().addLast(instruction);
            instruction.setBlock(newBlock);
            this.listIterator.remove();
        }
        if (blocksIterator == null) {
            blocks.add(blocks.indexOf(this.block) + 1, newBlock);
        } else {
            blocksIterator.add(newBlock);
            blocksIterator.previous();
            blocksIterator.next();
        }
        return newBlock;
    }

    @Override
    public BasicBlock split(IRCode code, int instructions, ListIterator<BasicBlock> blocksIterator) {
        BasicBlock newBlock = this.split(code, blocksIterator);
        assert (blocksIterator == null || IteratorUtils.peekPrevious(blocksIterator) == newBlock);
        InstructionListIterator iterator2 = newBlock.listIterator();
        for (int i = 0; i < instructions; ++i) {
            iterator2.next();
        }
        iterator2.split(code, blocksIterator);
        return newBlock;
    }

    private boolean canThrow(IRCode code) {
        InstructionIterator iterator2 = code.instructionIterator();
        while (iterator2.hasNext()) {
            boolean throwing = ((Instruction)iterator2.next()).instructionTypeCanThrow();
            if (!throwing) continue;
            return true;
        }
        return false;
    }

    private void splitBlockAndCopyCatchHandlers(IRCode code, BasicBlock invokeBlock, BasicBlock inlinedBlock, ListIterator<BasicBlock> blocksIterator) {
        InstructionListIterator instructionsIterator = inlinedBlock.listIterator();
        BasicBlock currentBlock = inlinedBlock;
        while (currentBlock != null && instructionsIterator.hasNext()) {
            assert (!currentBlock.hasCatchHandlers());
            Object throwingInstruction = instructionsIterator.nextUntil(Instruction::instructionTypeCanThrow);
            if (throwingInstruction != null) {
                BasicBlock b;
                BasicBlock nextBlock;
                if (instructionsIterator.hasNext()) {
                    nextBlock = instructionsIterator.split(code, blocksIterator);
                    assert (nextBlock.getPredecessors().size() == 1);
                    assert (currentBlock == nextBlock.getPredecessors().get(0));
                    b = blocksIterator.previous();
                    assert (b == nextBlock);
                } else {
                    nextBlock = null;
                }
                currentBlock.copyCatchHandlers(code, blocksIterator, invokeBlock);
                if (nextBlock != null) {
                    b = blocksIterator.next();
                    assert (b == nextBlock);
                    instructionsIterator = nextBlock.listIterator();
                } else {
                    instructionsIterator = null;
                }
                currentBlock = nextBlock;
                continue;
            }
            assert (!instructionsIterator.hasNext());
            instructionsIterator = null;
            currentBlock = null;
        }
    }

    private void appendCatchHandlers(IRCode code, BasicBlock invokeBlock, IRCode inlinee, ListIterator<BasicBlock> blocksIterator) {
        for (int i = 0; i < inlinee.blocks.size(); ++i) {
            blocksIterator.previous();
        }
        assert (IteratorUtils.peekNext(blocksIterator) == inlinee.blocks.getFirst());
        for (BasicBlock inlinedBlock : inlinee.blocks) {
            BasicBlock expected = blocksIterator.next();
            assert (inlinedBlock == expected);
            if (inlinedBlock.hasCatchHandlers()) {
                inlinedBlock.copyCatchHandlers(code, blocksIterator, invokeBlock);
                continue;
            }
            this.splitBlockAndCopyCatchHandlers(code, invokeBlock, inlinedBlock, blocksIterator);
        }
    }

    private static void removeArgumentInstruction(InstructionListIterator iterator2, Value expectedArgument) {
        assert (iterator2.hasNext());
        Instruction instruction = (Instruction)iterator2.next();
        assert (instruction.isArgument());
        assert (!instruction.outValue().isUsed());
        assert (instruction.outValue() == expectedArgument);
        iterator2.remove();
    }

    @Override
    public BasicBlock inlineInvoke(AppInfo appInfo, IRCode code, IRCode inlinee, ListIterator<BasicBlock> blocksIterator, List<BasicBlock> blocksToRemove, DexType downcast) {
        InstructionListIterator entryBlockIterator;
        BasicBlock inlineEntry;
        assert (blocksToRemove != null);
        boolean inlineeCanThrow = this.canThrow(inlinee);
        BasicBlock invokeBlock = this.split(code, 1, blocksIterator);
        assert (invokeBlock.getInstructions().size() == 2);
        assert (invokeBlock.getInstructions().getFirst().isInvoke());
        Invoke invoke = invokeBlock.getInstructions().getFirst().asInvoke();
        BasicBlock invokePredecessor = invokeBlock.getPredecessors().get(0);
        BasicBlock invokeSuccessor = invokeBlock.getSuccessors().get(0);
        if (!inlinee.doAllThrowingInstructionsHavePositions()) {
            code.setAllThrowingInstructionsHavePositions(false);
        }
        List<Value> arguments = inlinee.collectArguments();
        assert (invoke.inValues().size() == arguments.size());
        BasicBlock entryBlock = inlinee.blocks.getFirst();
        int i = 0;
        if (downcast != null) {
            CheckCast castInstruction = new CheckCast(code.createValue(ValueType.OBJECT), invoke.inValues().get(0), downcast);
            castInstruction.setPosition(invoke.getPosition());
            if (entryBlock.canThrow()) {
                inlineEntry = entryBlock;
                entryBlock = entryBlock.listIterator().split(inlinee);
                entryBlockIterator = entryBlock.listIterator();
                inlineEntry.getInstructions().addFirst(castInstruction);
                castInstruction.setBlock(inlineEntry);
                assert (castInstruction.getBlock().getInstructions().size() == 2);
            } else {
                castInstruction.setBlock(entryBlock);
                entryBlockIterator = entryBlock.listIterator();
                entryBlockIterator.add(castInstruction);
            }
            Value argument = arguments.get(i);
            argument.replaceUsers(castInstruction.outValue);
            BasicBlockInstructionIterator.removeArgumentInstruction(entryBlockIterator, argument);
            ++i;
        } else {
            entryBlockIterator = entryBlock.listIterator();
        }
        while (i < invoke.inValues().size()) {
            assert (!arguments.get(i).hasLocalInfo());
            Value argument = arguments.get(i);
            argument.replaceUsers(invoke.inValues().get(i));
            BasicBlockInstructionIterator.removeArgumentInstruction(entryBlockIterator, argument);
            ++i;
        }
        assert (entryBlock.getInstructions().stream().noneMatch(Instruction::isArgument));
        TypeAnalysis typeAnalysis = new TypeAnalysis(appInfo, code.method);
        typeAnalysis.widening(inlinee.method, inlinee);
        inlineEntry = inlinee.blocks.getFirst();
        BasicBlock inlineExit = null;
        ImmutableList<BasicBlock> normalExits = inlinee.computeNormalExitBlocks();
        if (!normalExits.isEmpty()) {
            InstructionListIterator inlineeIterator = this.ensureSingleReturnInstruction(inlinee, normalExits);
            assert (inlineeIterator.peekNext().isReturn());
            if (invoke.outValue() != null) {
                Return returnInstruction = inlineeIterator.peekNext().asReturn();
                ImmutableList usersOfReturn = invoke.outValue().uniqueUsers().stream().map(Instruction::outValue).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
                ImmutableList<Phi> phiUsersOfReturn = ImmutableList.copyOf(invoke.outValue().uniquePhiUsers());
                invoke.outValue().replaceUsers(returnInstruction.returnValue());
                typeAnalysis.narrowing(Iterables.concat(ImmutableList.of(returnInstruction.returnValue()), usersOfReturn, phiUsersOfReturn));
            }
            BasicBlock returnBlock = inlineeIterator.split(inlinee);
            inlineExit = returnBlock.unlinkSinglePredecessor();
            InstructionListIterator returnBlockIterator = returnBlock.listIterator();
            returnBlockIterator.next();
            returnBlockIterator.remove();
            assert (!returnBlockIterator.hasNext());
            inlinee.blocks.remove(returnBlock);
            invokeBlock.unlinkSinglePredecessor();
            InstructionListIterator invokeBlockIterator = invokeBlock.listIterator();
            invokeBlockIterator.next();
            invokeBlockIterator.remove();
            invokeSuccessor = invokeBlock;
            assert (invokeBlock.getInstructions().getFirst().isGoto());
        }
        invokePredecessor.link(inlineEntry);
        if (inlineExit != null) {
            inlineExit.link(invokeSuccessor);
        }
        if (blocksIterator == null) {
            blocksIterator = code.blocks.listIterator(code.blocks.indexOf(invokeBlock));
        } else {
            blocksIterator.previous();
            blocksIterator.previous();
        }
        assert (IteratorUtils.peekNext(blocksIterator) == invokeBlock);
        int blockNumber = code.getHighestBlockNumber() + 1;
        for (BasicBlock bb : inlinee.blocks) {
            bb.setNumber(blockNumber++);
            blocksIterator.add(bb);
        }
        if (invokeBlock.hasCatchHandlers()) {
            this.appendCatchHandlers(code, invokeBlock, inlinee, blocksIterator);
        }
        if (normalExits.isEmpty()) {
            assert (inlineeCanThrow);
            blocksToRemove.addAll(invokePredecessor.unlink(invokeBlock, new DominatorTree(code)));
        }
        blocksIterator.next();
        assert (IteratorUtils.peekPrevious(blocksIterator) == invokeBlock);
        BasicBlock finalInvokeSuccessor = invokeSuccessor;
        assert (invokeSuccessor == invokeBlock || IteratorUtils.anyRemainingMatch(blocksIterator, remaining -> remaining == finalInvokeSuccessor));
        return invokeSuccessor;
    }

    private InstructionListIterator ensureSingleReturnInstruction(IRCode code, ImmutableList<BasicBlock> normalExits) {
        Return newReturn;
        if (normalExits.size() == 1) {
            InstructionListIterator it = ((BasicBlock)normalExits.get(0)).listIterator();
            it.nextUntil(Instruction::isReturn);
            it.previous();
            return it;
        }
        BasicBlock newExitBlock = new BasicBlock();
        newExitBlock.setNumber(code.getHighestBlockNumber() + 1);
        if (((BasicBlock)normalExits.get(0)).exit().asReturn().isReturnVoid()) {
            newReturn = new Return();
        } else {
            Value value;
            ValueType returnType = null;
            boolean same = true;
            ArrayList<Value> operands = new ArrayList<Value>(normalExits.size());
            for (BasicBlock exitBlock : normalExits) {
                Return exit = exitBlock.exit().asReturn();
                Value retValue = exit.returnValue();
                operands.add(retValue);
                boolean bl = same = same && retValue == operands.get(0);
                assert (returnType == null || returnType == exit.getReturnType());
                returnType = exit.getReturnType();
            }
            if (same) {
                value = (Value)operands.get(0);
            } else {
                Phi phi = new Phi(code.valueNumberGenerator.next(), newExitBlock, returnType, null, Phi.RegisterReadType.NORMAL);
                phi.addOperands(operands);
                value = phi;
            }
            newReturn = new Return(value, returnType);
        }
        newReturn.setPosition(Position.none());
        newExitBlock.add(newReturn);
        for (BasicBlock exitBlock : normalExits) {
            InstructionListIterator it = exitBlock.listIterator(exitBlock.getInstructions().size());
            Instruction oldExit = (Instruction)it.previous();
            assert (oldExit.isReturn());
            it.replaceCurrentInstruction(new Goto());
            exitBlock.link(newExitBlock);
        }
        newExitBlock.close(null);
        code.blocks.add(newExitBlock);
        assert (code.isConsistentSSA());
        return newExitBlock.listIterator();
    }
}

