/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.status;

import java.io.File;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.status.RepositoryStatus;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;
import org.jetbrains.idea.svn.status.WorkingCopyStatus;

@XmlAccessorType(value=XmlAccessType.FIELD)
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0018R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\u0004\u0018\u00010\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/idea/svn/status/Entry;", "", "()V", "localStatus", "Lorg/jetbrains/idea/svn/status/WorkingCopyStatus;", "getLocalStatus", "()Lorg/jetbrains/idea/svn/status/WorkingCopyStatus;", "setLocalStatus", "(Lorg/jetbrains/idea/svn/status/WorkingCopyStatus;)V", "path", "", "getPath", "()Ljava/lang/String;", "setPath", "(Ljava/lang/String;)V", "repositoryStatus", "Lorg/jetbrains/idea/svn/status/RepositoryStatus;", "getRepositoryStatus", "()Lorg/jetbrains/idea/svn/status/RepositoryStatus;", "setRepositoryStatus", "(Lorg/jetbrains/idea/svn/status/RepositoryStatus;)V", "fixInvalidOutputForUnversionedBase", "", "base", "Ljava/io/File;", "status", "Lorg/jetbrains/idea/svn/status/Status$Builder;", "toBuilder", "intellij.vcs.svn"})
final class Entry {
    @XmlAttribute(required=true)
    @NotNull
    private String path = "";
    @XmlElement(name="wc-status")
    @NotNull
    private WorkingCopyStatus localStatus = new WorkingCopyStatus();
    @XmlElement(name="repos-status")
    @Nullable
    private RepositoryStatus repositoryStatus;

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public final void setPath(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.path = string;
    }

    @NotNull
    public final WorkingCopyStatus getLocalStatus() {
        return this.localStatus;
    }

    public final void setLocalStatus(@NotNull WorkingCopyStatus workingCopyStatus) {
        Intrinsics.checkParameterIsNotNull((Object)workingCopyStatus, (String)"<set-?>");
        this.localStatus = workingCopyStatus;
    }

    @Nullable
    public final RepositoryStatus getRepositoryStatus() {
        return this.repositoryStatus;
    }

    public final void setRepositoryStatus(@Nullable RepositoryStatus repositoryStatus) {
        this.repositoryStatus = repositoryStatus;
    }

    @NotNull
    public final Status.Builder toBuilder(@NotNull File base) {
        NodeKind nodeKind;
        Status.Builder builder;
        Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
        File file = SvnUtil.resolvePath(base, this.path);
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"SvnUtil.resolvePath(base, path)");
        Status.Builder $receiver = builder = new Status.Builder(file);
        boolean bl = false;
        $receiver.setFileExists($receiver.getFile().exists());
        if ($receiver.getFileExists()) {
            NodeKind nodeKind2 = NodeKind.from($receiver.getFile().isDirectory());
            nodeKind = nodeKind2;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)nodeKind2), (String)"NodeKind.from(file.isDirectory)");
        } else {
            nodeKind = NodeKind.UNKNOWN;
        }
        $receiver.setNodeKind(nodeKind);
        if (!$receiver.getFileExists()) {
            this.fixInvalidOutputForUnversionedBase(base, $receiver);
        }
        $receiver.setItemStatus(this.localStatus.getItemStatus());
        $receiver.setPropertyStatus(this.localStatus.getPropertyStatus());
        Long l = this.localStatus.getRevision();
        $receiver.setRevision(Revision.Companion.of(l != null ? l : -1L));
        $receiver.setWorkingCopyLocked(this.localStatus.isWorkingCopyLocked());
        $receiver.setCopied(this.localStatus.isCopied());
        $receiver.setSwitched(this.localStatus.isSwitched());
        $receiver.setTreeConflicted(this.localStatus.isTreeConflicted());
        $receiver.setCommitInfo(this.localStatus.getCommit());
        $receiver.setLocalLock(this.localStatus.getLock());
        RepositoryStatus repositoryStatus = this.repositoryStatus;
        $receiver.setRemoteItemStatus(repositoryStatus != null ? repositoryStatus.getItemStatus() : null);
        RepositoryStatus repositoryStatus2 = this.repositoryStatus;
        $receiver.setRemotePropertyStatus(repositoryStatus2 != null ? repositoryStatus2.getPropertyStatus() : null);
        RepositoryStatus repositoryStatus3 = this.repositoryStatus;
        $receiver.setRemoteLock(repositoryStatus3 != null ? repositoryStatus3.getLock() : null);
        return builder;
    }

    public final void fixInvalidOutputForUnversionedBase(@NotNull File base, @NotNull Status.Builder status) {
        Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
        Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
        if (Intrinsics.areEqual((Object)base.getName(), (Object)this.path) && StatusType.MISSING != status.getItemStatus() && StatusType.STATUS_DELETED != status.getItemStatus()) {
            status.setFileExists(true);
            status.setNodeKind(NodeKind.DIR);
            status.setFile(base);
        }
    }
}

