/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n.folding;

import com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.NamedFoldingDescriptor;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.parsing.PropertiesElementTypes;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.PropertyStub;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyStubImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLiteralUtils;

public class PropertyFoldingBuilder
extends FoldingBuilderEx {
    private static final int FOLD_MAX_LENGTH = 50;
    private static final Key<IProperty> CACHE = Key.create((String)"i18n.property.cache");
    public static final IProperty NULL = new PropertyImpl((PropertyStub)new PropertyStubImpl(null, null), PropertiesElementTypes.PROPERTY);

    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement element, @NotNull Document document, boolean quick) {
        if (element == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (document == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (!(element instanceof PsiFile) || quick || !PropertyFoldingBuilder.isFoldingsOn()) {
            if (FoldingDescriptor.EMPTY == null) {
                PropertyFoldingBuilder.$$$reportNull$$$0(2);
            }
            return FoldingDescriptor.EMPTY;
        }
        PsiFile file = (PsiFile)element;
        final ArrayList result = new ArrayList();
        boolean hasJsp = ContainerUtil.intersects(Arrays.asList(StdLanguages.JSP, StdLanguages.JSPX), (Collection)file.getViewProvider().getLanguages());
        file.accept((PsiElementVisitor)(hasJsp ? new JavaRecursiveElementWalkingVisitor(){

            public void visitLiteralExpression(PsiLiteralExpression expression) {
                ProgressManager.checkCanceled();
                ULiteralExpression uLiteralExpression = (ULiteralExpression)UastContextKt.toUElement((PsiElement)expression, ULiteralExpression.class);
                if (uLiteralExpression != null) {
                    PropertyFoldingBuilder.checkLiteral(uLiteralExpression, result);
                }
            }
        } : new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                ProgressManager.checkCanceled();
                ULiteralExpression uLiteralExpression = (ULiteralExpression)UastContextKt.toUElement((PsiElement)element, ULiteralExpression.class);
                if (uLiteralExpression != null) {
                    PropertyFoldingBuilder.checkLiteral(uLiteralExpression, result);
                }
                super.visitElement(element);
            }
        }));
        FoldingDescriptor[] foldingDescriptorArray = result.toArray(FoldingDescriptor.EMPTY);
        if (foldingDescriptorArray == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(3);
        }
        return foldingDescriptorArray;
    }

    private static boolean isFoldingsOn() {
        return JavaCodeFoldingSettings.getInstance().isCollapseI18nMessages();
    }

    private static void checkLiteral(ULiteralExpression expression, List<? super FoldingDescriptor> result) {
        PsiElement sourcePsi = expression.getSourcePsi();
        if (sourcePsi == null) {
            return;
        }
        if (!PropertyFoldingBuilder.isI18nProperty(expression)) {
            return;
        }
        IProperty property = PropertyFoldingBuilder.getI18nProperty(expression);
        HashSet<IProperty> set = new HashSet<IProperty>();
        set.add((IProperty)(property != null ? property : PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT));
        String msg = PropertyFoldingBuilder.formatI18nProperty(expression, property);
        UElement parent = expression.getUastParent();
        if (!msg.equals(UastLiteralUtils.getValueIfStringLiteral((UElement)expression)) && parent instanceof UCallExpression && ((UExpression)((UCallExpression)parent).getValueArguments().get(0)).getSourcePsi() == expression.getSourcePsi()) {
            UCallExpression expressions = (UCallExpression)parent;
            PsiElement callSourcePsi = expressions.getSourcePsi();
            if (callSourcePsi == null) {
                return;
            }
            int count = JavaI18nUtil.getPropertyValueParamsMaxCount((UExpression)expression);
            List args = expressions.getValueArguments();
            if (args.size() == 1 + count) {
                boolean ok = true;
                for (int i = 1; i < count + 1; ++i) {
                    Object value = ((UExpression)args.get(i)).evaluate();
                    if (value != null || args.get(i) instanceof UReferenceExpression) continue;
                    ok = false;
                    break;
                }
                if (ok) {
                    UExpression receiver = expressions.getReceiver();
                    PsiElement receiverSourcePsi = receiver != null ? receiver.getSourcePsi() : null;
                    PsiElement elementToFold = null;
                    if (receiverSourcePsi != null) {
                        elementToFold = PsiTreeUtil.findCommonParent((PsiElement)callSourcePsi, (PsiElement)receiverSourcePsi);
                    }
                    if (elementToFold == null) {
                        elementToFold = callSourcePsi;
                    }
                    result.add((FoldingDescriptor)new NamedFoldingDescriptor((ASTNode)ObjectUtils.assertNotNull((Object)elementToFold.getNode()), elementToFold.getTextRange(), null, PropertyFoldingBuilder.formatMethodCallExpression(expressions), Boolean.valueOf(PropertyFoldingBuilder.isFoldingsOn()), set));
                    return;
                }
            }
        }
        result.add((FoldingDescriptor)new NamedFoldingDescriptor((ASTNode)ObjectUtils.assertNotNull((Object)sourcePsi.getNode()), sourcePsi.getTextRange(), null, PropertyFoldingBuilder.getI18nMessage(expression), Boolean.valueOf(PropertyFoldingBuilder.isFoldingsOn()), set));
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(4);
        }
        return null;
    }

    @NotNull
    private static String formatMethodCallExpression(@NotNull UCallExpression methodCallExpression) {
        if (methodCallExpression == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(5);
        }
        List args = methodCallExpression.getValueArguments();
        PsiElement callSourcePsi = methodCallExpression.getSourcePsi();
        if (args.size() > 0 && args.get(0) instanceof ULiteralExpression && PropertyFoldingBuilder.isI18nProperty((ULiteralExpression)args.get(0))) {
            int count = JavaI18nUtil.getPropertyValueParamsMaxCount((UExpression)args.get(0));
            if (args.size() == 1 + count) {
                String text = PropertyFoldingBuilder.getI18nMessage((ULiteralExpression)args.get(0));
                for (int i = 1; i < count + 1; ++i) {
                    Object value = ((UExpression)args.get(i)).evaluate();
                    if (value == null) {
                        if (args.get(i) instanceof UReferenceExpression) {
                            PsiElement sourcePsi = ((UExpression)args.get(i)).getSourcePsi();
                            value = "{" + (sourcePsi != null ? sourcePsi.getText() : "<error>") + "}";
                        } else {
                            text = null;
                            break;
                        }
                    }
                    text = text.replace("{" + (i - 1) + "}", value.toString());
                }
                if (text != null) {
                    String string = text.length() > 50 ? text.substring(0, 47) + "...\"" : text;
                    if (string == null) {
                        PropertyFoldingBuilder.$$$reportNull$$$0(6);
                    }
                    return string;
                }
            }
        }
        String string = callSourcePsi != null ? callSourcePsi.getText() : "<error>";
        if (string == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static String getI18nMessage(@NotNull ULiteralExpression literal) {
        IProperty property;
        if (literal == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(8);
        }
        String string = (property = PropertyFoldingBuilder.getI18nProperty(literal)) == null ? UastLiteralUtils.getValueIfStringLiteral((UElement)literal) : PropertyFoldingBuilder.formatI18nProperty(literal, property);
        if (string == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public static IProperty getI18nProperty(@NotNull ULiteralExpression literal) {
        PsiElement sourcePsi;
        if (literal == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(10);
        }
        if ((sourcePsi = literal.getSourcePsi()) == null) {
            return null;
        }
        Property property = (Property)sourcePsi.getUserData(CACHE);
        if (property == NULL) {
            return null;
        }
        if (property != null && PropertyFoldingBuilder.isValid(property, literal)) {
            return property;
        }
        if (PropertyFoldingBuilder.isI18nProperty(literal)) {
            Iterable references = UastLiteralUtils.getInjectedReferences((ULiteralExpression)literal);
            for (PsiReference reference : references) {
                if (reference instanceof PsiPolyVariantReference) {
                    ResolveResult[] results;
                    for (ResolveResult result : results = ((PsiPolyVariantReference)reference).multiResolve(false)) {
                        PsiElement element = result.getElement();
                        if (!(element instanceof IProperty)) continue;
                        IProperty p = (IProperty)element;
                        sourcePsi.putUserData(CACHE, (Object)p);
                        return p;
                    }
                    continue;
                }
                PsiElement element = reference.resolve();
                if (!(element instanceof IProperty)) continue;
                IProperty p = (IProperty)element;
                sourcePsi.putUserData(CACHE, (Object)p);
                return p;
            }
        }
        return null;
    }

    private static boolean isValid(Property property, ULiteralExpression literal) {
        if (literal == null || property == null || !property.isValid()) {
            return false;
        }
        Object result = literal.evaluate();
        if (!(result instanceof String)) {
            return false;
        }
        return StringUtil.unquoteString((String)((String)result)).equals(property.getKey());
    }

    @NotNull
    private static String formatI18nProperty(@NotNull ULiteralExpression literal, IProperty property) {
        if (literal == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(11);
        }
        Object evaluated = literal.evaluate();
        String string = property == null ? (evaluated != null ? evaluated.toString() : "null") : "\"" + property.getValue() + "\"";
        if (string == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(12);
        }
        return string;
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(13);
        }
        return PropertyFoldingBuilder.isFoldingsOn();
    }

    public static boolean isI18nProperty(@NotNull PsiLiteralExpression expr) {
        ULiteralExpression uLiteralExpression;
        if (expr == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(14);
        }
        if ((uLiteralExpression = (ULiteralExpression)UastContextKt.toUElement((PsiElement)expr, ULiteralExpression.class)) == null) {
            return false;
        }
        return PropertyFoldingBuilder.isI18nProperty(uLiteralExpression);
    }

    public static boolean isI18nProperty(@NotNull ULiteralExpression expr) {
        if (expr == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(15);
        }
        if (!expr.isString()) {
            return false;
        }
        PsiElement sourcePsi = expr.getSourcePsi();
        if (sourcePsi == null) {
            return false;
        }
        IProperty property = (IProperty)sourcePsi.getUserData(CACHE);
        if (property == NULL) {
            return false;
        }
        if (property != null) {
            return true;
        }
        boolean isI18n = JavaI18nUtil.mustBePropertyKey((UExpression)expr, null);
        if (!isI18n) {
            sourcePsi.putUserData(CACHE, (Object)NULL);
        }
        return isI18n;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/i18n/folding/PropertyFoldingBuilder";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCallExpression";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/i18n/folding/PropertyFoldingBuilder";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "formatMethodCallExpression";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getI18nMessage";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "formatI18nProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "formatMethodCallExpression";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getI18nMessage";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getI18nProperty";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "formatI18nProperty";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isI18nProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

