/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Computable;
import com.intellij.util.ImageLoader;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Image;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.util.GithubImageResizer;
import org.jetbrains.plugins.github.util.NonReusableEmptyProgressIndicator;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/github/util/GithubImageResizer;", "Lcom/intellij/openapi/Disposable;", "progressManager", "Lcom/intellij/openapi/progress/ProgressManager;", "(Lcom/intellij/openapi/progress/ProgressManager;)V", "executor", "Ljava/util/concurrent/ExecutorService;", "progressIndicator", "Lcom/intellij/openapi/progress/EmptyProgressIndicator;", "dispose", "", "requestImageResize", "Ljava/util/concurrent/CompletableFuture;", "Ljava/awt/Image;", "image", "size", "", "scaleContext", "Lcom/intellij/util/ui/JBUI$ScaleContext;", "Companion", "intellij.vcs.github"})
public final class GithubImageResizer
implements Disposable {
    private final ExecutorService executor;
    private final EmptyProgressIndicator progressIndicator;
    private final ProgressManager progressManager;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final CompletableFuture<Image> requestImageResize(@NotNull Image image, int size, @NotNull JBUI.ScaleContext scaleContext) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Intrinsics.checkParameterIsNotNull((Object)scaleContext, (String)"scaleContext");
        EmptyProgressIndicator indicator = this.progressIndicator;
        CompletableFuture<Image> completableFuture = CompletableFuture.supplyAsync((Supplier)new Supplier<Image>(this, indicator, image, scaleContext, size){
            final /* synthetic */ GithubImageResizer this$0;
            final /* synthetic */ EmptyProgressIndicator $indicator;
            final /* synthetic */ Image $image;
            final /* synthetic */ JBUI.ScaleContext $scaleContext;
            final /* synthetic */ int $size;

            public final Image get() {
                return (Image)GithubImageResizer.access$getProgressManager$p(this.this$0).runProcess((Computable)new Computable<Image>(this){
                    final /* synthetic */ requestImageResize.1 this$0;

                    @NotNull
                    public final Image compute() {
                        this.this$0.$indicator.checkCanceled();
                        Image hidpiImage = ImageUtil.ensureHiDPI((Image)this.this$0.$image, (JBUI.ScaleContext)this.this$0.$scaleContext);
                        this.this$0.$indicator.checkCanceled();
                        return ImageLoader.scaleImage((Image)hidpiImage, (int)this.this$0.$size);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }, (ProgressIndicator)this.$indicator);
            }
            {
                this.this$0 = githubImageResizer;
                this.$indicator = emptyProgressIndicator;
                this.$image = image;
                this.$scaleContext = scaleContext;
                this.$size = n;
            }
        }, this.executor);
        Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"CompletableFuture.supply\u2026dicator)\n    }, executor)");
        return completableFuture;
    }

    public void dispose() {
        this.progressIndicator.cancel();
        this.executor.shutdownNow();
    }

    public GithubImageResizer(@NotNull ProgressManager progressManager) {
        Intrinsics.checkParameterIsNotNull((Object)progressManager, (String)"progressManager");
        this.progressManager = progressManager;
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"GitHub Image Resizer", (int)GithubImageResizer.Companion.getThreadPoolSize());
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"AppExecutorUtil.createBo\u2026er\", getThreadPoolSize())");
        this.executor = executorService;
        this.progressIndicator = new NonReusableEmptyProgressIndicator();
    }

    public static final /* synthetic */ ProgressManager access$getProgressManager$p(GithubImageResizer $this) {
        return $this.progressManager;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/github/util/GithubImageResizer$Companion;", "", "()V", "getThreadPoolSize", "", "intellij.vcs.github"})
    public static final class Companion {
        private final int getThreadPoolSize() {
            return Math.max(Runtime.getRuntime().availableProcessors() / 2, 1);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

