/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.ImageLoader;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.awt.Image;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.data.GithubUser;
import org.jetbrains.plugins.github.util.CachingGithubUserAvatarLoader;
import org.jetbrains.plugins.github.util.NonReusableEmptyProgressIndicator;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0016J*\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rn\u0010\u0007\u001ab\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\u001c\u0012\u001a\u0012\u0006\u0012\u0004\u0018\u00010\f \n*\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u000b0\u000b \n*0\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\u001c\u0012\u001a\u0012\u0006\u0012\u0004\u0018\u00010\f \n*\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u000b0\u000b\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/github/util/CachingGithubUserAvatarLoader;", "Lcom/intellij/openapi/Disposable;", "progressManager", "Lcom/intellij/openapi/progress/ProgressManager;", "(Lcom/intellij/openapi/progress/ProgressManager;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "avatarCache", "Lcom/google/common/cache/Cache;", "Lorg/jetbrains/plugins/github/api/data/GithubUser;", "kotlin.jvm.PlatformType", "Ljava/util/concurrent/CompletableFuture;", "Ljava/awt/Image;", "executor", "Ljava/util/concurrent/ExecutorService;", "progressIndicator", "Lcom/intellij/openapi/progress/EmptyProgressIndicator;", "dispose", "", "loadAndDownscale", "requestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "indicator", "url", "", "maximumSize", "", "requestAvatar", "user", "Companion", "intellij.vcs.github"})
public final class CachingGithubUserAvatarLoader
implements Disposable {
    private final Logger LOG;
    private final ExecutorService executor;
    private final EmptyProgressIndicator progressIndicator;
    private final Cache<GithubUser, CompletableFuture<Image>> avatarCache;
    private final ProgressManager progressManager;
    private static final int MAXIMUM_ICON_SIZE = 40;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final CompletableFuture<Image> requestAvatar(@NotNull GithubApiRequestExecutor requestExecutor, @NotNull GithubUser user) {
        Intrinsics.checkParameterIsNotNull((Object)requestExecutor, (String)"requestExecutor");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        EmptyProgressIndicator indicator = this.progressIndicator;
        int imageSize = 240;
        Object object = this.avatarCache.get((Object)user, (Callable)new Callable<CompletableFuture<Image>>(this, user, requestExecutor, indicator, imageSize){
            final /* synthetic */ CachingGithubUserAvatarLoader this$0;
            final /* synthetic */ GithubUser $user;
            final /* synthetic */ GithubApiRequestExecutor $requestExecutor;
            final /* synthetic */ EmptyProgressIndicator $indicator;
            final /* synthetic */ int $imageSize;

            public final CompletableFuture<Image> call() {
                String url = this.$user.getAvatarUrl();
                return url == null ? CompletableFuture.completedFuture(null) : CompletableFuture.supplyAsync((Supplier)new Supplier<Image>(this, url){
                    final /* synthetic */ requestAvatar.1 this$0;
                    final /* synthetic */ String $url;

                    @Nullable
                    public final Image get() {
                        Image image;
                        try {
                            image = (Image)CachingGithubUserAvatarLoader.access$getProgressManager$p(this.this$0.this$0).runProcess((Computable)new Computable<Image>(this){
                                final /* synthetic */ requestAvatar.1 this$0;

                                @Nullable
                                public final Image compute() {
                                    return CachingGithubUserAvatarLoader.access$loadAndDownscale(this.this$0.this$0.this$0, this.this$0.this$0.$requestExecutor, this.this$0.this$0.$indicator, this.this$0.$url, this.this$0.this$0.$imageSize);
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            }, (ProgressIndicator)this.this$0.$indicator);
                        }
                        catch (ProcessCanceledException e) {
                            image = null;
                        }
                        return image;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$url = string;
                    }
                }, CachingGithubUserAvatarLoader.access$getExecutor$p(this.this$0));
            }
            {
                this.this$0 = cachingGithubUserAvatarLoader;
                this.$user = githubUser;
                this.$requestExecutor = githubApiRequestExecutor;
                this.$indicator = emptyProgressIndicator;
                this.$imageSize = n;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"avatarCache.get(user) {\n\u2026\n      }, executor)\n    }");
        return (CompletableFuture)object;
    }

    private final Image loadAndDownscale(GithubApiRequestExecutor requestExecutor, EmptyProgressIndicator indicator, String url, int maximumSize) {
        try {
            Image image = requestExecutor.execute((ProgressIndicator)indicator, GithubApiRequests.CurrentUser.getAvatar(url));
            return image.getWidth(null) <= maximumSize && image.getHeight(null) <= maximumSize ? image : ImageLoader.scaleImage((Image)image, (int)maximumSize);
        }
        catch (ProcessCanceledException e) {
            return null;
        }
        catch (Exception e) {
            this.LOG.debug("Error loading image from " + url, (Throwable)e);
            return null;
        }
    }

    public void dispose() {
        this.progressIndicator.cancel();
    }

    public CachingGithubUserAvatarLoader(@NotNull ProgressManager progressManager) {
        Logger logger;
        Intrinsics.checkParameterIsNotNull((Object)progressManager, (String)"progressManager");
        this.progressManager = progressManager;
        CachingGithubUserAvatarLoader cachingGithubUserAvatarLoader = this;
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(CachingGithubUserAvatarLoader.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        cachingGithubUserAvatarLoader.LOG = logger = logger2;
        ExecutorService executorService = AppExecutorUtil.getAppExecutorService();
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"AppExecutorUtil.getAppExecutorService()");
        this.executor = executorService;
        this.progressIndicator = new NonReusableEmptyProgressIndicator();
        this.avatarCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
        LowMemoryWatcher.register((Runnable)new Runnable(){

            @Override
            public final void run() {
                avatarCache.invalidateAll();
            }
        }, (Disposable)this);
    }

    public static final /* synthetic */ ProgressManager access$getProgressManager$p(CachingGithubUserAvatarLoader $this) {
        return $this.progressManager;
    }

    public static final /* synthetic */ Image access$loadAndDownscale(CachingGithubUserAvatarLoader $this, GithubApiRequestExecutor requestExecutor, EmptyProgressIndicator indicator, String url, int maximumSize) {
        return $this.loadAndDownscale(requestExecutor, indicator, url, maximumSize);
    }

    public static final /* synthetic */ ExecutorService access$getExecutor$p(CachingGithubUserAvatarLoader $this) {
        return $this.executor;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/github/util/CachingGithubUserAvatarLoader$Companion;", "", "()V", "MAXIMUM_ICON_SIZE", "", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

