/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.details;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GithubIssueLabel;
import org.jetbrains.plugins.github.api.data.GithubPullRequestDetailed;
import org.jetbrains.plugins.github.api.data.GithubPullRequestDetailedWithHtml;
import org.jetbrains.plugins.github.api.data.GithubUser;
import org.jetbrains.plugins.github.pullrequest.avatars.CachingGithubAvatarIconsProvider;
import org.jetbrains.plugins.github.pullrequest.data.GithubPullRequestsBusyStateTracker;
import org.jetbrains.plugins.github.pullrequest.data.service.GithubPullRequestsMetadataService;
import org.jetbrains.plugins.github.pullrequest.data.service.GithubPullRequestsSecurityService;
import org.jetbrains.plugins.github.pullrequest.ui.details.GithubPullRequestDetailsModel;
import org.jetbrains.plugins.github.pullrequest.ui.details.GithubPullRequestDirectionPanel;
import org.jetbrains.plugins.github.pullrequest.ui.details.LabeledListPanelHandle;
import org.jetbrains.plugins.github.util.GithubUIUtil;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0003#$%B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\u0017H\u0016R\u0012\u0010\u000e\u001a\u00060\u000fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00060\u0015R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GithubPullRequestMetadataPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "model", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/GithubPullRequestDetailsModel;", "securityService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GithubPullRequestsSecurityService;", "busyStateTracker", "Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsBusyStateTracker;", "metadataService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GithubPullRequestsMetadataService;", "iconsProvider", "Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/details/GithubPullRequestDetailsModel;Lorg/jetbrains/plugins/github/pullrequest/data/service/GithubPullRequestsSecurityService;Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsBusyStateTracker;Lorg/jetbrains/plugins/github/pullrequest/data/service/GithubPullRequestsMetadataService;Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider;)V", "assigneesHandle", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/GithubPullRequestMetadataPanel$AssigneesListPanelHandle;", "directionPanel", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/GithubPullRequestDirectionPanel;", "labelsHandle", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/GithubPullRequestMetadataPanel$LabelsListPanelHandle;", "reviewersHandle", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/GithubPullRequestMetadataPanel$ReviewersListPanelHandle;", "addListPanel", "", "handle", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/LabeledListPanelHandle;", "createLabelLabel", "Lcom/intellij/ui/components/panels/Wrapper;", "label", "Lorg/jetbrains/plugins/github/api/data/GithubIssueLabel;", "createUserLabel", "Ljavax/swing/JLabel;", "user", "Lorg/jetbrains/plugins/github/api/data/GithubUser;", "dispose", "AssigneesListPanelHandle", "LabelsListPanelHandle", "ReviewersListPanelHandle", "intellij.vcs.github"})
public final class GithubPullRequestMetadataPanel
extends JPanel
implements Disposable {
    private final GithubPullRequestDirectionPanel directionPanel;
    private final ReviewersListPanelHandle reviewersHandle;
    private final AssigneesListPanelHandle assigneesHandle;
    private final LabelsListPanelHandle labelsHandle;
    private final GithubPullRequestDetailsModel model;
    private final GithubPullRequestsSecurityService securityService;
    private final GithubPullRequestsBusyStateTracker busyStateTracker;
    private final GithubPullRequestsMetadataService metadataService;
    private final CachingGithubAvatarIconsProvider iconsProvider;

    private final void addListPanel(LabeledListPanelHandle<?> handle) {
        this.add((Component)handle.getLabel(), new CC().alignY("top"));
        this.add((Component)handle.getPanel(), new CC().minWidth("0").growX().pushX().wrap());
    }

    public void dispose() {
    }

    private final JLabel createUserLabel(GithubUser user) {
        JLabel jLabel;
        JLabel $receiver = jLabel = new JLabel(user.getLogin(), this.iconsProvider.getIcon(user), 2);
        boolean bl = false;
        $receiver.setBorder((Border)JBUI.Borders.empty((int)4, (int)5, (int)4, (int)5));
        return jLabel;
    }

    private final Wrapper createLabelLabel(GithubIssueLabel label) {
        Wrapper wrapper;
        Wrapper $receiver = wrapper = new Wrapper((JComponent)GithubUIUtil.INSTANCE.createIssueLabelLabel(label));
        boolean bl = false;
        $receiver.setBorder((Border)JBUI.Borders.empty((int)5, (int)5, (int)6, (int)5));
        return wrapper;
    }

    public GithubPullRequestMetadataPanel(@NotNull GithubPullRequestDetailsModel model, @NotNull GithubPullRequestsSecurityService securityService, @NotNull GithubPullRequestsBusyStateTracker busyStateTracker, @NotNull GithubPullRequestsMetadataService metadataService, @NotNull CachingGithubAvatarIconsProvider iconsProvider) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)securityService, (String)"securityService");
        Intrinsics.checkParameterIsNotNull((Object)busyStateTracker, (String)"busyStateTracker");
        Intrinsics.checkParameterIsNotNull((Object)metadataService, (String)"metadataService");
        Intrinsics.checkParameterIsNotNull((Object)iconsProvider, (String)"iconsProvider");
        this.model = model;
        this.securityService = securityService;
        this.busyStateTracker = busyStateTracker;
        this.metadataService = metadataService;
        this.iconsProvider = iconsProvider;
        this.directionPanel = new GithubPullRequestDirectionPanel();
        this.reviewersHandle = new ReviewersListPanelHandle();
        this.assigneesHandle = new AssigneesListPanelHandle();
        this.labelsHandle = new LabelsListPanelHandle();
        this.setOpaque(false);
        this.setLayout((LayoutManager)new MigLayout(new LC().fillX().gridGap("0", "0").insets("0", "0", "0", "0")));
        this.add((Component)((Object)this.directionPanel), new CC().minWidth("0").spanX(2).growX().wrap());
        this.addListPanel(this.reviewersHandle);
        this.addListPanel(this.assigneesHandle);
        this.addListPanel(this.labelsHandle);
        this.model.addDetailsChangedListener(this, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                Pair pair;
                GithubPullRequestDirectionPanel githubPullRequestDirectionPanel = directionPanel;
                GithubPullRequestDetailedWithHtml githubPullRequestDetailedWithHtml = model.getDetails();
                if (githubPullRequestDetailedWithHtml != null) {
                    GithubPullRequestDetailedWithHtml githubPullRequestDetailedWithHtml2 = githubPullRequestDetailedWithHtml;
                    GithubPullRequestDirectionPanel githubPullRequestDirectionPanel2 = githubPullRequestDirectionPanel;
                    GithubPullRequestDetailedWithHtml it = githubPullRequestDetailedWithHtml2;
                    boolean bl = false;
                    Pair pair2 = TuplesKt.to((Object)it.getHead(), (Object)it.getBase());
                    githubPullRequestDirectionPanel = githubPullRequestDirectionPanel2;
                    pair = pair2;
                } else {
                    pair = null;
                }
                githubPullRequestDirectionPanel.setDirection(pair);
            }
        }));
        Disposer.register((Disposable)this, (Disposable)this.reviewersHandle);
        Disposer.register((Disposable)this, (Disposable)this.assigneesHandle);
        Disposer.register((Disposable)this, (Disposable)this.labelsHandle);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GithubPullRequestMetadataPanel$ReviewersListPanelHandle;", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/LabeledListPanelHandle;", "Lorg/jetbrains/plugins/github/api/data/GithubUser;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/details/GithubPullRequestMetadataPanel;)V", "editList", "", "extractItems", "", "details", "Lorg/jetbrains/plugins/github/api/data/GithubPullRequestDetailed;", "getItemComponent", "Ljavax/swing/JLabel;", "item", "intellij.vcs.github"})
    private final class ReviewersListPanelHandle
    extends LabeledListPanelHandle<GithubUser> {
        @Override
        @NotNull
        public List<GithubUser> extractItems(@NotNull GithubPullRequestDetailed details) {
            Intrinsics.checkParameterIsNotNull((Object)details, (String)"details");
            List<GithubUser> list2 = details.getRequestedReviewers();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"details.requestedReviewers");
            return list2;
        }

        @NotNull
        public JLabel getItemComponent(@NotNull GithubUser item) {
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            return GithubPullRequestMetadataPanel.this.createUserLabel(item);
        }

        @Override
        public void editList() {
            block0: {
                GithubPullRequestDetailedWithHtml githubPullRequestDetailedWithHtml;
                GithubPullRequestDetailedWithHtml githubPullRequestDetailedWithHtml2 = GithubPullRequestMetadataPanel.this.model.getDetails();
                if (githubPullRequestDetailedWithHtml2 == null) break block0;
                GithubPullRequestDetailedWithHtml $receiver = githubPullRequestDetailedWithHtml = githubPullRequestDetailedWithHtml2;
                boolean bl = false;
                GithubPullRequestMetadataPanel.this.metadataService.adjustReviewers($receiver.getNumber(), (JComponent)this.getEditButton());
            }
        }

        public ReviewersListPanelHandle() {
            super(GithubPullRequestMetadataPanel.this.model, GithubPullRequestMetadataPanel.this.securityService, GithubPullRequestMetadataPanel.this.busyStateTracker, "No Reviewers", "Reviewers:");
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GithubPullRequestMetadataPanel$AssigneesListPanelHandle;", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/LabeledListPanelHandle;", "Lorg/jetbrains/plugins/github/api/data/GithubUser;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/details/GithubPullRequestMetadataPanel;)V", "editList", "", "extractItems", "", "details", "Lorg/jetbrains/plugins/github/api/data/GithubPullRequestDetailed;", "getItemComponent", "Ljavax/swing/JLabel;", "item", "intellij.vcs.github"})
    private final class AssigneesListPanelHandle
    extends LabeledListPanelHandle<GithubUser> {
        @Override
        @NotNull
        public List<GithubUser> extractItems(@NotNull GithubPullRequestDetailed details) {
            Intrinsics.checkParameterIsNotNull((Object)details, (String)"details");
            List<GithubUser> list2 = details.getAssignees();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"details.assignees");
            return list2;
        }

        @NotNull
        public JLabel getItemComponent(@NotNull GithubUser item) {
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            return GithubPullRequestMetadataPanel.this.createUserLabel(item);
        }

        @Override
        public void editList() {
            block0: {
                GithubPullRequestDetailedWithHtml githubPullRequestDetailedWithHtml;
                GithubPullRequestDetailedWithHtml githubPullRequestDetailedWithHtml2 = GithubPullRequestMetadataPanel.this.model.getDetails();
                if (githubPullRequestDetailedWithHtml2 == null) break block0;
                GithubPullRequestDetailedWithHtml $receiver = githubPullRequestDetailedWithHtml = githubPullRequestDetailedWithHtml2;
                boolean bl = false;
                GithubPullRequestMetadataPanel.this.metadataService.adjustAssignees($receiver.getNumber(), (JComponent)this.getEditButton());
            }
        }

        public AssigneesListPanelHandle() {
            super(GithubPullRequestMetadataPanel.this.model, GithubPullRequestMetadataPanel.this.securityService, GithubPullRequestMetadataPanel.this.busyStateTracker, "Unassigned", "Assignees:");
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GithubPullRequestMetadataPanel$LabelsListPanelHandle;", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/LabeledListPanelHandle;", "Lorg/jetbrains/plugins/github/api/data/GithubIssueLabel;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/details/GithubPullRequestMetadataPanel;)V", "editList", "", "extractItems", "", "details", "Lorg/jetbrains/plugins/github/api/data/GithubPullRequestDetailed;", "getItemComponent", "Lcom/intellij/ui/components/panels/Wrapper;", "item", "intellij.vcs.github"})
    private final class LabelsListPanelHandle
    extends LabeledListPanelHandle<GithubIssueLabel> {
        @Override
        @Nullable
        public List<GithubIssueLabel> extractItems(@NotNull GithubPullRequestDetailed details) {
            Intrinsics.checkParameterIsNotNull((Object)details, (String)"details");
            return details.getLabels();
        }

        @NotNull
        public Wrapper getItemComponent(@NotNull GithubIssueLabel item) {
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            return GithubPullRequestMetadataPanel.this.createLabelLabel(item);
        }

        @Override
        public void editList() {
            block0: {
                GithubPullRequestDetailedWithHtml githubPullRequestDetailedWithHtml;
                GithubPullRequestDetailedWithHtml githubPullRequestDetailedWithHtml2 = GithubPullRequestMetadataPanel.this.model.getDetails();
                if (githubPullRequestDetailedWithHtml2 == null) break block0;
                GithubPullRequestDetailedWithHtml $receiver = githubPullRequestDetailedWithHtml = githubPullRequestDetailedWithHtml2;
                boolean bl = false;
                GithubPullRequestMetadataPanel.this.metadataService.adjustLabels($receiver.getNumber(), (JComponent)this.getEditButton());
            }
        }

        public LabelsListPanelHandle() {
            super(GithubPullRequestMetadataPanel.this.model, GithubPullRequestMetadataPanel.this.securityService, GithubPullRequestMetadataPanel.this.busyStateTracker, "No Labels", "Labels:");
        }
    }
}

