/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.search;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GithubIssueState;
import org.jetbrains.plugins.github.api.search.GithubIssueSearchSort;
import org.jetbrains.plugins.github.api.util.GithubApiSearchQueryBuilder;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0003\f\r\u000eB\u0017\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u000bR\u0018\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery;", "", "terms", "", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term;", "(Ljava/util/List;)V", "buildApiSearchQuery", "", "searchQueryBuilder", "Lorg/jetbrains/plugins/github/api/util/GithubApiSearchQueryBuilder;", "isEmpty", "", "Companion", "QualifierName", "Term", "intellij.vcs.github"})
public final class GithubPullRequestSearchQuery {
    private final List<Term<?>> terms;
    private static final SimpleDateFormat DATE_FORMAT;
    public static final Companion Companion;

    public final void buildApiSearchQuery(@NotNull GithubApiSearchQueryBuilder searchQueryBuilder) {
        Intrinsics.checkParameterIsNotNull((Object)searchQueryBuilder, (String)"searchQueryBuilder");
        for (Term<?> term : this.terms) {
            Term<?> term2 = term;
            if (term2 instanceof Term.QueryPart) {
                searchQueryBuilder.query(((Term.QueryPart)term).getApiValue());
                continue;
            }
            if (!(term2 instanceof Term.Qualifier)) continue;
            searchQueryBuilder.qualifier(((Term.Qualifier)term).getApiName(), term.getApiValue());
        }
    }

    public final boolean isEmpty() {
        return this.terms.isEmpty();
    }

    public GithubPullRequestSearchQuery(@NotNull List<? extends Term<?>> terms) {
        Intrinsics.checkParameterIsNotNull(terms, (String)"terms");
        this.terms = terms;
    }

    static {
        Companion = new Companion(null);
        DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\u0003H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$QualifierName;", "", "apiName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getApiName", "()Ljava/lang/String;", "createTerm", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term;", "value", "state", "assignee", "author", "after", "before", "sortBy", "intellij.vcs.github"})
    public static final abstract class QualifierName
    extends Enum<QualifierName> {
        public static final /* enum */ QualifierName state;
        public static final /* enum */ QualifierName assignee;
        public static final /* enum */ QualifierName author;
        public static final /* enum */ QualifierName after;
        public static final /* enum */ QualifierName before;
        public static final /* enum */ QualifierName sortBy;
        private static final /* synthetic */ QualifierName[] $VALUES;
        @NotNull
        private final String apiName;

        static {
            QualifierName[] qualifierNameArray = new QualifierName[6];
            QualifierName[] qualifierNameArray2 = qualifierNameArray;
            qualifierNameArray[0] = state = new state("state", 0);
            qualifierNameArray[1] = assignee = new assignee("assignee", 1);
            qualifierNameArray[2] = author = new author("author", 2);
            qualifierNameArray[3] = after = new after("after", 3);
            qualifierNameArray[4] = before = new before("before", 4);
            qualifierNameArray[5] = sortBy = new sortBy("sortBy", 5);
            $VALUES = qualifierNameArray;
        }

        @NotNull
        public abstract Term<?> createTerm(@NotNull String var1);

        @NotNull
        public final String getApiName() {
            return this.apiName;
        }

        private QualifierName(String apiName) {
            this.apiName = apiName;
        }

        public /* synthetic */ QualifierName(String $enum_name_or_ordinal$0, int $enum_name_or_ordinal$1, String apiName, DefaultConstructorMarker $constructor_marker) {
            this(apiName);
        }

        public static QualifierName[] values() {
            return (QualifierName[])$VALUES.clone();
        }

        public static QualifierName valueOf(String string) {
            return Enum.valueOf(QualifierName.class, string);
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$QualifierName$state;", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$QualifierName;", "createTerm", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term;", "value", "", "intellij.vcs.github"})
        static final class state
        extends QualifierName {
            @Override
            @NotNull
            public Term<?> createTerm(@NotNull String value) {
                Term.Qualifier qualifier;
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Term.Qualifier.Enum.Companion companion = Term.Qualifier.Enum.Companion;
                QualifierName name$iv = this;
                boolean $i$f$from = false;
                try {
                    GithubIssueState githubIssueState;
                    QualifierName qualifierName = name$iv;
                    GithubIssueState githubIssueState2 = githubIssueState = GithubIssueState.valueOf(value);
                    QualifierName qualifierName2 = qualifierName;
                    qualifier = new Term.Qualifier.Enum<GithubIssueState>(qualifierName2, githubIssueState2);
                }
                catch (IllegalArgumentException e$iv) {
                    qualifier = new Term.Qualifier.Simple(name$iv, value);
                }
                return qualifier;
            }

            /*
             * WARNING - void declaration
             */
            state() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$QualifierName$assignee;", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$QualifierName;", "createTerm", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term$Qualifier$Simple;", "value", "", "intellij.vcs.github"})
        static final class assignee
        extends QualifierName {
            @NotNull
            public Term.Qualifier.Simple createTerm(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return new Term.Qualifier.Simple((QualifierName)this, value);
            }

            /*
             * WARNING - void declaration
             */
            assignee() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$QualifierName$author;", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$QualifierName;", "createTerm", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term$Qualifier$Simple;", "value", "", "intellij.vcs.github"})
        static final class author
        extends QualifierName {
            @NotNull
            public Term.Qualifier.Simple createTerm(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return new Term.Qualifier.Simple((QualifierName)this, value);
            }

            /*
             * WARNING - void declaration
             */
            author() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$QualifierName$after;", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$QualifierName;", "createTerm", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term;", "value", "", "intellij.vcs.github"})
        static final class after
        extends QualifierName {
            @Override
            @NotNull
            public Term<?> createTerm(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return Term.Qualifier.Date.After.Companion.from(this, value);
            }

            /*
             * WARNING - void declaration
             */
            after() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$QualifierName$before;", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$QualifierName;", "createTerm", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term;", "value", "", "intellij.vcs.github"})
        static final class before
        extends QualifierName {
            @Override
            @NotNull
            public Term<?> createTerm(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return Term.Qualifier.Date.Before.Companion.from(this, value);
            }

            /*
             * WARNING - void declaration
             */
            before() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$QualifierName$sortBy;", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$QualifierName;", "createTerm", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term;", "value", "", "intellij.vcs.github"})
        static final class sortBy
        extends QualifierName {
            @Override
            @NotNull
            public Term<?> createTerm(@NotNull String value) {
                Term.Qualifier qualifier;
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Term.Qualifier.Enum.Companion companion = Term.Qualifier.Enum.Companion;
                QualifierName name$iv = this;
                boolean $i$f$from = false;
                try {
                    GithubIssueSearchSort githubIssueSearchSort;
                    QualifierName qualifierName = name$iv;
                    GithubIssueSearchSort githubIssueSearchSort2 = githubIssueSearchSort = GithubIssueSearchSort.valueOf(value);
                    QualifierName qualifierName2 = qualifierName;
                    qualifier = new Term.Qualifier.Enum<GithubIssueSearchSort>(qualifierName2, githubIssueSearchSort2);
                }
                catch (IllegalArgumentException e$iv) {
                    qualifier = new Term.Qualifier.Simple(name$iv, value);
                }
                return qualifier;
            }

            /*
             * WARNING - void declaration
             */
            sortBy() {
                void var1_1;
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0002\f\rB\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0003\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u0082\u0001\u0002\u000e\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term;", "T", "", "value", "(Ljava/lang/Object;)V", "apiValue", "", "getApiValue", "()Ljava/lang/String;", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "Qualifier", "QueryPart", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term$QueryPart;", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term$Qualifier;", "intellij.vcs.github"})
    public static abstract class Term<T> {
        @NotNull
        private final T value;

        @Nullable
        public abstract String getApiValue();

        @NotNull
        protected final T getValue() {
            return this.value;
        }

        private Term(T value) {
            this.value = value;
        }

        public /* synthetic */ Term(Object value, DefaultConstructorMarker $constructor_marker) {
            this(value);
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term$QueryPart;", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term;", "", "value", "(Ljava/lang/String;)V", "apiValue", "getApiValue", "()Ljava/lang/String;", "intellij.vcs.github"})
        public static final class QueryPart
        extends Term<String> {
            @NotNull
            private final String apiValue;

            @Override
            @NotNull
            public String getApiValue() {
                return this.apiValue;
            }

            public QueryPart(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                super(value, null);
                this.apiValue = (String)this.getValue();
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0003\f\r\u000eB\u0017\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0001\u0003\u000f\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term$Qualifier;", "T", "", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term;", "name", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$QualifierName;", "value", "(Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$QualifierName;Ljava/lang/Object;)V", "apiName", "", "getApiName", "()Ljava/lang/String;", "Date", "Enum", "Simple", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term$Qualifier$Simple;", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term$Qualifier$Enum;", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term$Qualifier$Date;", "intellij.vcs.github"})
        public static abstract class Qualifier<T>
        extends Term<T> {
            @NotNull
            private final String apiName;

            @NotNull
            public final String getApiName() {
                return this.apiName;
            }

            private Qualifier(QualifierName name, T value) {
                super(value, null);
                this.apiName = name.getApiName();
            }

            public /* synthetic */ Qualifier(QualifierName name, Object value, DefaultConstructorMarker $constructor_marker) {
                this(name, value);
            }

            @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term$Qualifier$Simple;", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term$Qualifier;", "", "name", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$QualifierName;", "value", "(Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$QualifierName;Ljava/lang/String;)V", "apiValue", "getApiValue", "()Ljava/lang/String;", "intellij.vcs.github"})
            public static final class Simple
            extends Qualifier<String> {
                @NotNull
                private final String apiValue;

                @Override
                @NotNull
                public String getApiValue() {
                    return this.apiValue;
                }

                public Simple(@NotNull QualifierName name, @NotNull String value) {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)name), (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                    super(name, value, null);
                    this.apiValue = (String)this.getValue();
                }
            }

            @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \f*\u000e\b\u0002\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00020\u0003:\u0001\fB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term$Qualifier$Enum;", "T", "", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term$Qualifier;", "name", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$QualifierName;", "value", "(Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$QualifierName;Ljava/lang/Enum;)V", "apiValue", "", "getApiValue", "()Ljava/lang/String;", "Companion", "intellij.vcs.github"})
            public static final class Enum<T extends java.lang.Enum<T>>
            extends Qualifier<java.lang.Enum<T>> {
                @NotNull
                private final String apiValue;
                public static final Companion Companion = new Companion(null);

                @Override
                @NotNull
                public String getApiValue() {
                    return this.apiValue;
                }

                public Enum(@NotNull QualifierName name, @NotNull T value) {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)name), (String)"name");
                    Intrinsics.checkParameterIsNotNull(value, (String)"value");
                    super(name, value, null);
                    this.apiValue = ((java.lang.Enum)this.getValue()).name();
                }

                @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\"\u0010\b\u0003\u0010\u0005\u0018\u0001*\b\u0012\u0004\u0012\u0002H\u00050\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0086\b\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term$Qualifier$Enum$Companion;", "", "()V", "from", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term;", "T", "", "name", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$QualifierName;", "value", "", "intellij.vcs.github"})
                public static final class Companion {
                    private final <T extends java.lang.Enum<T>> Term<?> from(QualifierName name, String value) {
                        Qualifier qualifier;
                        int $i$f$from = 0;
                        try {
                            Object t;
                            QualifierName qualifierName = name;
                            Intrinsics.reifiedOperationMarker((int)5, (String)"T");
                            Object t2 = t = java.lang.Enum.valueOf(null, value);
                            QualifierName qualifierName2 = qualifierName;
                            qualifier = new Enum(qualifierName2, t2);
                        }
                        catch (IllegalArgumentException e) {
                            qualifier = new Simple(name, value);
                        }
                        return qualifier;
                    }

                    private Companion() {
                    }

                    public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                        this();
                    }
                }
            }

            @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\t\nB\u0017\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0004\u0082\u0001\u0002\u000b\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term$Qualifier$Date;", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term$Qualifier;", "Ljava/util/Date;", "name", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$QualifierName;", "value", "(Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$QualifierName;Ljava/util/Date;)V", "formatDate", "", "After", "Before", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term$Qualifier$Date$Before;", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term$Qualifier$Date$After;", "intellij.vcs.github"})
            public static abstract class Date
            extends Qualifier<java.util.Date> {
                @NotNull
                protected final String formatDate() {
                    String string = DATE_FORMAT.format((java.util.Date)this.getValue());
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DATE_FORMAT.format(this.value)");
                    return string;
                }

                private Date(QualifierName name, java.util.Date value) {
                    super(name, value, null);
                }

                public /* synthetic */ Date(QualifierName name, java.util.Date value, DefaultConstructorMarker $constructor_marker) {
                    this(name, value);
                }

                @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term$Qualifier$Date$Before;", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term$Qualifier$Date;", "name", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$QualifierName;", "value", "Ljava/util/Date;", "(Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$QualifierName;Ljava/util/Date;)V", "apiValue", "", "getApiValue", "()Ljava/lang/String;", "Companion", "intellij.vcs.github"})
                public static final class Before
                extends Date {
                    @NotNull
                    private final String apiValue;
                    public static final Companion Companion = new Companion(null);

                    @Override
                    @NotNull
                    public String getApiValue() {
                        return this.apiValue;
                    }

                    public Before(@NotNull QualifierName name, @NotNull java.util.Date value) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)name), (String)"name");
                        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                        super(name, value, null);
                        this.apiValue = '<' + this.formatDate();
                    }

                    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term$Qualifier$Date$Before$Companion;", "", "()V", "from", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term;", "name", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$QualifierName;", "value", "", "intellij.vcs.github"})
                    public static final class Companion {
                        @NotNull
                        public final Term<?> from(@NotNull QualifierName name, @NotNull String value) {
                            java.util.Date date;
                            java.util.Date date2;
                            Intrinsics.checkParameterIsNotNull((Object)((Object)name), (String)"name");
                            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                            try {
                                date2 = DATE_FORMAT.parse(value);
                            }
                            catch (ParseException e) {
                                return new Simple(name, value);
                            }
                            java.util.Date date3 = date = date2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)date3, (String)"date");
                            return new Before(name, date3);
                        }

                        private Companion() {
                        }

                        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                            this();
                        }
                    }
                }

                @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term$Qualifier$Date$After;", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term$Qualifier$Date;", "name", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$QualifierName;", "value", "Ljava/util/Date;", "(Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$QualifierName;Ljava/util/Date;)V", "apiValue", "", "getApiValue", "()Ljava/lang/String;", "Companion", "intellij.vcs.github"})
                public static final class After
                extends Date {
                    @NotNull
                    private final String apiValue;
                    public static final Companion Companion = new Companion(null);

                    @Override
                    @NotNull
                    public String getApiValue() {
                        return this.apiValue;
                    }

                    public After(@NotNull QualifierName name, @NotNull java.util.Date value) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)name), (String)"name");
                        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                        super(name, value, null);
                        this.apiValue = '>' + this.formatDate();
                    }

                    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term$Qualifier$Date$After$Companion;", "", "()V", "from", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Term;", "name", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$QualifierName;", "value", "", "intellij.vcs.github"})
                    public static final class Companion {
                        @NotNull
                        public final Term<?> from(@NotNull QualifierName name, @NotNull String value) {
                            Qualifier qualifier;
                            Intrinsics.checkParameterIsNotNull((Object)((Object)name), (String)"name");
                            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                            try {
                                java.util.Date date = DATE_FORMAT.parse(value);
                                Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"DATE_FORMAT.parse(value)");
                                qualifier = new After(name, date);
                            }
                            catch (ParseException e) {
                                qualifier = new Simple(name, value);
                            }
                            return qualifier;
                        }

                        private Companion() {
                        }

                        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                            this();
                        }
                    }
                }
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery$Companion;", "", "()V", "DATE_FORMAT", "Ljava/text/SimpleDateFormat;", "parseFromString", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQuery;", "string", "", "intellij.vcs.github"})
    public static final class Companion {
        @NotNull
        public final GithubPullRequestSearchQuery parseFromString(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
            List result = new ArrayList();
            List terms = StringsKt.split$default((CharSequence)string, (char[])new char[]{' '}, (boolean)false, (int)0, (int)6, null);
            for (String term : terms) {
                CharSequence charSequence = term;
                if (charSequence.length() == 0) continue;
                int colonIdx = StringsKt.indexOf$default((CharSequence)term, (char)':', (int)0, (boolean)false, (int)6, null);
                if (colonIdx < 0) {
                    result.add(new Term.QueryPart(term));
                    continue;
                }
                try {
                    String string2;
                    String string3 = term;
                    int n = 0;
                    List list2 = result;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.substring(n, colonIdx);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    Object object = string5;
                    string3 = term;
                    n = colonIdx + 1;
                    object = QualifierName.valueOf((String)object);
                    String string6 = string3;
                    if (string6 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string6.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
                    list2.add(((QualifierName)((Object)object)).createTerm(string2));
                }
                catch (IllegalArgumentException e) {
                    result.add(new Term.QueryPart(term));
                }
            }
            return new GithubPullRequestSearchQuery(result);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

