/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.search;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.TextFieldCompletionProviderDumbAware;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GithubIssueState;
import org.jetbrains.plugins.github.api.search.GithubIssueSearchSort;
import org.jetbrains.plugins.github.pullrequest.search.GithubPullRequestSearchComponent;
import org.jetbrains.plugins.github.pullrequest.search.GithubPullRequestSearchModel;
import org.jetbrains.plugins.github.pullrequest.search.GithubPullRequestSearchQuery;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003*\u0001\n\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchComponent;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "project", "Lcom/intellij/openapi/project/Project;", "autoPopupController", "Lcom/intellij/codeInsight/AutoPopupController;", "model", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchModel;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/codeInsight/AutoPopupController;Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchModel;)V", "searchField", "org/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchComponent$searchField$1", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchComponent$searchField$1;", "value", "", "searchText", "getSearchText", "()Ljava/lang/String;", "setSearchText", "(Ljava/lang/String;)V", "updateQuery", "", "updateUI", "SearchCompletionProvider", "intellij.vcs.github"})
public final class GithubPullRequestSearchComponent
extends BorderLayoutPanel {
    private final searchField.1 searchField;
    private final AutoPopupController autoPopupController;
    private final GithubPullRequestSearchModel model;

    @NotNull
    public final String getSearchText() {
        String string = this.searchField.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"searchField.text");
        return string;
    }

    public final void setSearchText(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.searchField.setText(value);
        this.updateQuery();
    }

    private final void updateQuery() {
        String string = this.searchField.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"searchField.text");
        this.model.setQuery(GithubPullRequestSearchQuery.Companion.parseFromString(string));
    }

    public void updateUI() {
        super.updateUI();
        this.setBackground(UIUtil.getListBackground());
    }

    public GithubPullRequestSearchComponent(@NotNull Project project, @NotNull AutoPopupController autoPopupController, @NotNull GithubPullRequestSearchModel model) {
        JBLabel jBLabel;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)autoPopupController, (String)"autoPopupController");
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        this.autoPopupController = autoPopupController;
        this.model = model;
        this.searchField = new TextFieldWithCompletion(this, project, project, (TextCompletionProvider)new SearchCompletionProvider(), "", true, true, false, false){
            final /* synthetic */ GithubPullRequestSearchComponent this$0;
            final /* synthetic */ Project $project;

            protected boolean processKeyBinding(@Nullable KeyStroke ks, @Nullable KeyEvent e, int condition, boolean pressed) {
                KeyEvent keyEvent = e;
                if (keyEvent != null) {
                    if (keyEvent.getKeyCode() == 10) {
                        if (pressed) {
                            GithubPullRequestSearchComponent.access$updateQuery(this.this$0);
                            return true;
                        }
                    }
                }
                return super.processKeyBinding(ks, e, condition, pressed);
            }

            @NotNull
            protected EditorEx createEditor() {
                EditorEx editorEx;
                EditorEx $receiver = editorEx = super.createEditor();
                boolean bl = false;
                $receiver.putUserData(AutoPopupController.NO_ADS, (Object)true);
                EditorEx editorEx2 = editorEx;
                Intrinsics.checkExpressionValueIsNotNull((Object)editorEx2, (String)"super.createEditor().app\u2026ler.NO_ADS, true)\n      }");
                return editorEx2;
            }

            protected void setupBorder(@NotNull EditorEx editor) {
                Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
                editor.setBorder((Border)JBUI.Borders.empty((int)6, (int)5));
            }
            {
                this.this$0 = $outer;
                this.$project = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6, $super_call_param$7, $super_call_param$8);
            }
        };
        JBLabel $receiver = jBLabel = new JBLabel(AllIcons.Actions.Find);
        boolean bl = false;
        $receiver.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        JBLabel icon = jBLabel;
        this.addToLeft((Component)icon);
        this.addToCenter((Component)((Object)this.searchField));
        UIUtil.setNotOpaqueRecursively((Component)((Component)((Object)this.searchField)));
    }

    public static final /* synthetic */ AutoPopupController access$getAutoPopupController$p(GithubPullRequestSearchComponent $this) {
        return $this.autoPopupController;
    }

    public static final /* synthetic */ void access$updateQuery(GithubPullRequestSearchComponent $this) {
        $this.updateQuery();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000/\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0014R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchComponent$SearchCompletionProvider;", "Lcom/intellij/util/TextFieldCompletionProviderDumbAware;", "(Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchComponent;)V", "addColonInsertHandler", "org/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchComponent$SearchCompletionProvider$addColonInsertHandler$1", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchComponent$SearchCompletionProvider$addColonInsertHandler$1;", "addCompletionVariants", "", "text", "", "offset", "", "prefix", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "getCurrentQualifierName", "getPrefix", "currentTextPrefix", "intellij.vcs.github"})
    private final class SearchCompletionProvider
    extends TextFieldCompletionProviderDumbAware {
        private final addColonInsertHandler.1 addColonInsertHandler;

        protected void addCompletionVariants(@NotNull String text, int offset, @NotNull String prefix, @NotNull CompletionResultSet result) {
            block3: {
                String qualifierName;
                block4: {
                    block2: {
                        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
                        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
                        qualifierName = this.getCurrentQualifierName(text, offset);
                        if (qualifierName != null) break block2;
                        result.addElement((LookupElement)LookupElementBuilder.create((Object)((Object)GithubPullRequestSearchQuery.QualifierName.state)).withTailText(":").withInsertHandler((InsertHandler)this.addColonInsertHandler));
                        result.addElement((LookupElement)LookupElementBuilder.create((Object)((Object)GithubPullRequestSearchQuery.QualifierName.author)).withTailText(":").withTypeText("username", true).withInsertHandler((InsertHandler)this.addColonInsertHandler));
                        result.addElement((LookupElement)LookupElementBuilder.create((Object)((Object)GithubPullRequestSearchQuery.QualifierName.assignee)).withTailText(":").withTypeText("username", true).withInsertHandler((InsertHandler)this.addColonInsertHandler));
                        result.addElement((LookupElement)LookupElementBuilder.create((Object)((Object)GithubPullRequestSearchQuery.QualifierName.after)).withTailText(":").withTypeText("YYYY-MM-DD", true).withInsertHandler((InsertHandler)this.addColonInsertHandler));
                        result.addElement((LookupElement)LookupElementBuilder.create((Object)((Object)GithubPullRequestSearchQuery.QualifierName.before)).withTailText(":").withTypeText("YYYY-MM-DD", true).withInsertHandler((InsertHandler)this.addColonInsertHandler));
                        result.addElement((LookupElement)LookupElementBuilder.create((Object)((Object)GithubPullRequestSearchQuery.QualifierName.sortBy)).withTailText(":").withInsertHandler((InsertHandler)this.addColonInsertHandler));
                        break block3;
                    }
                    if (!StringsKt.equals((String)qualifierName, (String)GithubPullRequestSearchQuery.QualifierName.state.name(), (boolean)true)) break block4;
                    for (GithubIssueState state2 : GithubIssueState.values()) {
                        result.addElement((LookupElement)LookupElementBuilder.create((String)state2.name()));
                    }
                    break block3;
                }
                if (!StringsKt.equals((String)qualifierName, (String)GithubPullRequestSearchQuery.QualifierName.sortBy.name(), (boolean)true)) break block3;
                for (GithubIssueSearchSort sort : GithubIssueSearchSort.values()) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)sort.name()));
                }
            }
        }

        @NotNull
        protected String getPrefix(@NotNull String currentTextPrefix) {
            Intrinsics.checkParameterIsNotNull((Object)currentTextPrefix, (String)"currentTextPrefix");
            int spaceIdx = StringsKt.lastIndexOf$default((CharSequence)currentTextPrefix, (char)' ', (int)0, (boolean)false, (int)6, null);
            int colonIdx = StringsKt.indexOf$default((CharSequence)currentTextPrefix, (char)':', (int)Math.max(spaceIdx, 0), (boolean)false, (int)4, null);
            String string = currentTextPrefix;
            int n = Math.max(spaceIdx, colonIdx) + 1;
            String string2 = string.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            return string2;
        }

        private final String getCurrentQualifierName(String text, int offset) {
            int spaceIdx = StringsKt.lastIndexOf$default((CharSequence)text, (char)' ', (int)(offset - 1), (boolean)false, (int)4, null);
            int colonIdx = StringsKt.indexOf$default((CharSequence)text, (char)':', (int)Math.max(spaceIdx, 0), (boolean)false, (int)4, null);
            if (colonIdx < 0 || spaceIdx > colonIdx) {
                return null;
            }
            String string = text;
            int n = spaceIdx + 1;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, colonIdx);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return string3;
        }

        public SearchCompletionProvider() {
            super(true);
            this.addColonInsertHandler = new InsertHandler<LookupElement>(this){
                final /* synthetic */ SearchCompletionProvider this$0;

                public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                    Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                    Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                    if (context.getCompletionChar() == ':') {
                        return;
                    }
                    Editor editor = context.getEditor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"context.editor");
                    Editor editor2 = editor;
                    if (!this.isAtColon(context)) {
                        EditorModificationUtil.insertStringAtCaret((Editor)editor2, (String)":");
                        context.commitDocument();
                    }
                    GithubPullRequestSearchComponent.access$getAutoPopupController$p(this.this$0.GithubPullRequestSearchComponent.this).autoPopupMemberLookup(editor2, null);
                }

                private final boolean isAtColon(InsertionContext context) {
                    int startOffset = context.getStartOffset();
                    Document document = context.getDocument();
                    Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"context.document");
                    Document document2 = document;
                    return document2.getTextLength() > startOffset && document2.getCharsSequence().charAt(startOffset) == ':';
                }
                {
                    this.this$0 = $outer;
                }
            };
        }
    }
}

