/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data;

import com.intellij.openapi.Disposable;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.util.EventListener;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.pullrequest.data.GithubPullRequestsBusyStateTracker;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\t\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0016J$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000f0\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\tH\u0016R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u0007\u001a$\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\t0\t \u0006*\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\t0\t0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsBusyStateTrackerImpl;", "Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsBusyStateTracker;", "()V", "busyChangeEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsBusyStateTrackerImpl$GithubPullRequestBusyStateListener;", "kotlin.jvm.PlatformType", "busySet", "", "", "", "acquire", "", "pullRequest", "addPullRequestBusyStateListener", "", "disposable", "Lcom/intellij/openapi/Disposable;", "listener", "Lkotlin/Function1;", "isBusy", "release", "GithubPullRequestBusyStateListener", "intellij.vcs.github"})
public final class GithubPullRequestsBusyStateTrackerImpl
implements GithubPullRequestsBusyStateTracker {
    private final Set<Long> busySet;
    private final EventDispatcher<GithubPullRequestBusyStateListener> busyChangeEventDispatcher;

    @Override
    public boolean acquire(long pullRequest) {
        boolean ok = this.busySet.add(pullRequest);
        if (ok) {
            ((GithubPullRequestBusyStateListener)this.busyChangeEventDispatcher.getMulticaster()).busyStateChanged(pullRequest);
        }
        return ok;
    }

    @Override
    public void release(long pullRequest) {
        boolean ok = this.busySet.remove(pullRequest);
        if (ok) {
            ((GithubPullRequestBusyStateListener)this.busyChangeEventDispatcher.getMulticaster()).busyStateChanged(pullRequest);
        }
    }

    @Override
    public boolean isBusy(long pullRequest) {
        return this.busySet.contains(pullRequest);
    }

    @Override
    public void addPullRequestBusyStateListener(@NotNull Disposable disposable, @NotNull Function1<? super Long, Unit> listener) {
        Intrinsics.checkParameterIsNotNull((Object)disposable, (String)"disposable");
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        this.busyChangeEventDispatcher.addListener((EventListener)new GithubPullRequestBusyStateListener(listener){
            final /* synthetic */ Function1 $listener;

            public void busyStateChanged(long pullRequest) {
                this.$listener.invoke((Object)pullRequest);
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        }, disposable);
    }

    public GithubPullRequestsBusyStateTrackerImpl() {
        Set set = ContainerUtil.newConcurrentSet();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"ContainerUtil.newConcurrentSet<Long>()");
        this.busySet = set;
        EventDispatcher eventDispatcher = EventDispatcher.create(GithubPullRequestBusyStateListener.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)eventDispatcher, (String)"EventDispatcher.create(G\u2026tateListener::class.java)");
        this.busyChangeEventDispatcher = eventDispatcher;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\bb\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsBusyStateTrackerImpl$GithubPullRequestBusyStateListener;", "Ljava/util/EventListener;", "busyStateChanged", "", "pullRequest", "", "intellij.vcs.github"})
    private static interface GithubPullRequestBusyStateListener
    extends EventListener {
        public void busyStateChanged(long var1);
    }
}

