/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLEditorKit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubApiResponse;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;
import org.jetbrains.plugins.github.authentication.ui.GithubLoginDialog;
import org.jetbrains.plugins.github.authentication.util.GithubTokenCreator;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.exceptions.GithubParseException;
import org.jetbrains.plugins.github.ui.util.DialogValidationUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0004KLMNBw\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00128\b\u0002\u0010\b\u001a2\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\t\u0012\b\b\u0002\u0010\u0010\u001a\u00020\n\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u0012J\u0014\u0010-\u001a\u00020.2\n\u0010/\u001a\u00060\u001bR\u00020\u0000H\u0002J\b\u00100\u001a\u00020\u0014H\u0014J\n\u00101\u001a\u0004\u0018\u000102H\u0014J\b\u00103\u001a\u00020\u0014H\u0014J\b\u00104\u001a\u00020.H\u0014J\u000e\u00105\u001a\b\u0012\u0004\u0012\u00020*06H\u0014J\u0006\u00107\u001a\u00020\nJ\b\u00108\u001a\u000202H\u0016J\u0006\u00109\u001a\u00020\rJ\u0006\u0010:\u001a\u00020\nJ\u001c\u0010;\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010*0<j\u0002`=2\u0006\u0010>\u001a\u00020?H\u0002J\u0010\u0010@\u001a\u00020.2\u0006\u0010A\u001a\u00020\u000fH\u0002J \u0010B\u001a\u00020\u00002\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010C\u001a\u0004\u0018\u00010\nH\u0007J\u000e\u0010D\u001a\u00020\u00002\u0006\u0010E\u001a\u00020FJ\u001a\u0010G\u001a\u00020\u00002\u0006\u0010H\u001a\u00020\n2\b\b\u0002\u0010I\u001a\u00020\u000fH\u0007J\u0014\u0010J\u001a\u00020\u00002\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\nH\u0007R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0012\u0010\u001a\u001a\u00060\u001bR\u00020\u0000X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\b\u001a2\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001d\u001a\u00060\u001eR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010+\u001a\u00060,R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "executorFactory", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;", "project", "Lcom/intellij/openapi/project/Project;", "parent", "Ljava/awt/Component;", "isAccountUnique", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "server", "", "title", "message", "(Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;Lcom/intellij/openapi/project/Project;Ljava/awt/Component;Lkotlin/jvm/functions/Function2;Ljava/lang/String;Ljava/lang/String;)V", "centerPanel", "Lcom/intellij/ui/components/panels/Wrapper;", "clientName", "getClientName", "()Ljava/lang/String;", "setClientName", "(Ljava/lang/String;)V", "currentUi", "Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginDialog$CredentialsUI;", "login", "passwordUi", "Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginDialog$LoginPasswordCredentialsUI;", "progressExtension", "Lcom/intellij/ui/components/fields/ExtendableTextComponent$Extension;", "progressIcon", "Lcom/intellij/ui/AnimatedIcon$Default;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "serverTextField", "Lcom/intellij/ui/components/fields/ExtendableTextField;", "southAdditionalPanel", "token", "tokenAcquisitionError", "Lcom/intellij/openapi/ui/ValidationInfo;", "tokenUi", "Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginDialog$TokenCredentialsUI;", "applyUi", "", "ui", "createCenterPanel", "createNorthPanel", "Ljavax/swing/JComponent;", "createSouthAdditionalPanel", "doOKAction", "doValidateAll", "", "getLogin", "getPreferredFocusedComponent", "getServer", "getToken", "serverPathValidator", "Lkotlin/Function0;", "Lorg/jetbrains/plugins/github/ui/util/Validator;", "textField", "Ljavax/swing/JTextField;", "setBusy", "busy", "withCredentials", "password", "withError", "exception", "", "withServer", "path", "editable", "withToken", "CredentialsUI", "LoginNotUniqueException", "LoginPasswordCredentialsUI", "TokenCredentialsUI", "intellij.vcs.github"})
public final class GithubLoginDialog
extends DialogWrapper {
    private final ExtendableTextField serverTextField;
    private Wrapper centerPanel;
    private Wrapper southAdditionalPanel;
    private LoginPasswordCredentialsUI passwordUi;
    private TokenCredentialsUI tokenUi;
    private CredentialsUI currentUi;
    private ProgressIndicator progressIndicator;
    private final AnimatedIcon.Default progressIcon;
    private final ExtendableTextComponent.Extension progressExtension;
    private String login;
    private String token;
    @NotNull
    private String clientName;
    private ValidationInfo tokenAcquisitionError;
    private final GithubApiRequestExecutor.Factory executorFactory;
    private final Project project;
    private final Function2<String, GithubServerPath, Boolean> isAccountUnique;
    private final String message;

    @NotNull
    public final String getClientName() {
        return this.clientName;
    }

    public final void setClientName(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.clientName = string;
    }

    @JvmOverloads
    @NotNull
    public final GithubLoginDialog withServer(@NotNull String path, boolean editable) {
        ExtendableTextField extendableTextField;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        ExtendableTextField $receiver = extendableTextField = this.serverTextField;
        boolean bl = false;
        $receiver.setText(path);
        $receiver.setEditable(editable);
        return this;
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ GithubLoginDialog withServer$default(GithubLoginDialog githubLoginDialog, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return githubLoginDialog.withServer(string, bl);
    }

    @JvmOverloads
    @NotNull
    public final GithubLoginDialog withServer(@NotNull String path) {
        return GithubLoginDialog.withServer$default(this, path, false, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final GithubLoginDialog withCredentials(@Nullable String login2, @Nullable String password) {
        if (login2 != null) {
            this.passwordUi.setLogin(login2);
        }
        if (password != null) {
            this.passwordUi.setPassword(password);
        }
        this.applyUi(this.passwordUi);
        return this;
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ GithubLoginDialog withCredentials$default(GithubLoginDialog githubLoginDialog, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return githubLoginDialog.withCredentials(string, string2);
    }

    @JvmOverloads
    @NotNull
    public final GithubLoginDialog withCredentials(@Nullable String login2) {
        return GithubLoginDialog.withCredentials$default(this, login2, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final GithubLoginDialog withCredentials() {
        return GithubLoginDialog.withCredentials$default(this, null, null, 3, null);
    }

    @JvmOverloads
    @NotNull
    public final GithubLoginDialog withToken(@Nullable String token2) {
        if (token2 != null) {
            this.tokenUi.setToken(token2);
        }
        this.applyUi(this.tokenUi);
        return this;
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ GithubLoginDialog withToken$default(GithubLoginDialog githubLoginDialog, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return githubLoginDialog.withToken(string);
    }

    @JvmOverloads
    @NotNull
    public final GithubLoginDialog withToken() {
        return GithubLoginDialog.withToken$default(this, null, 1, null);
    }

    @NotNull
    public final GithubLoginDialog withError(@NotNull Throwable exception) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        CredentialsUI credentialsUI = this.currentUi;
        if (credentialsUI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
        }
        this.tokenAcquisitionError = credentialsUI.handleAcquireError(exception);
        this.startTrackingValidation();
        return this;
    }

    @NotNull
    public final GithubServerPath getServer() {
        String string;
        String string2 = this.serverTextField.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"serverTextField.text");
        String string3 = string = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        GithubServerPath githubServerPath = GithubServerPath.from(((Object)StringsKt.trim((CharSequence)string3)).toString());
        Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath, (String)"GithubServerPath.from(serverTextField.text.trim())");
        return githubServerPath;
    }

    @NotNull
    public final String getLogin() {
        String string;
        String string2 = this.login;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"login");
        }
        String string3 = string = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string3)).toString();
    }

    @NotNull
    public final String getToken() {
        String string;
        String string2 = this.token;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"token");
        }
        String string3 = string = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string3)).toString();
    }

    protected void doOKAction() {
        this.setBusy(true);
        this.tokenAcquisitionError = null;
        GithubServerPath server = this.getServer();
        CredentialsUI credentialsUI = this.currentUi;
        if (credentialsUI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
        }
        GithubApiRequestExecutor executor = credentialsUI.createExecutor();
        boolean $i$f$service = false;
        Object object = ServiceManager.getService(ProgressManager.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(T::class.java)");
        ProgressManager progressManager = (ProgressManager)object;
        Task.Backgroundable backgroundable = new Task.Backgroundable(this, server, executor, this.project, "Not Visible"){
            final /* synthetic */ GithubLoginDialog this$0;
            final /* synthetic */ GithubServerPath $server;
            final /* synthetic */ GithubApiRequestExecutor $executor;

            /*
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                void newLogin;
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                Pair<String, String> pair = GithubLoginDialog.access$getCurrentUi$p(this.this$0).acquireLoginAndToken(this.$server, this.$executor, indicator);
                String string = (String)pair.component1();
                String newToken = (String)pair.component2();
                GithubLoginDialog.access$setLogin$p(this.this$0, (String)newLogin);
                GithubLoginDialog.access$setToken$p(this.this$0, newToken);
            }

            public void onSuccess() {
                this.this$0.close(0, true);
                GithubLoginDialog.access$setBusy(this.this$0, false);
            }

            public void onThrowable(@NotNull Throwable error) {
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                GithubLoginDialog.access$startTrackingValidation(this.this$0);
                GithubLoginDialog.access$setTokenAcquisitionError$p(this.this$0, GithubLoginDialog.access$getCurrentUi$p(this.this$0).handleAcquireError(error));
                GithubLoginDialog.access$setBusy(this.this$0, false);
            }
            {
                this.this$0 = $outer;
                this.$server = $captured_local_variable$1;
                this.$executor = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4);
            }
        };
        ProgressIndicator progressIndicator = this.progressIndicator;
        if (progressIndicator == null) {
            Intrinsics.throwNpe();
        }
        progressManager.runProcessWithProgressAsynchronously(backgroundable, progressIndicator);
    }

    private final void setBusy(boolean busy) {
        if (busy) {
            if (!this.serverTextField.getExtensions().contains(this.progressExtension)) {
                this.serverTextField.addExtension(this.progressExtension);
            }
            ProgressIndicator progressIndicator = this.progressIndicator;
            if (progressIndicator != null) {
                progressIndicator.cancel();
            }
            this.progressIndicator = (ProgressIndicator)new EmptyProgressIndicator(ModalityState.stateForComponent((Component)this.getWindow()));
            Disposer.register((Disposable)this.getDisposable(), (Disposable)new Disposable(this){
                final /* synthetic */ GithubLoginDialog this$0;

                public final void dispose() {
                    block0: {
                        ProgressIndicator progressIndicator = GithubLoginDialog.access$getProgressIndicator$p(this.this$0);
                        if (progressIndicator == null) break block0;
                        progressIndicator.cancel();
                    }
                }
                {
                    this.this$0 = githubLoginDialog;
                }
            });
        } else {
            this.serverTextField.removeExtension(this.progressExtension);
            this.progressIndicator = null;
        }
        this.serverTextField.setEnabled(!busy);
        CredentialsUI credentialsUI = this.currentUi;
        if (credentialsUI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
        }
        credentialsUI.setBusy(busy);
    }

    @Nullable
    protected JComponent createNorthPanel() {
        JTextArea jTextArea;
        String string = this.message;
        if (string != null) {
            JTextArea jTextArea2;
            String string2;
            String it = string2 = string;
            boolean bl = false;
            JTextArea $receiver = jTextArea2 = new JTextArea();
            boolean bl2 = false;
            $receiver.setFont(UIUtil.getLabelFont());
            $receiver.setText(it);
            $receiver.setEditable(false);
            $receiver.setFocusable(false);
            $receiver.setOpaque(false);
            $receiver.setBorder((Border)JBUI.Borders.emptyBottom((int)8));
            $receiver.setMargin((Insets)JBUI.emptyInsets());
            jTextArea = jTextArea2;
        } else {
            jTextArea = null;
        }
        return jTextArea;
    }

    @NotNull
    protected Wrapper createSouthAdditionalPanel() {
        return this.southAdditionalPanel;
    }

    @NotNull
    protected Wrapper createCenterPanel() {
        return this.centerPanel;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        CredentialsUI credentialsUI = this.currentUi;
        if (credentialsUI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
        }
        return credentialsUI.getPreferredFocus();
    }

    private final void applyUi(CredentialsUI ui) {
        CredentialsUI credentialsUI = this.currentUi = ui;
        if (credentialsUI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
        }
        this.centerPanel.setContent((JComponent)credentialsUI.getPanel());
        CredentialsUI credentialsUI2 = this.currentUi;
        if (credentialsUI2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
        }
        this.southAdditionalPanel.setContent(credentialsUI2.getSouthPanel());
        CredentialsUI credentialsUI3 = this.currentUi;
        if (credentialsUI3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
        }
        credentialsUI3.getPreferredFocus().requestFocus();
        this.tokenAcquisitionError = null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        void var3_3;
        void $receiver$iv$iv;
        Object[] objectArray = new Function0[2];
        Function0[] function0Array = new Function0[2];
        function0Array[0] = DialogValidationUtils.INSTANCE.chain((Function0)new Function0<ValidationInfo>(this){
            final /* synthetic */ GithubLoginDialog this$0;

            @Nullable
            public final ValidationInfo invoke() {
                return DialogValidationUtils.INSTANCE.notBlank((JTextField)GithubLoginDialog.access$getServerTextField$p(this.this$0), "Server cannot be empty");
            }
            {
                this.this$0 = githubLoginDialog;
                super(0);
            }
        }, this.serverPathValidator((JTextField)this.serverTextField));
        CredentialsUI credentialsUI = this.currentUi;
        if (credentialsUI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
        }
        function0Array[1] = credentialsUI.getValidator();
        objectArray[0] = DialogValidationUtils.INSTANCE.chain(function0Array);
        objectArray[1] = (Function0)new Function0<ValidationInfo>(this){
            final /* synthetic */ GithubLoginDialog this$0;

            @Nullable
            public final ValidationInfo invoke() {
                return GithubLoginDialog.access$getTokenAcquisitionError$p(this.this$0);
            }
            {
                this.this$0 = githubLoginDialog;
                super(0);
            }
        };
        Iterable $receiver$iv = CollectionsKt.listOf((Object[])objectArray);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator = $receiver$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ValidationInfo validationInfo;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            Function0 it = (Function0)element$iv$iv;
            boolean bl = false;
            if ((ValidationInfo)it.invoke() == null) continue;
            ValidationInfo it$iv$iv = validationInfo;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)var3_3;
    }

    private final Function0<ValidationInfo> serverPathValidator(JTextField textField) {
        return (Function0)new Function0<ValidationInfo>(textField){
            final /* synthetic */ JTextField $textField;

            @Nullable
            public final ValidationInfo invoke() {
                ValidationInfo validationInfo;
                String text = this.$textField.getText();
                try {
                    GithubServerPath.from(text);
                    validationInfo = null;
                }
                catch (Exception e) {
                    validationInfo = new ValidationInfo(text + " is not a valid server path:\n" + e.getMessage(), (JComponent)this.$textField);
                }
                return validationInfo;
            }
            {
                this.$textField = jTextField;
                super(0);
            }
        };
    }

    @JvmOverloads
    public GithubLoginDialog(@NotNull GithubApiRequestExecutor.Factory executorFactory, @Nullable Project project, @Nullable Component parent, @NotNull Function2<? super String, ? super GithubServerPath, Boolean> isAccountUnique, @NotNull String title, @Nullable String message) {
        Wrapper wrapper;
        Intrinsics.checkParameterIsNotNull((Object)executorFactory, (String)"executorFactory");
        Intrinsics.checkParameterIsNotNull(isAccountUnique, (String)"isAccountUnique");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        super(project, parent, false, DialogWrapper.IdeModalityType.PROJECT);
        this.executorFactory = executorFactory;
        this.project = project;
        this.isAccountUnique = isAccountUnique;
        this.message = message;
        this.serverTextField = new ExtendableTextField("github.com");
        this.centerPanel = new Wrapper();
        Wrapper wrapper2 = new Wrapper();
        GithubLoginDialog githubLoginDialog = this;
        Wrapper $receiver = wrapper2;
        boolean bl = false;
        JBUI.Borders.emptyRight((int)10);
        githubLoginDialog.southAdditionalPanel = wrapper = wrapper2;
        this.passwordUi = new LoginPasswordCredentialsUI();
        this.tokenUi = new TokenCredentialsUI();
        this.progressIcon = new AnimatedIcon.Default();
        this.progressExtension = new ExtendableTextComponent.Extension(this){
            final /* synthetic */ GithubLoginDialog this$0;

            @NotNull
            public final AnimatedIcon.Default getIcon(boolean it) {
                return GithubLoginDialog.access$getProgressIcon$p(this.this$0);
            }
            {
                this.this$0 = githubLoginDialog;
            }
        };
        this.clientName = "Github Integration Plugin";
        this.setTitle(title);
        this.setOKButtonText("Log In");
        this.applyUi(this.passwordUi);
        this.init();
        Disposer.register((Disposable)this.getDisposable(), (Disposable)new Disposable(){

            public final void dispose() {
                block0: {
                    ProgressIndicator progressIndicator = progressIndicator;
                    if (progressIndicator == null) break block0;
                    progressIndicator.cancel();
                }
            }
        });
    }

    @JvmOverloads
    public /* synthetic */ GithubLoginDialog(GithubApiRequestExecutor.Factory factory, Project project, Component component, Function2 function2, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            project = null;
        }
        if ((n & 4) != 0) {
            component = null;
        }
        if ((n & 8) != 0) {
            function2 = 1.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            string = "Log In to GitHub";
        }
        if ((n & 0x20) != 0) {
            string2 = null;
        }
        this(factory, project, component, (Function2<? super String, ? super GithubServerPath, Boolean>)function2, string, string2);
    }

    @JvmOverloads
    public GithubLoginDialog(@NotNull GithubApiRequestExecutor.Factory executorFactory, @Nullable Project project, @Nullable Component parent, @NotNull Function2<? super String, ? super GithubServerPath, Boolean> isAccountUnique, @NotNull String title) {
        this(executorFactory, project, parent, isAccountUnique, title, null, 32, null);
    }

    @JvmOverloads
    public GithubLoginDialog(@NotNull GithubApiRequestExecutor.Factory executorFactory, @Nullable Project project, @Nullable Component parent, @NotNull Function2<? super String, ? super GithubServerPath, Boolean> isAccountUnique) {
        this(executorFactory, project, parent, isAccountUnique, null, null, 48, null);
    }

    @JvmOverloads
    public GithubLoginDialog(@NotNull GithubApiRequestExecutor.Factory executorFactory, @Nullable Project project, @Nullable Component parent) {
        this(executorFactory, project, parent, null, null, null, 56, null);
    }

    @JvmOverloads
    public GithubLoginDialog(@NotNull GithubApiRequestExecutor.Factory executorFactory, @Nullable Project project) {
        this(executorFactory, project, null, null, null, null, 60, null);
    }

    @JvmOverloads
    public GithubLoginDialog(@NotNull GithubApiRequestExecutor.Factory executorFactory) {
        this(executorFactory, null, null, null, null, null, 62, null);
    }

    public static final /* synthetic */ void access$applyUi(GithubLoginDialog $this, CredentialsUI ui) {
        $this.applyUi(ui);
    }

    public static final /* synthetic */ TokenCredentialsUI access$getTokenUi$p(GithubLoginDialog $this) {
        return $this.tokenUi;
    }

    public static final /* synthetic */ void access$setTokenUi$p(GithubLoginDialog $this, TokenCredentialsUI tokenCredentialsUI) {
        $this.tokenUi = tokenCredentialsUI;
    }

    public static final /* synthetic */ LoginPasswordCredentialsUI access$getPasswordUi$p(GithubLoginDialog $this) {
        return $this.passwordUi;
    }

    public static final /* synthetic */ void access$setPasswordUi$p(GithubLoginDialog $this, LoginPasswordCredentialsUI loginPasswordCredentialsUI) {
        $this.passwordUi = loginPasswordCredentialsUI;
    }

    public static final /* synthetic */ CredentialsUI access$getCurrentUi$p(GithubLoginDialog $this) {
        CredentialsUI credentialsUI = $this.currentUi;
        if (credentialsUI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
        }
        return credentialsUI;
    }

    public static final /* synthetic */ void access$setCurrentUi$p(GithubLoginDialog $this, CredentialsUI credentialsUI) {
        $this.currentUi = credentialsUI;
    }

    public static final /* synthetic */ String access$getLogin$p(GithubLoginDialog $this) {
        String string = $this.login;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"login");
        }
        return string;
    }

    public static final /* synthetic */ void access$setLogin$p(GithubLoginDialog $this, String string) {
        $this.login = string;
    }

    public static final /* synthetic */ String access$getToken$p(GithubLoginDialog $this) {
        String string = $this.token;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"token");
        }
        return string;
    }

    public static final /* synthetic */ void access$setToken$p(GithubLoginDialog $this, String string) {
        $this.token = string;
    }

    public static final /* synthetic */ void access$setBusy(GithubLoginDialog $this, boolean busy) {
        $this.setBusy(busy);
    }

    public static final /* synthetic */ void access$startTrackingValidation(GithubLoginDialog $this) {
        $this.startTrackingValidation();
    }

    public static final /* synthetic */ ValidationInfo access$getTokenAcquisitionError$p(GithubLoginDialog $this) {
        return $this.tokenAcquisitionError;
    }

    public static final /* synthetic */ void access$setTokenAcquisitionError$p(GithubLoginDialog $this, ValidationInfo validationInfo) {
        $this.tokenAcquisitionError = validationInfo;
    }

    public static final /* synthetic */ void access$setProgressIndicator$p(GithubLoginDialog $this, ProgressIndicator progressIndicator) {
        $this.progressIndicator = progressIndicator;
    }

    public static final /* synthetic */ AnimatedIcon.Default access$getProgressIcon$p(GithubLoginDialog $this) {
        return $this.progressIcon;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J,\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0014\u0010\u001a\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001bj\u0002`\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u000e\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\fJ\u000e\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginDialog$LoginPasswordCredentialsUI;", "Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginDialog$CredentialsUI;", "Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginDialog;", "(Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginDialog;)V", "contextHelp", "Ljavax/swing/JEditorPane;", "loginTextField", "Lcom/intellij/ui/components/JBTextField;", "passwordField", "Ljavax/swing/JPasswordField;", "acquireLoginAndToken", "Lkotlin/Pair;", "", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "executor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "createExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$WithBasicAuth;", "getPanel", "Ljavax/swing/JPanel;", "getPreferredFocus", "getSouthPanel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "getValidator", "Lkotlin/Function0;", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lorg/jetbrains/plugins/github/ui/util/Validator;", "handleAcquireError", "error", "", "setBusy", "", "busy", "", "setLogin", "login", "setPassword", "password", "intellij.vcs.github"})
    private final class LoginPasswordCredentialsUI
    extends CredentialsUI {
        private final JBTextField loginTextField;
        private final JPasswordField passwordField;
        private final JEditorPane contextHelp;

        public final void setLogin(@NotNull String login2) {
            Intrinsics.checkParameterIsNotNull((Object)login2, (String)"login");
            this.loginTextField.setText(login2);
        }

        public final void setPassword(@NotNull String password) {
            Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
            this.passwordField.setText(password);
        }

        @Override
        @NotNull
        public JPanel getPanel() {
            JPanel jPanel = UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JComponent)((JComponent)GithubLoginDialog.this.serverTextField)).withLabel("Server:")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)((JComponent)this.loginTextField)).withLabel("Login:")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)this.passwordField).withLabel("Password:")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)this.contextHelp)).createPanel();
            Intrinsics.checkExpressionValueIsNotNull((Object)jPanel, (String)"grid()\n      .add(panel(\u2026ntextHelp)).createPanel()");
            return jPanel;
        }

        @NotNull
        public JBTextField getPreferredFocus() {
            return this.loginTextField;
        }

        @Override
        @NotNull
        public Function0<ValidationInfo> getValidator() {
            return DialogValidationUtils.INSTANCE.chain((Function0)new Function0<ValidationInfo>(this){
                final /* synthetic */ LoginPasswordCredentialsUI this$0;

                @Nullable
                public final ValidationInfo invoke() {
                    return DialogValidationUtils.INSTANCE.notBlank((JTextField)LoginPasswordCredentialsUI.access$getLoginTextField$p(this.this$0), "Login cannot be empty");
                }
                {
                    this.this$0 = loginPasswordCredentialsUI;
                    super(0);
                }
            }, (Function0)new Function0<ValidationInfo>(this){
                final /* synthetic */ LoginPasswordCredentialsUI this$0;

                @Nullable
                public final ValidationInfo invoke() {
                    return DialogValidationUtils.INSTANCE.notBlank(LoginPasswordCredentialsUI.access$getPasswordField$p(this.this$0), "Password cannot be empty");
                }
                {
                    this.this$0 = loginPasswordCredentialsUI;
                    super(0);
                }
            });
        }

        @NotNull
        public BorderLayoutPanel getSouthPanel() {
            BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel().addToCenter((Component)LinkLabel.create((String)"Sign up for GitHub", (Runnable)getSouthPanel.1.INSTANCE)).addToRight((Component)new JBLabel(AllIcons.Ide.External_link_arrow));
            Intrinsics.checkExpressionValueIsNotNull((Object)borderLayoutPanel, (String)"JBUI.Panels.simplePanel(\u2026Ide.External_link_arrow))");
            return borderLayoutPanel;
        }

        @Override
        @NotNull
        public GithubApiRequestExecutor.WithBasicAuth createExecutor() {
            ModalityState modalityState = ModalityState.stateForComponent((Component)this.passwordField);
            Intrinsics.checkExpressionValueIsNotNull((Object)modalityState, (String)"ModalityState.stateForComponent(passwordField)");
            ModalityState modalityState2 = modalityState;
            GithubApiRequestExecutor.Factory factory = GithubLoginDialog.this.executorFactory;
            String string = this.loginTextField.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"loginTextField.text");
            char[] cArray = this.passwordField.getPassword();
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"passwordField.password");
            return factory.create$intellij_vcs_github(string, cArray, new Supplier<String>(this, modalityState2){
                final /* synthetic */ LoginPasswordCredentialsUI this$0;
                final /* synthetic */ ModalityState $modalityState;

                @Nullable
                public final String get() {
                    return (String)ActionsKt.invokeAndWaitIfNeeded((ModalityState)this.$modalityState, (Function0)((Function0)new Function0<String>(this){
                        final /* synthetic */ createExecutor.1 this$0;

                        @Nullable
                        public final String invoke() {
                            return Messages.showInputDialog((Component)LoginPasswordCredentialsUI.access$getPasswordField$p(this.this$0.this$0), (String)"Authentication Code", (String)"GitHub Two-Factor Authentication", null);
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }));
                }
                {
                    this.this$0 = loginPasswordCredentialsUI;
                    this.$modalityState = modalityState;
                }
            });
        }

        @Override
        @NotNull
        public Pair<String, String> acquireLoginAndToken(@NotNull GithubServerPath server, @NotNull GithubApiRequestExecutor executor, @NotNull ProgressIndicator indicator) {
            Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
            Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
            Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
            Function2 function2 = GithubLoginDialog.this.isAccountUnique;
            String string = this.loginTextField.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"loginTextField.text");
            if (!((Boolean)function2.invoke((Object)string, (Object)server)).booleanValue()) {
                throw (Throwable)new LoginNotUniqueException(null, 1, null);
            }
            String string2 = new GithubTokenCreator(server, executor, indicator).createMaster(GithubLoginDialog.this.getClientName()).getToken();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"GithubTokenCreator(serve\u2026eMaster(clientName).token");
            String token2 = string2;
            return TuplesKt.to((Object)this.loginTextField.getText(), (Object)token2);
        }

        @Override
        @NotNull
        public ValidationInfo handleAcquireError(@NotNull Throwable error) {
            ValidationInfo validationInfo;
            Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
            Throwable throwable = error;
            if (throwable instanceof LoginNotUniqueException) {
                validationInfo = new ValidationInfo("Account already added", (JComponent)this.loginTextField);
            } else if (throwable instanceof UnknownHostException) {
                ValidationInfo validationInfo2 = new ValidationInfo("Server is unreachable").withOKEnabled();
                validationInfo = validationInfo2;
                Intrinsics.checkExpressionValueIsNotNull((Object)validationInfo2, (String)"ValidationInfo(\"Server i\u2026achable\").withOKEnabled()");
            } else if (throwable instanceof GithubAuthenticationException) {
                String string = error.getMessage();
                StringBuilder stringBuilder = new StringBuilder().append("Incorrect credentials. ");
                String string2 = string;
                if (string2 == null) {
                    string2 = "";
                }
                String string3 = string2;
                String string4 = stringBuilder.append(string3).toString();
                ValidationInfo validationInfo3 = new ValidationInfo(string4).withOKEnabled();
                validationInfo = validationInfo3;
                Intrinsics.checkExpressionValueIsNotNull((Object)validationInfo3, (String)"ValidationInfo(\"Incorrec\u2026mpty()}\").withOKEnabled()");
            } else if (throwable instanceof GithubParseException) {
                String string = error.getMessage();
                if (string == null) {
                    string = "Invalid server path";
                }
                validationInfo = new ValidationInfo(string, (JComponent)GithubLoginDialog.this.serverTextField);
            } else {
                ValidationInfo validationInfo4 = new ValidationInfo("Invalid authentication data.\n " + error.getMessage()).withOKEnabled();
                validationInfo = validationInfo4;
                Intrinsics.checkExpressionValueIsNotNull((Object)validationInfo4, (String)"ValidationInfo(\"Invalid \u2026essage}\").withOKEnabled()");
            }
            return validationInfo;
        }

        @Override
        public void setBusy(boolean busy) {
            this.loginTextField.setEnabled(!busy);
            this.passwordField.setEnabled(!busy);
            this.contextHelp.setEnabled(!busy);
        }

        public LoginPasswordCredentialsUI() {
            JEditorPane jEditorPane;
            this.loginTextField = new JBTextField();
            this.passwordField = new JPasswordField();
            JEditorPane $receiver = jEditorPane = (this.contextHelp = new JEditorPane());
            boolean bl = false;
            $receiver.setEditorKit(UIUtil.getHTMLEditorKit());
            Color color = JBUI.CurrentTheme.Link.linkColor();
            Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"JBUI.CurrentTheme.Link.linkColor()");
            Color linkColor = color;
            EditorKit editorKit = $receiver.getEditorKit();
            if (editorKit == null) {
                throw new TypeCastException("null cannot be cast to non-null type javax.swing.text.html.HTMLEditorKit");
            }
            ((HTMLEditorKit)editorKit).getStyleSheet().addRule("a {color: rgb(" + linkColor.getRed() + ", " + linkColor.getGreen() + ", " + linkColor.getBlue() + ")}");
            $receiver.setText("<html>Password is not saved and used only to <br>acquire GitHub token. <a href=''>Enter token</a></html>");
            $receiver.addHyperlinkListener(new HyperlinkListener($receiver, this){
                final /* synthetic */ JEditorPane $this_apply;
                final /* synthetic */ LoginPasswordCredentialsUI this$0;
                {
                    this.$this_apply = jEditorPane;
                    this.this$0 = loginPasswordCredentialsUI;
                }

                public final void hyperlinkUpdate(HyperlinkEvent e) {
                    HyperlinkEvent hyperlinkEvent = e;
                    Intrinsics.checkExpressionValueIsNotNull((Object)hyperlinkEvent, (String)"e");
                    if (Intrinsics.areEqual((Object)hyperlinkEvent.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                        GithubLoginDialog.access$applyUi(this.this$0.GithubLoginDialog.this, GithubLoginDialog.access$getTokenUi$p(this.this$0.GithubLoginDialog.this));
                    } else {
                        this.$this_apply.setCursor(Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ENTERED) ? new Cursor(12) : new Cursor(0));
                    }
                }
            });
            $receiver.setEditable(false);
            $receiver.setFocusable(false);
            $receiver.setOpaque(false);
            $receiver.setBorder(null);
            $receiver.setMargin((Insets)JBUI.emptyInsets());
            $receiver.setForeground((Color)JBColor.GRAY);
        }

        public static final /* synthetic */ JBTextField access$getLoginTextField$p(LoginPasswordCredentialsUI $this) {
            return $this.loginTextField;
        }

        public static final /* synthetic */ JPasswordField access$getPasswordField$p(LoginPasswordCredentialsUI $this) {
            return $this.passwordField;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J,\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\nH\u0016J\f\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\bH\u0016J\u0010\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001aH\u0016J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u000e\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginDialog$TokenCredentialsUI;", "Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginDialog$CredentialsUI;", "Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginDialog;", "(Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginDialog;)V", "GIST_SCOPE_PATTERN", "Lkotlin/text/Regex;", "REPO_SCOPE_PATTERN", "switchUiLink", "Lcom/intellij/ui/components/labels/LinkLabel;", "tokenTextField", "Lcom/intellij/ui/components/JBTextField;", "acquireLoginAndToken", "Lkotlin/Pair;", "", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "executor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "createExecutor", "getPanel", "Ljavax/swing/JPanel;", "getPreferredFocus", "getSouthPanel", "getValidator", "Lkotlin/Function0;", "Lcom/intellij/openapi/ui/ValidationInfo;", "handleAcquireError", "error", "", "setBusy", "", "busy", "", "setToken", "token", "intellij.vcs.github"})
    private final class TokenCredentialsUI
    extends CredentialsUI {
        private final Regex GIST_SCOPE_PATTERN;
        private final Regex REPO_SCOPE_PATTERN;
        private final JBTextField tokenTextField;
        private final LinkLabel<?> switchUiLink;

        public final void setToken(@NotNull String token2) {
            Intrinsics.checkParameterIsNotNull((Object)token2, (String)"token");
            this.tokenTextField.setText(token2);
        }

        @Override
        @NotNull
        public JPanel getPanel() {
            JPanel jPanel = UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JComponent)((JComponent)GithubLoginDialog.this.serverTextField)).withLabel("Server:")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)((JComponent)this.tokenTextField)).withLabel("Token:")).createPanel();
            Intrinsics.checkExpressionValueIsNotNull((Object)jPanel, (String)"grid()\n      .add(panel(\u2026(\"Token:\")).createPanel()");
            return jPanel;
        }

        @NotNull
        public JBTextField getPreferredFocus() {
            return this.tokenTextField;
        }

        @Override
        @NotNull
        public Function0<ValidationInfo> getValidator() {
            return (Function0)new Function0<ValidationInfo>(this){
                final /* synthetic */ TokenCredentialsUI this$0;

                @Nullable
                public final ValidationInfo invoke() {
                    return DialogValidationUtils.INSTANCE.notBlank((JTextField)TokenCredentialsUI.access$getTokenTextField$p(this.this$0), "Token cannot be empty");
                }
                {
                    this.this$0 = tokenCredentialsUI;
                    super(0);
                }
            };
        }

        @NotNull
        public LinkLabel<?> getSouthPanel() {
            return this.switchUiLink;
        }

        @Override
        @NotNull
        public GithubApiRequestExecutor createExecutor() {
            GithubApiRequestExecutor.Factory factory = GithubLoginDialog.this.executorFactory;
            String string = this.tokenTextField.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"tokenTextField.text");
            return factory.create(string);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Pair<String, String> acquireLoginAndToken(@NotNull GithubServerPath server, @NotNull GithubApiRequestExecutor executor, @NotNull ProgressIndicator indicator) {
            String login2;
            block7: {
                block6: {
                    void scopes;
                    Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
                    Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
                    Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                    Ref.ObjectRef objectRef = new Ref.ObjectRef();
                    objectRef.element = null;
                    String string = ((GithubAuthenticatedUser)executor.execute(indicator, new GithubApiRequest.Get.Json<GithubAuthenticatedUser>((Ref.ObjectRef)scopes, server, GithubApiRequests.INSTANCE.getUrl(server, new String[]{GithubApiRequests.CurrentUser.INSTANCE.getUrlSuffix()}), GithubAuthenticatedUser.class){
                        final /* synthetic */ Ref.ObjectRef $scopes;
                        final /* synthetic */ GithubServerPath $server;

                        @NotNull
                        public GithubAuthenticatedUser extractResult(@NotNull GithubApiResponse response) {
                            Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                            this.$scopes.element = response.findHeader("X-OAuth-Scopes");
                            return (GithubAuthenticatedUser)super.extractResult(response);
                        }
                        {
                            this.$scopes = $captured_local_variable$0;
                            this.$server = $captured_local_variable$1;
                            super($super_call_param$2, $super_call_param$3, null, 4, null);
                        }
                    }.withOperationName("get profile information"))).getLogin();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"executor.execute(indicat\u2026file information\")).login");
                    login2 = string;
                    CharSequence charSequence = (String)scopes.element;
                    if (charSequence == null || charSequence.length() == 0) break block6;
                    String string2 = (String)scopes.element;
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!this.GIST_SCOPE_PATTERN.containsMatchIn((CharSequence)string2)) break block6;
                    String string3 = (String)scopes.element;
                    if (string3 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (this.REPO_SCOPE_PATTERN.containsMatchIn((CharSequence)string3)) break block7;
                }
                throw (Throwable)new GithubAuthenticationException("Access token should have `repo` and `gist` scopes.");
            }
            if (!((Boolean)GithubLoginDialog.this.isAccountUnique.invoke((Object)login2, (Object)server)).booleanValue()) {
                throw (Throwable)new LoginNotUniqueException(login2);
            }
            return TuplesKt.to((Object)login2, (Object)this.tokenTextField.getText());
        }

        @Override
        @NotNull
        public ValidationInfo handleAcquireError(@NotNull Throwable error) {
            ValidationInfo validationInfo;
            Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
            Throwable throwable = error;
            if (throwable instanceof LoginNotUniqueException) {
                ValidationInfo validationInfo2 = new ValidationInfo("Account " + ((LoginNotUniqueException)error).getLogin() + " already added").withOKEnabled();
                validationInfo = validationInfo2;
                Intrinsics.checkExpressionValueIsNotNull((Object)validationInfo2, (String)"ValidationInfo(\"Account \u2026y added\").withOKEnabled()");
            } else if (throwable instanceof UnknownHostException) {
                ValidationInfo validationInfo3 = new ValidationInfo("Server is unreachable").withOKEnabled();
                validationInfo = validationInfo3;
                Intrinsics.checkExpressionValueIsNotNull((Object)validationInfo3, (String)"ValidationInfo(\"Server i\u2026achable\").withOKEnabled()");
            } else if (throwable instanceof GithubAuthenticationException) {
                String string = error.getMessage();
                StringBuilder stringBuilder = new StringBuilder().append("Incorrect credentials. ");
                String string2 = string;
                if (string2 == null) {
                    string2 = "";
                }
                String string3 = string2;
                String string4 = stringBuilder.append(string3).toString();
                ValidationInfo validationInfo4 = new ValidationInfo(string4).withOKEnabled();
                validationInfo = validationInfo4;
                Intrinsics.checkExpressionValueIsNotNull((Object)validationInfo4, (String)"ValidationInfo(\"Incorrec\u2026mpty()}\").withOKEnabled()");
            } else if (throwable instanceof GithubParseException) {
                String string = error.getMessage();
                if (string == null) {
                    string = "Invalid server path";
                }
                validationInfo = new ValidationInfo(string, (JComponent)GithubLoginDialog.this.serverTextField);
            } else {
                ValidationInfo validationInfo5 = new ValidationInfo("Invalid authentication data.\n " + error.getMessage()).withOKEnabled();
                validationInfo = validationInfo5;
                Intrinsics.checkExpressionValueIsNotNull((Object)validationInfo5, (String)"ValidationInfo(\"Invalid \u2026essage}\").withOKEnabled()");
            }
            return validationInfo;
        }

        @Override
        public void setBusy(boolean busy) {
            this.tokenTextField.setEnabled(!busy);
            this.switchUiLink.setEnabled(!busy);
        }

        public TokenCredentialsUI() {
            this.GIST_SCOPE_PATTERN = new Regex("(?:^|, )repo(?:,|$)");
            this.REPO_SCOPE_PATTERN = new Regex("(?:^|, )gist(?:,|$)");
            this.tokenTextField = new JBTextField();
            LinkLabel linkLabel = LinkLabel.create((String)"Log In with Username", (Runnable)new Runnable(this){
                final /* synthetic */ TokenCredentialsUI this$0;

                public final void run() {
                    GithubLoginDialog.access$applyUi(this.this$0.GithubLoginDialog.this, GithubLoginDialog.access$getPasswordUi$p(this.this$0.GithubLoginDialog.this));
                }
                {
                    this.this$0 = tokenCredentialsUI;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)linkLabel, (String)"LinkLabel.create(\"Log In\u2026) { applyUi(passwordUi) }");
            this.switchUiLink = linkLabel;
        }

        public static final /* synthetic */ JBTextField access$getTokenTextField$p(TokenCredentialsUI $this) {
            return $this.tokenTextField;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&J\b\u0010\f\u001a\u00020\tH&J\b\u0010\r\u001a\u00020\u000eH&J\b\u0010\u000f\u001a\u00020\u0010H&J\b\u0010\u0011\u001a\u00020\u0010H&J\u0014\u0010\u0012\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013j\u0002`\u0015H&J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H&J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH&\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginDialog$CredentialsUI;", "", "(Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginDialog;)V", "acquireLoginAndToken", "Lkotlin/Pair;", "", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "executor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "createExecutor", "getPanel", "Ljavax/swing/JPanel;", "getPreferredFocus", "Ljavax/swing/JComponent;", "getSouthPanel", "getValidator", "Lkotlin/Function0;", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lorg/jetbrains/plugins/github/ui/util/Validator;", "handleAcquireError", "error", "", "setBusy", "", "busy", "", "intellij.vcs.github"})
    private abstract class CredentialsUI {
        @NotNull
        public abstract JPanel getPanel();

        @NotNull
        public abstract JComponent getPreferredFocus();

        @NotNull
        public abstract JComponent getSouthPanel();

        @NotNull
        public abstract Function0<ValidationInfo> getValidator();

        @NotNull
        public abstract GithubApiRequestExecutor createExecutor();

        @NotNull
        public abstract Pair<String, String> acquireLoginAndToken(@NotNull GithubServerPath var1, @NotNull GithubApiRequestExecutor var2, @NotNull ProgressIndicator var3);

        @NotNull
        public abstract ValidationInfo handleAcquireError(@NotNull Throwable var1);

        public abstract void setBusy(boolean var1);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0011\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginDialog$LoginNotUniqueException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "login", "", "(Ljava/lang/String;)V", "getLogin", "()Ljava/lang/String;", "intellij.vcs.github"})
    private static final class LoginNotUniqueException
    extends RuntimeException {
        @Nullable
        private final String login;

        @Nullable
        public final String getLogin() {
            return this.login;
        }

        public LoginNotUniqueException(@Nullable String login2) {
            this.login = login2;
        }

        public /* synthetic */ LoginNotUniqueException(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            this(string);
        }

        public LoginNotUniqueException() {
            this(null, 1, null);
        }
    }
}

