/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.accounts;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;
import org.jetbrains.plugins.github.authentication.accounts.AccountTokenChangedListener;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountManager;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005RN\u0010\u0003\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007 \u0006* \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountInformationProvider;", "", "()V", "informationCache", "Lcom/google/common/cache/Cache;", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/plugins/github/api/data/GithubAuthenticatedUser;", "getInformation", "executor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "account", "intellij.vcs.github"})
public final class GithubAccountInformationProvider {
    private final Cache<GithubAccount, GithubAuthenticatedUser> informationCache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build();

    @NotNull
    public final GithubAuthenticatedUser getInformation(@NotNull GithubApiRequestExecutor executor, @NotNull ProgressIndicator indicator, @NotNull GithubAccount account) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
        Object object = this.informationCache.get((Object)account, (Callable)new Callable<GithubAuthenticatedUser>(executor, indicator, account){
            final /* synthetic */ GithubApiRequestExecutor $executor;
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ GithubAccount $account;

            @NotNull
            public final GithubAuthenticatedUser call() {
                GithubServerPath githubServerPath = this.$account.getServer();
                Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath, (String)"account.server");
                return this.$executor.execute(this.$indicator, GithubApiRequests.CurrentUser.get(githubServerPath));
            }
            {
                this.$executor = githubApiRequestExecutor;
                this.$indicator = progressIndicator;
                this.$account = githubAccount;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"informationCache.get(acc\u2026er.get(account.server)) }");
        return (GithubAuthenticatedUser)object;
    }

    public GithubAccountInformationProvider() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        application.getMessageBus().connect().subscribe(GithubAccountManager.Companion.getACCOUNT_TOKEN_CHANGED_TOPIC(), (Object)new AccountTokenChangedListener(){

            @Override
            public void tokenChanged(@NotNull GithubAccount account) {
                Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
                informationCache.invalidate((Object)account);
            }
        });
    }
}

